/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.yarn.ApplicationMaster$;
import org.apache.spark.deploy.yarn.YarnAllocationHandler$;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r3Q!\u0001\u0002\u0001\r1\u0011A#W1s]\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014(BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT!!\u0002\u0004\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0005\u0001i\u0001C\u0001\b\u0010\u001b\u0005!\u0011B\u0001\t\u0005\u0005E!\u0016m]6TG\",G-\u001e7fe&k\u0007\u000f\u001c\u0005\t%\u0001\u0011\t\u0011)A\u0005)\u0005\u00111oY\u0002\u0001!\t)b#D\u0001\u0007\u0013\t9bA\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0011\u0019wN\u001c4\u0011\u0005myR\"\u0001\u000f\u000b\u0005ei\"B\u0001\u0010\t\u0003\u0019A\u0017\rZ8pa&\u0011\u0001\u0005\b\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\r!ce\n\t\u0003K\u0001i\u0011A\u0001\u0005\u0006%\u0005\u0002\r\u0001\u0006\u0005\u00063\u0005\u0002\rA\u0007\u0005\u0006E\u0001!\t!\u000b\u000b\u0003I)BQA\u0005\u0015A\u0002QAQ\u0001\f\u0001\u0005B5\nabZ3u%\u0006\u001c7NR8s\u0011>\u001cH\u000f\u0006\u0002/wA\u0019qF\r\u001b\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012aa\u00149uS>t\u0007CA\u001b9\u001d\tyc'\u0003\u00028a\u00051\u0001K]3eK\u001aL!!\u000f\u001e\u0003\rM#(/\u001b8h\u0015\t9\u0004\u0007C\u0003=W\u0001\u0007A'\u0001\u0005i_N$\bk\u001c:u\u0011\u0015q\u0004\u0001\"\u0011@\u00035\u0001xn\u001d;Ti\u0006\u0014H\u000fS8pWR\t\u0001\t\u0005\u00020\u0003&\u0011!\t\r\u0002\u0005+:LG\u000f")
public class YarnClusterScheduler
extends TaskSchedulerImpl {
    private final SparkContext sc;
    private final Configuration conf;

    public Option<String> getRackForHost(String hostPort) {
        String host = (String)Utils$.MODULE$.parseHostPort(hostPort)._1();
        String retval = YarnAllocationHandler$.MODULE$.lookupRack(this.conf, host);
        return retval == null ? None$.MODULE$ : new Some((Object)retval);
    }

    public void postStartHook() {
        boolean sparkContextInitialized = ApplicationMaster$.MODULE$.sparkContextInitialized(this.sc);
        if (sparkContextInitialized) {
            Thread.sleep(3000L);
        }
        this.logInfo((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "YarnClusterScheduler.postStartHook done";
            }
        });
    }

    public YarnClusterScheduler(SparkContext sc, Configuration conf) {
        this.sc = sc;
        this.conf = conf;
        super(sc);
        this.logInfo((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Created YarnClusterScheduler";
            }
        });
    }

    public YarnClusterScheduler(SparkContext sc) {
        this(sc, new Configuration());
    }
}

