/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u00015\u0011Qd\u00117jK:$H)[:ue&\u0014W\u000f^3e\u0007\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\tA!_1s]*\u0011QAB\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u00051\u0011BA\f\u0007\u0005\u001daunZ4j]\u001eDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0005?\u0005qA-[:u\u0007\u0006\u001c\u0007.\u001a$jY\u0016\u001cX#\u0001\u0011\u0011\t\u00052\u0003fL\u0007\u0002E)\u00111\u0005J\u0001\b[V$\u0018M\u00197f\u0015\t)\u0003#\u0001\u0006d_2dWm\u0019;j_:L!a\n\u0012\u0003\u00075\u000b\u0007\u000f\u0005\u0002*Y9\u0011qBK\u0005\u0003WA\ta\u0001\u0015:fI\u00164\u0017BA\u0017/\u0005\u0019\u0019FO]5oO*\u00111\u0006\u0005\t\u0006\u001fAB\u0003\u0006K\u0005\u0003cA\u0011a\u0001V;qY\u0016\u001c\u0004BB\u001a\u0001A\u0003%\u0001%A\beSN$8)Y2iK\u001aKG.Z:!\u0011\u001d)\u0004A1A\u0005\n}\t\u0011\u0003Z5ti\u000e\u000b7\r[3Be\u000eD\u0017N^3t\u0011\u00199\u0004\u0001)A\u0005A\u0005\u0011B-[:u\u0007\u0006\u001c\u0007.Z!sG\"Lg/Z:!\u0011\u0015I\u0004\u0001\"\u0001;\u0003-\tG\r\u001a*fg>,(oY3\u0015\u0013mrtIT*bM\"4\bCA\b=\u0013\ti\u0004C\u0001\u0003V]&$\b\"B 9\u0001\u0004\u0001\u0015A\u00014t!\t\tU)D\u0001C\u0015\ty4I\u0003\u0002E\u0011\u00051\u0001.\u00193p_BL!A\u0012\"\u0003\u0015\u0019KG.Z*zgR,W\u000eC\u0003Iq\u0001\u0007\u0011*\u0001\u0003d_:4\u0007C\u0001&M\u001b\u0005Y%B\u0001%D\u0013\ti5JA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006\u001fb\u0002\r\u0001U\u0001\tI\u0016\u001cH\u000fU1uQB\u0011\u0011)U\u0005\u0003%\n\u0013A\u0001U1uQ\")A\u000b\u000fa\u0001+\u0006qAn\\2bYJ+7o\\;sG\u0016\u001c\b\u0003B\u0011WQaK!a\u0016\u0012\u0003\u000f!\u000b7\u000f['baB\u0011\u0011lX\u0007\u00025*\u00111\fX\u0001\be\u0016\u001cwN\u001d3t\u0015\tif,A\u0002ba&T!aA\"\n\u0005\u0001T&!\u0004'pG\u0006d'+Z:pkJ\u001cW\rC\u0003cq\u0001\u00071-\u0001\u0007sKN|WO]2f)f\u0004X\r\u0005\u0002ZI&\u0011QM\u0017\u0002\u0012\u0019>\u001c\u0017\r\u001c*fg>,(oY3UsB,\u0007\"B49\u0001\u0004A\u0013\u0001\u00027j].DQ!\u001b\u001dA\u0002)\f\u0011b\u001d;bi\u000e\u000b7\r[3\u0011\t\u000523n\u001d\t\u0003YFl\u0011!\u001c\u0006\u0003]>\f1A\\3u\u0015\u0005\u0001\u0018\u0001\u00026bm\u0006L!A]7\u0003\u0007U\u0013\u0016\n\u0005\u0002Bi&\u0011QO\u0011\u0002\u000b\r&dWm\u0015;biV\u001c\bbB<9!\u0003\u0005\r\u0001_\u0001\u000eCB\u0004X*Y:uKJ|e\u000e\\=\u0011\u0005=I\u0018B\u0001>\u0011\u0005\u001d\u0011un\u001c7fC:DQ\u0001 \u0001\u0005\u0002u\fqb]3u\t&\u001cHOR5mKN,eN\u001e\u000b\u0003wyDaa`>A\u0002\u0005\u0005\u0011aA3omB!\u0011E\n\u0015)\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\t!c]3u\t&\u001cH/\u0011:dQ&4Xm]#omR\u00191(!\u0003\t\u000f}\f\u0019\u00011\u0001\u0002\u0002!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0011!D4fiZK7/\u001b2jY&$\u0018\u0010\u0006\u0005\u0002\u0012\u0005]\u0011\u0011DA\u000f!\rI\u00161C\u0005\u0004\u0003+Q&a\u0006'pG\u0006d'+Z:pkJ\u001cWMV5tS\nLG.\u001b;z\u0011\u0019A\u00151\u0002a\u0001\u0013\"9\u00111DA\u0006\u0001\u0004Y\u0017aA;sS\"1\u0011.a\u0003A\u0002)Dq!!\t\u0001\t\u0003\t\u0019#\u0001\u0005jgB+(\r\\5d)\u001dA\u0018QEA\u0014\u0003SAa\u0001SA\u0010\u0001\u0004I\u0005bBA\u000e\u0003?\u0001\ra\u001b\u0005\u0007S\u0006}\u0001\u0019\u00016\t\u000f\u00055\u0002\u0001\"\u0001\u00020\u0005y\u0012M\\2fgR|'o\u001d%bm\u0016,\u00050Z2vi\u0016\u0004VM]7jgNLwN\\:\u0015\u000fa\f\t$a\r\u00028!1q(a\u000bA\u0002\u0001Cq!!\u000e\u0002,\u0001\u0007\u0001+\u0001\u0003qCRD\u0007BB5\u0002,\u0001\u0007!\u000eC\u0004\u0002<\u0001!\t!!\u0010\u0002-\rDWmY6QKJl\u0017n]:j_:|em\u0014;iKJ$\u0012\u0002_A \u0003\u0003\n\u0019%a\u0015\t\r}\nI\u00041\u0001A\u0011\u001d\t)$!\u000fA\u0002AC\u0001\"!\u0012\u0002:\u0001\u0007\u0011qI\u0001\u0007C\u000e$\u0018n\u001c8\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014C\u0003)\u0001XM]7jgNLwN\\\u0005\u0005\u0003#\nYE\u0001\u0005Gg\u0006\u001bG/[8o\u0011\u0019I\u0017\u0011\ba\u0001U\"9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0013!D4fi\u001aKG.Z*uCR,8\u000fF\u0004t\u00037\ni&a\u0018\t\r}\n)\u00061\u0001A\u0011\u001d\tY\"!\u0016A\u0002-Da![A+\u0001\u0004Q\u0007\"CA2\u0001E\u0005I\u0011AA3\u0003U\tG\r\u001a*fg>,(oY3%I\u00164\u0017-\u001e7uIa*\"!a\u001a+\u0007a\fIg\u000b\u0002\u0002lA!\u0011QNA<\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014!C;oG\",7m[3e\u0015\r\t)\bE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA=\u0003_\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ClientDistributedCacheManager
implements Logging {
    private final Map<String, Tuple3<String, String, String>> distCacheFiles;
    private final Map<String, Tuple3<String, String, String>> distCacheArchives;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private Map<String, Tuple3<String, String, String>> distCacheFiles() {
        return this.distCacheFiles;
    }

    private Map<String, Tuple3<String, String, String>> distCacheArchives() {
        return this.distCacheArchives;
    }

    public void addResource(FileSystem fs, Configuration conf, Path destPath, HashMap<String, LocalResource> localResources, LocalResourceType resourceType, String link, Map<URI, FileStatus> statCache, boolean appMasterOnly) {
        FileStatus destStatus = fs.getFileStatus(destPath);
        LocalResource amJarRsrc = (LocalResource)Records.newRecord(LocalResource.class);
        amJarRsrc.setType(resourceType);
        LocalResourceVisibility visibility = this.getVisibility(conf, destPath.toUri(), statCache);
        amJarRsrc.setVisibility(visibility);
        amJarRsrc.setResource(ConverterUtils.getYarnUrlFromPath((Path)destPath));
        amJarRsrc.setTimestamp(destStatus.getModificationTime());
        amJarRsrc.setSize(destStatus.getLen());
        if (link == null || link.isEmpty()) {
            throw new Exception("You must specify a valid link name");
        }
        localResources.update((Object)link, (Object)amJarRsrc);
        if (!appMasterOnly) {
            URI uri = destPath.toUri();
            URI pathURI = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, link);
            LocalResourceType localResourceType = resourceType;
            LocalResourceType localResourceType2 = LocalResourceType.FILE;
            if (!(localResourceType != null ? !localResourceType.equals(localResourceType2) : localResourceType2 != null)) {
                this.distCacheFiles().update((Object)pathURI.toString(), (Object)new Tuple3((Object)((Object)BoxesRunTime.boxToLong((long)destStatus.getLen())).toString(), (Object)((Object)BoxesRunTime.boxToLong((long)destStatus.getModificationTime())).toString(), (Object)visibility.name()));
            } else {
                this.distCacheArchives().update((Object)pathURI.toString(), (Object)new Tuple3((Object)((Object)BoxesRunTime.boxToLong((long)destStatus.getLen())).toString(), (Object)((Object)BoxesRunTime.boxToLong((long)destStatus.getModificationTime())).toString(), (Object)visibility.name()));
            }
        }
    }

    public boolean addResource$default$8() {
        return false;
    }

    public void setDistFilesEnv(Map<String, String> env) {
        Tuple2 tuple2 = this.distCacheFiles().unzip((Function1)Predef$.MODULE$.conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Iterable keys = (Iterable)tuple2._1();
            Iterable tupleValues = (Iterable)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)keys, (Object)tupleValues);
            Iterable keys2 = (Iterable)tuple23._1();
            Iterable tupleValues2 = (Iterable)tuple23._2();
            Tuple3 tuple3 = tupleValues2.unzip3((Function1)Predef$.MODULE$.conforms());
            if (tuple3 != null) {
                Tuple3 tuple32;
                Iterable sizes = (Iterable)tuple3._1();
                Iterable timeStamps = (Iterable)tuple3._2();
                Iterable visibilities = (Iterable)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)sizes, (Object)timeStamps, (Object)visibilities);
                Iterable sizes2 = (Iterable)tuple33._1();
                Iterable timeStamps2 = (Iterable)tuple33._2();
                Iterable visibilities2 = (Iterable)tuple33._3();
                if (keys2.size() > 0) {
                    env.update((Object)"SPARK_YARN_CACHE_FILES", keys2.reduceLeft((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                    env.update((Object)"SPARK_YARN_CACHE_FILES_TIME_STAMPS", timeStamps2.reduceLeft((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                    env.update((Object)"SPARK_YARN_CACHE_FILES_FILE_SIZES", sizes2.reduceLeft((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                    env.update((Object)"SPARK_YARN_CACHE_FILES_VISIBILITIES", visibilities2.reduceLeft((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                }
                return;
            }
            throw new MatchError((Object)tuple3);
        }
        throw new MatchError((Object)tuple2);
    }

    public void setDistArchivesEnv(Map<String, String> env) {
        Tuple2 tuple2 = this.distCacheArchives().unzip((Function1)Predef$.MODULE$.conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Iterable keys = (Iterable)tuple2._1();
            Iterable tupleValues = (Iterable)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)keys, (Object)tupleValues);
            Iterable keys2 = (Iterable)tuple23._1();
            Iterable tupleValues2 = (Iterable)tuple23._2();
            Tuple3 tuple3 = tupleValues2.unzip3((Function1)Predef$.MODULE$.conforms());
            if (tuple3 != null) {
                Tuple3 tuple32;
                Iterable sizes = (Iterable)tuple3._1();
                Iterable timeStamps = (Iterable)tuple3._2();
                Iterable visibilities = (Iterable)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)sizes, (Object)timeStamps, (Object)visibilities);
                Iterable sizes2 = (Iterable)tuple33._1();
                Iterable timeStamps2 = (Iterable)tuple33._2();
                Iterable visibilities2 = (Iterable)tuple33._3();
                if (keys2.size() > 0) {
                    env.update((Object)"SPARK_YARN_CACHE_ARCHIVES", keys2.reduceLeft((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                    env.update((Object)"SPARK_YARN_CACHE_ARCHIVES_TIME_STAMPS", timeStamps2.reduceLeft((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                    env.update((Object)"SPARK_YARN_CACHE_ARCHIVES_FILE_SIZES", sizes2.reduceLeft((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                    env.update((Object)"SPARK_YARN_CACHE_ARCHIVES_VISIBILITIES", visibilities2.reduceLeft((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                }
                return;
            }
            throw new MatchError((Object)tuple3);
        }
        throw new MatchError((Object)tuple2);
    }

    public LocalResourceVisibility getVisibility(Configuration conf, URI uri, Map<URI, FileStatus> statCache) {
        if (this.isPublic(conf, uri, statCache)) {
            return LocalResourceVisibility.PUBLIC;
        }
        return LocalResourceVisibility.PRIVATE;
    }

    public boolean isPublic(Configuration conf, URI uri, Map<URI, FileStatus> statCache) {
        Path current;
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        if (this.checkPermissionOfOther(fs, current = new Path(uri.getPath()), FsAction.READ, statCache)) {
            return this.ancestorsHaveExecutePermissions(fs, current.getParent(), statCache);
        }
        return false;
    }

    public boolean ancestorsHaveExecutePermissions(FileSystem fs, Path path, Map<URI, FileStatus> statCache) {
        Path current = path;
        while (true) {
            Path path2;
            if (current == null) {
                return true;
            }
            if (!this.checkPermissionOfOther(fs, path2, FsAction.EXECUTE, statCache)) break;
            path2 = path2.getParent();
        }
        return false;
    }

    public boolean checkPermissionOfOther(FileSystem fs, Path path, FsAction action, Map<URI, FileStatus> statCache) {
        FileStatus status = this.getFileStatus(fs, path.toUri(), statCache);
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        return otherAction.implies(action);
    }

    public FileStatus getFileStatus(FileSystem fs, URI uri, Map<URI, FileStatus> statCache) {
        Option option;
        block4: {
            FileStatus fileStatus;
            block3: {
                block2: {
                    FileStatus existstat;
                    option = statCache.get((Object)uri);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    fileStatus = existstat = (FileStatus)some.x();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                FileStatus newStat = fs.getFileStatus(new Path(uri));
                statCache.put((Object)uri, (Object)newStat);
                fileStatus = newStat;
            }
            FileStatus stat = fileStatus;
            return stat;
        }
        throw new MatchError((Object)option);
    }

    public ClientDistributedCacheManager() {
        Logging.class.$init$((Logging)this);
        this.distCacheFiles = (Map)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.distCacheArchives = (Map)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

