/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.Client;
import org.apache.spark.deploy.yarn.ClientArguments;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;

public final class Client$ {
    public static final Client$ MODULE$;
    private final String SPARK_JAR;
    private final String APP_JAR;
    private final String LOG4J_PROP;
    private final String CONF_SPARK_YARN_SECONDARY_JARS;

    static {
        new Client$();
    }

    public String SPARK_JAR() {
        return this.SPARK_JAR;
    }

    public String APP_JAR() {
        return this.APP_JAR;
    }

    public String LOG4J_PROP() {
        return this.LOG4J_PROP;
    }

    public String CONF_SPARK_YARN_SECONDARY_JARS() {
        return this.CONF_SPARK_YARN_SECONDARY_JARS;
    }

    public void main(String[] argStrings) {
        System.setProperty("SPARK_YARN_MODE", "true");
        SparkConf sparkConf = new SparkConf();
        try {
            ClientArguments args = new ClientArguments(argStrings, sparkConf);
            new Client(args, sparkConf).run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public void populateHadoopClasspath(Configuration conf, HashMap<String, String> env) {
        Predef$.MODULE$.refArrayOps((Object[])conf.getStrings("yarn.application.classpath")).foreach((Function1)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$3;

            public final void apply(String c) {
                Apps.addToEnvironment((Map)JavaConversions$.MODULE$.mutableMapAsJavaMap((scala.collection.mutable.Map)this.env$3), (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)c.trim());
            }
            {
                this.env$3 = env$3;
            }
        });
    }

    public void populateClasspath(Configuration conf, SparkConf sparkConf, boolean addLog4j, HashMap<String, String> env) {
        Apps.addToEnvironment((Map)JavaConversions$.MODULE$.mutableMapAsJavaMap(env), (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)ApplicationConstants.Environment.PWD.$());
        if (addLog4j) {
            Apps.addToEnvironment((Map)JavaConversions$.MODULE$.mutableMapAsJavaMap(env), (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)new StringBuilder().append((Object)ApplicationConstants.Environment.PWD.$()).append((Object)"/").append((Object)this.LOG4J_PROP()).toString());
        }
        String[] cachedSecondaryJarLinks = (String[])Predef$.MODULE$.refArrayOps((Object[])((String)sparkConf.getOption(this.CONF_SPARK_YARN_SECONDARY_JARS()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).split(",")).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
            }
        });
        boolean userClasspathFirst = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.yarn.user.classpath.first", "false"))).toBoolean();
        if (userClasspathFirst) {
            Apps.addToEnvironment((Map)JavaConversions$.MODULE$.mutableMapAsJavaMap(env), (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)new StringBuilder().append((Object)ApplicationConstants.Environment.PWD.$()).append((Object)"/").append((Object)this.APP_JAR()).toString());
            Predef$.MODULE$.refArrayOps((Object[])cachedSecondaryJarLinks).foreach((Function1)new Serializable(env){
                public static final long serialVersionUID = 0L;
                private final HashMap env$2;

                public final void apply(String jarLink) {
                    Apps.addToEnvironment((Map)JavaConversions$.MODULE$.mutableMapAsJavaMap((scala.collection.mutable.Map)this.env$2), (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)new StringBuilder().append((Object)ApplicationConstants.Environment.PWD.$()).append((Object)"/").append((Object)jarLink).toString());
                }
                {
                    this.env$2 = env$2;
                }
            });
        }
        Apps.addToEnvironment((Map)JavaConversions$.MODULE$.mutableMapAsJavaMap(env), (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)new StringBuilder().append((Object)ApplicationConstants.Environment.PWD.$()).append((Object)"/").append((Object)this.SPARK_JAR()).toString());
        this.populateHadoopClasspath(conf, env);
        if (!userClasspathFirst) {
            Apps.addToEnvironment((Map)JavaConversions$.MODULE$.mutableMapAsJavaMap(env), (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)new StringBuilder().append((Object)ApplicationConstants.Environment.PWD.$()).append((Object)"/").append((Object)this.APP_JAR()).toString());
            Predef$.MODULE$.refArrayOps((Object[])cachedSecondaryJarLinks).foreach((Function1)new Serializable(env){
                public static final long serialVersionUID = 0L;
                private final HashMap env$2;

                public final void apply(String jarLink) {
                    Apps.addToEnvironment((Map)JavaConversions$.MODULE$.mutableMapAsJavaMap((scala.collection.mutable.Map)this.env$2), (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)new StringBuilder().append((Object)ApplicationConstants.Environment.PWD.$()).append((Object)"/").append((Object)jarLink).toString());
                }
                {
                    this.env$2 = env$2;
                }
            });
        }
        Apps.addToEnvironment((Map)JavaConversions$.MODULE$.mutableMapAsJavaMap(env), (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)new StringBuilder().append((Object)ApplicationConstants.Environment.PWD.$()).append((Object)"/").append((Object)"*").toString());
    }

    private Client$() {
        MODULE$ = this;
        this.SPARK_JAR = "__spark__.jar";
        this.APP_JAR = "__app__.jar";
        this.LOG4J_PROP = "log4j.properties";
        this.CONF_SPARK_YARN_SECONDARY_JARS = "spark.yarn.secondary.jars";
    }
}

