/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe;

import org.apache.spark.unsafe.Platform;

public class UnsafeAlignedOffset {
    private static final int UAO_SIZE = Platform.unaligned() ? 4 : 8;

    public static int getUaoSize() {
        return UAO_SIZE;
    }

    public static int getSize(Object object, long offset) {
        switch (UAO_SIZE) {
            case 4: {
                return Platform.getInt(object, offset);
            }
            case 8: {
                return (int)Platform.getLong(object, offset);
            }
        }
        throw new AssertionError((Object)"Illegal UAO_SIZE");
    }

    public static void putSize(Object object, long offset, int value) {
        switch (UAO_SIZE) {
            case 4: {
                Platform.putInt(object, offset, value);
                break;
            }
            case 8: {
                Platform.putLong(object, offset, value);
                break;
            }
            default: {
                throw new AssertionError((Object)"Illegal UAO_SIZE");
            }
        }
    }
}

