/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.types;

import java.util.Arrays;
import org.apache.spark.unsafe.Platform;

public final class ByteArray {
    public static final byte[] EMPTY_BYTE = new byte[0];

    public static void writeToMemory(byte[] src, Object target, long targetOffset) {
        Platform.copyMemory(src, Platform.BYTE_ARRAY_OFFSET, target, targetOffset, src.length);
    }

    public static long getPrefix(byte[] bytes) {
        if (bytes == null) {
            return 0L;
        }
        int minLen = Math.min(bytes.length, 8);
        long p = 0L;
        for (int i = 0; i < minLen; ++i) {
            p |= ((long)Platform.getByte(bytes, Platform.BYTE_ARRAY_OFFSET + i) & 0xFFL) << 56 - 8 * i;
        }
        return p;
    }

    public static byte[] subStringSQL(byte[] bytes, int pos, int len) {
        if (pos > bytes.length) {
            return EMPTY_BYTE;
        }
        int start = 0;
        if (pos > 0) {
            start = pos - 1;
        } else if (pos < 0) {
            start = bytes.length + pos;
        }
        int end = bytes.length - start < len ? bytes.length : start + len;
        start = Math.max(start, 0);
        if (start >= end) {
            return EMPTY_BYTE;
        }
        return Arrays.copyOfRange(bytes, start, end);
    }

    public static byte[] concat(byte[] ... inputs) {
        int totalLength = 0;
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] != null) {
                totalLength += inputs[i].length;
                continue;
            }
            return null;
        }
        byte[] result = new byte[totalLength];
        int offset = 0;
        for (int i = 0; i < inputs.length; ++i) {
            int len = inputs[i].length;
            Platform.copyMemory(inputs[i], Platform.BYTE_ARRAY_OFFSET, result, Platform.BYTE_ARRAY_OFFSET + offset, len);
            offset += len;
        }
        return result;
    }
}

