/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.memory;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.spark.unsafe.memory.ExecutorMemoryManager;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark-project.guava.annotations.VisibleForTesting;

public class TaskMemoryManager {
    private final Logger logger = LoggerFactory.getLogger(TaskMemoryManager.class);
    private static final int PAGE_NUMBER_BITS = 13;
    @VisibleForTesting
    static final int OFFSET_BITS = 51;
    private static final int PAGE_TABLE_SIZE = 8192;
    private static final long MAXIMUM_PAGE_SIZE = 0x8000000000000L;
    private static final long MASK_LONG_LOWER_51_BITS = 0x7FFFFFFFFFFFFL;
    private static final long MASK_LONG_UPPER_13_BITS = -2251799813685248L;
    private final MemoryBlock[] pageTable = new MemoryBlock[8192];
    private final BitSet allocatedPages = new BitSet(8192);
    private final HashSet<MemoryBlock> allocatedNonPageMemory = new HashSet();
    private final ExecutorMemoryManager executorMemoryManager;
    private final boolean inHeap;

    public TaskMemoryManager(ExecutorMemoryManager executorMemoryManager) {
        this.inHeap = executorMemoryManager.inHeap;
        this.executorMemoryManager = executorMemoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryBlock allocatePage(long size) {
        int pageNumber;
        if (size > 0x8000000000000L) {
            throw new IllegalArgumentException("Cannot allocate a page with more than 2251799813685248 bytes");
        }
        TaskMemoryManager taskMemoryManager = this;
        synchronized (taskMemoryManager) {
            pageNumber = this.allocatedPages.nextClearBit(0);
            if (pageNumber >= 8192) {
                throw new IllegalStateException("Have already allocated a maximum of 8192 pages");
            }
            this.allocatedPages.set(pageNumber);
        }
        MemoryBlock page = this.executorMemoryManager.allocate(size);
        page.pageNumber = pageNumber;
        this.pageTable[pageNumber] = page;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Allocate page number {} ({} bytes)", (Object)pageNumber, (Object)size);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freePage(MemoryBlock page) {
        assert (page.pageNumber != -1) : "Called freePage() on memory that wasn't allocated with allocatePage()";
        this.executorMemoryManager.free(page);
        TaskMemoryManager taskMemoryManager = this;
        synchronized (taskMemoryManager) {
            this.allocatedPages.clear(page.pageNumber);
        }
        this.pageTable[page.pageNumber] = null;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Freed page number {} ({} bytes)", (Object)page.pageNumber, (Object)page.size());
        }
    }

    public MemoryBlock allocate(long size) throws OutOfMemoryError {
        MemoryBlock memory = this.executorMemoryManager.allocate(size);
        this.allocatedNonPageMemory.add(memory);
        return memory;
    }

    public void free(MemoryBlock memory) {
        boolean wasAlreadyRemoved;
        assert (memory.pageNumber == -1) : "Should call freePage() for pages, not free()";
        this.executorMemoryManager.free(memory);
        boolean bl = wasAlreadyRemoved = !this.allocatedNonPageMemory.remove(memory);
        assert (!wasAlreadyRemoved) : "Called free() on memory that was already freed!";
    }

    public long encodePageNumberAndOffset(MemoryBlock page, long offsetInPage) {
        if (!this.inHeap) {
            offsetInPage -= page.getBaseOffset();
        }
        return TaskMemoryManager.encodePageNumberAndOffset(page.pageNumber, offsetInPage);
    }

    @VisibleForTesting
    public static long encodePageNumberAndOffset(int pageNumber, long offsetInPage) {
        assert (pageNumber != -1) : "encodePageNumberAndOffset called with invalid page";
        return (long)pageNumber << 51 | offsetInPage & 0x7FFFFFFFFFFFFL;
    }

    @VisibleForTesting
    public static int decodePageNumber(long pagePlusOffsetAddress) {
        return (int)((pagePlusOffsetAddress & 0xFFF8000000000000L) >>> 51);
    }

    private static long decodeOffset(long pagePlusOffsetAddress) {
        return pagePlusOffsetAddress & 0x7FFFFFFFFFFFFL;
    }

    public Object getPage(long pagePlusOffsetAddress) {
        if (this.inHeap) {
            int pageNumber = TaskMemoryManager.decodePageNumber(pagePlusOffsetAddress);
            assert (pageNumber >= 0 && pageNumber < 8192);
            Object page = this.pageTable[pageNumber].getBaseObject();
            assert (page != null);
            return page;
        }
        return null;
    }

    public long getOffsetInPage(long pagePlusOffsetAddress) {
        long offsetInPage = TaskMemoryManager.decodeOffset(pagePlusOffsetAddress);
        if (this.inHeap) {
            return offsetInPage;
        }
        int pageNumber = TaskMemoryManager.decodePageNumber(pagePlusOffsetAddress);
        assert (pageNumber >= 0 && pageNumber < 8192);
        return this.pageTable[pageNumber].getBaseOffset() + offsetInPage;
    }

    public long cleanUpAllAllocatedMemory() {
        long freedBytes = 0L;
        for (MemoryBlock page : this.pageTable) {
            if (page == null) continue;
            freedBytes += page.size();
            this.freePage(page);
        }
        Iterator<MemoryBlock> iter = this.allocatedNonPageMemory.iterator();
        while (iter.hasNext()) {
            MemoryBlock memory = iter.next();
            freedBytes += memory.size();
            this.executorMemoryManager.free(memory);
            iter.remove();
        }
        return freedBytes;
    }
}

