/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.bitset;

import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.bitset.BitSetMethods;
import org.apache.spark.unsafe.memory.MemoryBlock;

public final class BitSet {
    private final LongArray words;
    private final int numWords;
    private final Object baseObject;
    private final long baseOffset;

    public BitSet(MemoryBlock memory) {
        this.words = new LongArray(memory);
        assert (this.words.size() <= Integer.MAX_VALUE);
        this.numWords = (int)this.words.size();
        this.baseObject = this.words.memoryBlock().getBaseObject();
        this.baseOffset = this.words.memoryBlock().getBaseOffset();
    }

    public MemoryBlock memoryBlock() {
        return this.words.memoryBlock();
    }

    public long capacity() {
        return this.numWords * 64;
    }

    public void set(int index) {
        assert (index < this.numWords * 64) : "index (" + index + ") should < length (" + this.numWords * 64 + ")";
        BitSetMethods.set(this.baseObject, this.baseOffset, index);
    }

    public void unset(int index) {
        assert (index < this.numWords * 64) : "index (" + index + ") should < length (" + this.numWords * 64 + ")";
        BitSetMethods.unset(this.baseObject, this.baseOffset, index);
    }

    public boolean isSet(int index) {
        assert (index < this.numWords * 64) : "index (" + index + ") should < length (" + this.numWords * 64 + ")";
        return BitSetMethods.isSet(this.baseObject, this.baseOffset, index);
    }

    public int nextSetBit(int fromIndex) {
        return BitSetMethods.nextSetBit(this.baseObject, this.baseOffset, fromIndex, this.numWords);
    }

    public boolean anySet() {
        return BitSetMethods.anySet(this.baseObject, this.baseOffset, this.numWords);
    }
}

