/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.streaming.scheduler.BatchAllocationEvent;
import org.apache.spark.streaming.scheduler.BatchCleanupEvent;
import org.apache.spark.streaming.scheduler.BlockAdditionEvent;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.ReceivedBlockTrackerLogEvent;
import org.apache.spark.streaming.util.BatchedWriteAheadLog;
import org.apache.spark.streaming.util.BatchedWriteAheadLog$;
import org.apache.spark.streaming.util.CommonWriteAheadLogTests;
import org.apache.spark.streaming.util.WriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.streaming.util.WriteAheadLogSuite;
import org.apache.spark.streaming.util.WriteAheadLogSuite$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span;
import org.scalatest.time.Span$;
import org.scalatestplus.mockito.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Symbol;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001B\u000b\u0017\u0001\u0005BQ!\u0010\u0001\u0005\u0002yB\u0011\u0002\u0011\u0001A\u0002\u0003\u0007I\u0011B!\t\u0013\u0015\u0003\u0001\u0019!a\u0001\n\u00131\u0005\"C(\u0001\u0001\u0004\u0005\t\u0015)\u0003C\u0011%\u0001\u0006\u00011AA\u0002\u0013%\u0011\u000bC\u0005V\u0001\u0001\u0007\t\u0019!C\u0005-\"I\u0001\f\u0001a\u0001\u0002\u0003\u0006KA\u0015\u0005\n3\u0002\u0001\r\u00111A\u0005\niC\u0011b\u0019\u0001A\u0002\u0003\u0007I\u0011\u00023\t\u0013\u0019\u0004\u0001\u0019!A!B\u0013Y\u0006\"C4\u0001\u0001\u0004\u0005\r\u0011\"\u0003i\u0011%q\u0007\u00011AA\u0002\u0013%q\u000eC\u0005r\u0001\u0001\u0007\t\u0011)Q\u0005S\"9!\u000f\u0001b\u0001\n\u0013\u0019\bB\u0002=\u0001A\u0003%A\u000fC\u0004z\u0001\t\u0007I\u0011\u0002>\t\u000f\u0005\u0015\u0001\u0001)A\u0005w\"9\u0011q\u0001\u0001\u0005B\u0005%\u0001bBA\u0006\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0005e\u0011\u0015\r^2iK\u0012<&/\u001b;f\u0003\",\u0017\r\u001a'pON+\u0018\u000e^3\u000b\u0005]A\u0012\u0001B;uS2T!!\u0007\u000e\u0002\u0013M$(/Z1nS:<'BA\u000e\u001d\u0003\u0015\u0019\b/\u0019:l\u0015\tib$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0005\u0019qN]4\u0004\u0001M1\u0001A\t\u0014/ii\u0002\"a\t\u0013\u000e\u0003YI!!\n\f\u00031\r{W.\\8o/JLG/Z!iK\u0006$Gj\\4UKN$8\u000f\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u00059Qn\\2lSR|'BA\u0016\u001f\u00035\u00198-\u00197bi\u0016\u001cH\u000f\u001d7vg&\u0011Q\u0006\u000b\u0002\r\u001b>\u001c7.\u001b;p'V<\u0017M\u001d\t\u0003_Ij\u0011\u0001\r\u0006\u0003cy\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005M\u0002$A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0019\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002:m\tQQI^3oiV\fG\u000e\\=\u0011\u0005=Z\u0014B\u0001\u001f1\u0005M\u0001&/\u001b<bi\u0016lU\r\u001e5pIR+7\u000f^3s\u0003\u0019a\u0014N\\5u}Q\tq\b\u0005\u0002$\u0001\u0005\u0019q/\u00197\u0016\u0003\t\u0003\"aI\"\n\u0005\u00113\"!D,sSR,\u0017\t[3bI2{w-A\u0004xC2|F%Z9\u0015\u0005\u001dk\u0005C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%\u0001B+oSRDqAT\u0002\u0002\u0002\u0003\u0007!)A\u0002yIE\nAa^1mA\u0005Iq/\u00197IC:$G.Z\u000b\u0002%B\u00111eU\u0005\u0003)Z\u0011\u0011d\u0016:ji\u0016\f\u0005.Z1e\u0019><'+Z2pe\u0012D\u0015M\u001c3mK\u0006iq/\u00197IC:$G.Z0%KF$\"aR,\t\u000f93\u0011\u0011!a\u0001%\u0006Qq/\u00197IC:$G.\u001a\u0011\u0002+]\fGNQ1uG\"Lgn\u001a+ie\u0016\fG\rU8pYV\t1\f\u0005\u0002]C6\tQL\u0003\u00028=*\u0011qc\u0018\u0006\u0002A\u0006!!.\u0019<b\u0013\t\u0011WL\u0001\nUQJ,\u0017\r\u001a)p_2,\u00050Z2vi>\u0014\u0018!G<bY\n\u000bGo\u00195j]\u001e$\u0006N]3bIB{w\u000e\\0%KF$\"aR3\t\u000f9K\u0011\u0011!a\u00017\u00061r/\u00197CCR\u001c\u0007.\u001b8h)\"\u0014X-\u00193Q_>d\u0007%A\u000exC2\u0014\u0015\r^2iS:<W\t_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u0002SB\u0011!\u000e\\\u0007\u0002W*\u0011q'S\u0005\u0003[.\u0014q$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003}9\u0018\r\u001c\"bi\u000eD\u0017N\\4Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi~#S-\u001d\u000b\u0003\u000fBDqA\u0014\u0007\u0002\u0002\u0003\u0007\u0011.\u0001\u000fxC2\u0014\u0015\r^2iS:<W\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0011\u0002\u0013M\u0004\u0018M]6D_:4W#\u0001;\u0011\u0005U4X\"\u0001\u000e\n\u0005]T\"!C*qCJ\\7i\u001c8g\u0003)\u0019\b/\u0019:l\u0007>tg\rI\u0001\fcV,W/\u001a'f]\u001e$\b.F\u0001|!\raXp`\u0007\u0002\u0001%\u0011ap\u000f\u0002\u000e!JLg/\u0019;f\u001b\u0016$\bn\u001c3\u0011\u0007!\u000b\t!C\u0002\u0002\u0004%\u00131!\u00138u\u00031\tX/Z;f\u0019\u0016tw\r\u001e5!\u0003)\u0011WMZ8sK\u0016\u000b7\r\u001b\u000b\u0002\u000f\u0006I\u0011M\u001a;fe\u0016\u000b7\r[\u0001\u000boJLG/Z!ts:\u001cG\u0003CA\t\u0003/\tI\"a\r\u0011\t)\f\u0019bR\u0005\u0004\u0003+Y'a\u0002)s_6L7/\u001a\u0005\u0006\u0001R\u0001\rA\u0011\u0005\b\u00037!\u0002\u0019AA\u000f\u0003\u0015)g/\u001a8u!\u0011\ty\"!\f\u000f\t\u0005\u0005\u0012\u0011\u0006\t\u0004\u0003GIUBAA\u0013\u0015\r\t9\u0003I\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-\u0012*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\t\tD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003WI\u0005bBA\u001b)\u0001\u0007\u0011qG\u0001\u0005i&lW\rE\u0002I\u0003sI1!a\u000fJ\u0005\u0011auN\\4")
public class BatchedWriteAheadLogSuite
extends CommonWriteAheadLogTests
implements MockitoSugar,
Eventually,
PrivateMethodTester {
    private WriteAheadLog wal;
    private WriteAheadLogRecordHandle walHandle;
    private ThreadPoolExecutor walBatchingThreadPool;
    private ExecutionContextExecutorService walBatchingExecutionContext;
    private final SparkConf sparkConf;
    private final PrivateMethodTester.PrivateMethod<Object> queueLength;
    private volatile PrivateMethodTester.PrivateMethod$ PrivateMethod$module;
    private AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.anyRefToInvoker$((PrivateMethodTester)this, (Object)target);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    public <T> ArgumentCaptor<T> capture(ClassTag<T> classTag) {
        return MockitoSugar.capture$((MockitoSugar)this, classTag);
    }

    public <T> T invokeCaptureOnArgumentCaptor(ArgumentCaptor<T> captor) {
        return (T)MockitoSugar.invokeCaptureOnArgumentCaptor$((MockitoSugar)this, captor);
    }

    public PrivateMethodTester.PrivateMethod$ PrivateMethod() {
        if (this.PrivateMethod$module == null) {
            this.PrivateMethod$lzycompute$1();
        }
        return this.PrivateMethod$module;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    private WriteAheadLog wal() {
        return this.wal;
    }

    private void wal_$eq(WriteAheadLog x$1) {
        this.wal = x$1;
    }

    private WriteAheadLogRecordHandle walHandle() {
        return this.walHandle;
    }

    private void walHandle_$eq(WriteAheadLogRecordHandle x$1) {
        this.walHandle = x$1;
    }

    private ThreadPoolExecutor walBatchingThreadPool() {
        return this.walBatchingThreadPool;
    }

    private void walBatchingThreadPool_$eq(ThreadPoolExecutor x$1) {
        this.walBatchingThreadPool = x$1;
    }

    private ExecutionContextExecutorService walBatchingExecutionContext() {
        return this.walBatchingExecutionContext;
    }

    private void walBatchingExecutionContext_$eq(ExecutionContextExecutorService x$1) {
        this.walBatchingExecutionContext = x$1;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private PrivateMethodTester.PrivateMethod<Object> queueLength() {
        return this.queueLength;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.wal_$eq((WriteAheadLog)this.mock(ClassTag$.MODULE$.apply(WriteAheadLog.class)));
        this.walHandle_$eq((WriteAheadLogRecordHandle)this.mock(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class)));
        this.walBatchingThreadPool_$eq(ThreadUtils$.MODULE$.newDaemonFixedThreadPool(8, "wal-test-thread-pool"));
        this.walBatchingExecutionContext_$eq(ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.walBatchingThreadPool()));
    }

    public void afterEach() {
        try {
            if (this.walBatchingExecutionContext() != null) {
                this.walBatchingExecutionContext().shutdownNow();
            }
        }
        finally {
            BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
        }
    }

    private Promise<BoxedUnit> writeAsync(WriteAheadLog wal, String event, long time) {
        Promise p = Promise$.MODULE$.apply();
        p.completeWith(Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            WriteAheadLogRecordHandle v = wal.write(WriteAheadLogSuite$.MODULE$.stringToByteBuffer(event), time);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(v);
            WriteAheadLogRecordHandle $org_scalatest_assert_macro_right = this.walHandle();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
        }, (ExecutionContext)this.walBatchingExecutionContext()));
        return p;
    }

    private final void PrivateMethod$lzycompute$1() {
        BatchedWriteAheadLogSuite batchedWriteAheadLogSuite = this;
        synchronized (batchedWriteAheadLogSuite) {
            if (this.PrivateMethod$module == null) {
                this.PrivateMethod$module = new PrivateMethodTester.PrivateMethod$((PrivateMethodTester)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        BatchedWriteAheadLogSuite batchedWriteAheadLogSuite = this;
        synchronized (batchedWriteAheadLogSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$52(Promise x$7) {
        return ((Try)x$7.future().value().get()).isFailure();
    }

    public static final /* synthetic */ Assertion $anonfun$new$50(Seq writePromises$1) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(writePromises$1.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isCompleted())), "writePromises.forall(((x$6: scala.concurrent.Promise[Unit]) => x$6.isCompleted))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(writePromises$1.forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)BatchedWriteAheadLogSuite.$anonfun$new$52(x$7))), "writePromises.forall(((x$7: scala.concurrent.Promise[Unit]) => x$7.future.value.get.isFailure))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
    }

    public BatchedWriteAheadLogSuite() {
        super(true, false, "BatchedWriteAheadLog");
        MockitoSugar.$init$((MockitoSugar)this);
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        PrivateMethodTester.$init$((PrivateMethodTester)this);
        this.sparkConf = new SparkConf();
        this.queueLength = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "getQueueLength"));
        this.test("BatchedWriteAheadLog - serializing and deserializing batched records", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            .colon.colon events = new .colon.colon((Object)new BlockAdditionEvent(new ReceivedBlockInfo(0, (Option)None$.MODULE$, (Option)None$.MODULE$, null)), (List)new .colon.colon((Object)new BatchAllocationEvent(null, null), (List)new .colon.colon((Object)new BatchCleanupEvent((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)));
            Seq buffers = (Seq)events.map((Function1 & Serializable)e -> new BatchedWriteAheadLog.Record(ByteBuffer.wrap(Utils$.MODULE$.serialize(e)), 0L, null));
            ByteBuffer batched = BatchedWriteAheadLog$.MODULE$.aggregate(buffers);
            ReceivedBlockTrackerLogEvent[] deaggregate = (ReceivedBlockTrackerLogEvent[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])BatchedWriteAheadLog$.MODULE$.deaggregate(batched)), (Function1 & Serializable)buffer -> (ReceivedBlockTrackerLogEvent)Utils$.MODULE$.deserialize(buffer.array()), ClassTag$.MODULE$.apply(ReceivedBlockTrackerLogEvent.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])deaggregate)));
            .colon.colon $org_scalatest_assert_macro_right = events;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 470));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
        this.test("BatchedWriteAheadLog - failures in wrappedLog get bubbled up", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Mockito.when((Object)this.wal().write((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenThrow(new Throwable[]{new RuntimeException("Hello!")});
            BatchedWriteAheadLog batchedWal = new BatchedWriteAheadLog(this.wal(), this.sparkConf());
            SparkException e = (SparkException)((Object)((Object)this.intercept((Function0 & Serializable)() -> {
                ByteBuffer buffer = Utils$.MODULE$.isJavaVersionAtMost17() ? (ByteBuffer)this.mock(ClassTag$.MODULE$.apply(ByteBuffer.class)) : ByteBuffer.allocate(0);
                return batchedWal.write(buffer, 2L);
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getCause().getMessage());
            String $org_scalatest_assert_macro_right = "Hello!";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
        this.test("BatchedWriteAheadLog - name log with the highest timestamp of aggregated entries", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            WriteAheadLogSuite.BlockingWriteAheadLog blockingWal = new WriteAheadLogSuite.BlockingWriteAheadLog(this.wal(), this.walHandle());
            BatchedWriteAheadLog batchedWal = new BatchedWriteAheadLog((WriteAheadLog)blockingWal, this.sparkConf());
            String event1 = "hello";
            String event2 = "world";
            String event3 = "this";
            String event4 = "is";
            String event5 = "doge";
            this.writeAsync((WriteAheadLog)batchedWal, event1, 3L);
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0 & Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(blockingWal.isBlocked(), "blockingWal.isBlocked", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.anyRefToInvoker(batchedWal).invokePrivate(this.queueLength().apply((Seq)Nil$.MODULE$)));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
            }, this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
            this.writeAsync((WriteAheadLog)batchedWal, event2, 5L);
            this.writeAsync((WriteAheadLog)batchedWal, event3, 8L);
            this.writeAsync((WriteAheadLog)batchedWal, event5, 12L);
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0 & Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(blockingWal.isBlocked(), "blockingWal.isBlocked", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.anyRefToInvoker(batchedWal).invokePrivate(this.queueLength().apply((Seq)Nil$.MODULE$)));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
            }, this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
            this.writeAsync((WriteAheadLog)batchedWal, event4, 10L);
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0 & Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.walBatchingThreadPool().getActiveCount()));
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.anyRefToInvoker(batchedWal).invokePrivate(this.queueLength().apply((Seq)Nil$.MODULE$)));
                int $org_scalatest_assert_macro_right2 = 4;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
            }, this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
            blockingWal.allowWrite();
            ByteBuffer buffer = WriteAheadLogSuite$.MODULE$.wrapArrayArrayByte(new String[]{event1});
            Set queuedEvents = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{event2, event3, event4, event5}));
            return (Assertion)this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0 & Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.anyRefToInvoker(batchedWal).invokePrivate(this.queueLength().apply((Seq)Nil$.MODULE$)));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
                ((WriteAheadLog)Mockito.verify((Object)this.wal(), (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.eq((Object)buffer), ArgumentMatchers.eq((long)3L));
                ArgumentCaptor bufferCaptor = ArgumentCaptor.forClass(ByteBuffer.class);
                ((WriteAheadLog)Mockito.verify((Object)this.wal(), (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)bufferCaptor.capture(), ArgumentMatchers.eq((long)12L));
                String[] records = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])BatchedWriteAheadLog$.MODULE$.deaggregate((ByteBuffer)bufferCaptor.getValue())), (Function1 & Serializable)byteBuffer -> WriteAheadLogSuite$.MODULE$.byteBufferToString((ByteBuffer)byteBuffer), ClassTag$.MODULE$.apply(String.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Predef$.MODULE$.wrapRefArray((Object[])records).toSet());
                Set $org_scalatest_assert_macro_right2 = queuedEvents;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 546));
            }, this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
        this.test("BatchedWriteAheadLog - shutdown properly", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BatchedWriteAheadLog batchedWal = new BatchedWriteAheadLog(this.wal(), this.sparkConf());
            batchedWal.close();
            ((WriteAheadLog)Mockito.verify((Object)this.wal(), (VerificationMode)Mockito.times((int)1))).close();
            ByteBuffer buffer = Utils$.MODULE$.isJavaVersionAtMost17() ? (ByteBuffer)this.mock(ClassTag$.MODULE$.apply(ByteBuffer.class)) : ByteBuffer.allocate(0);
            return (IllegalStateException)this.intercept((Function0 & Serializable)() -> batchedWal.write(buffer, 12L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
        this.test("BatchedWriteAheadLog - fail everything in queue during shutdown", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            WriteAheadLogSuite.BlockingWriteAheadLog blockingWal = new WriteAheadLogSuite.BlockingWriteAheadLog(this.wal(), this.walHandle());
            BatchedWriteAheadLog batchedWal = new BatchedWriteAheadLog((WriteAheadLog)blockingWal, this.sparkConf());
            String event1 = "hello";
            String event2 = "world";
            String event3 = "this";
            Promise<BoxedUnit> promise1 = this.writeAsync((WriteAheadLog)batchedWal, event1, 3L);
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0 & Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(blockingWal.isBlocked(), "blockingWal.isBlocked", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.anyRefToInvoker(batchedWal).invokePrivate(this.queueLength().apply((Seq)Nil$.MODULE$)));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
            }, this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
            Promise<BoxedUnit> promise2 = this.writeAsync((WriteAheadLog)batchedWal, event2, 5L);
            Promise<BoxedUnit> promise3 = this.writeAsync((WriteAheadLog)batchedWal, event3, 8L);
            this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), (Function0 & Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.walBatchingThreadPool().getActiveCount()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 585));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(blockingWal.isBlocked(), "blockingWal.isBlocked", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.anyRefToInvoker(batchedWal).invokePrivate(this.queueLength().apply((Seq)Nil$.MODULE$)));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
            }, this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
            .colon.colon writePromises = new .colon.colon(promise1, (List)new .colon.colon(promise2, (List)new .colon.colon(promise3, (List)Nil$.MODULE$)));
            batchedWal.close();
            return (Assertion)this.eventually(this.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), () -> BatchedWriteAheadLogSuite.$anonfun$new$50((Seq)writePromises), this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        Statics.releaseFence();
    }
}

