/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.Serializable;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.FileGeneratingThread;
import org.apache.spark.streaming.KillingThread;
import org.apache.spark.streaming.Milliseconds$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.TestOutputStream;
import org.apache.spark.streaming.TestOutputStream$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random$;

public final class MasterFailureTest$
implements Logging {
    public static final MasterFailureTest$ MODULE$ = new MasterFailureTest$();
    private static volatile boolean killed;
    private static volatile int killCount;
    private static volatile boolean setupCalled;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        killed = false;
        killCount = 0;
        setupCalled = false;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean killed() {
        return killed;
    }

    public void killed_$eq(boolean x$1) {
        killed = x$1;
    }

    public int killCount() {
        return killCount;
    }

    public void killCount_$eq(int x$1) {
        killCount = x$1;
    }

    public boolean setupCalled() {
        return setupCalled;
    }

    public void setupCalled_$eq(boolean x$1) {
        setupCalled = x$1;
    }

    public void main(String[] args) {
        if (args.length < 2) {
            Predef$.MODULE$.println((Object)"Usage: MasterFailureTest <local/HDFS directory> <# batches> [<batch size in milliseconds>]");
            System.exit(1);
        }
        String directory = args[0];
        int numBatches = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[1]));
        Duration batchDuration = args.length > 2 ? Milliseconds$.MODULE$.apply((long)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[2]))) : Seconds$.MODULE$.apply(1L);
        Predef$.MODULE$.println((Object)"\n\n========================= MAP TEST =========================\n\n");
        this.testMap(directory, numBatches, batchDuration);
        Predef$.MODULE$.println((Object)"\n\n================= UPDATE-STATE-BY-KEY TEST =================\n\n");
        this.testUpdateStateByKey(directory, numBatches, batchDuration);
        Predef$.MODULE$.println((Object)"\n\nSUCCESS\n\n");
    }

    public void testMap(String directory, int numBatches, Duration batchDuration) {
        IndexedSeq input = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numBatches).map((Function1 & Serializable)x$1 -> MasterFailureTest$.$anonfun$testMap$1(BoxesRunTime.unboxToInt((Object)x$1))).toSeq();
        Range.Inclusive expectedOutput = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numBatches);
        Function1 & Serializable operation = (Function1 & Serializable)st -> st.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2))), (ClassTag)ClassTag$.MODULE$.Int());
        Seq output = this.testOperation(directory, batchDuration, (Seq<String>)input, (Function1)operation, (Seq)expectedOutput, (ClassTag)ClassTag$.MODULE$.Int());
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Expected output, size = " + expectedOutput.size());
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> expectedOutput.mkString("[", ",", "]"));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Output, size = " + output.size());
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> output.mkString("[", ",", "]"));
        Set $org_scalatest_assert_macro_left = ((IterableOnceOps)output.distinct()).toSet();
        Set $org_scalatest_assert_macro_right = expectedOutput.toSet();
        Set set = $org_scalatest_assert_macro_left;
        Set set2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
    }

    public void testUpdateStateByKey(String directory, int numBatches, Duration batchDuration) {
        IndexedSeq input = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numBatches).map((Function1 & Serializable)i -> MasterFailureTest$.$anonfun$testUpdateStateByKey$1(BoxesRunTime.unboxToInt((Object)i))).toSeq();
        IndexedSeq expectedOutput = (IndexedSeq)((IndexedSeqOps)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)numBatches)).map((Function1)(JFunction1.mcJJ.sp & Serializable)i -> BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)i)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)))).map((Function1 & Serializable)j -> MasterFailureTest$.$anonfun$testUpdateStateByKey$4(BoxesRunTime.unboxToLong((Object)j)));
        Function1 & Serializable operation = (Function1 & Serializable)st -> {
            Function2 & Serializable updateFunc = (Function2 & Serializable)(values, state) -> new Some((Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)values.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x$4, x$5) -> x$4 + x$5)) + BoxesRunTime.unboxToLong((Object)state.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)))));
            return DStream$.MODULE$.toPairDStreamFunctions(st.flatMap((Function1 & Serializable)x$6 -> Predef$.MODULE$.wrapRefArray((Object[])x$6.split(" ")), ClassTag$.MODULE$.apply(String.class)).map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToLong((long)1L)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).updateStateByKey((Function2)updateFunc, (ClassTag)ClassTag$.MODULE$.Long()).checkpoint(batchDuration.$times(5));
        };
        Seq output = this.testOperation(directory, batchDuration, (Seq<String>)input, (Function1)operation, (Seq)expectedOutput, (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Expected output, size = " + expectedOutput.size() + "\n" + expectedOutput);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Output, size = " + output.size() + "\n" + output);
        output.foreach((Function1 & Serializable)o -> {
            IndexedSeq $org_scalatest_assert_macro_left = expectedOutput;
            Tuple2 $org_scalatest_assert_macro_right = o;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Expected value " + o + " not found"), Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        });
        Tuple2 $org_scalatest_assert_macro_left = (Tuple2)output.last();
        Tuple2 $org_scalatest_assert_macro_right = (Tuple2)expectedOutput.last();
        Tuple2 tuple2 = $org_scalatest_assert_macro_left;
        Tuple2 tuple22 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
    }

    public <T> Seq<T> testOperation(String directory, Duration batchDuration, Seq<String> input, Function1<DStream<String>, DStream<T>> operation, Seq<T> expectedOutput, ClassTag<T> evidence$1) {
        Set $org_scalatest_assert_macro_left = ((IterableOnceOps)expectedOutput.distinct()).toSet();
        Set $org_scalatest_assert_macro_right = expectedOutput.toSet();
        Set set = $org_scalatest_assert_macro_left;
        Set set2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.reset();
        String uuid = UUID.randomUUID().toString();
        Path rootDir = new Path(directory, uuid);
        FileSystem fs = rootDir.getFileSystem(new Configuration());
        Path checkpointDir = new Path(rootDir, "checkpoint");
        Path testDir = new Path(rootDir, "test");
        fs.mkdirs(checkpointDir);
        fs.mkdirs(testDir);
        StreamingContext ssc = StreamingContext$.MODULE$.getOrCreate(checkpointDir.toString(), (Function0 & Serializable)() -> MODULE$.setupStreams(batchDuration, operation, checkpointDir, testDir, evidence$1), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.setupCalled(), "MasterFailureTest.this.setupCalled", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Setup was not called in the first call to StreamingContext.getOrCreate", Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        FileGeneratingThread fileGeneratingThread = new FileGeneratingThread(input, testDir, batchDuration.milliseconds());
        fileGeneratingThread.start();
        Object lastExpectedOutput = expectedOutput.last();
        long maxTimeToRun = (long)expectedOutput.size() * batchDuration.milliseconds() * 2L;
        Seq<Object> mergedOutput = this.runStreams(ssc, lastExpectedOutput, maxTimeToRun, evidence$1);
        fileGeneratingThread.join();
        ssc.stop(ssc.stop$default$1());
        fs.delete(checkpointDir, true);
        fs.delete(testDir, true);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Finished test after " + MODULE$.killCount() + " failures");
        return mergedOutput;
    }

    private <T> StreamingContext setupStreams(Duration batchDuration, Function1<DStream<String>, DStream<T>> operation, Path checkpointDir, Path testDir, ClassTag<T> evidence$2) {
        this.setupCalled_$eq(true);
        StreamingContext ssc = new StreamingContext("local[4]", "MasterFailureTest", batchDuration, null, (Seq)Nil$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        ssc.checkpoint(checkpointDir.toString());
        DStream inputStream = ssc.textFileStream(testDir.toString());
        DStream operatedStream = (DStream)operation.apply((Object)inputStream);
        TestOutputStream outputStream = new TestOutputStream(operatedStream, TestOutputStream$.MODULE$.$lessinit$greater$default$2(), evidence$2);
        outputStream.register();
        return ssc;
    }

    private <T> Seq<T> runStreams(StreamingContext _ssc, T lastExpectedOutput, long maxTimeToRun, ClassTag<T> evidence$3) {
        StreamingContext ssc = _ssc;
        LongRef totalTimeRan = LongRef.create((long)0L);
        BooleanRef isLastOutputGenerated = BooleanRef.create((boolean)false);
        BooleanRef isTimedOut = BooleanRef.create((boolean)false);
        ArrayBuffer mergedOutput = new ArrayBuffer();
        String checkpointDir = ssc.checkpointDir();
        Duration batchDuration = ssc.graph().batchDuration();
        while (!isLastOutputGenerated.elem && !isTimedOut.elem) {
            ConcurrentLinkedQueue outputQueue = ((TestOutputStream)((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getOutputStreams())))).output();
            this.killed_$eq(false);
            KillingThread killingThread = new KillingThread(ssc, batchDuration.milliseconds() * 10L);
            killingThread.start();
            LongRef timeRan = LongRef.create((long)0L);
            try {
                try {
                    System.clearProperty("spark.streaming.clock");
                    System.clearProperty("spark.driver.port");
                    ssc.start();
                    long startTimeNs = System.nanoTime();
                    while (!(this.killed() || isLastOutputGenerated.elem || isTimedOut.elem)) {
                        Thread.sleep(100L);
                        timeRan.elem = System.nanoTime() - startTimeNs;
                        isLastOutputGenerated.elem = MasterFailureTest$.output$3(outputQueue).nonEmpty() && BoxesRunTime.equals((Object)MasterFailureTest$.output$3(outputQueue).last(), lastExpectedOutput);
                        isTimedOut.elem = timeRan.elem + totalTimeRan.elem > TimeUnit.MILLISECONDS.toNanos(maxTimeToRun);
                    }
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable)() -> "Error running streaming context", (Throwable)e);
                }
            }
            finally {
                StreamingContext qual$1 = ssc;
                boolean x$1 = qual$1.stop$default$1();
                qual$1.stop(x$1);
            }
            if (killingThread.isAlive()) {
                killingThread.interrupt();
                killingThread.join();
            }
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Has been killed = " + MODULE$.killed());
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Is last output generated = " + isLastOutputGenerated$1.elem);
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Is timed out = " + isTimedOut$1.elem);
            mergedOutput.$plus$plus$eq((IterableOnce)MasterFailureTest$.output$3(outputQueue).toSeq());
            totalTimeRan.elem += timeRan.elem;
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "New output = " + MasterFailureTest$.output$3(outputQueue).toSeq());
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Merged output = " + mergedOutput);
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Time ran = " + timeRan$1.elem);
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Total time ran = " + TimeUnit.NANOSECONDS.toMillis(totalTimeRan$1.elem));
            if (isLastOutputGenerated.elem || isTimedOut.elem) continue;
            int sleepTime = Random$.MODULE$.nextInt((int)batchDuration.milliseconds() * 10);
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "\n-------------------------------------------\n   Restarting stream computation in " + sleepTime + " ms   \n-------------------------------------------\n");
            Thread.sleep(sleepTime);
            ssc = StreamingContext$.MODULE$.getOrCreate(checkpointDir, (Function0 & Serializable)() -> {
                throw new Exception("Trying to create new context when it should be reading from checkpoint file");
            }, StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4());
        }
        return mergedOutput.toSeq();
    }

    private <T> void verifyOutput(Seq<T> output, Seq<T> expectedOutput, ClassTag<T> evidence$4) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), expectedOutput.size() - 1).foreach((Function1 & Serializable)i -> MasterFailureTest$.$anonfun$verifyOutput$1(expectedOutput, BoxesRunTime.unboxToInt((Object)i)));
        Predef$.MODULE$.println((Object)("Expected output, size = " + expectedOutput.size()));
        Predef$.MODULE$.println((Object)expectedOutput.mkString("[", ",", "]"));
        Predef$.MODULE$.println((Object)("Output, size = " + output.size()));
        Predef$.MODULE$.println((Object)output.mkString("[", ",", "]"));
        output.foreach((Function1 & Serializable)o -> {
            Seq $org_scalatest_assert_macro_left = expectedOutput;
            Object $org_scalatest_assert_macro_right = o;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Expected value " + o + " not found"), Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        });
    }

    private void reset() {
        this.killed_$eq(false);
        this.killCount_$eq(0);
        this.setupCalled_$eq(false);
    }

    public static final /* synthetic */ String $anonfun$testMap$1(int x$1) {
        return Integer.toString(x$1);
    }

    public static final /* synthetic */ String $anonfun$testUpdateStateByKey$2(int x$3) {
        return "a";
    }

    public static final /* synthetic */ String $anonfun$testUpdateStateByKey$1(int i) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), i).map((Function1 & Serializable)x$3 -> MasterFailureTest$.$anonfun$testUpdateStateByKey$2(BoxesRunTime.unboxToInt((Object)x$3))).mkString(" ");
    }

    public static final /* synthetic */ Tuple2 $anonfun$testUpdateStateByKey$4(long j) {
        return new Tuple2((Object)"a", (Object)BoxesRunTime.boxToLong((long)j));
    }

    private static final Iterable output$3(ConcurrentLinkedQueue outputQueue$1) {
        return (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)outputQueue$1).asScala().flatten(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ Assertion $anonfun$verifyOutput$1(Seq expectedOutput$3, int i) {
        Object $org_scalatest_assert_macro_right;
        Object $org_scalatest_assert_macro_left;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "!=", $org_scalatest_assert_macro_right, !BoxesRunTime.equals((Object)($org_scalatest_assert_macro_left = expectedOutput$3.apply(i)), (Object)($org_scalatest_assert_macro_right = expectedOutput$3.apply(i + 1))), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Expected output has consecutive duplicate sequence of values", Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
    }

    private MasterFailureTest$() {
    }
}

