/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.rdd;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.RDDCheckpointTester;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.streaming.State;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.rdd.MapWithStateRDD;
import org.apache.spark.streaming.rdd.MapWithStateRDD$;
import org.apache.spark.streaming.rdd.MapWithStateRDDRecord;
import org.apache.spark.streaming.rdd.MapWithStateRDDRecord$;
import org.apache.spark.streaming.rdd.MapWithStateRDDSuite$;
import org.apache.spark.streaming.util.OpenHashMapBasedStateMap;
import org.apache.spark.streaming.util.StateMap;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001\u0002\u000b\u0016\u0001\u0001BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001A\u0002\u0013%Q\u0006C\u00042\u0001\u0001\u0007I\u0011\u0002\u001a\t\rm\u0002\u0001\u0015)\u0003/\u0011%a\u0004\u00011AA\u0002\u0013%Q\bC\u0005G\u0001\u0001\u0007\t\u0019!C\u0005\u000f\"I\u0011\n\u0001a\u0001\u0002\u0003\u0006KA\u0010\u0005\u0006\u0015\u0002!\te\u0013\u0005\u0006\u0019\u0002!\te\u0013\u0005\u0006\u001b\u0002!\t%\f\u0005\u0006\u001d\u0002!Ia\u0014\u0005\n\u0003[\u0002\u0011\u0013!C\u0005\u0003_Bq!a$\u0001\t\u0013\t\tjB\u0004\u0002PVA\t!!5\u0007\rQ)\u0002\u0012AAj\u0011\u0019As\u0002\"\u0001\u0002b\"I\u00111]\bC\u0002\u0013%\u0011Q\u001d\u0005\t\u0003{|\u0001\u0015!\u0003\u0002h\"I\u0011q`\b\u0002\u0002\u0013%!\u0011\u0001\u0002\u0015\u001b\u0006\u0004x+\u001b;i'R\fG/\u001a*E\tN+\u0018\u000e^3\u000b\u0005Y9\u0012a\u0001:eI*\u0011\u0001$G\u0001\ngR\u0014X-Y7j]\u001eT!AG\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011%\n\t\u0003E\rj\u0011!G\u0005\u0003Ie\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u0012'\u0013\t9\u0013DA\nS\t\u0012\u001b\u0005.Z2la>Lg\u000e\u001e+fgR,'/\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u0002+\u0005\u00111oY\u000b\u0002]A\u0011!eL\u0005\u0003ae\u0011Ab\u00159be.\u001cuN\u001c;fqR\faa]2`I\u0015\fHCA\u001a:!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0011)f.\u001b;\t\u000fi\u001a\u0011\u0011!a\u0001]\u0005\u0019\u0001\u0010J\u0019\u0002\u0007M\u001c\u0007%A\u0007dQ\u0016\u001c7\u000e]8j]R$\u0015N]\u000b\u0002}A\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0003S>T\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\n!a)\u001b7f\u0003E\u0019\u0007.Z2la>Lg\u000e\u001e#je~#S-\u001d\u000b\u0003g!CqA\u000f\u0004\u0002\u0002\u0003\u0007a(\u0001\bdQ\u0016\u001c7\u000e]8j]R$\u0015N\u001d\u0011\u0002\u0013\t,gm\u001c:f\u00032dG#A\u001a\u0002\u0011\u00054G/\u001a:BY2\fAb\u001d9be.\u001cuN\u001c;fqR\fq\"Y:tKJ$x\n]3sCRLwN\\\u000b\u0006!^\u000bGm\u001a\u000b\u000e#jd\u0018QBA\u0017\u0003o\ti&a\u0019\u0015\u000bIK\u0017\u000f^<\u0011\r-\u001aV\u000bY2g\u0013\t!VCA\bNCB<\u0016\u000e\u001e5Ti\u0006$XM\u0015#E!\t1v\u000b\u0004\u0001\u0005\u000ba[!\u0019A-\u0003\u0003-\u000b\"AW/\u0011\u0005QZ\u0016B\u0001/6\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u000e0\n\u0005}+$aA!osB\u0011a+\u0019\u0003\u0006E.\u0011\r!\u0017\u0002\u0002-B\u0011a\u000b\u001a\u0003\u0006K.\u0011\r!\u0017\u0002\u0002'B\u0011ak\u001a\u0003\u0006Q.\u0011\r!\u0017\u0002\u0002)\"9!nCA\u0001\u0002\bY\u0017AC3wS\u0012,gnY3%cA\u0019An\\+\u000e\u00035T!A\\\u001b\u0002\u000fI,g\r\\3di&\u0011\u0001/\u001c\u0002\t\u00072\f7o\u001d+bO\"9!oCA\u0001\u0002\b\u0019\u0018AC3wS\u0012,gnY3%eA\u0019An\u001c1\t\u000fU\\\u0011\u0011!a\u0002m\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\u00071|7\rC\u0004y\u0017\u0005\u0005\t9A=\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007E\u0002m_\u001aDQa_\u0006A\u0002I\u000bA\u0002^3tiN#\u0018\r^3S\t\u0012CQ!`\u0006A\u0002y\f!B\\3x\t\u0006$\u0018M\u0015#E!\u0015y\u00181AA\u0004\u001b\t\t\tA\u0003\u0002\u00173%!\u0011QAA\u0001\u0005\r\u0011F\t\u0012\t\u0006i\u0005%Q\u000bY\u0005\u0004\u0003\u0017)$A\u0002+va2,'\u0007C\u0004\u0002\u0010-\u0001\r!!\u0005\u0002\u001f5\f\u0007\u000f]5oO\u001a+hn\u0019;j_:\u0004B\u0002NA\n\u0003/)\u0016qDA\u0013\u0003WI1!!\u00066\u0005%1UO\\2uS>tG\u0007\u0005\u0003\u0002\u001a\u0005mQ\"A\f\n\u0007\u0005uqC\u0001\u0003US6,\u0007\u0003\u0002\u001b\u0002\"\u0001L1!a\t6\u0005\u0019y\u0005\u000f^5p]B)\u0011\u0011DA\u0014G&\u0019\u0011\u0011F\f\u0003\u000bM#\u0018\r^3\u0011\tQ\n\tC\u001a\u0005\b\u0003_Y\u0001\u0019AA\u0019\u0003-\u0019WO\u001d:f]R$\u0016.\\3\u0011\u0007Q\n\u0019$C\u0002\u00026U\u0012A\u0001T8oO\"9\u0011\u0011H\u0006A\u0002\u0005m\u0012AD3ya\u0016\u001cG/\u001a3Ti\u0006$Xm\u001d\t\u0007\u0003{\tY%!\u0015\u000f\t\u0005}\u0012q\t\t\u0004\u0003\u0003*TBAA\"\u0015\r\t)eH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%S'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\nyEA\u0002TKRT1!!\u00136!\u001d!\u00141K+d\u0003/J1!!\u00166\u0005\u0019!V\u000f\u001d7fgA\u0019A'!\u0017\n\u0007\u0005mSGA\u0002J]RDq!a\u0018\f\u0001\u0004\t\t'\u0001\nfqB,7\r^3e\u001b\u0006\u0004\b/\u001a3ECR\f\u0007#BA\u001f\u0003\u00172\u0007\"CA3\u0017A\u0005\t\u0019AA4\u0003)!wNR;mYN\u001b\u0017M\u001c\t\u0004i\u0005%\u0014bAA6k\t9!i\\8mK\u0006t\u0017!G1tg\u0016\u0014Ho\u00149fe\u0006$\u0018n\u001c8%I\u00164\u0017-\u001e7uI]*\"\"!\u001d\u0002\b\u0006%\u00151RAG+\t\t\u0019H\u000b\u0003\u0002h\u0005U4FAA<!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005U'\u0001\u0006b]:|G/\u0019;j_:LA!!\"\u0002|\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000bac!\u0019A-\u0005\u000b\td!\u0019A-\u0005\u000b\u0015d!\u0019A-\u0005\u000b!d!\u0019A-\u0002\u0013\u0005\u001c8/\u001a:u%\u0012#UCCAJ\u0003?\u000bI+a-\u0002>RA\u0011QSA`\u0003\u000b\fY\rF\u00054\u0003/\u000b\t+a+\u00026\"I\u0011\u0011T\u0007\u0002\u0002\u0003\u000f\u00111T\u0001\u000bKZLG-\u001a8dK\u0012*\u0004\u0003\u00027p\u0003;\u00032AVAP\t\u0015AVB1\u0001Z\u0011%\t\u0019+DA\u0001\u0002\b\t)+\u0001\u0006fm&$WM\\2fIY\u0002B\u0001\\8\u0002(B\u0019a+!+\u0005\u000b\tl!\u0019A-\t\u0013\u00055V\"!AA\u0004\u0005=\u0016AC3wS\u0012,gnY3%oA!An\\AY!\r1\u00161\u0017\u0003\u0006K6\u0011\r!\u0017\u0005\n\u0003ok\u0011\u0011!a\u0002\u0003s\u000b!\"\u001a<jI\u0016t7-\u001a\u00139!\u0011aw.a/\u0011\u0007Y\u000bi\fB\u0003i\u001b\t\u0007\u0011\fC\u0004\u0002B6\u0001\r!a1\u0002\u0011M$\u0018\r^3S\t\u0012\u0003\"bK*\u0002\u001e\u0006\u001d\u0016\u0011WA^\u0011\u001d\tI$\u0004a\u0001\u0003\u000f\u0004b!!\u0010\u0002L\u0005%\u0007#\u0003\u001b\u0002T\u0005u\u0015\u0011WA,\u0011\u001d\ty&\u0004a\u0001\u0003\u001b\u0004b!!\u0010\u0002L\u0005m\u0016\u0001F'ba^KG\u000f[*uCR,'\u000b\u0012#Tk&$X\r\u0005\u0002,\u001fM)q\"!6\u0002\\B\u0019A'a6\n\u0007\u0005eWG\u0001\u0004B]f\u0014VM\u001a\t\u0004i\u0005u\u0017bAApk\ta1+\u001a:jC2L'0\u00192mKR\u0011\u0011\u0011[\u0001\u0011i>,8\r[3e'R\fG/Z&fsN,\"!a:\u0011\r\u0005%\u00181_A|\u001b\t\tYO\u0003\u0003\u0002n\u0006=\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003c,\u0014AC2pY2,7\r^5p]&!\u0011Q_Av\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\t\u0005u\u0012\u0011`\u0005\u0005\u0003w\fyE\u0001\u0004TiJLgnZ\u0001\u0012i>,8\r[3e'R\fG/Z&fsN\u0004\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0001\u0011\t\t\u0015!1B\u0007\u0003\u0005\u000fQ1A!\u0003C\u0003\u0011a\u0017M\\4\n\t\t5!q\u0001\u0002\u0007\u001f\nTWm\u0019;")
public class MapWithStateRDDSuite
extends SparkFunSuite
implements RDDCheckpointTester {
    private SparkContext sc;
    private File checkpointDir;
    private final HashPartitioner partitioner;

    public <U> void testRDD(Function1<RDD<Object>, RDD<U>> op, boolean reliableCheckpoint, Function1<RDD<U>, Object> collectFunc, ClassTag<U> evidence$1) {
        RDDCheckpointTester.testRDD$((RDDCheckpointTester)this, op, (boolean)reliableCheckpoint, collectFunc, evidence$1);
    }

    public <U> Function1<RDD<U>, Object> testRDD$default$3() {
        return RDDCheckpointTester.testRDD$default$3$((RDDCheckpointTester)this);
    }

    public <U> void testRDDPartitions(Function1<RDD<Object>, RDD<U>> op, boolean reliableCheckpoint, Function1<RDD<U>, Object> collectFunc, ClassTag<U> evidence$2) {
        RDDCheckpointTester.testRDDPartitions$((RDDCheckpointTester)this, op, (boolean)reliableCheckpoint, collectFunc, evidence$2);
    }

    public <U> Function1<RDD<U>, Object> testRDDPartitions$default$3() {
        return RDDCheckpointTester.testRDDPartitions$default$3$((RDDCheckpointTester)this);
    }

    public <T> T serializeDeserialize(T obj) {
        return (T)RDDCheckpointTester.serializeDeserialize$((RDDCheckpointTester)this, obj);
    }

    public void checkpoint(RDD<?> rdd, boolean reliableCheckpoint) {
        RDDCheckpointTester.checkpoint$((RDDCheckpointTester)this, rdd, (boolean)reliableCheckpoint);
    }

    public void runTest(String name, boolean skipLocalCheckpoint, Function1<Object, BoxedUnit> body) {
        RDDCheckpointTester.runTest$((RDDCheckpointTester)this, (String)name, (boolean)skipLocalCheckpoint, body);
    }

    public boolean runTest$default$2() {
        return RDDCheckpointTester.runTest$default$2$((RDDCheckpointTester)this);
    }

    public RDD<Object> generateFatRDD() {
        return RDDCheckpointTester.generateFatRDD$((RDDCheckpointTester)this);
    }

    public RDD<Tuple2<Object, Object>> generateFatPairRDD() {
        return RDDCheckpointTester.generateFatPairRDD$((RDDCheckpointTester)this);
    }

    public HashPartitioner partitioner() {
        return this.partitioner;
    }

    public void org$apache$spark$RDDCheckpointTester$_setter_$partitioner_$eq(HashPartitioner x$1) {
        this.partitioner = x$1;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    private File checkpointDir() {
        return this.checkpointDir;
    }

    private void checkpointDir_$eq(File x$1) {
        this.checkpointDir = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.sc_$eq(new SparkContext(new SparkConf().setMaster("local").setAppName("MapWithStateRDDSuite")));
        this.checkpointDir_$eq(Utils$.MODULE$.createTempDir());
        this.sc().setCheckpointDir(this.checkpointDir().toString());
    }

    public void afterAll() {
        try {
            if (this.sc() != null) {
                this.sc().stop();
            }
            Utils$.MODULE$.deleteRecursively(this.checkpointDir());
        }
        finally {
            super.afterAll();
        }
    }

    public SparkContext sparkContext() {
        return this.sc();
    }

    private <K, V, S, T> MapWithStateRDD<K, V, S, T> assertOperation(MapWithStateRDD<K, V, S, T> testStateRDD, RDD<Tuple2<K, V>> newDataRDD, Function4<Time, K, Option<V>, State<S>, Option<T>> mappingFunction, long currentTime, Set<Tuple3<K, S, Object>> expectedStates, Set<T> expectedMappedData, boolean doFullScan, ClassTag<K> evidence$1, ClassTag<V> evidence$2, ClassTag<S> evidence$3, ClassTag<T> evidence$4) {
        RDD rDD;
        Option option = newDataRDD.partitioner();
        Option option2 = testStateRDD.partitioner();
        if (option == null ? option2 != null : !option.equals(option2)) {
            RDD x$1 = newDataRDD;
            ClassTag<K> x$2 = evidence$1;
            ClassTag<V> x$3 = evidence$2;
            Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
            rDD = RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).partitionBy((Partitioner)testStateRDD.partitioner().get());
        } else {
            rDD = newDataRDD;
        }
        RDD partitionedNewDataRDD = rDD;
        MapWithStateRDD newStateRDD = new MapWithStateRDD(testStateRDD, newDataRDD, mappingFunction, new Time(currentTime), (Option)None$.MODULE$, evidence$1, evidence$2, evidence$3, evidence$4);
        if (doFullScan) {
            newStateRDD.setFullScan();
        }
        newStateRDD.persist().count();
        this.assertRDD(newStateRDD, expectedStates, expectedMappedData, evidence$1, evidence$2, evidence$3, evidence$4);
        return newStateRDD;
    }

    private <K, V, S, T> boolean assertOperation$default$7() {
        return false;
    }

    private <K, V, S, T> void assertRDD(MapWithStateRDD<K, V, S, T> stateRDD, Set<Tuple3<K, S, Object>> expectedStates, Set<T> expectedMappedData, ClassTag<K> evidence$5, ClassTag<V> evidence$6, ClassTag<S> evidence$7, ClassTag<T> evidence$8) {
        Set states = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stateRDD.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.stateMap().getAll(), ClassTag$.MODULE$.apply(Tuple3.class)).collect())).toSet();
        Set mappedData = Predef$.MODULE$.genericArrayOps(stateRDD.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.mappedData(), evidence$8).collect()).toSet();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(states);
        Set<Tuple3<K, S, Object>> $org_scalatest_assert_macro_right = expectedStates;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"states after mapWithState operation were not as expected", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(mappedData);
        Set<T> $org_scalatest_assert_macro_right2 = expectedMappedData;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mapped data after mapWithState operation were not as expected", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
    }

    private final Option testFunc$1(Time t, String key, Option data, State state, VolatileBooleanRef functionCalled$1, long updatedTime$1, ArrayBuffer removedStates$1, ArrayBuffer timingOutStates$1) {
        String string;
        String string2;
        String string3;
        functionCalled$1.elem = true;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)t.milliseconds()));
        long $org_scalatest_assert_macro_right = updatedTime$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"mapping func called with wrong time", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        boolean bl = false;
        Some some = null;
        Option option = data;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string4 = (String)some.value();
            if ("noop".equals(string4)) {
                return None$.MODULE$;
            }
        }
        if (bl && "get-state".equals(string3 = (String)some.value())) {
            return new Some(state.getOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
        }
        if (bl && "update-state".equals(string2 = (String)some.value())) {
            if (state.exists()) {
                state.update((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)state.get()) + 1)));
            } else {
                state.update((Object)BoxesRunTime.boxToInteger((int)0));
            }
            return None$.MODULE$;
        }
        if (bl && "remove-state".equals(string = (String)some.value())) {
            removedStates$1.$plus$eq(state.get());
            state.remove();
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(state.isTimingOut(), "state.isTimingOut()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"State is not timing out when data = None", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            timingOutStates$1.$plus$eq(state.get());
            return None$.MODULE$;
        }
        throw this.fail("Unexpected test data", new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }

    private final void assertRecordUpdate$1(Iterable initStates, Iterable data2, Iterable expectedStates, Option timeoutThreshold, boolean removeTimedoutData, Iterable expectedOutput, Iterable expectedTimingOutStates, Iterable expectedRemovedStates, long initialTime$1, VolatileBooleanRef functionCalled$1, long updatedTime$1) {
        OpenHashMapBasedStateMap initialStateMap = new OpenHashMapBasedStateMap(ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int());
        initStates.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)s -> initialStateMap.put((Object)"key", (Object)BoxesRunTime.boxToInteger((int)s), initialTime$1));
        functionCalled$1.elem = false;
        MapWithStateRDDRecord record = new MapWithStateRDDRecord((StateMap)initialStateMap, (Seq)Nil$.MODULE$);
        Iterator dataIterator = ((IterableLike)data2.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2((Object)"key", v), Iterable$.MODULE$.canBuildFrom())).iterator();
        ArrayBuffer removedStates = new ArrayBuffer();
        ArrayBuffer timingOutStates = new ArrayBuffer();
        MapWithStateRDDRecord updatedRecord = MapWithStateRDDRecord$.MODULE$.updateRecordWithData((Option)new Some((Object)record), dataIterator, (Function4 & Serializable & scala.Serializable)(t, key, data, state) -> this.testFunc$1((Time)t, (String)key, (Option)data, (State)state, functionCalled$1, updatedTime$1, removedStates, timingOutStates), new Time(updatedTime$1), timeoutThreshold, removeTimedoutData, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
        Iterator updatedStateData = updatedRecord.stateMap().getAll().map((Function1 & Serializable & scala.Serializable)x -> new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)x._2()), BoxesRunTime.unboxToLong((Object)x._3())));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(updatedStateData.toSet());
        Set $org_scalatest_assert_macro_right = expectedStates.toSet();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"states do not match after updating the MapWithStateRDDRecord", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(updatedRecord.mappedData().toSet());
        Set $org_scalatest_assert_macro_right2 = expectedOutput.toSet();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mapped data do not match after updating the MapWithStateRDDRecord", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(timingOutStates.toSet());
        Set $org_scalatest_assert_macro_right3 = expectedTimingOutStates.toSet();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"timing out states do not match those that were expected to do so while updating the MapWithStateRDDRecord", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(removedStates.toSet());
        Set $org_scalatest_assert_macro_right4 = expectedRemovedStates.toSet();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"removed states do not match those that were expected to do so while updating the MapWithStateRDDRecord", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
    }

    private static final Option assertRecordUpdate$default$4$1() {
        return None$.MODULE$;
    }

    private static final boolean assertRecordUpdate$default$5$1() {
        return false;
    }

    private static final Iterable assertRecordUpdate$default$6$1() {
        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
    }

    private static final Iterable assertRecordUpdate$default$7$1() {
        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
    }

    private static final Iterable assertRecordUpdate$default$8$1() {
        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
    }

    private final MapWithStateRDD testStateUpdates$1(MapWithStateRDD testStateRDD, Seq testData, Set expectedStates, int updateTime$1, MapWithStateRDD initStateRDD$1, Set initStateWthTime$1) {
        testStateRDD.persist().count();
        MapWithStateRDDSuite$.MODULE$.org$apache$spark$streaming$rdd$MapWithStateRDDSuite$$touchedStateKeys().clear();
        Function4 & Serializable & scala.Serializable mappingFunction = (Function4 & Serializable & scala.Serializable)(time, key, data, state) -> {
            block3: {
                int n;
                Some some;
                boolean bl;
                block2: {
                    MapWithStateRDDSuite$.MODULE$.org$apache$spark$streaming$rdd$MapWithStateRDDSuite$$touchedStateKeys().$plus$eq(key);
                    bl = false;
                    some = null;
                    Option option = data;
                    if (!(option instanceof Some)) break block2;
                    bl = true;
                    some = (Some)option;
                    int n2 = BoxesRunTime.unboxToInt((Object)some.value());
                    if (1 != n2) break block2;
                    if (state.exists()) {
                        state.update((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)state.get()) + 1)));
                    } else {
                        state.update((Object)BoxesRunTime.boxToInteger((int)0));
                    }
                    break block3;
                }
                if (!bl || 2 != (n = BoxesRunTime.unboxToInt((Object)some.value()))) break block3;
                state.remove();
            }
            return None$.MODULE$;
        };
        SparkContext qual$1 = this.sc();
        Seq x$1 = testData;
        int x$2 = qual$1.makeRDD$default$2();
        RDD newDataRDD = RDD$.MODULE$.rddToPairRDDFunctions(qual$1.makeRDD(x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).partitionBy((Partitioner)testStateRDD.partitioner().get());
        MapWithStateRDD newStateRDD = this.assertOperation(testStateRDD, newDataRDD, mappingFunction, updateTime$1, expectedStates, Predef$.MODULE$.Set().empty(), this.assertOperation$default$7(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)MapWithStateRDDSuite$.MODULE$.org$apache$spark$streaming$rdd$MapWithStateRDDSuite$$touchedStateKeys().size()));
        int $org_scalatest_assert_macro_right = testData.size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"More number of keys are being touched than that is expected", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(MapWithStateRDDSuite$.MODULE$.org$apache$spark$streaming$rdd$MapWithStateRDDSuite$$touchedStateKeys().toSet());
        Iterable $org_scalatest_assert_macro_right2 = testData.toMap(Predef$.MODULE$.$conforms()).keys();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Keys not in the data are being touched unexpectedly", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        this.assertRDD(initStateRDD$1, initStateWthTime$1, Predef$.MODULE$.Set().empty(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
        return newStateRDD;
    }

    private static final Set rddCollectFunc$1(RDD rdd) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.map((Function1 & Serializable & scala.Serializable)record -> new Tuple2((Object)record.stateMap().getAll().toList(), (Object)record.mappedData().toList()), ClassTag$.MODULE$.apply(Tuple2.class)).collect())).toSet();
    }

    private final MapWithStateRDD makeStateRDDWithLongLineageDataRDD$1(RDD longLineageRDD) {
        return MapWithStateRDD$.MODULE$.createFromPairRDD(longLineageRDD.map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$1))), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), (Partitioner)this.partitioner(), new Time(0L), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
    }

    public static final /* synthetic */ None$ $anonfun$new$19(Time time, int key, Option value, State state) {
        return None$.MODULE$;
    }

    private final MapWithStateRDD makeStateRDDWithLongLineageParentStateRDD$1(RDD longLineageRDD) {
        MapWithStateRDD stateRDDWithLongLineage = this.makeStateRDDWithLongLineageDataRDD$1(longLineageRDD);
        return new MapWithStateRDD((RDD)stateRDDWithLongLineage, RDD$.MODULE$.rddToPairRDDFunctions(stateRDDWithLongLineage.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)this.partitioner()), (Function4 & Serializable & scala.Serializable)(time, key, value, state) -> MapWithStateRDDSuite.$anonfun$new$19(time, BoxesRunTime.unboxToInt((Object)key), value, state), new Time(10L), (Option)None$.MODULE$, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
    }

    public MapWithStateRDDSuite() {
        RDDCheckpointTester.$init$((RDDCheckpointTester)this);
        this.sc = null;
        this.test("creation from pair RDD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq data = (Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"1"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"2"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)"3"), (List)Nil$.MODULE$)));
            HashPartitioner partitioner = new HashPartitioner(10);
            SparkContext qual$1 = this.sc();
            Seq x$1 = data;
            int x$2 = qual$1.parallelize$default$2();
            MapWithStateRDD rdd = MapWithStateRDD$.MODULE$.createFromPairRDD(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)), (Partitioner)partitioner, new Time(123L), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int());
            this.assertRDD(rdd, ((TraversableOnce)data.map((Function1 & Serializable & scala.Serializable)x -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), x._2(), (Object)BoxesRunTime.boxToInteger((int)123)), Seq$.MODULE$.canBuildFrom())).toSet(), Predef$.MODULE$.Set().empty(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.partitions())).size()));
            int $org_scalatest_assert_macro_right = partitioner.numPartitions();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rdd.partitioner());
            Some $org_scalatest_assert_macro_right2 = new Some((Object)partitioner);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }, new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("updating state and generating mapped data in MapWithStateRDDRecord", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long initialTime = 1000L;
            long updatedTime = 2000L;
            long thresholdTime = 1500L;
            VolatileBooleanRef functionCalled = VolatileBooleanRef.create((boolean)false);
            this.assertRecordUpdate$1((Iterable)Nil$.MODULE$, Option$.MODULE$.option2Iterable((Option)None$.MODULE$), (Iterable)Nil$.MODULE$, MapWithStateRDDSuite.assertRecordUpdate$default$4$1(), MapWithStateRDDSuite.assertRecordUpdate$default$5$1(), MapWithStateRDDSuite.assertRecordUpdate$default$6$1(), MapWithStateRDDSuite.assertRecordUpdate$default$7$1(), MapWithStateRDDSuite.assertRecordUpdate$default$8$1(), initialTime, functionCalled, updatedTime);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)functionCalled.elem));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            this.assertRecordUpdate$1((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), Option$.MODULE$.option2Iterable((Option)None$.MODULE$), (Iterable)new .colon.colon((Object)new Tuple2.mcIJ.sp(0, initialTime), (List)Nil$.MODULE$), MapWithStateRDDSuite.assertRecordUpdate$default$4$1(), MapWithStateRDDSuite.assertRecordUpdate$default$5$1(), MapWithStateRDDSuite.assertRecordUpdate$default$6$1(), MapWithStateRDDSuite.assertRecordUpdate$default$7$1(), MapWithStateRDDSuite.assertRecordUpdate$default$8$1(), initialTime, functionCalled, updatedTime);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)functionCalled.elem));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            this.assertRecordUpdate$1((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Iterable)new .colon.colon((Object)"noop", (List)Nil$.MODULE$), (Iterable)new .colon.colon((Object)new Tuple2.mcIJ.sp(0, initialTime), (List)Nil$.MODULE$), MapWithStateRDDSuite.assertRecordUpdate$default$4$1(), MapWithStateRDDSuite.assertRecordUpdate$default$5$1(), MapWithStateRDDSuite.assertRecordUpdate$default$6$1(), MapWithStateRDDSuite.assertRecordUpdate$default$7$1(), MapWithStateRDDSuite.assertRecordUpdate$default$8$1(), initialTime, functionCalled, updatedTime);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(functionCalled.elem, "functionCalled", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            this.assertRecordUpdate$1(Option$.MODULE$.option2Iterable((Option)None$.MODULE$), Option$.MODULE$.option2Iterable((Option)new Some((Object)"noop")), Option$.MODULE$.option2Iterable((Option)None$.MODULE$), MapWithStateRDDSuite.assertRecordUpdate$default$4$1(), MapWithStateRDDSuite.assertRecordUpdate$default$5$1(), MapWithStateRDDSuite.assertRecordUpdate$default$6$1(), MapWithStateRDDSuite.assertRecordUpdate$default$7$1(), MapWithStateRDDSuite.assertRecordUpdate$default$8$1(), initialTime, functionCalled, updatedTime);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(functionCalled.elem, "functionCalled", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            Iterable x$3 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            Seq x$4 = (Seq)new .colon.colon((Object)"get-state", (List)Nil$.MODULE$);
            Iterable x$5 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1}));
            Option x$7 = MapWithStateRDDSuite.assertRecordUpdate$default$4$1();
            boolean x$8 = MapWithStateRDDSuite.assertRecordUpdate$default$5$1();
            Iterable x$9 = MapWithStateRDDSuite.assertRecordUpdate$default$7$1();
            Iterable x$10 = MapWithStateRDDSuite.assertRecordUpdate$default$8$1();
            this.assertRecordUpdate$1(x$3, (Iterable)x$4, x$5, x$7, x$8, (Iterable)x$6, x$9, x$10, initialTime, functionCalled, updatedTime);
            Seq x$11 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Seq x$12 = (Seq)new .colon.colon((Object)"get-state", (List)Nil$.MODULE$);
            Seq x$13 = (Seq)new .colon.colon((Object)new Tuple2.mcIJ.sp(123, initialTime), (List)Nil$.MODULE$);
            Seq x$14 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Option x$15 = MapWithStateRDDSuite.assertRecordUpdate$default$4$1();
            boolean x$16 = MapWithStateRDDSuite.assertRecordUpdate$default$5$1();
            Iterable x$17 = MapWithStateRDDSuite.assertRecordUpdate$default$7$1();
            Iterable x$18 = MapWithStateRDDSuite.assertRecordUpdate$default$8$1();
            this.assertRecordUpdate$1((Iterable)x$11, (Iterable)x$12, (Iterable)x$13, x$15, x$16, (Iterable)x$14, x$17, x$18, initialTime, functionCalled, updatedTime);
            this.assertRecordUpdate$1((Iterable)Nil$.MODULE$, (Iterable)new .colon.colon((Object)"update-state", (List)Nil$.MODULE$), (Iterable)new .colon.colon((Object)new Tuple2.mcIJ.sp(0, updatedTime), (List)Nil$.MODULE$), MapWithStateRDDSuite.assertRecordUpdate$default$4$1(), MapWithStateRDDSuite.assertRecordUpdate$default$5$1(), MapWithStateRDDSuite.assertRecordUpdate$default$6$1(), MapWithStateRDDSuite.assertRecordUpdate$default$7$1(), MapWithStateRDDSuite.assertRecordUpdate$default$8$1(), initialTime, functionCalled, updatedTime);
            this.assertRecordUpdate$1((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Iterable)new .colon.colon((Object)"update-state", (List)Nil$.MODULE$), (Iterable)new .colon.colon((Object)new Tuple2.mcIJ.sp(1, updatedTime), (List)Nil$.MODULE$), MapWithStateRDDSuite.assertRecordUpdate$default$4$1(), MapWithStateRDDSuite.assertRecordUpdate$default$5$1(), MapWithStateRDDSuite.assertRecordUpdate$default$6$1(), MapWithStateRDDSuite.assertRecordUpdate$default$7$1(), MapWithStateRDDSuite.assertRecordUpdate$default$8$1(), initialTime, functionCalled, updatedTime);
            Seq x$19 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{345}));
            Seq x$20 = (Seq)new .colon.colon((Object)"remove-state", (List)Nil$.MODULE$);
            Nil$ x$21 = Nil$.MODULE$;
            Seq x$22 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{345}));
            Option x$23 = MapWithStateRDDSuite.assertRecordUpdate$default$4$1();
            boolean x$24 = MapWithStateRDDSuite.assertRecordUpdate$default$5$1();
            Iterable x$25 = MapWithStateRDDSuite.assertRecordUpdate$default$6$1();
            Iterable x$26 = MapWithStateRDDSuite.assertRecordUpdate$default$7$1();
            this.assertRecordUpdate$1((Iterable)x$19, (Iterable)x$20, (Iterable)x$21, x$23, x$24, x$25, x$26, (Iterable)x$22, initialTime, functionCalled, updatedTime);
            Seq x$27 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Nil$ x$28 = Nil$.MODULE$;
            Some x$29 = new Some((Object)BoxesRunTime.boxToLong((long)initialTime));
            boolean x$30 = true;
            Seq x$31 = (Seq)new .colon.colon((Object)new Tuple2.mcIJ.sp(123, initialTime), (List)Nil$.MODULE$);
            Nil$ x$32 = Nil$.MODULE$;
            Iterable x$33 = MapWithStateRDDSuite.assertRecordUpdate$default$6$1();
            Iterable x$34 = MapWithStateRDDSuite.assertRecordUpdate$default$8$1();
            this.assertRecordUpdate$1((Iterable)x$27, (Iterable)x$28, (Iterable)x$31, (Option)x$29, x$30, x$33, (Iterable)x$32, x$34, initialTime, functionCalled, updatedTime);
            Seq x$35 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Nil$ x$36 = Nil$.MODULE$;
            Some x$37 = new Some((Object)BoxesRunTime.boxToLong((long)(initialTime + 1L)));
            boolean x$38 = true;
            Nil$ x$39 = Nil$.MODULE$;
            Seq x$40 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Iterable x$41 = MapWithStateRDDSuite.assertRecordUpdate$default$6$1();
            Iterable x$42 = MapWithStateRDDSuite.assertRecordUpdate$default$8$1();
            this.assertRecordUpdate$1((Iterable)x$35, (Iterable)x$36, (Iterable)x$39, (Option)x$37, x$38, x$41, (Iterable)x$40, x$42, initialTime, functionCalled, updatedTime);
            Seq x$43 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Seq x$44 = (Seq)new .colon.colon((Object)"noop", (List)Nil$.MODULE$);
            Some x$45 = new Some((Object)BoxesRunTime.boxToLong((long)(initialTime + 1L)));
            boolean x$46 = true;
            Seq x$47 = (Seq)new .colon.colon((Object)new Tuple2.mcIJ.sp(123, updatedTime), (List)Nil$.MODULE$);
            Nil$ x$48 = Nil$.MODULE$;
            Iterable x$49 = MapWithStateRDDSuite.assertRecordUpdate$default$6$1();
            Iterable x$50 = MapWithStateRDDSuite.assertRecordUpdate$default$8$1();
            this.assertRecordUpdate$1((Iterable)x$43, (Iterable)x$44, (Iterable)x$47, (Option)x$45, x$46, x$49, (Iterable)x$48, x$50, initialTime, functionCalled, updatedTime);
            Seq x$51 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Seq x$52 = (Seq)new .colon.colon((Object)"remove-state", (List)Nil$.MODULE$);
            Some x$53 = new Some((Object)BoxesRunTime.boxToLong((long)(initialTime + 1L)));
            boolean x$54 = true;
            Nil$ x$55 = Nil$.MODULE$;
            Nil$ x$56 = Nil$.MODULE$;
            Seq x$57 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Iterable x$58 = MapWithStateRDDSuite.assertRecordUpdate$default$6$1();
            this.assertRecordUpdate$1((Iterable)x$51, (Iterable)x$52, (Iterable)x$55, (Option)x$53, x$54, x$58, (Iterable)x$56, (Iterable)x$57, initialTime, functionCalled, updatedTime);
            Seq x$59 = (Seq)Nil$.MODULE$;
            Seq x$60 = (Seq)new .colon.colon((Object)"noop", (List)Nil$.MODULE$);
            Some x$61 = new Some((Object)BoxesRunTime.boxToLong((long)(initialTime + 1L)));
            boolean x$62 = true;
            Nil$ x$63 = Nil$.MODULE$;
            Nil$ x$64 = Nil$.MODULE$;
            Iterable x$65 = MapWithStateRDDSuite.assertRecordUpdate$default$6$1();
            Iterable x$66 = MapWithStateRDDSuite.assertRecordUpdate$default$8$1();
            this.assertRecordUpdate$1((Iterable)x$59, (Iterable)x$60, (Iterable)x$63, (Option)x$61, x$62, x$65, (Iterable)x$64, x$66, initialTime, functionCalled, updatedTime);
        }, new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("states generated by MapWithStateRDD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq initStates = (Seq)new .colon.colon((Object)new Tuple2((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$));
            int initTime = 123;
            Set initStateWthTime = ((TraversableOnce)initStates.map((Function1 & Serializable & scala.Serializable)x -> new Tuple3(x._1(), (Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)initTime)), Seq$.MODULE$.canBuildFrom())).toSet();
            HashPartitioner partitioner = new HashPartitioner(2);
            SparkContext qual$2 = this.sc();
            Seq x$67 = initStates;
            int x$68 = qual$2.parallelize$default$2();
            MapWithStateRDD initStateRDD = (MapWithStateRDD)MapWithStateRDD$.MODULE$.createFromPairRDD(qual$2.parallelize(x$67, x$68, ClassTag$.MODULE$.apply(Tuple2.class)), (Partitioner)partitioner, new Time((long)initTime), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).persist();
            this.assertRDD(initStateRDD, initStateWthTime, Predef$.MODULE$.Set().empty(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
            int updateTime = 345;
            this.testStateUpdates$1(initStateRDD, (Seq)Nil$.MODULE$, initStateWthTime, updateTime, initStateRDD, initStateWthTime);
            this.testStateUpdates$1(initStateRDD, (Seq)new .colon.colon((Object)new Tuple2((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$), initStateWthTime, updateTime, initStateRDD, initStateWthTime);
            this.testStateUpdates$1(initStateRDD, (Seq)new .colon.colon((Object)new Tuple2((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$), initStateWthTime, updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd1 = this.testStateUpdates$1(initStateRDD, (Seq)new .colon.colon((Object)new Tuple2((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)initTime)), new Tuple3((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)initTime)), new Tuple3((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)updateTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd2 = this.testStateUpdates$1(rdd1, (Seq)new .colon.colon((Object)new Tuple2((Object)"k4", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)initTime)), new Tuple3((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)initTime)), new Tuple3((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)updateTime)), new Tuple3((Object)"k4", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)updateTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd3 = this.testStateUpdates$1(initStateRDD, (Seq)new .colon.colon((Object)new Tuple2((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)updateTime)), new Tuple3((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)initTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd4 = this.testStateUpdates$1(rdd3, (Seq)new .colon.colon((Object)new Tuple2((Object)"x", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)new Tuple2((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)new Tuple2((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)))), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)updateTime)), new Tuple3((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)updateTime)), new Tuple3((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)updateTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd5 = this.testStateUpdates$1(rdd4, (Seq)new .colon.colon((Object)new Tuple2((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)updateTime)), new Tuple3((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)updateTime)), new Tuple3((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)updateTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd6 = this.testStateUpdates$1(initStateRDD, (Seq)new .colon.colon((Object)new Tuple2((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)initTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd7 = this.testStateUpdates$1(rdd6, (Seq)new .colon.colon((Object)new Tuple2((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple2((Object)"k0", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple2((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$))), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)updateTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd8 = this.testStateUpdates$1(rdd7, (Seq)new .colon.colon((Object)new Tuple2((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), updateTime, initStateRDD, initStateWthTime);
        }, new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testRDD((Function1 & Serializable & scala.Serializable)longLineageRDD -> this.makeStateRDDWithLongLineageDataRDD$1((RDD)longLineageRDD), true, (Function1 & Serializable & scala.Serializable)rdd -> MapWithStateRDDSuite.rddCollectFunc$1(rdd), ClassTag$.MODULE$.apply(MapWithStateRDDRecord.class));
            this.testRDDPartitions((Function1 & Serializable & scala.Serializable)longLineageRDD -> this.makeStateRDDWithLongLineageDataRDD$1((RDD)longLineageRDD), true, (Function1 & Serializable & scala.Serializable)rdd -> MapWithStateRDDSuite.rddCollectFunc$1(rdd), ClassTag$.MODULE$.apply(MapWithStateRDDRecord.class));
            this.testRDD((Function1 & Serializable & scala.Serializable)longLineageRDD -> this.makeStateRDDWithLongLineageParentStateRDD$1((RDD)longLineageRDD), true, (Function1 & Serializable & scala.Serializable)rdd -> MapWithStateRDDSuite.rddCollectFunc$1(rdd), ClassTag$.MODULE$.apply(MapWithStateRDDRecord.class));
            this.testRDDPartitions((Function1 & Serializable & scala.Serializable)longLineageRDD -> this.makeStateRDDWithLongLineageParentStateRDD$1((RDD)longLineageRDD), true, (Function1 & Serializable & scala.Serializable)rdd -> MapWithStateRDDSuite.rddCollectFunc$1(rdd), ClassTag$.MODULE$.apply(MapWithStateRDDRecord.class));
        }, new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        this.test("checkpointing empty state RDD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MapWithStateRDD emptyStateRDD = MapWithStateRDD$.MODULE$.createFromPairRDD(this.sc().emptyRDD(ClassTag$.MODULE$.apply(Tuple2.class)), (Partitioner)new HashPartitioner(10), new Time(0L), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
            emptyStateRDD.checkpoint();
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])emptyStateRDD.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.stateMap().getAll(), ClassTag$.MODULE$.apply(Tuple3.class)).collect());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            RDD cpRDD = this.sc().checkpointFile((String)emptyStateRDD.getCheckpointFile().get(), ClassTag$.MODULE$.apply(MapWithStateRDDRecord.class));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])cpRDD.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.stateMap().getAll(), ClassTag$.MODULE$.apply(Tuple3.class)).collect());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        }, new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
    }
}

