/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.streaming.util.RateLimitedOutputStream;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001E2Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00053\ta\"+\u0019;f\u0019&l\u0017\u000e^3e\u001fV$\b/\u001e;TiJ,\u0017-\\*vSR,'BA\u0003\u0007\u0003\u0011)H/\u001b7\u000b\u0005\u001dA\u0011!C:ue\u0016\fW.\u001b8h\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003!I!a\u0005\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\ta\u0003\u0005\u0002\u0018\u00015\tA!A\u0005cK:\u001c\u0007.\\1sWV\u0011!\u0004\u000b\u000b\u00037\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011A\u0001T8oO\"1!E\u0001CA\u0002\r\n\u0011A\u001a\t\u00049\u00112\u0013BA\u0013\u001e\u0005!a$-\u001f8b[\u0016t\u0004CA\u0014)\u0019\u0001!Q!\u000b\u0002C\u0002)\u0012\u0011!V\t\u0003W9\u0002\"\u0001\b\u0017\n\u00055j\"a\u0002(pi\"Lgn\u001a\t\u00039=J!\u0001M\u000f\u0003\u0007\u0005s\u0017\u0010")
public class RateLimitedOutputStreamSuite
extends SparkFunSuite {
    private <U> long benchmark(Function0<U> f) {
        long start = System.nanoTime();
        f.apply();
        return System.nanoTime() - start;
    }

    public RateLimitedOutputStreamSuite() {
        this.test("write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long seconds;
            ByteArrayOutputStream underlying = new ByteArrayOutputStream();
            String data = new StringOps(Predef$.MODULE$.augmentString("X")).$times(41000);
            RateLimitedOutputStream stream = new RateLimitedOutputStream((OutputStream)underlying, 10000);
            long elapsedNs = this.benchmark((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> stream.write(data.getBytes(StandardCharsets.UTF_8)));
            long $org_scalatest_assert_macro_left = seconds = TimeUnit.SECONDS.convert(elapsedNs, TimeUnit.NANOSECONDS);
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(32).append("Seconds value (").append(seconds).append(") is less than 4.").toString(), Prettifier$.MODULE$.default(), new Position("RateLimitedOutputStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            long $org_scalatest_assert_macro_left2 = seconds;
            int $org_scalatest_assert_macro_right2 = 30;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(43).append("Took more than 30 seconds (").append(seconds).append(") to write data.").toString(), Prettifier$.MODULE$.default(), new Position("RateLimitedOutputStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(underlying.toString(StandardCharsets.UTF_8.name()));
            String $org_scalatest_assert_macro_right3 = data;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RateLimitedOutputStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        }, new Position("RateLimitedOutputStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
    }
}

