/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.BlockGenerator$;
import org.apache.spark.streaming.receiver.BlockGenerator$Block$;
import org.apache.spark.streaming.receiver.BlockGenerator$GeneratorState$;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.RateLimiter;
import org.apache.spark.streaming.util.RecurringTimer;
import org.apache.spark.util.Clock;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r%a!B\u0001\u0003\u0001\u0011a!A\u0004\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d\u0006\u0003\u0007\u0011\t\u0001B]3dK&4XM\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0012!\tqq\"D\u0001\u0003\u0013\t\u0001\"AA\u0006SCR,G*[7ji\u0016\u0014\bC\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\f\u0014\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\tY&\u001cH/\u001a8fe\u000e\u0001\u0001C\u0001\b\u001c\u0013\ta\"A\u0001\fCY>\u001c7nR3oKJ\fGo\u001c:MSN$XM\\3s\u0011!q\u0002A!A!\u0002\u0013y\u0012A\u0003:fG\u0016Lg/\u001a:JIB\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t\u0019\u0011J\u001c;\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001d\nAaY8oMB\u0011\u0001&K\u0007\u0002\r%\u0011!F\u0002\u0002\n'B\f'o[\"p]\u001aD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\u0006G2|7m\u001b\t\u0003]Ej\u0011a\f\u0006\u0003a\u0019\tA!\u001e;jY&\u0011!g\f\u0002\u0006\u00072|7m\u001b\u0005\u0006i\u0001!\t!N\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bY:\u0004(\u000f\u001e\u0011\u00059\u0001\u0001\"\u0002\r4\u0001\u0004Q\u0002\"\u0002\u00104\u0001\u0004y\u0002\"\u0002\u00144\u0001\u00049\u0003b\u0002\u00174!\u0003\u0005\r!\f\u0004\u0005y\u0001!UHA\u0003CY>\u001c7n\u0005\u0003<}\u0005#\u0005C\u0001\u0011@\u0013\t\u0001\u0015E\u0001\u0004B]f\u0014VM\u001a\t\u0003A\tK!aQ\u0011\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001%R\u0005\u0003\r\u0006\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002S\u001e\u0003\u0016\u0004%\t!S\u0001\u0003S\u0012,\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b\u001a\tqa\u001d;pe\u0006<W-\u0003\u0002P\u0019\ni1\u000b\u001e:fC6\u0014En\\2l\u0013\u0012D\u0001\"U\u001e\u0003\u0012\u0003\u0006IAS\u0001\u0004S\u0012\u0004\u0003\u0002C*<\u0005+\u0007I\u0011\u0001+\u0002\r\t,hMZ3s+\u0005)\u0006c\u0001,\\;6\tqK\u0003\u0002Y3\u00069Q.\u001e;bE2,'B\u0001.\"\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00039^\u00131\"\u0011:sCf\u0014UO\u001a4feB\u0011\u0001EX\u0005\u0003?\u0006\u00121!\u00118z\u0011!\t7H!E!\u0002\u0013)\u0016a\u00022vM\u001a,'\u000f\t\u0005\u0006im\"\ta\u0019\u000b\u0004I\u001a<\u0007CA3<\u001b\u0005\u0001\u0001\"\u0002%c\u0001\u0004Q\u0005\"B*c\u0001\u0004)\u0006bB5<\u0003\u0003%\tA[\u0001\u0005G>\u0004\u0018\u0010F\u0002eW2Dq\u0001\u00135\u0011\u0002\u0003\u0007!\nC\u0004TQB\u0005\t\u0019A+\t\u000f9\\\u0014\u0013!C\u0001_\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00019+\u0005)\u000b8&\u0001:\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018!C;oG\",7m[3e\u0015\t9\u0018%\u0001\u0006b]:|G/\u0019;j_:L!!\u001f;\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004|wE\u0005I\u0011\u0001?\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\tQP\u000b\u0002Vc\"AqpOA\u0001\n\u0003\n\t!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003mC:<'BAA\u0007\u0003\u0011Q\u0017M^1\n\t\u0005E\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\t\u0013\u0005U1(!A\u0005\u0002\u0005]\u0011\u0001\u00049s_\u0012,8\r^!sSRLX#A\u0010\t\u0013\u0005m1(!A\u0005\u0002\u0005u\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004;\u0006}\u0001\"CA\u0011\u00033\t\t\u00111\u0001 \u0003\rAH%\r\u0005\n\u0003KY\u0014\u0011!C!\u0003O\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003S\u0001R!a\u000b\u0002.uk\u0011!W\u0005\u0004\u0003_I&\u0001C%uKJ\fGo\u001c:\t\u0013\u0005M2(!A\u0005\u0002\u0005U\u0012\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]\u0012Q\b\t\u0004A\u0005e\u0012bAA\u001eC\t9!i\\8mK\u0006t\u0007\"CA\u0011\u0003c\t\t\u00111\u0001^\u0011%\t\teOA\u0001\n\u0003\n\u0019%\u0001\u0005iCND7i\u001c3f)\u0005y\u0002\"CA$w\u0005\u0005I\u0011IA%\u0003!!xn\u0015;sS:<GCAA\u0002\u0011%\tieOA\u0001\n\u0003\ny%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003o\t\t\u0006C\u0005\u0002\"\u0005-\u0013\u0011!a\u0001;\u001eI\u0011Q\u000b\u0001\u0002\u0002#%\u0011qK\u0001\u0006\u00052|7m\u001b\t\u0004K\u0006ec\u0001\u0003\u001f\u0001\u0003\u0003EI!a\u0017\u0014\u000b\u0005e\u0013Q\f#\u0011\u000f\u0005}\u0013Q\r&VI6\u0011\u0011\u0011\r\u0006\u0004\u0003G\n\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003O\n\tGA\tBEN$(/Y2u\rVt7\r^5p]JBq\u0001NA-\t\u0003\tY\u0007\u0006\u0002\u0002X!Q\u0011qIA-\u0003\u0003%)%!\u0013\t\u0015\u0005E\u0014\u0011LA\u0001\n\u0003\u000b\u0019(A\u0003baBd\u0017\u0010F\u0003e\u0003k\n9\b\u0003\u0004I\u0003_\u0002\rA\u0013\u0005\u0007'\u0006=\u0004\u0019A+\t\u0015\u0005m\u0014\u0011LA\u0001\n\u0003\u000bi(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005}\u00141\u0012\t\u0006A\u0005\u0005\u0015QQ\u0005\u0004\u0003\u0007\u000b#AB(qi&|g\u000eE\u0003!\u0003\u000fSU+C\u0002\u0002\n\u0006\u0012a\u0001V;qY\u0016\u0014\u0004\"CAG\u0003s\n\t\u00111\u0001e\u0003\rAH\u0005\r\u0005\u000b\u0003#\u000bI&!A\u0005\n\u0005M\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!&\u0011\t\u0005\u0015\u0011qS\u0005\u0005\u00033\u000b9A\u0001\u0004PE*,7\r^\u0004\b\u0003;\u0003\u0001\u0012BAP\u000399UM\\3sCR|'o\u0015;bi\u0016\u00042!ZAQ\r\u001d\t\u0019\u000b\u0001E\u0005\u0003K\u0013abR3oKJ\fGo\u001c:Ti\u0006$Xm\u0005\u0003\u0002\"\u0006\u001d\u0006c\u0001\u0011\u0002*&\u0019\u00111V\u0011\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u0005\bi\u0005\u0005F\u0011AAX)\t\ty*B\u0004\u0002$\u0006\u0005\u0006!a-\u0011\t\u0005U\u0016qW\u0007\u0003\u0003CKA!!/\u0002*\n)a+\u00197vK\"Q\u0011QXAQ\u0005\u0004%\t!a0\u0002\u0017%s\u0017\u000e^5bY&TX\rZ\u000b\u0003\u0003gC\u0011\"a1\u0002\"\u0002\u0006I!a-\u0002\u0019%s\u0017\u000e^5bY&TX\r\u001a\u0011\t\u0015\u0005\u001d\u0017\u0011\u0015b\u0001\n\u0003\ty,\u0001\u0004BGRLg/\u001a\u0005\n\u0003\u0017\f\t\u000b)A\u0005\u0003g\u000bq!Q2uSZ,\u0007\u0005\u0003\u0006\u0002P\u0006\u0005&\u0019!C\u0001\u0003\u007f\u000b\u0011c\u0015;paB,G-\u00113eS:<G)\u0019;b\u0011%\t\u0019.!)!\u0002\u0013\t\u0019,\u0001\nTi>\u0004\b/\u001a3BI\u0012Lgn\u001a#bi\u0006\u0004\u0003BCAl\u0003C\u0013\r\u0011\"\u0001\u0002@\u000692\u000b^8qa\u0016$w)\u001a8fe\u0006$\u0018N\\4CY>\u001c7n\u001d\u0005\n\u00037\f\t\u000b)A\u0005\u0003g\u000b\u0001d\u0015;paB,GmR3oKJ\fG/\u001b8h\u00052|7m[:!\u0011)\ty.!)C\u0002\u0013\u0005\u0011qX\u0001\u000b'R|\u0007\u000f]3e\u00032d\u0007\"CAr\u0003C\u0003\u000b\u0011BAZ\u0003-\u0019Fo\u001c9qK\u0012\fE\u000e\u001c\u0011\t\u0013\u0005\u001d\bA1A\u0005\n\u0005%\u0018a\u00042m_\u000e\\\u0017J\u001c;feZ\fG.T:\u0016\u0005\u0005-\bc\u0001\u0011\u0002n&\u0019\u0011q^\u0011\u0003\t1{gn\u001a\u0005\t\u0003g\u0004\u0001\u0015!\u0003\u0002l\u0006\u0001\"\r\\8dW&sG/\u001a:wC2l5\u000f\t\u0005\n\u0003o\u0004!\u0019!C\u0005\u0003s\f!C\u00197pG.Le\u000e^3sm\u0006dG+[7feV\u0011\u00111 \t\u0005\u0003{\u0014\t!\u0004\u0002\u0002\u0000*\u0011\u0001\u0007B\u0005\u0005\u0005\u0007\tyP\u0001\bSK\u000e,(O]5oORKW.\u001a:\t\u0011\t\u001d\u0001\u0001)A\u0005\u0003w\f1C\u00197pG.Le\u000e^3sm\u0006dG+[7fe\u0002B\u0011Ba\u0003\u0001\u0005\u0004%I!a\u0006\u0002\u001d\tdwnY6Rk\u0016,XmU5{K\"9!q\u0002\u0001!\u0002\u0013y\u0012a\u00042m_\u000e\\\u0017+^3vKNK'0\u001a\u0011\t\u0013\tM\u0001A1A\u0005\n\tU\u0011\u0001\u00052m_\u000e\\7OR8s!V\u001c\b.\u001b8h+\t\u00119\u0002E\u0003\u0003\u001a\t\u0005B-\u0004\u0002\u0003\u001c)!!Q\u0004B\u0010\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004a\u0005-\u0011\u0002\u0002B\u0012\u00057\u0011!#\u0011:sCf\u0014En\\2lS:<\u0017+^3vK\"A!q\u0005\u0001!\u0002\u0013\u00119\"A\tcY>\u001c7n\u001d$peB+8\u000f[5oO\u0002B\u0011Ba\u000b\u0001\u0005\u0004%IA!\f\u0002%\tdwnY6QkND\u0017N\\4UQJ,\u0017\rZ\u000b\u0003\u0005_\u0001B!!\u0002\u00032%!!1GA\u0004\u0005\u0019!\u0006N]3bI\"A!q\u0007\u0001!\u0002\u0013\u0011y#A\ncY>\u001c7\u000eU;tQ&tw\r\u00165sK\u0006$\u0007\u0005\u0003\u0005\u0003<\u0001\u0001\r\u0011\"\u0003U\u00035\u0019WO\u001d:f]R\u0014UO\u001a4fe\"I!q\b\u0001A\u0002\u0013%!\u0011I\u0001\u0012GV\u0014(/\u001a8u\u0005V4g-\u001a:`I\u0015\fH\u0003\u0002B\"\u0005\u0013\u00022\u0001\tB#\u0013\r\u00119%\t\u0002\u0005+:LG\u000fC\u0005\u0002\"\tu\u0012\u0011!a\u0001+\"9!Q\n\u0001!B\u0013)\u0016AD2veJ,g\u000e\u001e\"vM\u001a,'\u000f\t\u0015\u0005\u0005\u0017\u0012\t\u0006E\u0002!\u0005'J1A!\u0016\"\u0005!1x\u000e\\1uS2,\u0007\"\u0003B-\u0001\u0001\u0007I\u0011\u0002B.\u0003\u0015\u0019H/\u0019;f+\t\u0011i\u0006\u0005\u0003\u0003`\u0005]fbA3\u0002\u001c\"I!1\r\u0001A\u0002\u0013%!QM\u0001\ngR\fG/Z0%KF$BAa\u0011\u0003h!Q\u0011\u0011\u0005B1\u0003\u0003\u0005\rA!\u0018\t\u0011\t-\u0004\u0001)Q\u0005\u0005;\naa\u001d;bi\u0016\u0004\u0003\u0006\u0002B5\u0005#BqA!\u001d\u0001\t\u0003\u0011\u0019(A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0003D!9!q\u000f\u0001\u0005\u0002\tM\u0014\u0001B:u_BDqAa\u001f\u0001\t\u0003\u0011i(A\u0004bI\u0012$\u0015\r^1\u0015\t\t\r#q\u0010\u0005\b\u0005\u0003\u0013I\b1\u0001^\u0003\u0011!\u0017\r^1\t\u000f\t\u0015\u0005\u0001\"\u0001\u0003\b\u0006\u0019\u0012\r\u001a3ECR\fw+\u001b;i\u0007\u0006dGNY1dWR1!1\tBE\u0005\u0017CqA!!\u0003\u0004\u0002\u0007Q\fC\u0004\u0003\u000e\n\r\u0005\u0019A/\u0002\u00115,G/\u00193bi\u0006DqA!%\u0001\t\u0003\u0011\u0019*A\u000ebI\u0012lU\u000f\u001c;ja2,G)\u0019;b/&$\bnQ1mY\n\f7m\u001b\u000b\u0007\u0005\u0007\u0012)Ja,\t\u0011\t]%q\u0012a\u0001\u00053\u000bA\u0002Z1uC&#XM]1u_J\u0004RAa'\u0003,vsAA!(\u0003(:!!q\u0014BS\u001b\t\u0011\tKC\u0002\u0003$f\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0012\n\u0007\t%\u0016%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\"Q\u0016\u0006\u0004\u0005S\u000b\u0003b\u0002BG\u0005\u001f\u0003\r!\u0018\u0005\b\u0005g\u0003A\u0011\u0001B[\u0003!I7/Q2uSZ,GCAA\u001c\u0011\u001d\u0011I\f\u0001C\u0001\u0005k\u000b\u0011\"[:Ti>\u0004\b/\u001a3\t\u000f\tu\u0006\u0001\"\u0003\u0003@\u0006\u0019R\u000f\u001d3bi\u0016\u001cUO\u001d:f]R\u0014UO\u001a4feR!!1\tBa\u0011!\u0011\u0019Ma/A\u0002\u0005-\u0018\u0001\u0002;j[\u0016DqAa2\u0001\t\u0013\u0011\u0019(A\tlK\u0016\u0004\b+^:iS:<'\t\\8dWNDqAa3\u0001\t\u0013\u0011i-A\u0006sKB|'\u000f^#se>\u0014HC\u0002B\"\u0005\u001f\u0014y\u000e\u0003\u0005\u0003R\n%\u0007\u0019\u0001Bj\u0003\u001diWm]:bO\u0016\u0004BA!6\u0003\\:\u0019\u0001Ea6\n\u0007\te\u0017%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\u0011iNC\u0002\u0003Z\u0006B\u0001B!9\u0003J\u0002\u0007!1]\u0001\u0002iB!!1\u0014Bs\u0013\u0011\u00119O!,\u0003\u0013QC'o\\<bE2,\u0007b\u0002Bv\u0001\u0011%!Q^\u0001\naV\u001c\bN\u00117pG.$BAa\u0011\u0003p\"9!\u0011\u001fBu\u0001\u0004!\u0017!\u00022m_\u000e\\wA\u0003B{\u0005\u0005\u0005\t\u0012\u0001\u0003\u0003x\u0006q!\t\\8dW\u001e+g.\u001a:bi>\u0014\bc\u0001\b\u0003z\u001aI\u0011AAA\u0001\u0012\u0003!!1`\n\u0004\u0005st\u0004b\u0002\u001b\u0003z\u0012\u0005!q \u000b\u0003\u0005oD!ba\u0001\u0003zF\u0005I\u0011AB\u0003\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111q\u0001\u0016\u0003[E\u0004")
public class BlockGenerator
extends RateLimiter {
    private final BlockGeneratorListener listener;
    private final int receiverId;
    private final long blockIntervalMs;
    private final RecurringTimer blockIntervalTimer;
    private final int blockQueueSize;
    private final ArrayBlockingQueue<Block> org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing;
    private final Thread blockPushingThread;
    private volatile ArrayBuffer<Object> currentBuffer;
    private volatile Enumeration.Value org$apache$spark$streaming$receiver$BlockGenerator$$state;
    private volatile BlockGenerator$Block$ Block$module;
    private volatile BlockGenerator$GeneratorState$ GeneratorState$module;

    public static Clock $lessinit$greater$default$4() {
        return BlockGenerator$.MODULE$.$lessinit$greater$default$4();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlockGenerator$Block$ org$apache$spark$streaming$receiver$BlockGenerator$$Block$lzycompute() {
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            if (this.Block$module != null) return this.Block$module;
            this.Block$module = new BlockGenerator$Block$(this);
            return this.Block$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlockGenerator$GeneratorState$ GeneratorState$lzycompute() {
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            if (this.GeneratorState$module != null) return this.GeneratorState$module;
            this.GeneratorState$module = new BlockGenerator$GeneratorState$(this);
            return this.GeneratorState$module;
        }
    }

    public BlockGenerator$Block$ org$apache$spark$streaming$receiver$BlockGenerator$$Block() {
        return this.Block$module == null ? this.org$apache$spark$streaming$receiver$BlockGenerator$$Block$lzycompute() : this.Block$module;
    }

    private BlockGenerator$GeneratorState$ GeneratorState() {
        return this.GeneratorState$module == null ? this.GeneratorState$lzycompute() : this.GeneratorState$module;
    }

    private long blockIntervalMs() {
        return this.blockIntervalMs;
    }

    private RecurringTimer blockIntervalTimer() {
        return this.blockIntervalTimer;
    }

    private int blockQueueSize() {
        return this.blockQueueSize;
    }

    public ArrayBlockingQueue<Block> org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing() {
        return this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing;
    }

    private Thread blockPushingThread() {
        return this.blockPushingThread;
    }

    private ArrayBuffer<Object> currentBuffer() {
        return this.currentBuffer;
    }

    private void currentBuffer_$eq(ArrayBuffer<Object> x$1) {
        this.currentBuffer = x$1;
    }

    public Enumeration.Value org$apache$spark$streaming$receiver$BlockGenerator$$state() {
        return this.org$apache$spark$streaming$receiver$BlockGenerator$$state;
    }

    private void org$apache$spark$streaming$receiver$BlockGenerator$$state_$eq(Enumeration.Value x$1) {
        this.org$apache$spark$streaming$receiver$BlockGenerator$$state = x$1;
    }

    public synchronized void start() {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().Initialized();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.org$apache$spark$streaming$receiver$BlockGenerator$$state_$eq(this.GeneratorState().Active());
            this.blockIntervalTimer().start();
            this.blockPushingThread().start();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Started BlockGenerator";
                }
            });
            return;
        }
        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot start BlockGenerator as its not in the Initialized state [state = ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$streaming$receiver$BlockGenerator$$state()})));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void stop() {
        block10: {
            BlockGenerator blockGenerator = this;
            // MONITORENTER : blockGenerator
            Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
            Enumeration.Value value2 = this.GeneratorState().Active();
            if (value != null ? !value.equals(value2) : value2 != null) break block10;
            this.org$apache$spark$streaming$receiver$BlockGenerator$$state_$eq(this.GeneratorState().StoppedAddingData());
            // MONITOREXIT : blockGenerator
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopping BlockGenerator";
                }
            });
            this.blockIntervalTimer().stop(false);
            BlockGenerator blockGenerator2 = this;
            // MONITORENTER : blockGenerator2
            this.org$apache$spark$streaming$receiver$BlockGenerator$$state_$eq(this.GeneratorState().StoppedGeneratingBlocks());
            // MONITOREXIT : blockGenerator2
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Waiting for block pushing thread to terminate";
                }
            });
            this.blockPushingThread().join();
            BlockGenerator blockGenerator3 = this;
            // MONITORENTER : blockGenerator3
            this.org$apache$spark$streaming$receiver$BlockGenerator$$state_$eq(this.GeneratorState().StoppedAll());
            // MONITOREXIT : blockGenerator3
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopped BlockGenerator";
                }
            });
            return;
        }
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockGenerator $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot stop BlockGenerator as its not in the Active state [state = ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$state()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        // MONITOREXIT : blockGenerator
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addData(Object data) {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        if (value != null ? !value.equals(value2) : value2 != null) throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
        this.waitToPush();
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            Enumeration.Value value3 = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
            Enumeration.Value value4 = this.GeneratorState().Active();
            if (value3 != null ? !value3.equals(value4) : value4 != null) throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
            this.currentBuffer().$plus$eq(data);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDataWithCallback(Object data, Object metadata) {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        if (value != null ? !value.equals(value2) : value2 != null) throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
        this.waitToPush();
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            Enumeration.Value value3 = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
            Enumeration.Value value4 = this.GeneratorState().Active();
            if (value3 != null ? !value3.equals(value4) : value4 != null) throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
            this.currentBuffer().$plus$eq(data);
            this.listener.onAddData(data, metadata);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMultipleDataWithCallback(Iterator<Object> dataIterator, Object metadata) {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        if (value != null ? !value.equals(value2) : value2 != null) throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
        ArrayBuffer tempBuffer = new ArrayBuffer();
        dataIterator.foreach((Function1)new Serializable(this, tempBuffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockGenerator $outer;
            private final ArrayBuffer tempBuffer$1;

            public final ArrayBuffer<Object> apply(Object data) {
                this.$outer.waitToPush();
                return this.tempBuffer$1.$plus$eq(data);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.tempBuffer$1 = tempBuffer$1;
            }
        });
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            Enumeration.Value value3 = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
            Enumeration.Value value4 = this.GeneratorState().Active();
            if (value3 != null ? !value3.equals(value4) : value4 != null) throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
            this.currentBuffer().$plus$plus$eq((TraversableOnce)tempBuffer);
            this.listener.onAddData(tempBuffer, metadata);
            return;
        }
    }

    public boolean isActive() {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean isStopped() {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().StoppedAll();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void org$apache$spark$streaming$receiver$BlockGenerator$$updateCurrentBuffer(long time) {
        try {
            Block newBlock = null;
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                BoxedUnit boxedUnit;
                if (this.currentBuffer().nonEmpty()) {
                    ArrayBuffer<Object> newBlockBuffer = this.currentBuffer();
                    this.currentBuffer_$eq((ArrayBuffer<Object>)new ArrayBuffer());
                    StreamBlockId blockId = new StreamBlockId(this.receiverId, time - this.blockIntervalMs());
                    this.listener.onGenerateBlock(blockId);
                    newBlock = new Block(this, blockId, newBlockBuffer);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : blockGenerator
                if (newBlock == null) return;
            }
            this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().put(newBlock);
            return;
        }
        catch (Exception exception) {
            this.reportError("Error in block updating thread", exception);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Block updating timer thread was interrupted";
                }
            });
        }
    }

    public void org$apache$spark$streaming$receiver$BlockGenerator$$keepPushingBlocks() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Started block pushing thread";
            }
        });
        try {
            while (this.areBlocksBeingGenerated$1()) {
                BoxedUnit boxedUnit;
                Option option = Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().poll(10L, TimeUnit.MILLISECONDS));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Block block = (Block)some.x();
                    this.pushBlock(block);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)option);
            }
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BlockGenerator $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Pushing out the last ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().size())).append((Object)" blocks").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            while (true) {
                if (this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().isEmpty()) {
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Stopped block pushing thread";
                        }
                    });
                    break;
                }
                Block block = this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().take();
                this.logDebug((Function0<String>)new Serializable(this, block){
                    public static final long serialVersionUID = 0L;
                    private final Block block$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pushing block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.block$2}));
                    }
                    {
                        this.block$2 = block$2;
                    }
                });
                this.pushBlock(block);
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BlockGenerator $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Blocks left to push ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().size())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }
        catch (Exception exception) {
            this.reportError("Error in block pushing thread", exception);
        }
        catch (InterruptedException interruptedException) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Block pushing thread was interrupted";
                }
            });
        }
    }

    private void reportError(String message, Throwable t) {
        this.logError((Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final String message$1;

            public final String apply() {
                return this.message$1;
            }
            {
                this.message$1 = message$1;
            }
        }, t);
        this.listener.onError(message, t);
    }

    private void pushBlock(Block block) {
        this.listener.onPushBlock(block.id(), block.buffer());
        this.logInfo((Function0<String>)new Serializable(this, block){
            public static final long serialVersionUID = 0L;
            private final Block block$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Pushed block ").append((Object)this.block$1.id()).toString();
            }
            {
                this.block$1 = block$1;
            }
        });
    }

    private final synchronized boolean areBlocksBeingGenerated$1() {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().StoppedGeneratingBlocks();
        return value != null ? !value.equals(value2) : value2 != null;
    }

    public BlockGenerator(BlockGeneratorListener listener, int receiverId, SparkConf conf, Clock clock) {
        this.listener = listener;
        this.receiverId = receiverId;
        super(conf);
        this.blockIntervalMs = conf.getTimeAsMs("spark.streaming.blockInterval", "200ms");
        Predef$.MODULE$.require(this.blockIntervalMs() > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'spark.streaming.blockInterval' should be a positive value"})).s((Seq)Nil$.MODULE$);
            }
        });
        this.blockIntervalTimer = new RecurringTimer(clock, this.blockIntervalMs(), (Function1<Object, BoxedUnit>)new $anonfun$1(this), "BlockGenerator");
        this.blockQueueSize = conf.getInt("spark.streaming.blockQueueSize", 10);
        this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing = new ArrayBlockingQueue(this.blockQueueSize());
        this.blockPushingThread = new $anon$1(this);
        this.currentBuffer = new ArrayBuffer();
        this.org$apache$spark$streaming$receiver$BlockGenerator$$state = this.GeneratorState().Initialized();
    }

    public class Block
    implements Product,
    Serializable {
        private final StreamBlockId id;
        private final ArrayBuffer<Object> buffer;
        public final /* synthetic */ BlockGenerator $outer;

        public StreamBlockId id() {
            return this.id;
        }

        public ArrayBuffer<Object> buffer() {
            return this.buffer;
        }

        public Block copy(StreamBlockId id, ArrayBuffer<Object> buffer) {
            return new Block(this.org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer(), id, buffer);
        }

        public StreamBlockId copy$default$1() {
            return this.id();
        }

        public ArrayBuffer<Object> copy$default$2() {
            return this.buffer();
        }

        public String productPrefix() {
            return "Block";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            StreamBlockId streamBlockId;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    streamBlockId = this.buffer();
                    break;
                }
                case 0: {
                    streamBlockId = this.id();
                }
            }
            return streamBlockId;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Block;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Block)) return false;
            boolean bl = true;
            if (!bl) return false;
            Block block = (Block)x$1;
            StreamBlockId streamBlockId = this.id();
            StreamBlockId streamBlockId2 = block.id();
            if (streamBlockId == null) {
                if (streamBlockId2 != null) {
                    return false;
                }
            } else if (!streamBlockId.equals(streamBlockId2)) return false;
            ArrayBuffer<Object> arrayBuffer = this.buffer();
            ArrayBuffer<Object> arrayBuffer2 = block.buffer();
            if (arrayBuffer == null) {
                if (arrayBuffer2 != null) {
                    return false;
                }
            } else if (!arrayBuffer.equals(arrayBuffer2)) return false;
            if (!block.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BlockGenerator org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer() {
            return this.$outer;
        }

        public Block(BlockGenerator $outer, StreamBlockId id, ArrayBuffer<Object> buffer) {
            this.id = id;
            this.buffer = buffer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

