/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.Logging;
import org.apache.spark.streaming.scheduler.StreamingListener;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchSubmitted;
import org.apache.spark.streaming.scheduler.StreamingListenerEvent;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.util.AsynchronousListenerBus;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00113Q!\u0001\u0002\u0001\r1\u0011Ac\u0015;sK\u0006l\u0017N\\4MSN$XM\\3s\u0005V\u001c(BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!\u0004\u000e\u0011\t9\t2cF\u0007\u0002\u001f)\u0011\u0001CB\u0001\u0005kRLG.\u0003\u0002\u0013\u001f\t9\u0012i]=oG\"\u0014xN\\8vg2K7\u000f^3oKJ\u0014Uo\u001d\t\u0003)Ui\u0011AA\u0005\u0003-\t\u0011\u0011c\u0015;sK\u0006l\u0017N\\4MSN$XM\\3s!\t!\u0002$\u0003\u0002\u001a\u0005\t12\u000b\u001e:fC6Lgn\u001a'jgR,g.\u001a:Fm\u0016tG\u000f\u0005\u0002\u001c95\ta!\u0003\u0002\u001e\r\t9Aj\\4hS:<\u0007\"B\u0010\u0001\t\u0003\t\u0013A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\t\u0002\"\u0001\u0006\u0001\t\u000f\u0011\u0002!\u0019!C\u0005K\u0005yAn\\4Ee>\u0004\b/\u001a3Fm\u0016tG/F\u0001'!\t9s&D\u0001)\u0015\tI#&\u0001\u0004bi>l\u0017n\u0019\u0006\u0003W1\n!bY8oGV\u0014(/\u001a8u\u0015\t\u0001RFC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AB#!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u00043\u0001\u0001\u0006IAJ\u0001\u0011Y><GI]8qa\u0016$WI^3oi\u0002BQ\u0001\u000e\u0001\u0005BU\n1b\u001c8Q_N$XI^3oiR\u0019a\u0007\u0010 \u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006{M\u0002\raE\u0001\tY&\u001cH/\u001a8fe\")qh\ra\u0001/\u0005)QM^3oi\")\u0011\t\u0001C!\u0005\u0006YqN\u001c#s_B,e/\u001a8u)\t14\tC\u0003@\u0001\u0002\u0007q\u0003")
public class StreamingListenerBus
extends AsynchronousListenerBus<StreamingListener, StreamingListenerEvent>
implements Logging {
    private final AtomicBoolean logDroppedEvent = new AtomicBoolean(false);

    private AtomicBoolean logDroppedEvent() {
        return this.logDroppedEvent;
    }

    public void onPostEvent(StreamingListener listener, StreamingListenerEvent event) {
        StreamingListenerEvent streamingListenerEvent = event;
        if (streamingListenerEvent instanceof StreamingListenerReceiverStarted) {
            StreamingListenerReceiverStarted streamingListenerReceiverStarted = (StreamingListenerReceiverStarted)streamingListenerEvent;
            listener.onReceiverStarted(streamingListenerReceiverStarted);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (streamingListenerEvent instanceof StreamingListenerReceiverError) {
            StreamingListenerReceiverError streamingListenerReceiverError = (StreamingListenerReceiverError)streamingListenerEvent;
            listener.onReceiverError(streamingListenerReceiverError);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (streamingListenerEvent instanceof StreamingListenerReceiverStopped) {
            StreamingListenerReceiverStopped streamingListenerReceiverStopped = (StreamingListenerReceiverStopped)streamingListenerEvent;
            listener.onReceiverStopped(streamingListenerReceiverStopped);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (streamingListenerEvent instanceof StreamingListenerBatchSubmitted) {
            StreamingListenerBatchSubmitted streamingListenerBatchSubmitted = (StreamingListenerBatchSubmitted)streamingListenerEvent;
            listener.onBatchSubmitted(streamingListenerBatchSubmitted);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (streamingListenerEvent instanceof StreamingListenerBatchStarted) {
            StreamingListenerBatchStarted streamingListenerBatchStarted = (StreamingListenerBatchStarted)streamingListenerEvent;
            listener.onBatchStarted(streamingListenerBatchStarted);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (streamingListenerEvent instanceof StreamingListenerBatchCompleted) {
            StreamingListenerBatchCompleted streamingListenerBatchCompleted = (StreamingListenerBatchCompleted)streamingListenerEvent;
            listener.onBatchCompleted(streamingListenerBatchCompleted);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (streamingListenerEvent instanceof StreamingListenerOutputOperationStarted) {
            StreamingListenerOutputOperationStarted streamingListenerOutputOperationStarted = (StreamingListenerOutputOperationStarted)streamingListenerEvent;
            listener.onOutputOperationStarted(streamingListenerOutputOperationStarted);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (streamingListenerEvent instanceof StreamingListenerOutputOperationCompleted) {
            StreamingListenerOutputOperationCompleted streamingListenerOutputOperationCompleted = (StreamingListenerOutputOperationCompleted)streamingListenerEvent;
            listener.onOutputOperationCompleted(streamingListenerOutputOperationCompleted);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void onDropEvent(StreamingListenerEvent event) {
        if (this.logDroppedEvent().compareAndSet(false, true)) {
            this.logError((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Dropping StreamingListenerEvent because no remaining room in event queue. This likely means one of the StreamingListeners is too slow and cannot keep up with the rate at which events are being started by the scheduler.";
                }
            });
        }
    }

    public StreamingListenerBus() {
        super("StreamingListenerBus");
    }
}

