/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.Logging;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.receiver.ArrayBufferBlock;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGenerator$;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.BlockManagerBasedBlockHandler;
import org.apache.spark.streaming.receiver.ByteBufferBlock;
import org.apache.spark.streaming.receiver.IteratorBlock;
import org.apache.spark.streaming.receiver.ReceivedBlock;
import org.apache.spark.streaming.receiver.ReceivedBlockHandler;
import org.apache.spark.streaming.receiver.ReceivedBlockStoreResult;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisor;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl$;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedBlockHandler;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedBlockHandler$;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.util.RpcUtils$;
import org.spark-project.guava.base.Throwables;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.SynchronizedBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUc!B\u0001\u0003\u0001\u0011a!A\u0006*fG\u0016Lg/\u001a:TkB,'O^5t_JLU\u000e\u001d7\u000b\u0005\r!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e#A\u0011abD\u0007\u0002\u0005%\u0011\u0001C\u0001\u0002\u0013%\u0016\u001cW-\u001b<feN+\b/\u001a:wSN|'\u000f\u0005\u0002\u0013'5\ta!\u0003\u0002\u0015\r\t9Aj\\4hS:<\u0007\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0004\u0001A\u0012\u0001$\b\t\u0004\u001deY\u0012B\u0001\u000e\u0003\u0005!\u0011VmY3jm\u0016\u0014\bC\u0001\u000f\u001e\u0019\u0001!\u0011BH\u000b\u0002\u0002\u0003\u0005)\u0011A\u0010\u0003\u0007}#\u0013'\u0005\u0002!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t9aj\u001c;iS:<\u0007CA\u0011(\u0013\tA#EA\u0002B]fD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0004K:4\bC\u0001\n-\u0013\ticA\u0001\u0005Ta\u0006\u00148.\u00128w\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014A\u00035bI>|\u0007oQ8oMB\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0005G>tgM\u0003\u00026\u0011\u00051\u0001.\u00193p_BL!a\u000e\u001a\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011!I\u0004A!A!\u0002\u0013Q\u0014aE2iK\u000e\\\u0007o\\5oi\u0012K'o\u00149uS>t\u0007cA\u0011<{%\u0011AH\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005y\neBA\u0011@\u0013\t\u0001%%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!#\u0011\u0015)\u0005\u0001\"\u0001G\u0003\u0019a\u0014N\\5u}Q)q\tS'O\u001fB\u0011a\u0002\u0001\u0005\u0006\u0007\u0011\u0003\r!\u0013\u0019\u0003\u00152\u00032AD\rL!\taB\nB\u0005\u001f\u0011\u0006\u0005\t\u0011!B\u0001?!)!\u0006\u0012a\u0001W!)q\u0006\u0012a\u0001a!)\u0011\b\u0012a\u0001u!9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0016\u0001\u00025pgR,\u0012!\u0010\u0005\u0007)\u0002\u0001\u000b\u0011B\u001f\u0002\u000b!|7\u000f\u001e\u0011\t\u000fY\u0003!\u0019!C\u0005%\u0006QQ\r_3dkR|'/\u00133\t\ra\u0003\u0001\u0015!\u0003>\u0003-)\u00070Z2vi>\u0014\u0018\n\u001a\u0011\t\u000fi\u0003!\u0019!C\u00057\u0006!\"/Z2fSZ,GM\u00117pG.D\u0015M\u001c3mKJ,\u0012\u0001\u0018\t\u0003\u001duK!A\u0018\u0002\u0003)I+7-Z5wK\u0012\u0014En\\2l\u0011\u0006tG\r\\3s\u0011\u0019\u0001\u0007\u0001)A\u00059\u0006)\"/Z2fSZ,GM\u00117pG.D\u0015M\u001c3mKJ\u0004\u0003b\u00022\u0001\u0005\u0004%IaY\u0001\u0010iJ\f7m[3s\u000b:$\u0007o\\5oiV\tA\r\u0005\u0002fQ6\taM\u0003\u0002h\r\u0005\u0019!\u000f]2\n\u0005%4'A\u0004*qG\u0016sG\r]8j]R\u0014VM\u001a\u0005\u0007W\u0002\u0001\u000b\u0011\u00023\u0002!Q\u0014\u0018mY6fe\u0016sG\r]8j]R\u0004\u0003bB7\u0001\u0005\u0004%IaY\u0001\tK:$\u0007o\\5oi\"1q\u000e\u0001Q\u0001\n\u0011\f\u0011\"\u001a8ea>Lg\u000e\u001e\u0011\t\u000fE\u0004!\u0019!C\u0005e\u0006Qa.Z<CY>\u001c7.\u00133\u0016\u0003M\u0004\"\u0001^?\u000e\u0003UT!A^<\u0002\r\u0005$x.\\5d\u0015\tA\u00180\u0001\u0006d_:\u001cWO\u001d:f]RT!A_>\u0002\tU$\u0018\u000e\u001c\u0006\u0002y\u0006!!.\u0019<b\u0013\tqXO\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDq!!\u0001\u0001A\u0003%1/A\u0006oK^\u0014En\\2l\u0013\u0012\u0004\u0003\"CA\u0003\u0001\t\u0007I\u0011BA\u0004\u0003e\u0011XmZ5ti\u0016\u0014X\r\u001a\"m_\u000e\\w)\u001a8fe\u0006$xN]:\u0016\u0005\u0005%!CBA\u0006\u0003'\tICB\u0004\u0002\u000e\u0005=\u0001!!\u0003\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0013\t!D]3hSN$XM]3e\u00052|7m[$f]\u0016\u0014\u0018\r^8sg\u0002\u0002b!!\u0006\u0002 \u0005\rRBAA\f\u0015\u0011\tI\"a\u0007\u0002\u000f5,H/\u00192mK*\u0019\u0011Q\u0004\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\"\u0005]!aC!se\u0006L()\u001e4gKJ\u00042ADA\u0013\u0013\r\t9C\u0001\u0002\u000f\u00052|7m[$f]\u0016\u0014\u0018\r^8s!\u0019\t)\"a\u000b\u0002$%!\u0011QFA\f\u0005I\u0019\u0016P\\2ie>t\u0017N_3e\u0005V4g-\u001a:\t\u0013\u0005E\u0002A1A\u0005\n\u0005M\u0012!\b3fM\u0006,H\u000e\u001e\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d'jgR,g.\u001a:\u0016\u0005\u0005U\"CBA\u001c\u0003{\t\u0019EB\u0004\u0002\u000e\u0005e\u0002!!\u000e\t\u0011\u0005m\u0002\u0001)A\u0005\u0003k\ta\u0004Z3gCVdGO\u00117pG.<UM\\3sCR|'\u000fT5ti\u0016tWM\u001d\u0011\u0011\u0007\u0005\ny$C\u0002\u0002B\t\u0012a!\u00118z%\u00164\u0007c\u0001\b\u0002F%\u0019\u0011q\t\u0002\u0003-\tcwnY6HK:,'/\u0019;pe2K7\u000f^3oKJD\u0011\"a\u0013\u0001\u0005\u0004%I!!\u0014\u0002+\u0011,g-Y;mi\ncwnY6HK:,'/\u0019;peV\u0011\u00111\u0005\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002$\u00051B-\u001a4bk2$(\t\\8dW\u001e+g.\u001a:bi>\u0014\b\u0005\u0003\u0005\u0002V\u0001!\t\u0005BA,\u0003M9W\r^\"veJ,g\u000e\u001e*bi\u0016d\u0015.\\5u+\t\tI\u0006E\u0002\"\u00037J1!!\u0018#\u0005\u0011auN\\4\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d\u0005Q\u0001/^:i'&tw\r\\3\u0015\t\u0005\u0015\u00141\u000e\t\u0004C\u0005\u001d\u0014bAA5E\t!QK\\5u\u0011\u001d\ti'a\u0018A\u0002\u0019\nA\u0001Z1uC\"9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0014a\u00049vg\"\f%O]1z\u0005V4g-\u001a:\u0015\u0011\u0005\u0015\u0014QOAB\u0003\u0013C\u0001\"a\u001e\u0002p\u0001\u0007\u0011\u0011P\u0001\fCJ\u0014\u0018-\u001f\"vM\u001a,'\u000f\r\u0003\u0002|\u0005}\u0004CBA\u000b\u0003?\ti\bE\u0002\u001d\u0003\u007f\"1\"!!\u0002v\u0005\u0005\t\u0011!B\u0001?\t\u0019q\fJ\u001a\t\u0011\u0005\u0015\u0015q\u000ea\u0001\u0003\u000f\u000ba\"\\3uC\u0012\fG/Y(qi&|g\u000eE\u0002\"w\u0019B\u0001\"a#\u0002p\u0001\u0007\u0011QR\u0001\u000eE2|7m[%e\u001fB$\u0018n\u001c8\u0011\t\u0005Z\u0014q\u0012\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011Q\u0013\u0004\u0002\u000fM$xN]1hK&!\u0011\u0011TAJ\u00055\u0019FO]3b[\ncwnY6JI\"9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0015\u0001\u00049vg\"LE/\u001a:bi>\u0014H\u0003CA3\u0003C\u000b)-a2\t\u0011\u0005\r\u00161\u0014a\u0001\u0003K\u000b\u0001\"\u001b;fe\u0006$xN\u001d\u0019\u0005\u0003O\u000b\t\r\u0005\u0004\u0002*\u0006e\u0016q\u0018\b\u0005\u0003W\u000b)L\u0004\u0003\u0002.\u0006MVBAAX\u0015\r\t\tLF\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ1!a.#\u0003\u001d\u0001\u0018mY6bO\u0016LA!a/\u0002>\nA\u0011\n^3sCR|'OC\u0002\u00028\n\u00022\u0001HAa\t-\t\u0019-!)\u0002\u0002\u0003\u0005)\u0011A\u0010\u0003\u0007}#C\u0007\u0003\u0005\u0002\u0006\u0006m\u0005\u0019AAD\u0011!\tY)a'A\u0002\u00055\u0005bBAf\u0001\u0011\u0005\u0011QZ\u0001\naV\u001c\bNQ=uKN$\u0002\"!\u001a\u0002P\u0006}\u0017\u0011\u001d\u0005\t\u0003#\fI\r1\u0001\u0002T\u0006)!-\u001f;fgB!\u0011Q[An\u001b\t\t9NC\u0002\u0002Zn\f1A\\5p\u0013\u0011\ti.a6\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f\u0003\u0005\u0002\u0006\u0006%\u0007\u0019AAD\u0011!\tY)!3A\u0002\u00055\u0005bBAs\u0001\u0011\u0005\u0011q]\u0001\u0013aV\u001c\b.\u00118e%\u0016\u0004xN\u001d;CY>\u001c7\u000e\u0006\u0005\u0002f\u0005%\u00181_A{\u0011!\tY/a9A\u0002\u00055\u0018!\u0004:fG\u0016Lg/\u001a3CY>\u001c7\u000eE\u0002\u000f\u0003_L1!!=\u0003\u00055\u0011VmY3jm\u0016$'\t\\8dW\"A\u0011QQAr\u0001\u0004\t9\t\u0003\u0005\u0002\f\u0006\r\b\u0019AAG\u0011\u001d\tI\u0010\u0001C\u0001\u0003w\f1B]3q_J$XI\u001d:peR1\u0011QMA\u007f\u0005\u0003Aq!a@\u0002x\u0002\u0007Q(A\u0004nKN\u001c\u0018mZ3\t\u0011\t\r\u0011q\u001fa\u0001\u0005\u000b\tQ!\u001a:s_J\u0004B!!+\u0003\b%!!\u0011BA_\u0005%!\u0006N]8xC\ndW\rC\u0004\u0003\u000e\u0001!\tFa\u0004\u0002\u000f=t7\u000b^1siR\u0011\u0011Q\r\u0005\b\u0005'\u0001A\u0011\u000bB\u000b\u0003\u0019ygn\u0015;paR1\u0011Q\rB\f\u00053Aq!a@\u0003\u0012\u0001\u0007Q\b\u0003\u0005\u0003\u0004\tE\u0001\u0019\u0001B\u000e!\u0011\t3H!\u0002\t\u000f\t}\u0001\u0001\"\u0015\u0003\"\u0005yqN\u001c*fG\u0016Lg/\u001a:Ti\u0006\u0014H\u000f\u0006\u0002\u0003$A\u0019\u0011E!\n\n\u0007\t\u001d\"EA\u0004C_>dW-\u00198\t\u000f\t-\u0002\u0001\"\u0015\u0003.\u0005qqN\u001c*fG\u0016Lg/\u001a:Ti>\u0004HCBA3\u0005_\u0011\t\u0004C\u0004\u0002\u0000\n%\u0002\u0019A\u001f\t\u0011\t\r!\u0011\u0006a\u0001\u00057AqA!\u000e\u0001\t\u0003\u00129$\u0001\u000bde\u0016\fG/\u001a\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d\u000b\u0005\u0003G\u0011I\u0004\u0003\u0005\u0003<\tM\u0002\u0019AA\"\u0003Y\u0011Gn\\2l\u000f\u0016tWM]1u_Jd\u0015n\u001d;f]\u0016\u0014\bb\u0002B \u0001\u0011%!\u0011I\u0001\f]\u0016DHO\u00117pG.LE-\u0006\u0002\u0002\u0010\"9!Q\t\u0001\u0005\n\t\u001d\u0013\u0001E2mK\u0006tW\u000f](mI\ncwnY6t)\u0011\t)G!\u0013\t\u0011\t-#1\ta\u0001\u0005\u001b\n\u0011c\u00197fC:,\b\u000f\u00165sKNDG+[7f!\u0011\u0011yE!\u0015\u000e\u0003\u0011I1Aa\u0015\u0005\u0005\u0011!\u0016.\\3")
public class ReceiverSupervisorImpl
extends ReceiverSupervisor {
    private final Receiver<?> receiver;
    public final SparkEnv org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env;
    private final String host;
    private final String executorId;
    private final ReceivedBlockHandler receivedBlockHandler;
    private final RpcEndpointRef trackerEndpoint;
    private final RpcEndpointRef endpoint;
    private final AtomicLong newBlockId;
    private final ArrayBuffer<BlockGenerator> org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators;
    private final BlockGeneratorListener defaultBlockGeneratorListener;
    private final BlockGenerator defaultBlockGenerator;

    private String host() {
        return this.host;
    }

    private String executorId() {
        return this.executorId;
    }

    private ReceivedBlockHandler receivedBlockHandler() {
        return this.receivedBlockHandler;
    }

    private RpcEndpointRef trackerEndpoint() {
        return this.trackerEndpoint;
    }

    private RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    private AtomicLong newBlockId() {
        return this.newBlockId;
    }

    public ArrayBuffer<BlockGenerator> org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators() {
        return this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators;
    }

    private BlockGeneratorListener defaultBlockGeneratorListener() {
        return this.defaultBlockGeneratorListener;
    }

    private BlockGenerator defaultBlockGenerator() {
        return this.defaultBlockGenerator;
    }

    @Override
    public long getCurrentRateLimit() {
        return this.defaultBlockGenerator().getCurrentLimit();
    }

    @Override
    public void pushSingle(Object data) {
        this.defaultBlockGenerator().addData(data);
    }

    @Override
    public void pushArrayBuffer(ArrayBuffer<?> arrayBuffer, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new ArrayBufferBlock(arrayBuffer), metadataOption, blockIdOption);
    }

    @Override
    public void pushIterator(Iterator<Object> iterator, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new IteratorBlock(iterator), metadataOption, blockIdOption);
    }

    @Override
    public void pushBytes(ByteBuffer bytes, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new ByteBufferBlock(bytes), metadataOption, blockIdOption);
    }

    public void pushAndReportBlock(ReceivedBlock receivedBlock, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        StreamBlockId blockId = (StreamBlockId)blockIdOption.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final StreamBlockId apply() {
                return this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$nextBlockId();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        long time = System.currentTimeMillis();
        ReceivedBlockStoreResult blockStoreResult = this.receivedBlockHandler().storeBlock(blockId, receivedBlock);
        this.logDebug((Function0<String>)new Serializable(this, blockId, time){
            public static final long serialVersionUID = 0L;
            private final StreamBlockId blockId$1;
            private final long time$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pushed block ", " in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.time$1))}));
            }
            {
                this.blockId$1 = blockId$1;
                this.time$1 = time$1;
            }
        });
        Option<Object> numRecords2 = blockStoreResult.numRecords();
        ReceivedBlockInfo blockInfo = new ReceivedBlockInfo(this.streamId(), numRecords2, metadataOption, blockStoreResult);
        this.trackerEndpoint().askWithRetry((Object)new AddBlock(blockInfo), ClassTag$.MODULE$.Boolean());
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final StreamBlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reported block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
            }
            {
                this.blockId$1 = blockId$1;
            }
        });
    }

    @Override
    public void reportError(String message, Throwable error) {
        String errorString = (String)Option$.MODULE$.apply((Object)error).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Throwable x$1) {
                return Throwables.getStackTraceAsString((Throwable)x$1);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        this.trackerEndpoint().send((Object)new ReportError(this.streamId(), message, errorString));
        this.logWarning((Function0<String>)new Serializable(this, message, error){
            public static final long serialVersionUID = 0L;
            private final String message$1;
            private final Throwable error$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Reported error ").append((Object)this.message$1).append((Object)" - ").append((Object)this.error$1).toString();
            }
            {
                this.message$1 = message$1;
                this.error$1 = error$1;
            }
        });
    }

    @Override
    public void onStart() {
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BlockGenerator x$1) {
                x$1.start();
            }
        });
    }

    @Override
    public void onStop(String message, Option<Throwable> error) {
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BlockGenerator x$2) {
                x$2.stop();
            }
        });
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env.rpcEnv().stop(this.endpoint());
    }

    @Override
    public boolean onReceiverStart() {
        RegisterReceiver msg = new RegisterReceiver(this.streamId(), this.receiver.getClass().getSimpleName(), this.host(), this.executorId(), this.endpoint());
        return BoxesRunTime.unboxToBoolean((Object)this.trackerEndpoint().askWithRetry((Object)msg, ClassTag$.MODULE$.Boolean()));
    }

    @Override
    public void onReceiverStop(String message, Option<Throwable> error) {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Deregistering receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.streamId())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        String errorString = (String)error.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Throwable x$1) {
                return Throwables.getStackTraceAsString((Throwable)x$1);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        this.trackerEndpoint().askWithRetry((Object)new DeregisterReceiver(this.streamId(), message, errorString), ClassTag$.MODULE$.Boolean());
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Stopped receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.streamId())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BlockGenerator createBlockGenerator(BlockGeneratorListener blockGeneratorListener) {
        void var2_2;
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators().$minus$minus$eq((TraversableOnce)this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BlockGenerator x$3) {
                return x$3.isStopped();
            }
        }));
        BlockGenerator newBlockGenerator = new BlockGenerator(blockGeneratorListener, this.streamId(), this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env.conf(), BlockGenerator$.MODULE$.$lessinit$greater$default$4());
        ((SynchronizedBuffer)this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators()).$plus$eq((Object)newBlockGenerator);
        return var2_2;
    }

    public StreamBlockId org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$nextBlockId() {
        return new StreamBlockId(this.streamId(), this.newBlockId().getAndIncrement());
    }

    public void org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$cleanupOldBlocks(Time cleanupThreshTime) {
        this.logDebug((Function0<String>)new Serializable(this, cleanupThreshTime){
            public static final long serialVersionUID = 0L;
            private final Time cleanupThreshTime$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleaning up blocks older then ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanupThreshTime$1}));
            }
            {
                this.cleanupThreshTime$1 = cleanupThreshTime$1;
            }
        });
        this.receivedBlockHandler().cleanupOldBlocks(cleanupThreshTime.milliseconds());
    }

    public ReceiverSupervisorImpl(Receiver<?> receiver, SparkEnv env, Configuration hadoopConf, Option<String> checkpointDirOption) {
        Logging logging;
        this.receiver = receiver;
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env = env;
        super(receiver, env.conf());
        this.host = SparkEnv$.MODULE$.get().blockManager().blockManagerId().host();
        this.executorId = SparkEnv$.MODULE$.get().blockManager().blockManagerId().executorId();
        if (WriteAheadLogUtils$.MODULE$.enableReceiverLog(env.conf())) {
            if (checkpointDirOption.isEmpty()) {
                throw new SparkException("Cannot enable receiver write-ahead log without checkpoint directory set. Please use streamingContext.checkpoint() to set the checkpoint directory. See documentation for more details.");
            }
            logging = new WriteAheadLogBasedBlockHandler(env.blockManager(), receiver.streamId(), receiver.storageLevel(), env.conf(), hadoopConf, (String)checkpointDirOption.get(), WriteAheadLogBasedBlockHandler$.MODULE$.$lessinit$greater$default$7());
        } else {
            logging = new BlockManagerBasedBlockHandler(env.blockManager(), receiver.storageLevel());
        }
        this.receivedBlockHandler = logging;
        this.trackerEndpoint = RpcUtils$.MODULE$.makeDriverRef("ReceiverTracker", env.conf(), env.rpcEnv());
        this.endpoint = env.rpcEnv().setupEndpoint(new StringBuilder().append((Object)"Receiver-").append((Object)BoxesRunTime.boxToInteger((int)this.streamId())).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString(), (RpcEndpoint)new $anon$2(this));
        this.newBlockId = new AtomicLong(System.currentTimeMillis());
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators = new $anon$1(this);
        this.defaultBlockGeneratorListener = new $anon$3(this);
        this.defaultBlockGenerator = this.createBlockGenerator(this.defaultBlockGeneratorListener());
    }
}

