/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.Checkpoint$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

public final class CheckpointReader$
implements Logging {
    public static final CheckpointReader$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new CheckpointReader$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Option<Checkpoint> read(String checkpointDir) {
        return this.read(checkpointDir, new SparkConf(), SparkHadoopUtil$.MODULE$.get().conf(), true);
    }

    /*
     * WARNING - void declaration
     */
    public Option<Checkpoint> read(String checkpointDir, SparkConf conf, Configuration hadoopConf, boolean ignoreReadError) {
        NonLocalReturnControl nonLocalReturnControl2;
        block4: {
            Option option;
            Object object = new Object();
            try {
                Path checkpointPath = new Path(checkpointDir);
                Seq checkpointFiles = (Seq)Checkpoint$.MODULE$.getCheckpointFiles(checkpointDir, (Option<FileSystem>)new Some((Object)this.org$apache$spark$streaming$CheckpointReader$$fs$1(hadoopConf, checkpointPath))).reverse();
                if (checkpointFiles.isEmpty()) {
                    return None$.MODULE$;
                }
                this.logInfo((Function0<String>)new Serializable(checkpointFiles){
                    public static final long serialVersionUID = 0L;
                    private final Seq checkpointFiles$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Checkpoint files found: ").append((Object)this.checkpointFiles$1.mkString(",")).toString();
                    }
                    {
                        this.checkpointFiles$1 = checkpointFiles$1;
                    }
                });
                ObjectRef readError = new ObjectRef(null);
                checkpointFiles.foreach((Function1)new Serializable(conf, hadoopConf, checkpointPath, readError, object){
                    public static final long serialVersionUID = 0L;
                    private final SparkConf conf$1;
                    private final Configuration hadoopConf$1;
                    private final Path checkpointPath$1;
                    private final ObjectRef readError$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(Path file) {
                        CheckpointReader$.MODULE$.logInfo((Function0<String>)new Serializable(this, file){
                            public static final long serialVersionUID = 0L;
                            private final Path file$2;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Attempting to load checkpoint from file ").append((Object)this.file$2).toString();
                            }
                            {
                                this.file$2 = file$2;
                            }
                        });
                        try {
                            FSDataInputStream fis = CheckpointReader$.MODULE$.org$apache$spark$streaming$CheckpointReader$$fs$1(this.hadoopConf$1, this.checkpointPath$1).open(file);
                            Checkpoint cp = Checkpoint$.MODULE$.deserialize((InputStream)fis, this.conf$1);
                            CheckpointReader$.MODULE$.logInfo((Function0<String>)new Serializable(this, file){
                                public static final long serialVersionUID = 0L;
                                private final Path file$2;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Checkpoint successfully loaded from file ").append((Object)this.file$2).toString();
                                }
                                {
                                    this.file$2 = file$2;
                                }
                            });
                            CheckpointReader$.MODULE$.logInfo((Function0<String>)new Serializable(this, cp){
                                public static final long serialVersionUID = 0L;
                                private final Checkpoint cp$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Checkpoint was generated at time ").append((Object)this.cp$1.checkpointTime()).toString();
                                }
                                {
                                    this.cp$1 = cp$1;
                                }
                            });
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)cp));
                        }
                        catch (Exception exception) {
                            this.readError$1.elem = exception;
                            CheckpointReader$.MODULE$.logWarning((Function0<String>)new Serializable(this, file){
                                public static final long serialVersionUID = 0L;
                                private final Path file$2;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Error reading checkpoint from file ").append((Object)this.file$2).toString();
                                }
                                {
                                    this.file$2 = file$2;
                                }
                            }, exception);
                            return;
                        }
                    }
                    {
                        this.conf$1 = conf$1;
                        this.hadoopConf$1 = hadoopConf$1;
                        this.checkpointPath$1 = checkpointPath$1;
                        this.readError$1 = readError$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                if (!ignoreReadError) {
                    void var8_8;
                    void var6_6;
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to read checkpoint from directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_6})), (Throwable)((Exception)var8_8.elem));
                }
                option = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block4;
                option = (Option)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    public boolean read$default$4() {
        return false;
    }

    public final FileSystem org$apache$spark$streaming$CheckpointReader$$fs$1(Configuration hadoopConf$1, Path checkpointPath$1) {
        return checkpointPath$1.getFileSystem(hadoopConf$1);
    }

    private CheckpointReader$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

