/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import org.apache.spark.Logging;
import org.apache.spark.streaming.util.RecurringTimer$;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%b!B\u0001\u0003\u0001\u0011a!A\u0004*fGV\u0014(/\u001b8h)&lWM\u001d\u0006\u0003\u0007\u0011\tA!\u001e;jY*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0004\u00015\u0019\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015+5\ta!\u0003\u0002\u0017\r\t9Aj\\4hS:<\u0007\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u000b\rdwnY6\u0004\u0001A\u00111$H\u0007\u00029)\u00111AB\u0005\u0003=q\u0011Qa\u00117pG.D\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!I\u0001\u0007a\u0016\u0014\u0018n\u001c3\u0011\u00059\u0011\u0013BA\u0012\u0010\u0005\u0011auN\\4\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019\n\u0001bY1mY\n\f7m\u001b\t\u0005\u001d\u001d\n\u0013&\u0003\u0002)\u001f\tIa)\u001e8di&|g.\r\t\u0003\u001d)J!aK\b\u0003\tUs\u0017\u000e\u001e\u0005\t[\u0001\u0011\t\u0011)A\u0005]\u0005!a.Y7f!\ty#G\u0004\u0002\u000fa%\u0011\u0011gD\u0001\u0007!J,G-\u001a4\n\u0005M\"$AB*ue&twM\u0003\u00022\u001f!)a\u0007\u0001C\u0001o\u00051A(\u001b8jiz\"R\u0001\u000f\u001e<yu\u0002\"!\u000f\u0001\u000e\u0003\tAQ\u0001G\u001bA\u0002iAQ\u0001I\u001bA\u0002\u0005BQ!J\u001bA\u0002\u0019BQ!L\u001bA\u00029Bqa\u0010\u0001C\u0002\u0013%\u0001)\u0001\u0004uQJ,\u0017\rZ\u000b\u0002\u0003B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0005Y\u0006twMC\u0001G\u0003\u0011Q\u0017M^1\n\u0005!\u001b%A\u0002+ie\u0016\fG\r\u0003\u0004K\u0001\u0001\u0006I!Q\u0001\bi\"\u0014X-\u00193!\u0011\u0015a\u0005\u0001\"\u0001N\u000319W\r^*uCJ$H+[7f)\u0005\t\u0003\"B(\u0001\t\u0003\u0001\u0016AD4fiJ+7\u000f^1siRKW.\u001a\u000b\u0003CECQA\u0015(A\u0002\u0005\n\u0011c\u001c:jO&t\u0017\r\\*uCJ$H+[7f\u0011\u0015!\u0006\u0001\"\u0001V\u0003\u0015\u0019H/\u0019:u)\t\tc\u000bC\u0003X'\u0002\u0007\u0011%A\u0005ti\u0006\u0014H\u000fV5nK\")A\u000b\u0001C\u0001\u001b\")!\f\u0001C\u00017\u0006!1\u000f^8q)\t\tC\fC\u0003^3\u0002\u0007a,\u0001\bj]R,'O];qiRKW.\u001a:\u0011\u00059y\u0016B\u00011\u0010\u0005\u001d\u0011un\u001c7fC:DQA\u0019\u0001\u0005\n\r\fA\u0001\\8paR\t\u0011\u0006C\u0004f\u0001\u0001\u0007I\u0011\u00024\u0002\u0011A\u0014XM\u001e+j[\u0016,\u0012!\t\u0005\bQ\u0002\u0001\r\u0011\"\u0003j\u00031\u0001(/\u001a<US6,w\fJ3r)\tI#\u000eC\u0004lO\u0006\u0005\t\u0019A\u0011\u0002\u0007a$\u0013\u0007\u0003\u0004n\u0001\u0001\u0006K!I\u0001\naJ,g\u000fV5nK\u0002B#\u0001\\8\u0011\u00059\u0001\u0018BA9\u0010\u0005!1x\u000e\\1uS2,\u0007bB:\u0001\u0001\u0004%IAZ\u0001\t]\u0016DH\u000fV5nK\"9Q\u000f\u0001a\u0001\n\u00131\u0018\u0001\u00048fqR$\u0016.\\3`I\u0015\fHCA\u0015x\u0011\u001dYG/!AA\u0002\u0005Ba!\u001f\u0001!B\u0013\t\u0013!\u00038fqR$\u0016.\\3!Q\tAx\u000eC\u0004}\u0001\u0001\u0007I\u0011B?\u0002\u000fM$x\u000e\u001d9fIV\ta\f\u0003\u0005\u0000\u0001\u0001\u0007I\u0011BA\u0001\u0003-\u0019Ho\u001c9qK\u0012|F%Z9\u0015\u0007%\n\u0019\u0001C\u0004l}\u0006\u0005\t\u0019\u00010\t\u000f\u0005\u001d\u0001\u0001)Q\u0005=\u0006A1\u000f^8qa\u0016$\u0007\u0005K\u0002\u0002\u0006=<\u0001\"!\u0004\u0003\u0011\u0003!\u0011qB\u0001\u000f%\u0016\u001cWO\u001d:j]\u001e$\u0016.\\3s!\rI\u0014\u0011\u0003\u0004\b\u0003\tA\t\u0001BA\n'\r\t\t\"\u0004\u0005\bm\u0005EA\u0011AA\f)\t\ty\u0001\u0003\u0005\u0002\u001c\u0005EA\u0011AA\u000f\u0003\u0011i\u0017-\u001b8\u0015\u0007%\ny\u0002\u0003\u0005\u0002\"\u0005e\u0001\u0019AA\u0012\u0003\u0011\t'oZ:\u0011\t9\t)CL\u0005\u0004\u0003Oy!!B!se\u0006L\b")
public class RecurringTimer
implements Logging {
    private final Clock clock;
    private final long period;
    private final Function1<Object, BoxedUnit> callback;
    public final String org$apache$spark$streaming$util$RecurringTimer$$name;
    private final Thread thread;
    private volatile long org$apache$spark$streaming$util$RecurringTimer$$prevTime;
    private volatile long org$apache$spark$streaming$util$RecurringTimer$$nextTime;
    private volatile boolean stopped;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        RecurringTimer$.MODULE$.main(stringArray);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private Thread thread() {
        return this.thread;
    }

    public long org$apache$spark$streaming$util$RecurringTimer$$prevTime() {
        return this.org$apache$spark$streaming$util$RecurringTimer$$prevTime;
    }

    private void org$apache$spark$streaming$util$RecurringTimer$$prevTime_$eq(long x$1) {
        this.org$apache$spark$streaming$util$RecurringTimer$$prevTime = x$1;
    }

    public long org$apache$spark$streaming$util$RecurringTimer$$nextTime() {
        return this.org$apache$spark$streaming$util$RecurringTimer$$nextTime;
    }

    private void org$apache$spark$streaming$util$RecurringTimer$$nextTime_$eq(long x$1) {
        this.org$apache$spark$streaming$util$RecurringTimer$$nextTime = x$1;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public long getStartTime() {
        return (long)(package$.MODULE$.floor((double)this.clock.getTimeMillis() / (double)this.period) + 1.0) * this.period;
    }

    public long getRestartTime(long originalStartTime) {
        long gap = this.clock.getTimeMillis() - originalStartTime;
        return ((long)package$.MODULE$.floor((double)gap / (double)this.period) + 1L) * this.period + originalStartTime;
    }

    public synchronized long start(long startTime) {
        this.org$apache$spark$streaming$util$RecurringTimer$$nextTime_$eq(startTime);
        this.thread().start();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecurringTimer $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Started timer for ").append((Object)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$name).append((Object)" at time ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$nextTime())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        return this.org$apache$spark$streaming$util$RecurringTimer$$nextTime();
    }

    public long start() {
        return this.start(this.getStartTime());
    }

    public synchronized long stop(boolean interruptTimer) {
        if (!this.stopped()) {
            this.stopped_$eq(true);
            if (interruptTimer) {
                this.thread().interrupt();
            }
            this.thread().join();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RecurringTimer $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Stopped timer for ").append((Object)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$name).append((Object)" after time ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$prevTime())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        return this.org$apache$spark$streaming$util$RecurringTimer$$prevTime();
    }

    public void org$apache$spark$streaming$util$RecurringTimer$$loop() {
        try {
            while (!this.stopped()) {
                this.clock.waitTillTime(this.org$apache$spark$streaming$util$RecurringTimer$$nextTime());
                this.callback.apply$mcVJ$sp(this.org$apache$spark$streaming$util$RecurringTimer$$nextTime());
                this.org$apache$spark$streaming$util$RecurringTimer$$prevTime_$eq(this.org$apache$spark$streaming$util$RecurringTimer$$nextTime());
                this.org$apache$spark$streaming$util$RecurringTimer$$nextTime_$eq(this.org$apache$spark$streaming$util$RecurringTimer$$nextTime() + this.period);
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RecurringTimer $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Callback for ").append((Object)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$name).append((Object)" called at time ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$prevTime())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public RecurringTimer(Clock clock, long period, Function1<Object, BoxedUnit> callback, String name) {
        this.clock = clock;
        this.period = period;
        this.callback = callback;
        this.org$apache$spark$streaming$util$RecurringTimer$$name = name;
        Logging.class.$init$((Logging)this);
        this.thread = new $anon$1(this);
        this.org$apache$spark$streaming$util$RecurringTimer$$prevTime = -1L;
        this.org$apache$spark$streaming$util$RecurringTimer$$nextTime = -1L;
        this.stopped = false;
    }
}

