/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.Closeable;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSegment;
import org.apache.spark.streaming.util.HdfsUtils$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194Q!\u0001\u0002\u0001\t1\u0011!ER5mK\n\u000b7/\u001a3Xe&$X-\u00115fC\u0012dun\u001a*b]\u0012|WNU3bI\u0016\u0014(BA\u0002\u0005\u0003\u0011)H/\u001b7\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e+A\u0011abE\u0007\u0002\u001f)\u0011\u0001#E\u0001\u0005Y\u0006twMC\u0001\u0013\u0003\u0011Q\u0017M^1\n\u0005Qy!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001735\tqC\u0003\u0002\u0019#\u0005\u0011\u0011n\\\u0005\u00035]\u0011\u0011b\u00117pg\u0016\f'\r\\3\t\u0011q\u0001!\u0011!Q\u0001\ny\tA\u0001]1uQ\u000e\u0001\u0001CA\u0010&\u001d\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0003\u0019\u0001&/\u001a3fM&\u0011ae\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011\n\u0003\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\t\r|gN\u001a\t\u0003W=j\u0011\u0001\f\u0006\u0003S5R!A\f\u0005\u0002\r!\fGm\\8q\u0013\t\u0001DFA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006e\u0001!\taM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007Q2t\u0007\u0005\u00026\u00015\t!\u0001C\u0003\u001dc\u0001\u0007a\u0004C\u0003*c\u0001\u0007!\u0006C\u0004:\u0001\t\u0007I\u0011\u0002\u001e\u0002\u0011%t7\u000f\u001e:fC6,\u0012a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0003}5\n!AZ:\n\u0005\u0001k$!\u0005$T\t\u0006$\u0018-\u00138qkR\u001cFO]3b[\"1!\t\u0001Q\u0001\nm\n\u0011\"\u001b8tiJ,\u0017-\u001c\u0011\t\u000f\u0011\u0003\u0001\u0019!C\u0005\u000b\u000611\r\\8tK\u0012,\u0012A\u0012\t\u0003A\u001dK!\u0001S\u0011\u0003\u000f\t{w\u000e\\3b]\"9!\n\u0001a\u0001\n\u0013Y\u0015AC2m_N,Gm\u0018\u0013fcR\u0011Aj\u0014\t\u0003A5K!AT\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b!&\u000b\t\u00111\u0001G\u0003\rAH%\r\u0005\u0007%\u0002\u0001\u000b\u0015\u0002$\u0002\u000f\rdwn]3eA!)A\u000b\u0001C\u0001+\u0006!!/Z1e)\t1F\f\u0005\u0002X56\t\u0001L\u0003\u0002Z#\u0005\u0019a.[8\n\u0005mC&A\u0003\"zi\u0016\u0014UO\u001a4fe\")Ql\u0015a\u0001=\u000691/Z4nK:$\bCA\u001b`\u0013\t\u0001'AA\u000fGS2,')Y:fI^\u0013\u0018\u000e^3BQ\u0016\fG\rT8h'\u0016<W.\u001a8u\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0003\u0015\u0019Gn\\:f)\u0005a\u0005\"B3\u0001\t\u0013\u0019\u0017AC1tg\u0016\u0014Ho\u00149f]\u0002")
public class FileBasedWriteAheadLogRandomReader
implements Closeable {
    private final FSDataInputStream instream;
    private boolean closed;

    private FSDataInputStream instream() {
        return this.instream;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public synchronized ByteBuffer read(FileBasedWriteAheadLogSegment segment) {
        this.assertOpen();
        this.instream().seek(segment.offset());
        int nextLength = this.instream().readInt();
        HdfsUtils$.MODULE$.checkState(nextLength == segment.length(), (Function0<String>)new Serializable(this, segment, nextLength){
            public static final long serialVersionUID = 0L;
            private final FileBasedWriteAheadLogSegment segment$1;
            private final int nextLength$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected message length to be ", ", but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.segment$1.length()), BoxesRunTime.boxToInteger((int)this.nextLength$1)}));
            }
            {
                this.segment$1 = segment$1;
                this.nextLength$1 = nextLength$1;
            }
        });
        byte[] buffer = new byte[nextLength];
        this.instream().readFully(buffer);
        return ByteBuffer.wrap(buffer);
    }

    @Override
    public synchronized void close() {
        this.closed_$eq(true);
        this.instream().close();
    }

    private void assertOpen() {
        HdfsUtils$.MODULE$.checkState(!this.closed(), (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stream is closed. Create a new Reader to read from the file.";
            }
        });
    }

    public FileBasedWriteAheadLogRandomReader(String path, Configuration conf) {
        this.instream = HdfsUtils$.MODULE$.getInputStream(path, conf);
        this.closed = false;
    }
}

