/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.spark.SerializableWritable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.UnionRDD;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.FileInputDStream$;
import org.apache.spark.streaming.dstream.FileInputDStream$$anonfun$4$;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.util.Clock;
import org.apache.spark.util.TimeStampedHashMap;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.SynchronizedMap;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rme!B\u0001\u0003\u0001\u0011a!\u0001\u0005$jY\u0016Le\u000e];u\tN#(/Z1n\u0015\t\u0019A!A\u0004egR\u0014X-Y7\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<W\u0003B\u0007\u001bK\u0015\u001c\"\u0001\u0001\b\u0011\u0007=\u0001\"#D\u0001\u0003\u0013\t\t\"A\u0001\u0007J]B,H\u000fR*ue\u0016\fW\u000e\u0005\u0003\u0014-a!S\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\rQ+\b\u000f\\33!\tI\"\u0004\u0004\u0001\u0005\u000bm\u0001!\u0019A\u000f\u0003\u0003-\u001b\u0001!\u0005\u0002\u001fCA\u00111cH\u0005\u0003AQ\u0011qAT8uQ&tw\r\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0004\u0003:L\bCA\r&\t\u00151\u0003A1\u0001\u001e\u0005\u00051\u0006\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\tM\u001c8m\u0018\t\u0003U-j\u0011\u0001B\u0005\u0003Y\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;)\u0005\u001dr\u0003CA\n0\u0013\t\u0001DCA\u0005ue\u0006t7/[3oi\"A!\u0007\u0001B\u0001B\u0003%1'A\u0005eSJ,7\r^8ssB\u0011Ag\u000e\b\u0003'UJ!A\u000e\u000b\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003mQA\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\u0007M&dG/\u001a:\u0011\tMithR\u0005\u0003}Q\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015A\u00014t\u0015\t!\u0005\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\r\u0006\u0013A\u0001U1uQB\u00111\u0003S\u0005\u0003\u0013R\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003H\u00031qWm\u001e$jY\u0016\u001cxJ\u001c7z\u0011!i\u0005A!A!\u0002\u0013q\u0015\u0001B2p]\u001a\u00042aE(R\u0013\t\u0001FC\u0001\u0004PaRLwN\u001c\t\u0003%Rk\u0011a\u0015\u0006\u0003\u001b\u000eK!!V*\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011!9\u0006A!A!\u0002\u0017A\u0016AA6n!\rIF\fG\u0007\u00025*\u00111\fF\u0001\be\u00164G.Z2u\u0013\ti&L\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011!y\u0006A!A!\u0002\u0017\u0001\u0017A\u0001<n!\rIF\f\n\u0005\tE\u0002\u0011\t\u0011)A\u0006G\u0006\u0011a-\u001c\t\u00043r#\u0007CA\rf\t\u00151\u0007A1\u0001h\u0005\u00051\u0015C\u0001\u0010i!\u0011IG\u000e\u0007\u0013\u000e\u0003)T!a[\"\u0002\u00135\f\u0007O]3ek\u000e,\u0017BA7k\u0005-Ie\u000e];u\r>\u0014X.\u0019;\t\u000b=\u0004A\u0011\u00019\u0002\rqJg.\u001b;?)\u0019\tho\u001e=zuR!!o\u001d;v!\u0015y\u0001\u0001\u0007\u0013e\u0011\u00159f\u000eq\u0001Y\u0011\u0015yf\u000eq\u0001a\u0011\u0015\u0011g\u000eq\u0001d\u0011\u0015Ac\u000e1\u0001*\u0011\u0015\u0011d\u000e1\u00014\u0011\u001dYd\u000e%AA\u0002qBqa\u00138\u0011\u0002\u0003\u0007q\tC\u0004N]B\u0005\t\u0019\u0001(\t\u000fq\u0004!\u0019!C\u0005{\u0006\u00192/\u001a:jC2L'0\u00192mK\u000e{gNZ(qiV\ta\u0010E\u0002\u0014\u001f~\u0004R!!\u0001\u0002\u0004Ek\u0011AB\u0005\u0004\u0003\u000b1!\u0001F*fe&\fG.\u001b>bE2,wK]5uC\ndW\rC\u0004\u0002\n\u0001\u0001\u000b\u0011\u0002@\u0002)M,'/[1mSj\f'\r\\3D_:4w\n\u001d;!\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001f\tQa\u00197pG.,\"!!\u0005\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006\u0007\u0003\u0011)H/\u001b7\n\t\u0005m\u0011Q\u0003\u0002\u0006\u00072|7m\u001b\u0005\u000b\u0003?\u0001!\u0019!C)\t\u0005\u0005\u0012AD2iK\u000e\\\u0007o\\5oi\u0012\u000bG/Y\u000b\u0003\u0003G\u0001B!!\n\u0002(5\t\u0001AB\u0004\u0002*\u0001\u0001A!a\u000b\u0003=\u0019KG.Z%oaV$Hi\u0015;sK\u0006l7\t[3dWB|\u0017N\u001c;ECR\f7\u0003BA\u0014\u0003[\u0001BaDA\u0018%%\u0019\u0011\u0011\u0007\u0002\u0003+\u0011\u001bFO]3b[\u000eCWmY6q_&tG\u000fR1uC\"9q.a\n\u0005\u0002\u0005UBCAA\u0012\u0011!\tI$a\n\u0005\u0002\u0005m\u0012a\u00035bI>|\u0007OR5mKN,\"!!\u0010\u0011\u0011\u0005}\u0012\u0011JA'\u0003'j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\b[V$\u0018M\u00197f\u0015\r\t9\u0005F\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA&\u0003\u0003\u0012q\u0001S1tQ6\u000b\u0007\u000fE\u0002+\u0003\u001fJ1!!\u0015\u0005\u0005\u0011!\u0016.\\3\u0011\tM\t)fM\u0005\u0004\u0003/\"\"!B!se\u0006L\b\u0002CA.\u0003O!\t%!\u0018\u0002\rU\u0004H-\u0019;f)\u0011\ty&!\u001a\u0011\u0007M\t\t'C\u0002\u0002dQ\u0011A!\u00168ji\"A\u0011qMA-\u0001\u0004\ti%\u0001\u0003uS6,\u0007\u0002CA6\u0003O!\t%!\u001c\u0002\u000f\rdW-\u00198vaR!\u0011qLA8\u0011!\t9'!\u001bA\u0002\u00055\u0003\u0002CA:\u0003O!\t%!\u001e\u0002\u000fI,7\u000f^8sKR\u0011\u0011q\f\u0005\t\u0003s\n9\u0003\"\u0011\u0002|\u0005AAo\\*ue&tw\r\u0006\u0002\u0002~A!\u0011qPAE\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015\u0001\u00027b]\u001eT!!a\"\u0002\t)\fg/Y\u0005\u0004q\u0005\u0005\u0005\u0002CAG\u0001\u0001\u0006I!a\t\u0002\u001f\rDWmY6q_&tG\u000fR1uC\u0002B\u0011\"!%\u0001\u0005\u0004%I!a%\u0002;%t\u0017\u000e^5bY6{G\rV5nK&;gn\u001c:f)\"\u0014Xm\u001d5pY\u0012,\"!!&\u0011\u0007M\t9*C\u0002\u0002\u001aR\u0011A\u0001T8oO\"A\u0011Q\u0014\u0001!\u0002\u0013\t)*\u0001\u0010j]&$\u0018.\u00197N_\u0012$\u0016.\\3JO:|'/\u001a+ie\u0016\u001c\bn\u001c7eA!I\u0011\u0011\u0015\u0001C\u0002\u0013%\u00111U\u0001\u0015]Vl')\u0019;dQ\u0016\u001cHk\u001c*f[\u0016l'-\u001a:\u0016\u0005\u0005\u0015\u0006cA\n\u0002(&\u0019\u0011\u0011\u0016\u000b\u0003\u0007%sG\u000f\u0003\u0005\u0002.\u0002\u0001\u000b\u0011BAS\u0003UqW/\u001c\"bi\u000eDWm\u001d+p%\u0016lW-\u001c2fe\u0002B\u0011\"!-\u0001\u0005\u0004%I!a-\u0002%\u0011,(/\u0019;j_:$vNU3nK6\u0014WM]\u000b\u0003\u0003k\u00032AKA\\\u0013\r\tI\f\u0002\u0002\t\tV\u0014\u0018\r^5p]\"A\u0011Q\u0018\u0001!\u0002\u0013\t),A\nekJ\fG/[8o)>\u0014V-\\3nE\u0016\u0014\b\u0005C\u0004\u0002B\u0002!\t%!\u001e\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005\u0015\u0007\u0001\"\u0011\u0002v\u0005!1\u000f^8q\u0011\u001d\tI\r\u0001C!\u0003\u0017\fqaY8naV$X\r\u0006\u0003\u0002N\u0006m\u0007\u0003B\nP\u0003\u001f\u0004R!!5\u0002XJi!!a5\u000b\u0007\u0005Ug!A\u0002sI\u0012LA!!7\u0002T\n\u0019!\u000b\u0012#\t\u0011\u0005u\u0017q\u0019a\u0001\u0003\u001b\n\u0011B^1mS\u0012$\u0016.\\3\t\u0011\u0005\u0005\b\u0001\"\u0015\u0005\u0003G\fQb\u00197fCJlU\r^1eCR\fG\u0003BA0\u0003KD\u0001\"a\u001a\u0002`\u0002\u0007\u0011Q\n\u0005\b\u0003S\u0004A\u0011BAv\u000311\u0017N\u001c3OK^4\u0015\u000e\\3t)\u0011\t\u0019&!<\t\u0011\u0005=\u0018q\u001da\u0001\u0003+\u000b1bY;se\u0016tG\u000fV5nK\"9\u00111\u001f\u0001\u0005\n\u0005U\u0018!C5t\u001d\u0016<h)\u001b7f)\u001d9\u0015q_A~\u0003{Dq!!?\u0002r\u0002\u0007q(\u0001\u0003qCRD\u0007\u0002CAx\u0003c\u0004\r!!&\t\u0011\u0005}\u0018\u0011\u001fa\u0001\u0003+\u000ba#\\8e)&lW-S4o_J,G\u000b\u001b:fg\"|G\u000e\u001a\u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0003)1\u0017\u000e\\3t)>\u0014F\t\u0012\u000b\u0005\u0003\u001f\u00149\u0001\u0003\u0005\u0003\n\t\u0005\u0001\u0019\u0001B\u0006\u0003\u00151\u0017\u000e\\3t!\u0015\u0011iA!\b4\u001d\u0011\u0011yA!\u0007\u000f\t\tE!qC\u0007\u0003\u0005'Q1A!\u0006\u001d\u0003\u0019a$o\\8u}%\tQ#C\u0002\u0003\u001cQ\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003 \t\u0005\"aA*fc*\u0019!1\u0004\u000b\t\u000f\t\u0015\u0002\u0001\"\u0003\u0003(\u0005qq-\u001a;GS2,Wj\u001c3US6,G\u0003BAK\u0005SAq!!?\u0003$\u0001\u0007q\bC\u0004\u0003.\u0001!IAa\f\u0002\u001b\u0011L'/Z2u_JL\b+\u0019;i+\u0005y\u0004B\u0002\"\u0001\t\u0013\u0011\u0019$\u0006\u0002\u00036A\u0019\u0001Ia\u000e\n\u0007\te\u0012I\u0001\u0006GS2,7+_:uK6DqA!\u0010\u0001\t\u0013\t)(A\u0003sKN,G\u000fC\u0004\u0003B\u0001!IAa\u0011\u0002\u0015I,\u0017\rZ(cU\u0016\u001cG\u000f\u0006\u0003\u0002`\t\u0015\u0003\u0002\u0003B$\u0005\u007f\u0001\rA!\u0013\u0002\u0007=L7\u000f\u0005\u0003\u0003L\tESB\u0001B'\u0015\u0011\u0011y%!\"\u0002\u0005%|\u0017\u0002\u0002B*\u0005\u001b\u0012\u0011c\u00142kK\u000e$\u0018J\u001c9viN#(/Z1nQ\u0019\u0011yDa\u0016\u0003nA)1C!\u0017\u0003^%\u0019!1\f\u000b\u0003\rQD'o\\<t!\rI\"q\f\u0003\b\u0005C\u0002!\u0019\u0001B2\u0005\u0005!\u0016c\u0001\u0010\u0003fA!!q\rB5\u001d\r\u0019\"\u0011D\u0005\u0005\u0005W\u0012\tCA\u0005UQJ|w/\u00192mK\u000e\u0012!q\u000e\t\u0005\u0005\u0017\u0012\t(\u0003\u0003\u0003t\t5#aC%P\u000bb\u001cW\r\u001d;j_:D!Ba\u001e\u0001\u0001\u0004%\t\u0001\u0002B=\u0003a\u0011\u0017\r^2i)&lW\rV8TK2,7\r^3e\r&dWm]\u000b\u0003\u0005w\u0012bA! \u0002>\t\u001dea\u0002B@\u0005\u0003\u0003!1\u0010\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\u0005\t\u0005\u0007\u0003\u0001\u0015)\u0003\u0003|\u0005I\"-\u0019;dQRKW.\u001a+p'\u0016dWm\u0019;fI\u001aKG.Z:!Q\r\u0011\tI\f\t\t\u0003\u007f\u0011I)!\u0014\u0002T%!!1RA!\u0005=\u0019\u0016P\\2ie>t\u0017N_3e\u001b\u0006\u0004\bB\u0003BH\u0001\u0001\u0007I\u0011\u0001\u0003\u0003\u0012\u0006a\"-\u0019;dQRKW.\u001a+p'\u0016dWm\u0019;fI\u001aKG.Z:`I\u0015\fH\u0003BA0\u0005'C!B!&\u0003\u000e\u0006\u0005\t\u0019\u0001B>\u0003\rAH%\r\u0005\n\u00053\u0003\u0001\u0019!C\u0005\u00057\u000bQC]3dK:$H._*fY\u0016\u001cG/\u001a3GS2,7/\u0006\u0002\u0003\u001eB)\u0011q\bBPg%!!\u0011UA!\u0005\u001dA\u0015m\u001d5TKRD\u0011B!*\u0001\u0001\u0004%IAa*\u00023I,7-\u001a8uYf\u001cV\r\\3di\u0016$g)\u001b7fg~#S-\u001d\u000b\u0005\u0003?\u0012I\u000b\u0003\u0006\u0003\u0016\n\r\u0016\u0011!a\u0001\u0005;C\u0001B!,\u0001A\u0003&!QT\u0001\u0017e\u0016\u001cWM\u001c;msN+G.Z2uK\u00124\u0015\u000e\\3tA!\u001a!1\u0016\u0018\t\u0013\tM\u0006\u00011A\u0005\n\tU\u0016!\u00044jY\u0016$v.T8e)&lW-\u0006\u0002\u00038B9\u00111\u0003B]g\u0005U\u0015\u0002\u0002B^\u0003+\u0011!\u0003V5nKN#\u0018-\u001c9fI\"\u000b7\u000f['ba\"I!q\u0018\u0001A\u0002\u0013%!\u0011Y\u0001\u0012M&dW\rV8N_\u0012$\u0016.\\3`I\u0015\fH\u0003BA0\u0005\u0007D!B!&\u0003>\u0006\u0005\t\u0019\u0001B\\\u0011!\u00119\r\u0001Q!\n\t]\u0016A\u00044jY\u0016$v.T8e)&lW\r\t\u0015\u0004\u0005\u000bt\u0003\"\u0003Bg\u0001\u0001\u0007I\u0011BAJ\u0003Ya\u0017m\u001d;OK^4\u0015\u000e\\3GS:$\u0017N\\4US6,\u0007\"\u0003Bi\u0001\u0001\u0007I\u0011\u0002Bj\u0003ia\u0017m\u001d;OK^4\u0015\u000e\\3GS:$\u0017N\\4US6,w\fJ3r)\u0011\tyF!6\t\u0015\tU%qZA\u0001\u0002\u0004\t)\n\u0003\u0005\u0003Z\u0002\u0001\u000b\u0015BAK\u0003]a\u0017m\u001d;OK^4\u0015\u000e\\3GS:$\u0017N\\4US6,\u0007\u0005K\u0002\u0003X:B\u0011Ba8\u0001\u0001\u0004%IAa\f\u0002\u000bA\fG\u000f[0\t\u0013\t\r\b\u00011A\u0005\n\t\u0015\u0018!\u00039bi\"|v\fJ3r)\u0011\tyFa:\t\u0013\tU%\u0011]A\u0001\u0002\u0004y\u0004b\u0002Bv\u0001\u0001\u0006KaP\u0001\u0007a\u0006$\bn\u0018\u0011)\u0007\t%h\u0006C\u0005\u0003r\u0002\u0001\r\u0011\"\u0003\u00034\u0005\u0019am]0\t\u0013\tU\b\u00011A\u0005\n\t]\u0018a\u00024t?~#S-\u001d\u000b\u0005\u0003?\u0012I\u0010\u0003\u0006\u0003\u0016\nM\u0018\u0011!a\u0001\u0005kA\u0001B!@\u0001A\u0003&!QG\u0001\u0005MN|\u0006\u0005K\u0002\u0003|::\u0001ba\u0001\u0003\u0011\u0003!1QA\u0001\u0011\r&dW-\u00138qkR$5\u000b\u001e:fC6\u00042aDB\u0004\r\u001d\t!\u0001#\u0001\u0005\u0007\u0013\u0019baa\u0002\u0004\f\rE\u0001cA\n\u0004\u000e%\u00191q\u0002\u000b\u0003\r\u0005s\u0017PU3g!\r\u001921C\u0005\u0004\u0007+!\"\u0001D*fe&\fG.\u001b>bE2,\u0007bB8\u0004\b\u0011\u00051\u0011\u0004\u000b\u0003\u0007\u000bA!b!\b\u0004\b\t\u0007I\u0011BAZ\u0003Ui\u0015JT0S\u000b6+UJQ#S?\u0012+&+\u0011+J\u001f:C\u0011b!\t\u0004\b\u0001\u0006I!!.\u0002-5Kej\u0018*F\u001b\u0016k%)\u0012*`\tV\u0013\u0016\tV%P\u001d\u0002B\u0001b!\n\u0004\b\u0011\u00051qE\u0001\u000eI\u00164\u0017-\u001e7u\r&dG/\u001a:\u0015\u0007\u001d\u001bI\u0003C\u0004\u0002z\u000e\r\u0002\u0019A \t\u0011\r52q\u0001C\u0001\u0007_\tQdY1mGVd\u0017\r^3Ok6\u0014\u0015\r^2iKN$vNU3nK6\u0014WM\u001d\u000b\u0005\u0003K\u001b\t\u0004\u0003\u0005\u00044\r-\u0002\u0019AA[\u00035\u0011\u0017\r^2i\tV\u0014\u0018\r^5p]\"Q1qGB\u0004#\u0003%\ta!\u000f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+!\u0019Yd!\u0015\u0004T\rUSCAB\u001fU\ra4qH\u0016\u0003\u0007\u0003\u0002Baa\u0011\u0004N5\u00111Q\t\u0006\u0005\u0007\u000f\u001aI%A\u0005v]\u000eDWmY6fI*\u001911\n\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004P\r\u0015#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001211d!\u000eC\u0002u!aAJB\u001b\u0005\u0004iBa\u00024\u00046\t\u00071qK\t\u0004=\re\u0003CB5m\u00077\u001ai\u0006E\u0002\u001a\u0007#\u00022!GB*\u0011)\u0019\tga\u0002\u0012\u0002\u0013\u000511M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0011\r\u00154\u0011NB6\u0007[*\"aa\u001a+\u0007\u001d\u001by\u0004\u0002\u0004\u001c\u0007?\u0012\r!\b\u0003\u0007M\r}#\u0019A\u000f\u0005\u000f\u0019\u001cyF1\u0001\u0004pE\u0019ad!\u001d\u0011\r%d71OB;!\rI2\u0011\u000e\t\u00043\r-\u0004BCB=\u0007\u000f\t\n\u0011\"\u0001\u0004|\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\u0002b! \u0004\u0002\u000e\r5QQ\u000b\u0003\u0007\u007fR3ATB \t\u0019Y2q\u000fb\u0001;\u00111aea\u001eC\u0002u!qAZB<\u0005\u0004\u00199)E\u0002\u001f\u0007\u0013\u0003b!\u001b7\u0004\f\u000e5\u0005cA\r\u0004\u0002B\u0019\u0011da!\t\u0015\rE5qAA\u0001\n\u0013\u0019\u0019*A\u0006sK\u0006$'+Z:pYZ,GCABK!\u0011\tyha&\n\t\re\u0015\u0011\u0011\u0002\u0007\u001f\nTWm\u0019;")
public class FileInputDStream<K, V, F extends InputFormat<K, V>>
extends InputDStream<Tuple2<K, V>> {
    private final String directory;
    private final Function1<Path, Object> filter;
    public final ClassTag<K> org$apache$spark$streaming$dstream$FileInputDStream$$km;
    public final ClassTag<V> org$apache$spark$streaming$dstream$FileInputDStream$$vm;
    public final ClassTag<F> org$apache$spark$streaming$dstream$FileInputDStream$$fm;
    private final Option<SerializableWritable<Configuration>> org$apache$spark$streaming$dstream$FileInputDStream$$serializableConfOpt;
    private final FileInputDStreamCheckpointData checkpointData;
    private final long initialModTimeIgnoreThreshold;
    private final int numBatchesToRemember;
    private final Duration durationToRemember;
    private transient HashMap<Time, String[]> batchTimeToSelectedFiles;
    private transient HashSet<String> org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles;
    private transient TimeStampedHashMap<String, Object> org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime;
    private transient long lastNewFileFindingTime;
    private transient Path path_;
    private transient FileSystem fs_;

    public static <K, V, F extends InputFormat<K, V>> Option<Configuration> $lessinit$greater$default$5() {
        return FileInputDStream$.MODULE$.$lessinit$greater$default$5();
    }

    public static <K, V, F extends InputFormat<K, V>> boolean $lessinit$greater$default$4() {
        return FileInputDStream$.MODULE$.$lessinit$greater$default$4();
    }

    public static <K, V, F extends InputFormat<K, V>> Function1<Path, Object> $lessinit$greater$default$3() {
        return FileInputDStream$.MODULE$.$lessinit$greater$default$3();
    }

    public static int calculateNumBatchesToRemember(Duration duration) {
        return FileInputDStream$.MODULE$.calculateNumBatchesToRemember(duration);
    }

    public static boolean defaultFilter(Path path) {
        return FileInputDStream$.MODULE$.defaultFilter(path);
    }

    public Option<SerializableWritable<Configuration>> org$apache$spark$streaming$dstream$FileInputDStream$$serializableConfOpt() {
        return this.org$apache$spark$streaming$dstream$FileInputDStream$$serializableConfOpt;
    }

    private Clock clock() {
        return this.ssc().scheduler().clock();
    }

    public FileInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    private long initialModTimeIgnoreThreshold() {
        return this.initialModTimeIgnoreThreshold;
    }

    private int numBatchesToRemember() {
        return this.numBatchesToRemember;
    }

    private Duration durationToRemember() {
        return this.durationToRemember;
    }

    public HashMap<Time, String[]> batchTimeToSelectedFiles() {
        return this.batchTimeToSelectedFiles;
    }

    public void batchTimeToSelectedFiles_$eq(HashMap<Time, String[]> x$1) {
        this.batchTimeToSelectedFiles = x$1;
    }

    public HashSet<String> org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles() {
        return this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles;
    }

    public void org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles_$eq(HashSet<String> x$1) {
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles = x$1;
    }

    public TimeStampedHashMap<String, Object> org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime() {
        return this.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime;
    }

    public void org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime_$eq(TimeStampedHashMap<String, Object> x$1) {
        this.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime = x$1;
    }

    private long lastNewFileFindingTime() {
        return this.lastNewFileFindingTime;
    }

    private void lastNewFileFindingTime_$eq(long x$1) {
        this.lastNewFileFindingTime = x$1;
    }

    private Path path_() {
        return this.path_;
    }

    private void path__$eq(Path x$1) {
        this.path_ = x$1;
    }

    private FileSystem fs_() {
        return this.fs_;
    }

    private void fs__$eq(FileSystem x$1) {
        this.fs_ = x$1;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Option<RDD<Tuple2<K, V>>> compute(Time validTime) {
        String[] newFiles = this.findNewFiles(validTime.milliseconds());
        this.logInfo((Function0<String>)new Serializable(this, validTime, newFiles){
            public static final long serialVersionUID = 0L;
            private final Time validTime$1;
            private final String[] newFiles$1;

            public final String apply() {
                return new StringBuilder().append((Object)"New files at time ").append((Object)this.validTime$1).append((Object)":\n").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.newFiles$1).mkString("\n")).toString();
            }
            {
                void var3_3;
                this.validTime$1 = validTime$1;
                this.newFiles$1 = var3_3;
            }
        });
        ((SynchronizedMap)this.batchTimeToSelectedFiles()).$plus$eq(new Tuple2((Object)validTime, (Object)newFiles));
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])newFiles));
        return new Some(this.org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])newFiles)));
    }

    @Override
    public void clearMetadata(Time time) {
        super.clearMetadata(time);
        HashMap oldFiles = (HashMap)this.batchTimeToSelectedFiles().filter((Function1)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;
            private final Time time$1;

            public final boolean apply(Tuple2<Time, String[]> x$2) {
                return ((Time)x$2._1()).$less(this.time$1.$minus(this.$outer.rememberDuration()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.time$1 = time$1;
            }
        });
        this.batchTimeToSelectedFiles().$minus$minus$eq((TraversableOnce)oldFiles.keys());
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().$minus$minus$eq((TraversableOnce)oldFiles.values().flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String[] xs) {
                return Predef$.MODULE$.refArrayOps((Object[])xs);
            }
        }));
        this.logInfo((Function0<String>)new Serializable(this, time, oldFiles){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;
            private final Time time$1;
            private final HashMap oldFiles$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Cleared ").append((Object)BoxesRunTime.boxToInteger((int)this.oldFiles$1.size())).append((Object)" old files that were older than ").append((Object)this.time$1.$minus(this.$outer.rememberDuration())).append((Object)": ").append((Object)this.oldFiles$1.keys().mkString(", ")).toString();
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.time$1 = time$1;
                this.oldFiles$1 = var3_3;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this, oldFiles){
            public static final long serialVersionUID = 0L;
            private final HashMap oldFiles$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Cleared files are:\n").append((Object)((TraversableOnce)this.oldFiles$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Time, String> apply(Tuple2<Time, String[]> p) {
                        return new Tuple2(p._1(), (Object)Predef$.MODULE$.refArrayOps((Object[])p._2()).mkString(", "));
                    }
                }, HashMap$.MODULE$.canBuildFrom())).mkString("\n")).toString();
            }
            {
                this.oldFiles$1 = oldFiles$1;
            }
        });
        this.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime().clearOldValues(this.lastNewFileFindingTime() - 1L);
    }

    private String[] findNewFiles(long currentTime) {
        String[] stringArray;
        try {
            this.lastNewFileFindingTime_$eq(this.clock().getTimeMillis());
            long modTimeIgnoreThreshold = package$.MODULE$.max(this.initialModTimeIgnoreThreshold(), currentTime - this.durationToRemember().milliseconds());
            this.logDebug((Function0<String>)new Serializable(this, currentTime, modTimeIgnoreThreshold){
                public static final long serialVersionUID = 0L;
                private final long currentTime$1;
                private final long modTimeIgnoreThreshold$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Getting new files for time ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.currentTime$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ignoring files older than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.modTimeIgnoreThreshold$1)}))).toString();
                }
                {
                    this.currentTime$1 = currentTime$1;
                    this.modTimeIgnoreThreshold$1 = modTimeIgnoreThreshold$1;
                }
            });
            PathFilter filter2 = new PathFilter(this, currentTime, modTimeIgnoreThreshold){
                private final /* synthetic */ FileInputDStream $outer;
                private final long currentTime$1;
                private final long modTimeIgnoreThreshold$1;

                public boolean accept(Path path) {
                    return this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$isNewFile(path, this.currentTime$1, this.modTimeIgnoreThreshold$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.currentTime$1 = currentTime$1;
                    this.modTimeIgnoreThreshold$1 = modTimeIgnoreThreshold$1;
                }
            };
            String[] newFiles = (String[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$dstream$FileInputDStream$$fs().listStatus(this.directoryPath(), filter2)).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(FileStatus x$3) {
                    return x$3.getPath().toString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            long timeTaken = this.clock().getTimeMillis() - this.lastNewFileFindingTime();
            this.logInfo((Function0<String>)new Serializable(this, timeTaken){
                public static final long serialVersionUID = 0L;
                private final long timeTaken$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Finding new files took ").append((Object)BoxesRunTime.boxToLong((long)this.timeTaken$1)).append((Object)" ms").toString();
                }
                {
                    this.timeTaken$1 = timeTaken$1;
                }
            });
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileInputDStream $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"# cached file times = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime().size())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (timeTaken > this.slideDuration().milliseconds()) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Time taken to find new files exceeds the batch size. Consider increasing the batch size or reducing the number of files in the monitored directory.";
                    }
                });
            }
            stringArray = newFiles;
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error finding new files";
                }
            }, exception);
            this.reset();
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    public boolean org$apache$spark$streaming$dstream$FileInputDStream$$isNewFile(Path path, long currentTime, long modTimeIgnoreThreshold) {
        String pathStr = path.toString();
        if (BoxesRunTime.unboxToBoolean((Object)this.filter.apply((Object)path))) {
            long modTime = this.getFileModTime(path);
            if (modTime <= modTimeIgnoreThreshold) {
                this.logDebug((Function0<String>)new Serializable(this, modTimeIgnoreThreshold, pathStr, modTime){
                    public static final long serialVersionUID = 0L;
                    private final long modTimeIgnoreThreshold$2;
                    private final String pathStr$1;
                    private final long modTime$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ignored as mod time ", " <= ignore time ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathStr$1, BoxesRunTime.boxToLong((long)this.modTime$1), BoxesRunTime.boxToLong((long)this.modTimeIgnoreThreshold$2)}));
                    }
                    {
                        void var4_3;
                        this.modTimeIgnoreThreshold$2 = modTimeIgnoreThreshold$2;
                        this.pathStr$1 = var4_3;
                        this.modTime$1 = modTime$1;
                    }
                });
                return false;
            }
            if (modTime > currentTime) {
                this.logDebug((Function0<String>)new Serializable(this, currentTime, pathStr, modTime){
                    public static final long serialVersionUID = 0L;
                    private final long currentTime$2;
                    private final String pathStr$1;
                    private final long modTime$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " not selected as mod time ", " > current time ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathStr$1, BoxesRunTime.boxToLong((long)this.modTime$1), BoxesRunTime.boxToLong((long)this.currentTime$2)}));
                    }
                    {
                        void var4_3;
                        this.currentTime$2 = currentTime$2;
                        this.pathStr$1 = var4_3;
                        this.modTime$1 = modTime$1;
                    }
                });
                return false;
            }
            if (this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().contains((Object)pathStr)) {
                this.logDebug((Function0<String>)new Serializable(this, pathStr){
                    public static final long serialVersionUID = 0L;
                    private final String pathStr$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " already considered"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathStr$1}));
                    }
                    {
                        this.pathStr$1 = pathStr$1;
                    }
                });
                return false;
            }
            this.logDebug((Function0<String>)new Serializable(this, pathStr, modTime){
                public static final long serialVersionUID = 0L;
                private final String pathStr$1;
                private final long modTime$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " accepted with mod time ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathStr$1, BoxesRunTime.boxToLong((long)this.modTime$1)}));
                }
                {
                    this.pathStr$1 = pathStr$1;
                    this.modTime$1 = modTime$1;
                }
            });
            return true;
        }
        this.logDebug((Function0<String>)new Serializable(this, pathStr){
            public static final long serialVersionUID = 0L;
            private final String pathStr$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " rejected by filter"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathStr$1}));
            }
            {
                this.pathStr$1 = pathStr$1;
            }
        });
        return false;
    }

    public RDD<Tuple2<K, V>> org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD(Seq<String> files) {
        Seq fileRDDs = (Seq)files.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;

            public final RDD<Tuple2<K, V>> apply(String file) {
                Option option;
                block6: {
                    RDD rDD;
                    block5: {
                        block4: {
                            option = this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$serializableConfOpt().map((Function1)new $anonfun$4$$anonfun$5(this));
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            Configuration config = (Configuration)some.x();
                            rDD = this.$outer.context().sparkContext().newAPIHadoopFile(file, this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$fm.runtimeClass(), this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$km.runtimeClass(), this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$vm.runtimeClass(), config);
                            break block5;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                        rDD = this.$outer.context().sparkContext().newAPIHadoopFile(file, this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$km, this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$vm, this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$fm);
                    }
                    RDD rdd = rDD;
                    if (Predef$.MODULE$.refArrayOps((Object[])rdd.partitions()).size() == 0) {
                        this.$outer.logError((Function0<String>)new Serializable(this, file){
                            public static final long serialVersionUID = 0L;
                            private final String file$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"File ").append((Object)this.file$1).append((Object)" has no data in it. Spark Streaming can only ingest ").append((Object)"files that have been \"moved\" to the directory assigned to the file stream. ").append((Object)"Refer to the streaming programming guide for more details.").toString();
                            }
                            {
                                this.file$1 = file$1;
                            }
                        });
                    }
                    return rdd;
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new UnionRDD(this.context().sparkContext(), fileRDDs, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private long getFileModTime(Path path) {
        return BoxesRunTime.unboxToLong((Object)this.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime().getOrElseUpdate((Object)path.toString(), (Function0)new Serializable(this, path){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;
            private final Path path$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$fs().getFileStatus(this.path$1).getModificationTime();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.path$1 = path$1;
            }
        }));
    }

    private Path directoryPath() {
        if (this.path_() == null) {
            this.path__$eq(new Path(this.directory));
        }
        return this.path_();
    }

    public FileSystem org$apache$spark$streaming$dstream$FileInputDStream$$fs() {
        if (this.fs_() == null) {
            this.fs__$eq(this.directoryPath().getFileSystem(this.ssc().sparkContext().hadoopConfiguration()));
        }
        return this.fs_();
    }

    private void reset() {
        this.fs__$eq(null);
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)new Serializable(this, ois){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;
            private final ObjectInputStream ois$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$readObject$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$anonfun$$$outer().getClass().getSimpleName()).append((Object)".readObject used").toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.ois$1.defaultReadObject();
                this.$outer.generatedRDDs_$eq(new HashMap());
                this.$outer.batchTimeToSelectedFiles_$eq((HashMap<Time, String[]>)new SynchronizedMap<Time, String[]>(this){

                    public Option scala$collection$mutable$SynchronizedMap$$super$get(Object key) {
                        return super.get(key);
                    }

                    public Iterator scala$collection$mutable$SynchronizedMap$$super$iterator() {
                        return super.iterator();
                    }

                    public SynchronizedMap scala$collection$mutable$SynchronizedMap$$super$$plus$eq(Tuple2 kv) {
                        return (SynchronizedMap)super.$plus$eq(kv);
                    }

                    public SynchronizedMap scala$collection$mutable$SynchronizedMap$$super$$minus$eq(Object key) {
                        return (SynchronizedMap)super.$minus$eq(key);
                    }

                    public int scala$collection$mutable$SynchronizedMap$$super$size() {
                        return super.size();
                    }

                    public Option scala$collection$mutable$SynchronizedMap$$super$put(Object key, Object value) {
                        return super.put(key, value);
                    }

                    public void scala$collection$mutable$SynchronizedMap$$super$update(Object key, Object value) {
                        super.update(key, value);
                    }

                    public Option scala$collection$mutable$SynchronizedMap$$super$remove(Object key) {
                        return super.remove(key);
                    }

                    public void scala$collection$mutable$SynchronizedMap$$super$clear() {
                        super.clear();
                    }

                    public Object scala$collection$mutable$SynchronizedMap$$super$getOrElseUpdate(Object key, Function0 op) {
                        return MapLike.class.getOrElseUpdate((scala.collection.mutable.MapLike)this, (Object)key, (Function0)op);
                    }

                    public SynchronizedMap scala$collection$mutable$SynchronizedMap$$super$transform(Function2 f) {
                        return (SynchronizedMap)MapLike.class.transform((scala.collection.mutable.MapLike)this, (Function2)f);
                    }

                    public SynchronizedMap scala$collection$mutable$SynchronizedMap$$super$retain(Function2 p) {
                        return (SynchronizedMap)MapLike.class.retain((scala.collection.mutable.MapLike)this, (Function2)p);
                    }

                    public Iterable scala$collection$mutable$SynchronizedMap$$super$values() {
                        return super.values();
                    }

                    public Iterator scala$collection$mutable$SynchronizedMap$$super$valuesIterator() {
                        return super.valuesIterator();
                    }

                    public Map scala$collection$mutable$SynchronizedMap$$super$clone() {
                        return MapLike.class.clone((scala.collection.mutable.MapLike)this);
                    }

                    public void scala$collection$mutable$SynchronizedMap$$super$foreach(Function1 f) {
                        super.foreach(f);
                    }

                    public Object scala$collection$mutable$SynchronizedMap$$super$apply(Object key) {
                        return super.apply(key);
                    }

                    public Set scala$collection$mutable$SynchronizedMap$$super$keySet() {
                        return super.keySet();
                    }

                    public Iterable scala$collection$mutable$SynchronizedMap$$super$keys() {
                        return MapLike.class.keys((MapLike)this);
                    }

                    public Iterator scala$collection$mutable$SynchronizedMap$$super$keysIterator() {
                        return super.keysIterator();
                    }

                    public boolean scala$collection$mutable$SynchronizedMap$$super$isEmpty() {
                        return MapLike.class.isEmpty((MapLike)this);
                    }

                    public boolean scala$collection$mutable$SynchronizedMap$$super$contains(Object key) {
                        return super.contains(key);
                    }

                    public boolean scala$collection$mutable$SynchronizedMap$$super$isDefinedAt(Object key) {
                        return MapLike.class.isDefinedAt((MapLike)this, (Object)key);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Option get(Object key) {
                        return SynchronizedMap.class.get((SynchronizedMap)this, (Object)key);
                    }

                    public Iterator<Tuple2<Time, String[]>> iterator() {
                        return SynchronizedMap.class.iterator((SynchronizedMap)this);
                    }

                    public SynchronizedMap<Time, String[]> $plus$eq(Tuple2<Time, String[]> kv) {
                        return SynchronizedMap.class.$plus$eq((SynchronizedMap)this, kv);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public SynchronizedMap $minus$eq(Object key) {
                        return SynchronizedMap.class.$minus$eq((SynchronizedMap)this, (Object)key);
                    }

                    public int size() {
                        return SynchronizedMap.class.size((SynchronizedMap)this);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Option put(Object key, Object value) {
                        return SynchronizedMap.class.put((SynchronizedMap)this, (Object)key, (Object)value);
                    }

                    public void update(Object key, Object value) {
                        SynchronizedMap.class.update((SynchronizedMap)this, (Object)key, (Object)value);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Option remove(Object key) {
                        return SynchronizedMap.class.remove((SynchronizedMap)this, (Object)key);
                    }

                    public void clear() {
                        SynchronizedMap.class.clear((SynchronizedMap)this);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Object getOrElseUpdate(Object key, Function0 function0) {
                        return SynchronizedMap.class.getOrElseUpdate((SynchronizedMap)this, (Object)key, (Function0)function0);
                    }

                    public SynchronizedMap<Time, String[]> transform(Function2<Time, String[], String[]> f) {
                        return SynchronizedMap.class.transform((SynchronizedMap)this, f);
                    }

                    public SynchronizedMap<Time, String[]> retain(Function2<Time, String[], Object> p) {
                        return SynchronizedMap.class.retain((SynchronizedMap)this, p);
                    }

                    public Iterable<String[]> values() {
                        return SynchronizedMap.class.values((SynchronizedMap)this);
                    }

                    public Iterator<String[]> valuesIterator() {
                        return SynchronizedMap.class.valuesIterator((SynchronizedMap)this);
                    }

                    public Map<Time, String[]> clone() {
                        return SynchronizedMap.class.clone((SynchronizedMap)this);
                    }

                    public <U> void foreach(Function1<Tuple2<Time, String[]>, U> f) {
                        SynchronizedMap.class.foreach((SynchronizedMap)this, f);
                    }

                    public Object apply(Object key) {
                        return SynchronizedMap.class.apply((SynchronizedMap)this, (Object)key);
                    }

                    public Set<Time> keySet() {
                        return SynchronizedMap.class.keySet((SynchronizedMap)this);
                    }

                    public Iterable<Time> keys() {
                        return SynchronizedMap.class.keys((SynchronizedMap)this);
                    }

                    public Iterator<Time> keysIterator() {
                        return SynchronizedMap.class.keysIterator((SynchronizedMap)this);
                    }

                    public boolean isEmpty() {
                        return SynchronizedMap.class.isEmpty((SynchronizedMap)this);
                    }

                    public boolean contains(Object key) {
                        return SynchronizedMap.class.contains((SynchronizedMap)this, (Object)key);
                    }

                    public boolean isDefinedAt(Object key) {
                        return SynchronizedMap.class.isDefinedAt((SynchronizedMap)this, (Object)key);
                    }
                    {
                        SynchronizedMap.class.$init$((SynchronizedMap)this);
                    }
                });
                this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles_$eq((HashSet<String>)new HashSet());
                this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime_$eq((TimeStampedHashMap<String, Object>)new TimeStampedHashMap(true));
            }

            public /* synthetic */ FileInputDStream org$apache$spark$streaming$dstream$FileInputDStream$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.ois$1 = ois$1;
            }
        });
    }

    public FileInputDStream(StreamingContext ssc_, String directory, Function1<Path, Object> filter2, boolean newFilesOnly, Option<Configuration> conf, ClassTag<K> km, ClassTag<V> vm, ClassTag<F> fm) {
        this.directory = directory;
        this.filter = filter2;
        this.org$apache$spark$streaming$dstream$FileInputDStream$$km = km;
        this.org$apache$spark$streaming$dstream$FileInputDStream$$vm = vm;
        this.org$apache$spark$streaming$dstream$FileInputDStream$$fm = fm;
        super(ssc_, ClassTag$.MODULE$.apply(Tuple2.class));
        this.org$apache$spark$streaming$dstream$FileInputDStream$$serializableConfOpt = conf.map((Function1)new $anonfun$1(this));
        this.checkpointData = new FileInputDStreamCheckpointData();
        this.initialModTimeIgnoreThreshold = newFilesOnly ? this.clock().getTimeMillis() : 0L;
        this.numBatchesToRemember = FileInputDStream$.MODULE$.calculateNumBatchesToRemember(this.slideDuration());
        this.durationToRemember = this.slideDuration().$times(this.numBatchesToRemember());
        this.remember(this.durationToRemember());
        this.batchTimeToSelectedFiles = new $anon$1(this);
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles = new HashSet();
        this.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime = new TimeStampedHashMap(true);
        this.lastNewFileFindingTime = 0L;
        this.path_ = null;
        this.fs_ = null;
    }

    public class FileInputDStreamCheckpointData
    extends DStreamCheckpointData<Tuple2<K, V>> {
        public HashMap<Time, String[]> hadoopFiles() {
            return this.data();
        }

        @Override
        public void update(Time time) {
            this.hadoopFiles().clear();
            this.hadoopFiles().$plus$plus$eq(this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().batchTimeToSelectedFiles());
        }

        @Override
        public void cleanup(Time time) {
        }

        @Override
        public void restore() {
            ((IterableLike)this.hadoopFiles().toSeq().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Time apply(Tuple2<Time, String[]> x$5) {
                    return (Time)x$5._1();
                }
            }, Time$.MODULE$.ordering())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileInputDStreamCheckpointData $outer;

                public final HashMap<Time, RDD<Tuple2<K, V>>> apply(Tuple2<Time, String[]> x0$1) {
                    Tuple2<Time, String[]> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Time t = (Time)tuple2._1();
                        String[] f = (String[])tuple2._2();
                        this.$outer.logInfo((Function0<String>)new Serializable(this, t, f){
                            public static final long serialVersionUID = 0L;
                            private final Time t$1;
                            private final String[] f$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Restoring files for time ").append((Object)this.t$1).append((Object)" - ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.f$1).mkString("[", ", ", "]")).toString();
                            }
                            {
                                void var3_3;
                                this.t$1 = t$1;
                                this.f$1 = var3_3;
                            }
                        });
                        ((SynchronizedMap)this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().batchTimeToSelectedFiles()).$plus$eq(new Tuple2((Object)t, (Object)f));
                        this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])f));
                        HashMap hashMap = this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(new Tuple2((Object)t, this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])f))));
                        return hashMap;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        @Override
        public String toString() {
            return new StringBuilder().append((Object)"[\n").append((Object)BoxesRunTime.boxToInteger((int)this.hadoopFiles().size())).append((Object)" file sets\n").append((Object)((TraversableOnce)this.hadoopFiles().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Time, String> apply(Tuple2<Time, String[]> p) {
                    return new Tuple2(p._1(), (Object)Predef$.MODULE$.refArrayOps((Object[])p._2()).mkString(", "));
                }
            }, HashMap$.MODULE$.canBuildFrom())).mkString("\n")).append((Object)"\n]").toString();
        }

        public /* synthetic */ FileInputDStream org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer() {
            return FileInputDStream.this;
        }

        public FileInputDStreamCheckpointData() {
            if (FileInputDStream.this == null) {
                throw new NullPointerException();
            }
            super(FileInputDStream.this, ClassTag$.MODULE$.apply(Tuple2.class));
        }
    }
}

