/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.api.python;

import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Interval;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.python.PythonDStream;
import org.apache.spark.streaming.api.python.PythonTransformFunction;
import org.apache.spark.streaming.api.python.TransformFunction;
import org.apache.spark.streaming.dstream.DStream;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001)4Q!\u0001\u0002\u0001\u00059\u0011A\u0004U=uQ>t'+\u001a3vG\u0016$w+\u001b8e_^,G\rR*ue\u0016\fWN\u0003\u0002\u0004\t\u00051\u0001/\u001f;i_:T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0011\u0001a\u0004\t\u0003!Ei\u0011AA\u0005\u0003%\t\u0011Q\u0002U=uQ>tGi\u0015;sK\u0006l\u0007\u0002\u0003\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\rA\f'/\u001a8u\u0007\u0001\u00012a\u0006\u000e\u001d\u001b\u0005A\"BA\r\u0007\u0003\u001d!7\u000f\u001e:fC6L!a\u0007\r\u0003\u000f\u0011\u001bFO]3b[B\u0019Q\u0004\t\u0012\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011Q!\u0011:sCf\u0004\"!H\u0012\n\u0005\u0011r\"\u0001\u0002\"zi\u0016D\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\faJ,G-^2f\rVt7\r\u0005\u0002\u0011Q%\u0011\u0011F\u0001\u0002\u0018!f$\bn\u001c8Ue\u0006t7OZ8s[\u001a+hn\u0019;j_:D#!J\u0016\u0011\u0005ua\u0013BA\u0017\u001f\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u0003(\u00039\u0001\u0018N\u001c<SK\u0012,8-\u001a$v]\u000eD#AL\u0016\t\u0011I\u0002!\u0011!Q\u0001\nM\nqbX<j]\u0012|w\u000fR;sCRLwN\u001c\t\u0003iUj\u0011AB\u0005\u0003m\u0019\u0011\u0001\u0002R;sCRLwN\u001c\u0005\tq\u0001\u0011\t\u0011)A\u0005g\u0005qql\u001d7jI\u0016$UO]1uS>t\u0007\"\u0002\u001e\u0001\t\u0003Y\u0014A\u0002\u001fj]&$h\b\u0006\u0004={yz\u0004)\u0011\t\u0003!\u0001AQ\u0001F\u001dA\u0002YAQAJ\u001dA\u0002\u001dBQaL\u001dA\u0002\u001dBQAM\u001dA\u0002MBQ\u0001O\u001dA\u0002MBqa\u0011\u0001C\u0002\u0013\u0005C)\u0001\bnkN$8\t[3dWB|\u0017N\u001c;\u0016\u0003\u0015\u0003\"!\b$\n\u0005\u001ds\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0013\u0002\u0001\u000b\u0011B#\u0002\u001f5,8\u000f^\"iK\u000e\\\u0007o\\5oi\u0002Bqa\u0013\u0001C\u0002\u0013\u0005A*A\u0007j]Z\u0014V\rZ;dK\u001a+hnY\u000b\u0002\u001bB\u0011\u0001CT\u0005\u0003\u001f\n\u0011\u0011\u0003\u0016:b]N4wN]7Gk:\u001cG/[8o\u0011\u0019\t\u0006\u0001)A\u0005\u001b\u0006q\u0011N\u001c<SK\u0012,8-\u001a$v]\u000e\u0004\u0003\"B*\u0001\t\u0003!\u0016AD<j]\u0012|w\u000fR;sCRLwN\\\u000b\u0002g!)a\u000b\u0001C!)\u0006i1\u000f\\5eK\u0012+(/\u0019;j_:DQ\u0001\u0017\u0001\u0005BQ\u000ba\u0003]1sK:$(+Z7f[\n,'\u000fR;sCRLwN\u001c\u0005\u00065\u0002!\teW\u0001\bG>l\u0007/\u001e;f)\taV\rE\u0002\u001e;~K!A\u0018\u0010\u0003\r=\u0003H/[8o!\r\u00017\rH\u0007\u0002C*\u0011!\rC\u0001\u0004e\u0012$\u0017B\u00013b\u0005\r\u0011F\t\u0012\u0005\u0006Mf\u0003\raZ\u0001\nm\u0006d\u0017\u000e\u001a+j[\u0016\u0004\"\u0001\u000e5\n\u0005%4!\u0001\u0002+j[\u0016\u0004")
public class PythonReducedWindowedDStream
extends PythonDStream {
    private final DStream<byte[]> parent;
    private final transient PythonTransformFunction pinvReduceFunc;
    private final Duration _windowDuration;
    private final Duration _slideDuration;
    private final boolean mustCheckpoint;
    private final TransformFunction invReduceFunc;

    @Override
    public boolean mustCheckpoint() {
        return this.mustCheckpoint;
    }

    public TransformFunction invReduceFunc() {
        return this.invReduceFunc;
    }

    public Duration windowDuration() {
        return this._windowDuration;
    }

    @Override
    public Duration slideDuration() {
        return this._slideDuration;
    }

    @Override
    public Duration parentRememberDuration() {
        return this.rememberDuration().$plus(this.windowDuration());
    }

    @Override
    public Option<RDD<byte[]>> compute(Time validTime) {
        Object object;
        Time currentTime = validTime;
        Interval current = new Interval(currentTime.$minus(this.windowDuration()), currentTime);
        Interval previous = current.$minus(this.slideDuration());
        Option previousRDD = this.getOrCompute(previous.endTime());
        if (this.pinvReduceFunc != null && previousRDD.isDefined() && this.windowDuration().$greater$eq(this.slideDuration().$times(5))) {
            Seq<RDD<byte[]>> oldRDDs = this.parent.slice(previous.beginTime().$plus(this.parent.slideDuration()), current.beginTime());
            Option subtracted = oldRDDs.size() > 0 ? this.invReduceFunc().apply(previousRDD, (Option<RDD<?>>)new Some((Object)this.ssc().sc().union(oldRDDs, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))), validTime) : previousRDD;
            Seq<RDD<byte[]>> newRDDs = this.parent.slice(previous.endTime().$plus(this.parent.slideDuration()), current.endTime());
            object = newRDDs.size() > 0 ? this.func().apply(subtracted, (Option<RDD<?>>)new Some((Object)this.ssc().sc().union(newRDDs, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))), validTime) : subtracted;
        } else {
            Seq<RDD<byte[]>> currentRDDs = this.parent.slice(current.beginTime().$plus(this.parent.slideDuration()), current.endTime());
            object = currentRDDs.size() > 0 ? this.func().apply((Option<RDD<?>>)None$.MODULE$, (Option<RDD<?>>)new Some((Object)this.ssc().sc().union(currentRDDs, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))), validTime) : None$.MODULE$;
        }
        return object;
    }

    public PythonReducedWindowedDStream(DStream<byte[]> parent, PythonTransformFunction preduceFunc, PythonTransformFunction pinvReduceFunc, Duration _windowDuration, Duration _slideDuration) {
        this.parent = parent;
        this.pinvReduceFunc = pinvReduceFunc;
        this._windowDuration = _windowDuration;
        this._slideDuration = _slideDuration;
        super(parent, preduceFunc);
        super.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        this.mustCheckpoint = true;
        this.invReduceFunc = new TransformFunction(pinvReduceFunc);
    }
}

