/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import org.apache.spark.Logging;
import org.apache.spark.streaming.util.Clock;
import org.apache.spark.streaming.util.RecurringTimer$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b!B\u0001\u0003\u0001\u0011a!A\u0004*fGV\u0014(/\u001b8h)&lWM\u001d\u0006\u0003\u0007\u0011\tA!\u001e;jY*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0004\u00015\u0019\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015+5\ta!\u0003\u0002\u0017\r\t9Aj\\4hS:<\u0007\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u000b\rdwnY6\u0004\u0001A\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\u0006\u00072|7m\u001b\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u00051\u0001/\u001a:j_\u0012\u0004\"AD\u0011\n\u0005\tz!\u0001\u0002'p]\u001eD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\tG\u0006dGNY1dWB!aB\n\u0011)\u0013\t9sBA\u0005Gk:\u001cG/[8ocA\u0011a\"K\u0005\u0003U=\u0011A!\u00168ji\"AA\u0006\u0001B\u0001B\u0003%Q&\u0001\u0003oC6,\u0007C\u0001\u00182\u001d\tqq&\u0003\u00021\u001f\u00051\u0001K]3eK\u001aL!AM\u001a\u0003\rM#(/\u001b8h\u0015\t\u0001t\u0002C\u00036\u0001\u0011\u0005a'\u0001\u0004=S:LGO\u0010\u000b\u0006oaJ$h\u000f\t\u00037\u0001AQ\u0001\u0007\u001bA\u0002iAQa\b\u001bA\u0002\u0001BQ\u0001\n\u001bA\u0002\u0015BQ\u0001\f\u001bA\u00025Bq!\u0010\u0001C\u0002\u0013%a(\u0001\u0004uQJ,\u0017\rZ\u000b\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\u0005Y\u0006twMC\u0001E\u0003\u0011Q\u0017M^1\n\u0005\u0019\u000b%A\u0002+ie\u0016\fG\r\u0003\u0004I\u0001\u0001\u0006IaP\u0001\bi\"\u0014X-\u00193!\u0011\u001dQ\u0005\u00011A\u0005\n-\u000b\u0001\u0002\u001d:fmRKW.Z\u000b\u0002A!9Q\n\u0001a\u0001\n\u0013q\u0015\u0001\u00049sKZ$\u0016.\\3`I\u0015\fHC\u0001\u0015P\u0011\u001d\u0001F*!AA\u0002\u0001\n1\u0001\u001f\u00132\u0011\u0019\u0011\u0006\u0001)Q\u0005A\u0005I\u0001O]3w)&lW\r\t\u0015\u0003#R\u0003\"AD+\n\u0005Y{!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000fa\u0003\u0001\u0019!C\u0005\u0017\u0006Aa.\u001a=u)&lW\rC\u0004[\u0001\u0001\u0007I\u0011B.\u0002\u00199,\u0007\u0010\u001e+j[\u0016|F%Z9\u0015\u0005!b\u0006b\u0002)Z\u0003\u0003\u0005\r\u0001\t\u0005\u0007=\u0002\u0001\u000b\u0015\u0002\u0011\u0002\u00139,\u0007\u0010\u001e+j[\u0016\u0004\u0003FA/U\u0011\u001d\t\u0007\u00011A\u0005\n\t\fqa\u001d;paB,G-F\u0001d!\tqA-\u0003\u0002f\u001f\t9!i\\8mK\u0006t\u0007bB4\u0001\u0001\u0004%I\u0001[\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000f\u0006\u0002)S\"9\u0001KZA\u0001\u0002\u0004\u0019\u0007BB6\u0001A\u0003&1-\u0001\u0005ti>\u0004\b/\u001a3!Q\tQG\u000bC\u0003o\u0001\u0011\u0005q.\u0001\u0007hKR\u001cF/\u0019:u)&lW\rF\u0001!\u0011\u0015\t\b\u0001\"\u0001s\u000399W\r\u001e*fgR\f'\u000f\u001e+j[\u0016$\"\u0001I:\t\u000bQ\u0004\b\u0019\u0001\u0011\u0002#=\u0014\u0018nZ5oC2\u001cF/\u0019:u)&lW\rC\u0003w\u0001\u0011\u0005q/A\u0003ti\u0006\u0014H\u000f\u0006\u0002!q\")\u00110\u001ea\u0001A\u0005I1\u000f^1siRKW.\u001a\u0005\u0006m\u0002!\ta\u001c\u0005\u0006y\u0002!\t!`\u0001\u0005gR|\u0007\u000f\u0006\u0002!}\")qp\u001fa\u0001G\u0006q\u0011N\u001c;feJ,\b\u000f\u001e+j[\u0016\u0014\bbBA\u0002\u0001\u0011%\u0011QA\u0001\u0005Y>|\u0007\u000fF\u0001)\u000f!\tIA\u0001E\u0001\t\u0005-\u0011A\u0004*fGV\u0014(/\u001b8h)&lWM\u001d\t\u00047\u00055aaB\u0001\u0003\u0011\u0003!\u0011qB\n\u0004\u0003\u001bi\u0001bB\u001b\u0002\u000e\u0011\u0005\u00111\u0003\u000b\u0003\u0003\u0017A\u0001\"a\u0006\u0002\u000e\u0011\u0005\u0011\u0011D\u0001\u0005[\u0006Lg\u000eF\u0002)\u00037A\u0001\"!\b\u0002\u0016\u0001\u0007\u0011qD\u0001\u0005CJ<7\u000f\u0005\u0003\u000f\u0003Ci\u0013bAA\u0012\u001f\t)\u0011I\u001d:bs\u0002")
public class RecurringTimer
implements Logging {
    private final Clock clock;
    private final long period;
    private final Function1<Object, BoxedUnit> callback;
    public final String org$apache$spark$streaming$util$RecurringTimer$$name;
    private final Thread thread;
    private volatile long org$apache$spark$streaming$util$RecurringTimer$$prevTime;
    private volatile long org$apache$spark$streaming$util$RecurringTimer$$nextTime;
    private volatile boolean stopped;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        RecurringTimer$.MODULE$.main(stringArray);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private Thread thread() {
        return this.thread;
    }

    public long org$apache$spark$streaming$util$RecurringTimer$$prevTime() {
        return this.org$apache$spark$streaming$util$RecurringTimer$$prevTime;
    }

    private void org$apache$spark$streaming$util$RecurringTimer$$prevTime_$eq(long x$1) {
        this.org$apache$spark$streaming$util$RecurringTimer$$prevTime = x$1;
    }

    public long org$apache$spark$streaming$util$RecurringTimer$$nextTime() {
        return this.org$apache$spark$streaming$util$RecurringTimer$$nextTime;
    }

    private void org$apache$spark$streaming$util$RecurringTimer$$nextTime_$eq(long x$1) {
        this.org$apache$spark$streaming$util$RecurringTimer$$nextTime = x$1;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public long getStartTime() {
        return (long)(package$.MODULE$.floor((double)this.clock.currentTime() / (double)this.period) + 1.0) * this.period;
    }

    public long getRestartTime(long originalStartTime) {
        long gap = this.clock.currentTime() - originalStartTime;
        return ((long)package$.MODULE$.floor((double)gap / (double)this.period) + 1L) * this.period + originalStartTime;
    }

    public synchronized long start(long startTime) {
        this.org$apache$spark$streaming$util$RecurringTimer$$nextTime_$eq(startTime);
        this.thread().start();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecurringTimer $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Started timer for ").append((Object)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$name).append((Object)" at time ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$nextTime())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        return this.org$apache$spark$streaming$util$RecurringTimer$$nextTime();
    }

    public long start() {
        return this.start(this.getStartTime());
    }

    public synchronized long stop(boolean interruptTimer) {
        if (!this.stopped()) {
            this.stopped_$eq(true);
            if (interruptTimer) {
                this.thread().interrupt();
            }
            this.thread().join();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RecurringTimer $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Stopped timer for ").append((Object)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$name).append((Object)" after time ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$prevTime())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        return this.org$apache$spark$streaming$util$RecurringTimer$$prevTime();
    }

    public void org$apache$spark$streaming$util$RecurringTimer$$loop() {
        try {
            while (!this.stopped()) {
                this.clock.waitTillTime(this.org$apache$spark$streaming$util$RecurringTimer$$nextTime());
                this.callback.apply$mcVJ$sp(this.org$apache$spark$streaming$util$RecurringTimer$$nextTime());
                this.org$apache$spark$streaming$util$RecurringTimer$$prevTime_$eq(this.org$apache$spark$streaming$util$RecurringTimer$$nextTime());
                this.org$apache$spark$streaming$util$RecurringTimer$$nextTime_$eq(this.org$apache$spark$streaming$util$RecurringTimer$$nextTime() + this.period);
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RecurringTimer $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Callback for ").append((Object)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$name).append((Object)" called at time ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$prevTime())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public RecurringTimer(Clock clock, long period, Function1<Object, BoxedUnit> callback, String name) {
        this.clock = clock;
        this.period = period;
        this.callback = callback;
        this.org$apache$spark$streaming$util$RecurringTimer$$name = name;
        Logging.class.$init$((Logging)this);
        this.thread = new $anon$1(this);
        this.org$apache$spark$streaming$util$RecurringTimer$$prevTime = -1L;
        this.org$apache$spark$streaming$util$RecurringTimer$$nextTime = -1L;
        this.stopped = false;
    }
}

