/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.Props$;
import akka.actor.ScalaActorSelection;
import akka.pattern.AskableActorSelection$;
import akka.pattern.package$;
import akka.util.Timeout$;
import com.google.common.base.Throwables;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkEnv;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisor;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl$;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.util.AkkaUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]h!B\u0001\u0003\u0001\u0011a!A\u0006*fG\u0016Lg/\u001a:TkB,'O^5t_JLU\u000e\u001d7\u000b\u0005\r!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e#A\u0011abD\u0007\u0002\u0005%\u0011\u0001C\u0001\u0002\u0013%\u0016\u001cW-\u001b<feN+\b/\u001a:wSN|'\u000f\u0005\u0002\u0013'5\ta!\u0003\u0002\u0015\r\t9Aj\\4hS:<\u0007\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0004\u0001A\u0012\u0001$\b\t\u0004\u001deY\u0012B\u0001\u000e\u0003\u0005!\u0011VmY3jm\u0016\u0014\bC\u0001\u000f\u001e\u0019\u0001!\u0011BH\u000b\u0002\u0002\u0003\u0005)\u0011A\u0010\u0003\u0007}#\u0013'\u0005\u0002!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t9aj\u001c;iS:<\u0007CA\u0011(\u0013\tA#EA\u0002B]fD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0004K:4\bC\u0001\n-\u0013\ticA\u0001\u0005Ta\u0006\u00148.\u00128w\u0011\u0015y\u0003\u0001\"\u00011\u0003\u0019a\u0014N\\5u}Q\u0019\u0011GM\u001c\u0011\u00059\u0001\u0001\"B\u0002/\u0001\u0004\u0019\u0004G\u0001\u001b7!\rq\u0011$\u000e\t\u00039Y\"\u0011B\b\u001a\u0002\u0002\u0003\u0005)\u0011A\u0010\t\u000b)r\u0003\u0019A\u0016\t\u000fe\u0002!\u0019!C\u0005u\u0005a!\r\\8dW6\u000bg.Y4feV\t1\b\u0005\u0002=\u007f5\tQH\u0003\u0002?\r\u000591\u000f^8sC\u001e,\u0017B\u0001!>\u00051\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0011\u0019\u0011\u0005\u0001)A\u0005w\u0005i!\r\\8dW6\u000bg.Y4fe\u0002Bq\u0001\u0012\u0001C\u0002\u0013%Q)\u0001\u0007ti>\u0014\u0018mZ3MKZ,G.F\u0001G!\tat)\u0003\u0002I{\ta1\u000b^8sC\u001e,G*\u001a<fY\"1!\n\u0001Q\u0001\n\u0019\u000bQb\u001d;pe\u0006<W\rT3wK2\u0004\u0003b\u0002'\u0001\u0005\u0004%I!T\u0001\riJ\f7m[3s\u0003\u000e$xN]\u000b\u0002\u001dB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0006C\u000e$xN\u001d\u0006\u0002'\u0006!\u0011m[6b\u0013\t)\u0006K\u0001\bBGR|'oU3mK\u000e$\u0018n\u001c8\t\r]\u0003\u0001\u0015!\u0003O\u00035!(/Y2lKJ\f5\r^8sA!9\u0011\f\u0001b\u0001\n\u0013Q\u0016AC1tWRKW.Z8viV\t1\f\u0005\u0002]C6\tQL\u0003\u0002_?\u0006AA-\u001e:bi&|gN\u0003\u0002aE\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\tl&A\u0004$j]&$X\rR;sCRLwN\u001c\u0005\u0007I\u0002\u0001\u000b\u0011B.\u0002\u0017\u0005\u001c8\u000eV5nK>,H\u000f\t\u0005\b#\u0002\u0011\r\u0011\"\u0003g+\u00059\u0007CA(i\u0013\tI\u0007K\u0001\u0005BGR|'OU3g\u0011\u0019Y\u0007\u0001)A\u0005O\u00061\u0011m\u0019;pe\u0002Bq!\u001c\u0001C\u0002\u0013%a.\u0001\u0006oK^\u0014En\\2l\u0013\u0012,\u0012a\u001c\t\u0003abl\u0011!\u001d\u0006\u0003eN\fa!\u0019;p[&\u001c'B\u00011u\u0015\t)h/\u0001\u0003vi&d'\"A<\u0002\t)\fg/Y\u0005\u0003sF\u0014!\"\u0011;p[&\u001cGj\u001c8h\u0011\u0019Y\b\u0001)A\u0005_\u0006Ya.Z<CY>\u001c7.\u00133!\u0011\u001di\bA1A\u0005\ny\faB\u00197pG.<UM\\3sCR|'/F\u0001\u0000!\rq\u0011\u0011A\u0005\u0004\u0003\u0007\u0011!A\u0004\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003\u0000\u0003=\u0011Gn\\2l\u000f\u0016tWM]1u_J\u0004\u0003bBA\u0006\u0001\u0011\u0005\u0011QB\u0001\u000baV\u001c\bnU5oO2,G\u0003BA\b\u0003+\u00012!IA\t\u0013\r\t\u0019B\t\u0002\u0005+:LG\u000fC\u0004\u0002\u0018\u0005%\u0001\u0019\u0001\u0014\u0002\t\u0011\fG/\u0019\u0005\b\u00037\u0001A\u0011AA\u000f\u0003=\u0001Xo\u001d5BeJ\f\u0017PQ;gM\u0016\u0014H\u0003CA\b\u0003?\tY$!\u0012\t\u0011\u0005\u0005\u0012\u0011\u0004a\u0001\u0003G\t1\"\u0019:sCf\u0014UO\u001a4feB\"\u0011QEA\u001c!\u0019\t9#!\r\u000265\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#A\u0004nkR\f'\r\\3\u000b\u0007\u0005=\"%\u0001\u0006d_2dWm\u0019;j_:LA!a\r\u0002*\tY\u0011I\u001d:bs\n+hMZ3s!\ra\u0012q\u0007\u0003\f\u0003s\ty\"!A\u0001\u0002\u000b\u0005qDA\u0002`IMB\u0001\"!\u0010\u0002\u001a\u0001\u0007\u0011qH\u0001\u0011_B$\u0018n\u001c8bY6+G/\u00193bi\u0006\u0004B!IA!M%\u0019\u00111\t\u0012\u0003\r=\u0003H/[8o\u0011!\t9%!\u0007A\u0002\u0005%\u0013aD8qi&|g.\u00197CY>\u001c7.\u00133\u0011\u000b\u0005\n\t%a\u0013\u0011\u0007q\ni%C\u0002\u0002Pu\u0012Qb\u0015;sK\u0006l'\t\\8dW&#\u0007bBA*\u0001\u0011\u0005\u0011QK\u0001\raV\u001c\b.\u0013;fe\u0006$xN\u001d\u000b\t\u0003\u001f\t9&a\u001f\u0002~!A\u0011\u0011LA)\u0001\u0004\tY&\u0001\u0005ji\u0016\u0014\u0018\r^8sa\u0011\ti&a\u001e\u0011\r\u0005}\u0013qNA;\u001d\u0011\t\t'a\u001b\u000f\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001a\u0017\u0003\u0019a$o\\8u}%\t1%C\u0002\u0002n\t\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002r\u0005M$\u0001C%uKJ\fGo\u001c:\u000b\u0007\u00055$\u0005E\u0002\u001d\u0003o\"1\"!\u001f\u0002X\u0005\u0005\t\u0011!B\u0001?\t\u0019q\f\n\u001b\t\u0011\u0005u\u0012\u0011\u000ba\u0001\u0003\u007fA\u0001\"a\u0012\u0002R\u0001\u0007\u0011\u0011\n\u0005\b\u0003\u0003\u0003A\u0011AAB\u0003%\u0001Xo\u001d5CsR,7\u000f\u0006\u0005\u0002\u0010\u0005\u0015\u0015QSAL\u0011!\t9)a A\u0002\u0005%\u0015!\u00022zi\u0016\u001c\b\u0003BAF\u0003#k!!!$\u000b\u0007\u0005=e/A\u0002oS>LA!a%\u0002\u000e\nQ!)\u001f;f\u0005V4g-\u001a:\t\u0011\u0005u\u0012q\u0010a\u0001\u0003\u007fA\u0001\"a\u0012\u0002\u0000\u0001\u0007\u0011\u0011\n\u0005\b\u00037\u0003A\u0011AAO\u0003E\u0011X\r]8siB+8\u000f[3e\u00052|7m\u001b\u000b\t\u0003\u001f\ty*a)\u0002.\"A\u0011\u0011UAM\u0001\u0004\tY%A\u0004cY>\u001c7.\u00133\t\u0011\u0005\u0015\u0016\u0011\u0014a\u0001\u0003O\u000b!B\\;n%\u0016\u001cwN\u001d3t!\r\t\u0013\u0011V\u0005\u0004\u0003W\u0013#\u0001\u0002'p]\u001eD\u0001\"!\u0010\u0002\u001a\u0002\u0007\u0011q\b\u0005\b\u0003c\u0003A\u0011AAZ\u0003-\u0011X\r]8si\u0016\u0013(o\u001c:\u0015\r\u0005=\u0011QWAd\u0011!\t9,a,A\u0002\u0005e\u0016aB7fgN\fw-\u001a\t\u0005\u0003w\u000b\tMD\u0002\"\u0003{K1!a0#\u0003\u0019\u0001&/\u001a3fM&!\u00111YAc\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0018\u0012\t\u0011\u0005%\u0017q\u0016a\u0001\u0003\u0017\fQ!\u001a:s_J\u0004B!a\u0018\u0002N&!\u0011qZA:\u0005%!\u0006N]8xC\ndW\rC\u0004\u0002T\u0002!\t&!6\u0002\u000f=t7\u000b^1siR\u0011\u0011q\u0002\u0005\b\u00033\u0004A\u0011KAn\u0003\u0019ygn\u0015;paR1\u0011qBAo\u0003?D\u0001\"a.\u0002X\u0002\u0007\u0011\u0011\u0018\u0005\t\u0003\u0013\f9\u000e1\u0001\u0002bB)\u0011%!\u0011\u0002L\"9\u0011Q\u001d\u0001\u0005R\u0005U\u0017aD8o%\u0016\u001cW-\u001b<feN#\u0018M\u001d;\t\u000f\u0005%\b\u0001\"\u0015\u0002l\u0006qqN\u001c*fG\u0016Lg/\u001a:Ti>\u0004HCBA\b\u0003[\fy\u000f\u0003\u0005\u00028\u0006\u001d\b\u0019AA]\u0011!\tI-a:A\u0002\u0005\u0005\bbBAz\u0001\u0011%\u0011Q_\u0001\f]\u0016DHO\u00117pG.LE-\u0006\u0002\u0002L\u0001")
public class ReceiverSupervisorImpl
extends ReceiverSupervisor {
    public final Receiver<?> org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$receiver;
    private final SparkEnv env;
    private final BlockManager blockManager;
    private final StorageLevel storageLevel;
    private final ActorSelection org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$trackerActor;
    private final FiniteDuration org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$askTimeout;
    private final ActorRef actor;
    private final AtomicLong newBlockId;
    private final BlockGenerator blockGenerator;

    private BlockManager blockManager() {
        return this.blockManager;
    }

    private StorageLevel storageLevel() {
        return this.storageLevel;
    }

    public ActorSelection org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$trackerActor() {
        return this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$trackerActor;
    }

    public FiniteDuration org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$askTimeout() {
        return this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$askTimeout;
    }

    private ActorRef actor() {
        return this.actor;
    }

    private AtomicLong newBlockId() {
        return this.newBlockId;
    }

    private BlockGenerator blockGenerator() {
        return this.blockGenerator;
    }

    @Override
    public void pushSingle(Object data) {
        this.blockGenerator().$plus$eq(data);
    }

    @Override
    public void pushArrayBuffer(ArrayBuffer<?> arrayBuffer, Option<Object> optionalMetadata, Option<StreamBlockId> optionalBlockId) {
        StreamBlockId blockId = (StreamBlockId)optionalBlockId.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final StreamBlockId apply() {
                return this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$nextBlockId();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        long time = System.currentTimeMillis();
        this.blockManager().put((BlockId)blockId, arrayBuffer, this.storageLevel(), true);
        this.logDebug((Function0<String>)new Serializable(this, blockId, time){
            public static final long serialVersionUID = 0L;
            private final StreamBlockId blockId$1;
            private final long time$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Pushed block ").append((Object)this.blockId$1).append((Object)" in ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.time$1))).append((Object)" ms").toString();
            }
            {
                this.blockId$1 = blockId$1;
                this.time$1 = time$1;
            }
        });
        this.reportPushedBlock(blockId, arrayBuffer.size(), optionalMetadata);
    }

    @Override
    public void pushIterator(Iterator<Object> iterator, Option<Object> optionalMetadata, Option<StreamBlockId> optionalBlockId) {
        StreamBlockId blockId = (StreamBlockId)optionalBlockId.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final StreamBlockId apply() {
                return this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$nextBlockId();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        long time = System.currentTimeMillis();
        this.blockManager().put((BlockId)blockId, iterator, this.storageLevel(), true);
        this.logDebug((Function0<String>)new Serializable(this, blockId, time){
            public static final long serialVersionUID = 0L;
            private final StreamBlockId blockId$3;
            private final long time$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Pushed block ").append((Object)this.blockId$3).append((Object)" in ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.time$2))).append((Object)" ms").toString();
            }
            {
                this.blockId$3 = blockId$3;
                this.time$2 = time$2;
            }
        });
        this.reportPushedBlock(blockId, -1L, optionalMetadata);
    }

    @Override
    public void pushBytes(ByteBuffer bytes, Option<Object> optionalMetadata, Option<StreamBlockId> optionalBlockId) {
        StreamBlockId blockId = (StreamBlockId)optionalBlockId.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final StreamBlockId apply() {
                return this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$nextBlockId();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        long time = System.currentTimeMillis();
        this.blockManager().putBytes((BlockId)blockId, bytes, this.storageLevel(), true);
        this.logDebug((Function0<String>)new Serializable(this, blockId, time){
            public static final long serialVersionUID = 0L;
            private final StreamBlockId blockId$4;
            private final long time$3;

            public final String apply() {
                return new StringBuilder().append((Object)"Pushed block ").append((Object)this.blockId$4).append((Object)" in ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.time$3))).append((Object)" ms").toString();
            }
            {
                this.blockId$4 = blockId$4;
                this.time$3 = time$3;
            }
        });
        this.reportPushedBlock(blockId, -1L, optionalMetadata);
    }

    public void reportPushedBlock(StreamBlockId blockId, long numRecords, Option<Object> optionalMetadata) {
        ReceivedBlockInfo blockInfo = new ReceivedBlockInfo(this.streamId(), blockId, numRecords, optionalMetadata.orNull(Predef$.MODULE$.conforms()));
        ScalaActorSelection qual$1 = ActorSelection$.MODULE$.toScala(this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$trackerActor());
        AddBlock x$1 = new AddBlock(blockInfo);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final StreamBlockId blockId$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Reported block ").append((Object)this.blockId$2).toString();
            }
            {
                this.blockId$2 = blockId$2;
            }
        });
    }

    @Override
    public void reportError(String message, Throwable error) {
        String errorString = (String)Option$.MODULE$.apply((Object)error).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Throwable x$1) {
                return Throwables.getStackTraceAsString((Throwable)x$1);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        ScalaActorSelection qual$2 = ActorSelection$.MODULE$.toScala(this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$trackerActor());
        ReportError x$3 = new ReportError(this.streamId(), message, errorString);
        ActorRef x$4 = qual$2.$bang$default$2((Object)x$3);
        qual$2.$bang((Object)x$3, x$4);
        this.logWarning((Function0<String>)new Serializable(this, message, error){
            public static final long serialVersionUID = 0L;
            private final String message$1;
            private final Throwable error$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Reported error ").append((Object)this.message$1).append((Object)" - ").append((Object)this.error$1).toString();
            }
            {
                this.message$1 = message$1;
                this.error$1 = error$1;
            }
        });
    }

    @Override
    public void onStart() {
        this.blockGenerator().start();
    }

    @Override
    public void onStop(String message, Option<Throwable> error) {
        this.blockGenerator().stop();
        this.env.actorSystem().stop(this.actor());
    }

    @Override
    public void onReceiverStart() {
        RegisterReceiver msg = new RegisterReceiver(this.streamId(), this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$receiver.getClass().getSimpleName(), Utils$.MODULE$.localHostName(), this.actor());
        Future future = AskableActorSelection$.MODULE$.ask$extension(package$.MODULE$.ask(this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$trackerActor()), (Object)msg, Timeout$.MODULE$.durationToTimeout(this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$askTimeout()));
        Await$.MODULE$.result((Awaitable)future, (Duration)this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$askTimeout());
    }

    @Override
    public void onReceiverStop(String message, Option<Throwable> error) {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Deregistering receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.streamId())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        String errorString = (String)error.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Throwable x$1) {
                return Throwables.getStackTraceAsString((Throwable)x$1);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        Future future = AskableActorSelection$.MODULE$.ask$extension(package$.MODULE$.ask(this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$trackerActor()), (Object)new DeregisterReceiver(this.streamId(), message, errorString), Timeout$.MODULE$.durationToTimeout(this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$askTimeout()));
        Await$.MODULE$.result((Awaitable)future, (Duration)this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$askTimeout());
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Stopped receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.streamId())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public StreamBlockId org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$nextBlockId() {
        return new StreamBlockId(this.streamId(), this.newBlockId().getAndIncrement());
    }

    public ReceiverSupervisorImpl(Receiver<?> receiver, SparkEnv env) {
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$receiver = receiver;
        this.env = env;
        super(receiver, env.conf());
        this.blockManager = env.blockManager();
        this.storageLevel = receiver.storageLevel();
        String ip = env.conf().get("spark.driver.host", "localhost");
        int port = env.conf().getInt("spark.driver.port", 7077);
        String url = new StringOps(Predef$.MODULE$.augmentString("akka.tcp://spark@%s:%s/user/ReceiverTracker")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ip, BoxesRunTime.boxToInteger((int)port)}));
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$trackerActor = env.actorSystem().actorSelection(url);
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$askTimeout = AkkaUtils$.MODULE$.askTimeout(env.conf());
        this.actor = env.actorSystem().actorOf(Props$.MODULE$.apply((Function0)new $anonfun$1(this), ClassTag$.MODULE$.apply(Actor.class)), new StringBuilder().append((Object)"Receiver-").append((Object)BoxesRunTime.boxToInteger((int)this.streamId())).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString());
        this.newBlockId = new AtomicLong(System.currentTimeMillis());
        this.blockGenerator = new BlockGenerator(new $anon$2(this), this.streamId(), env.conf());
    }
}

