/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisor$;
import org.apache.spark.streaming.receiver.ReceiverSupervisor$ReceiverState$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\tMcAB\u0001\u0003\u0003\u0003!AB\u0001\nSK\u000e,\u0017N^3s'V\u0004XM\u001d<jg>\u0014(BA\u0002\u0005\u0003!\u0011XmY3jm\u0016\u0014(BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q)R\"\u0001\u0004\n\u0005Y1!a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u00053\r\u0001\u0001G\u0001\u000e!!\rYBDH\u0007\u0002\u0005%\u0011QD\u0001\u0002\t%\u0016\u001cW-\u001b<feB\u0011q\u0004\t\u0007\u0001\t%\ts#!A\u0001\u0002\u000b\u0005!EA\u0002`IE\n\"a\t\u0014\u0011\u00059!\u0013BA\u0013\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AD\u0014\n\u0005!z!aA!os\"A!\u0006\u0001B\u0001B\u0003%1&\u0001\u0003d_:4\u0007C\u0001\u000b-\u0013\ticAA\u0005Ta\u0006\u00148nQ8oM\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"2!\r\u001a8!\tY\u0002\u0001C\u0003\u0004]\u0001\u00071\u0007\r\u00025mA\u00191\u0004H\u001b\u0011\u0005}1D!C\u00113\u0003\u0003\u0005\tQ!\u0001#\u0011\u0015Qc\u00061\u0001,\u000f\u0015I\u0004\u0001#\u0001;\u00035\u0011VmY3jm\u0016\u00148\u000b^1uKB\u00111\bP\u0007\u0002\u0001\u0019)Q\b\u0001E\u0001}\ti!+Z2fSZ,'o\u0015;bi\u0016\u001c\"\u0001P \u0011\u00059\u0001\u0015BA!\u0010\u0005-)e.^7fe\u0006$\u0018n\u001c8\t\u000b=bD\u0011A\"\u0015\u0003i*A!\u0012\u001f\u0001\r\ny1\t[3dWB|\u0017N\u001c;Ti\u0006$X\r\u0005\u0002H\u00116\tA(\u0003\u0002J\u0001\n)a+\u00197vK\"91\n\u0010b\u0001\n\u0003a\u0015aC%oSRL\u0017\r\\5{K\u0012,\u0012A\u0012\u0005\u0007\u001dr\u0002\u000b\u0011\u0002$\u0002\u0019%s\u0017\u000e^5bY&TX\r\u001a\u0011\t\u000fAc$\u0019!C\u0001\u0019\u000691\u000b^1si\u0016$\u0007B\u0002*=A\u0003%a)\u0001\u0005Ti\u0006\u0014H/\u001a3!\u0011\u001d!FH1A\u0005\u00021\u000bqa\u0015;paB,G\r\u0003\u0004Wy\u0001\u0006IAR\u0001\t'R|\u0007\u000f]3eA!9\u0001\f\u0001b\u0001\n#I\u0016\u0001C:ue\u0016\fW.\u00133\u0016\u0003i\u0003\"AD.\n\u0005q{!aA%oi\"1a\f\u0001Q\u0001\ni\u000b\u0011b\u001d;sK\u0006l\u0017\n\u001a\u0011\t\u000f\u0001\u0004!\u0019!C\u0005C\u0006I1\u000f^8q\u0019\u0006$8\r[\u000b\u0002EB\u00111M[\u0007\u0002I*\u0011QMZ\u0001\u000bG>t7-\u001e:sK:$(BA4i\u0003\u0011)H/\u001b7\u000b\u0003%\fAA[1wC&\u00111\u000e\u001a\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0011\u0019i\u0007\u0001)A\u0005E\u0006Q1\u000f^8q\u0019\u0006$8\r\u001b\u0011\t\u000f=\u0004!\u0019!C\u00053\u0006\u0019B-\u001a4bk2$(+Z:uCJ$H)\u001a7bs\"1\u0011\u000f\u0001Q\u0001\ni\u000bA\u0003Z3gCVdGOU3ti\u0006\u0014H\u000fR3mCf\u0004\u0003bB:\u0001\u0001\u0004%\t\u0002^\u0001\u000egR|\u0007\u000f]5oO\u0016\u0013(o\u001c:\u0016\u0003U\u0004\"A\u001e@\u000f\u0005]dhB\u0001=|\u001b\u0005I(B\u0001>\u0019\u0003\u0019a$o\\8u}%\t\u0001#\u0003\u0002~\u001f\u00059\u0001/Y2lC\u001e,\u0017bA@\u0002\u0002\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003{>A\u0011\"!\u0002\u0001\u0001\u0004%\t\"a\u0002\u0002#M$x\u000e\u001d9j]\u001e,%O]8s?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0005=\u0001c\u0001\b\u0002\f%\u0019\u0011QB\b\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003#\t\u0019!!AA\u0002U\f1\u0001\u001f\u00132\u0011\u001d\t)\u0002\u0001Q!\nU\fab\u001d;paBLgnZ#se>\u0014\b\u0005\u000b\u0003\u0002\u0014\u0005e\u0001c\u0001\b\u0002\u001c%\u0019\u0011QD\b\u0003\u0011Y|G.\u0019;jY\u0016D!\"!\t\u0001\u0001\u0004%\t\u0001BA\u0012\u00035\u0011XmY3jm\u0016\u00148\u000b^1uKV\u0011\u0011Q\u0005\t\u0004\u0003OAeBA\u001e9\u0011)\tY\u0003\u0001a\u0001\n\u0003!\u0011QF\u0001\u0012e\u0016\u001cW-\u001b<feN#\u0018\r^3`I\u0015\fH\u0003BA\u0005\u0003_A!\"!\u0005\u0002*\u0005\u0005\t\u0019AA\u0013\u0011!\t\u0019\u0004\u0001Q!\n\u0005\u0015\u0012A\u0004:fG\u0016Lg/\u001a:Ti\u0006$X\r\t\u0015\u0005\u0003c\tI\u0002C\u0004\u0002:\u00011\t!a\u000f\u0002\u0015A,8\u000f[*j]\u001edW\r\u0006\u0003\u0002\n\u0005u\u0002bBA \u0003o\u0001\rAJ\u0001\u0005I\u0006$\u0018\rC\u0004\u0002D\u00011\t!!\u0012\u0002\u0013A,8\u000f\u001b\"zi\u0016\u001cH\u0003CA\u0005\u0003\u000f\n9&!\u0019\t\u0011\u0005%\u0013\u0011\ta\u0001\u0003\u0017\nQAY=uKN\u0004B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#B\u0017a\u00018j_&!\u0011QKA(\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\t\u00033\n\t\u00051\u0001\u0002\\\u0005\u0001r\u000e\u001d;j_:\fG.T3uC\u0012\fG/\u0019\t\u0005\u001d\u0005uc%C\u0002\u0002`=\u0011aa\u00149uS>t\u0007\u0002CA2\u0003\u0003\u0002\r!!\u001a\u0002\u001f=\u0004H/[8oC2\u0014En\\2l\u0013\u0012\u0004RADA/\u0003O\u0002B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[2\u0011aB:u_J\fw-Z\u0005\u0005\u0003c\nYGA\u0007TiJ,\u0017-\u001c\"m_\u000e\\\u0017\n\u001a\u0005\b\u0003k\u0002a\u0011AA<\u00031\u0001Xo\u001d5Ji\u0016\u0014\u0018\r^8s)!\tI!!\u001f\u0002\f\u00065\u0005\u0002CA>\u0003g\u0002\r!! \u0002\u0011%$XM]1u_J\u0004D!a \u0002\bB)a/!!\u0002\u0006&!\u00111QA\u0001\u0005!IE/\u001a:bi>\u0014\bcA\u0010\u0002\b\u0012Y\u0011\u0011RA=\u0003\u0003\u0005\tQ!\u0001#\u0005\ryFE\r\u0005\t\u00033\n\u0019\b1\u0001\u0002\\!A\u00111MA:\u0001\u0004\t)\u0007C\u0004\u0002\u0012\u00021\t!a%\u0002\u001fA,8\u000f[!se\u0006L()\u001e4gKJ$\u0002\"!\u0003\u0002\u0016\u0006E\u00161\u0017\u0005\t\u0003/\u000by\t1\u0001\u0002\u001a\u0006Y\u0011M\u001d:bs\n+hMZ3sa\u0011\tY*!,\u0011\r\u0005u\u0015qUAV\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003K{\u0011AC2pY2,7\r^5p]&!\u0011\u0011VAP\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007}\ti\u000bB\u0006\u00020\u0006U\u0015\u0011!A\u0001\u0006\u0003\u0011#aA0%g!A\u0011\u0011LAH\u0001\u0004\tY\u0006\u0003\u0005\u0002d\u0005=\u0005\u0019AA3\u0011\u001d\t9\f\u0001D\u0001\u0003s\u000b1B]3q_J$XI\u001d:peR1\u0011\u0011BA^\u0003\u001bD\u0001\"!0\u00026\u0002\u0007\u0011qX\u0001\b[\u0016\u001c8/Y4f!\u0011\t\t-a2\u000f\u00079\t\u0019-C\u0002\u0002F>\ta\u0001\u0015:fI\u00164\u0017\u0002BAe\u0003\u0017\u0014aa\u0015;sS:<'bAAc\u001f!9\u0011qZA[\u0001\u0004)\u0018!\u0003;ie><\u0018M\u00197f\u0011\u001d\t\u0019\u000e\u0001C\t\u0003+\fqa\u001c8Ti\u0006\u0014H\u000f\u0006\u0002\u0002\n!9\u0011\u0011\u001c\u0001\u0005\u0012\u0005m\u0017AB8o'R|\u0007\u000f\u0006\u0004\u0002\n\u0005u\u0017q\u001c\u0005\t\u0003{\u000b9\u000e1\u0001\u0002@\"A\u0011\u0011]Al\u0001\u0004\t\u0019/A\u0003feJ|'\u000f\u0005\u0003\u000f\u0003;*\bbBAt\u0001\u0011E\u0011Q[\u0001\u0010_:\u0014VmY3jm\u0016\u00148\u000b^1si\"9\u00111\u001e\u0001\u0005\u0012\u00055\u0018AD8o%\u0016\u001cW-\u001b<feN#x\u000e\u001d\u000b\u0007\u0003\u0013\ty/!=\t\u0011\u0005u\u0016\u0011\u001ea\u0001\u0003\u007fC\u0001\"!9\u0002j\u0002\u0007\u00111\u001d\u0005\b\u0003k\u0004A\u0011AAk\u0003\u0015\u0019H/\u0019:u\u0011\u001d\tI\u0010\u0001C\u0001\u0003w\fAa\u001d;paR1\u0011\u0011BA\u007f\u0003\u007fD\u0001\"!0\u0002x\u0002\u0007\u0011q\u0018\u0005\t\u0003C\f9\u00101\u0001\u0002d\"9!1\u0001\u0001\u0005\u0002\u0005U\u0017!D:uCJ$(+Z2fSZ,'\u000fC\u0004\u0003\b\u0001!\tA!\u0003\u0002\u0019M$x\u000e\u001d*fG\u0016Lg/\u001a:\u0015\r\u0005%!1\u0002B\u0007\u0011!\tiL!\u0002A\u0002\u0005}\u0006\u0002CAq\u0005\u000b\u0001\r!a9\t\u000f\tE\u0001\u0001\"\u0001\u0003\u0014\u0005y!/Z:uCJ$(+Z2fSZ,'\u000f\u0006\u0004\u0002\n\tU!q\u0003\u0005\t\u0003{\u0013y\u00011\u0001\u0002@\"Q\u0011\u0011\u001dB\b!\u0003\u0005\r!a9\t\u000f\tE\u0001\u0001\"\u0001\u0003\u001cQA\u0011\u0011\u0002B\u000f\u0005?\u0011\t\u0003\u0003\u0005\u0002>\ne\u0001\u0019AA`\u0011!\t\tO!\u0007A\u0002\u0005\r\bb\u0002B\u0012\u00053\u0001\rAW\u0001\u0006I\u0016d\u0017-\u001f\u0005\b\u0005O\u0001A\u0011\u0001B\u0015\u0003EI7OU3dK&4XM]*uCJ$X\r\u001a\u000b\u0003\u0005W\u00012A\u0004B\u0017\u0013\r\u0011yc\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0005S\t\u0011#[:SK\u000e,\u0017N^3s'R|\u0007\u000f]3e\u0011\u001d\u00119\u0004\u0001C\u0001\u0003+\f\u0001#Y<bSR$VM]7j]\u0006$\u0018n\u001c8\t\u0013\tm\u0002!%A\u0005\u0002\tu\u0012!\u0007:fgR\f'\u000f\u001e*fG\u0016Lg/\u001a:%I\u00164\u0017-\u001e7uII*\"Aa\u0010+\t\u0005\r(\u0011I\u0016\u0003\u0005\u0007\u0002BA!\u0012\u0003P5\u0011!q\t\u0006\u0005\u0005\u0013\u0012Y%A\u0005v]\u000eDWmY6fI*\u0019!QJ\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003R\t\u001d#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public abstract class ReceiverSupervisor
implements Logging {
    private final Receiver<?> receiver;
    private final int streamId;
    private final CountDownLatch stopLatch;
    private final int defaultRestartDelay;
    private volatile Throwable stoppingError;
    private volatile Enumeration.Value receiverState;
    private volatile ReceiverSupervisor$ReceiverState$ ReceiverState$module;
    private transient Logger org$apache$spark$Logging$$log_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReceiverSupervisor$ReceiverState$ ReceiverState$lzycompute() {
        ReceiverSupervisor receiverSupervisor = this;
        synchronized (receiverSupervisor) {
            if (this.ReceiverState$module != null) return this.ReceiverState$module;
            this.ReceiverState$module = new ReceiverSupervisor$ReceiverState$(this);
            return this.ReceiverState$module;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ReceiverSupervisor$ReceiverState$ ReceiverState() {
        return this.ReceiverState$module == null ? this.ReceiverState$lzycompute() : this.ReceiverState$module;
    }

    public int streamId() {
        return this.streamId;
    }

    private CountDownLatch stopLatch() {
        return this.stopLatch;
    }

    private int defaultRestartDelay() {
        return this.defaultRestartDelay;
    }

    public Throwable stoppingError() {
        return this.stoppingError;
    }

    public void stoppingError_$eq(Throwable x$1) {
        this.stoppingError = x$1;
    }

    public Enumeration.Value receiverState() {
        return this.receiverState;
    }

    public void receiverState_$eq(Enumeration.Value x$1) {
        this.receiverState = x$1;
    }

    public abstract void pushSingle(Object var1);

    public abstract void pushBytes(ByteBuffer var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract void pushIterator(Iterator<Object> var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract void pushArrayBuffer(ArrayBuffer<?> var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract void reportError(String var1, Throwable var2);

    public void onStart() {
    }

    public void onStop(String message, Option<Throwable> error) {
    }

    public void onReceiverStart() {
    }

    public void onReceiverStop(String message, Option<Throwable> error) {
    }

    public void start() {
        this.onStart();
        this.startReceiver();
    }

    public void stop(String message, Option<Throwable> error) {
        this.stoppingError_$eq((Throwable)error.orNull(Predef$.MODULE$.conforms()));
        this.stopReceiver(message, error);
        this.onStop(message, error);
        this.stopLatch().countDown();
    }

    public synchronized void startReceiver() {
        try {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting receiver";
                }
            });
            this.receiver.onStart();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Called receiver onStart";
                }
            });
            this.onReceiverStart();
            this.receiverState_$eq(this.ReceiverState().Started());
        }
        catch (Throwable throwable) {
            this.stop(new StringBuilder().append((Object)"Error starting receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId())).toString(), (Option<Throwable>)new Some((Object)throwable));
        }
    }

    public synchronized void stopReceiver(String message, Option<Throwable> error) {
        try {
            this.logInfo((Function0<String>)new Serializable(this, message, error){
                public static final long serialVersionUID = 0L;
                private final String message$2;
                private final Option error$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Stopping receiver with message: ").append((Object)this.message$2).append((Object)": ").append(this.error$2.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    })).toString();
                }
                {
                    this.message$2 = message$2;
                    this.error$2 = error$2;
                }
            });
            this.receiverState_$eq(this.ReceiverState().Stopped());
            this.receiver.onStop();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Called receiver onStop";
                }
            });
            this.onReceiverStop(message, error);
        }
        catch (Throwable throwable) {
            this.stop(new StringBuilder().append((Object)"Error stopping receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId())).toString(), (Option<Throwable>)new Some((Object)throwable));
        }
    }

    public void restartReceiver(String message, Option<Throwable> error) {
        this.restartReceiver(message, error, this.defaultRestartDelay());
    }

    public void restartReceiver(String message, Option<Throwable> error, int delay) {
        Future$.MODULE$.apply((Function0)new Serializable(this, message, error, delay){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisor $outer;
            public final String message$1;
            private final Option error$1;
            public final int delay$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$restartReceiver$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Restarting receiver with delay ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.delay$1)).append((Object)" ms: ").append((Object)this.$outer.message$1).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, (Throwable)this.error$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                this.$outer.stopReceiver(new StringBuilder().append((Object)"Restarting receiver with delay ").append((Object)BoxesRunTime.boxToInteger((int)this.delay$1)).append((Object)"ms: ").append((Object)this.message$1).toString(), (Option<Throwable>)this.error$1);
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$restartReceiver$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Sleeping for ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.delay$1)).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Thread.sleep(this.delay$1);
                this.$outer.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting receiver again";
                    }
                });
                this.$outer.startReceiver();
                this.$outer.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Receiver started again";
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.message$1 = message$1;
                this.error$1 = error$1;
                this.delay$1 = delay$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public Option<Throwable> restartReceiver$default$2() {
        return None$.MODULE$;
    }

    public boolean isReceiverStarted() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisor $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"state = ").append((Object)this.$outer.receiverState()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Enumeration.Value value = this.receiverState();
        Enumeration.Value value2 = this.ReceiverState().Started();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean isReceiverStopped() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisor $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"state = ").append((Object)this.$outer.receiverState()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Enumeration.Value value = this.receiverState();
        Enumeration.Value value2 = this.ReceiverState().Stopped();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public void awaitTermination() {
        this.stopLatch().await();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Waiting for executor stop is over";
            }
        });
        if (this.stoppingError() == null) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopped executor without error";
                }
            });
        } else {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverSupervisor $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Stopped executor with error: ").append((Object)this.$outer.stoppingError()).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        if (this.stoppingError() == null) {
            return;
        }
        throw this.stoppingError();
    }

    public ReceiverSupervisor(Receiver<?> receiver, SparkConf conf) {
        this.receiver = receiver;
        Logging.class.$init$((Logging)this);
        receiver.attachExecutor(this);
        this.streamId = receiver.streamId();
        this.stopLatch = new CountDownLatch(1);
        this.defaultRestartDelay = conf.getInt("spark.streaming.receiverRestartDelay", 2000);
        this.stoppingError = null;
        this.receiverState = this.ReceiverState().Initialized();
    }
}

