/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.twitter;

import org.apache.spark.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.receiver.Receiver;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import twitter4j.FilterQuery;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.auth.Authorization;

@ScalaSignature(bytes="\u0006\u0001i4Q!\u0001\u0002\u0001\t1\u0011q\u0002V<jiR,'OU3dK&4XM\u001d\u0006\u0003\u0007\u0011\tq\u0001^<jiR,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\r\u0011\u00079\t2#D\u0001\u0010\u0015\t\u0001B!\u0001\u0005sK\u000e,\u0017N^3s\u0013\t\u0011rB\u0001\u0005SK\u000e,\u0017N^3s!\t!r#D\u0001\u0016\u0015\u00051\u0012!\u0003;xSR$XM\u001d\u001bk\u0013\tARC\u0001\u0004Ti\u0006$Xo\u001d\t\u00035mi\u0011AB\u0005\u00039\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003!\u0003-!x/\u001b;uKJ\fU\u000f\u001e5\u0004\u0001A\u0011\u0011\u0005J\u0007\u0002E)\u00111%F\u0001\u0005CV$\b.\u0003\u0002&E\ti\u0011)\u001e;i_JL'0\u0019;j_:D\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\bM&dG/\u001a:t!\rI3G\u000e\b\u0003UAr!a\u000b\u0018\u000e\u00031R!!L\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0013!B:dC2\f\u0017BA\u00193\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011aL\u0005\u0003iU\u00121aU3r\u0015\t\t$\u0007\u0005\u00028w9\u0011\u0001(O\u0007\u0002e%\u0011!HM\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;e!Iq\b\u0001B\u0001B\u0003%\u0001IR\u0001\rgR|'/Y4f\u0019\u00164X\r\u001c\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\u001a\tqa\u001d;pe\u0006<W-\u0003\u0002F\u0005\na1\u000b^8sC\u001e,G*\u001a<fY&\u0011q(\u0005\u0005\u0006\u0011\u0002!\t!S\u0001\u0007y%t\u0017\u000e\u001e \u0015\t)cUJ\u0014\t\u0003\u0017\u0002i\u0011A\u0001\u0005\u0006=\u001d\u0003\r\u0001\t\u0005\u0006O\u001d\u0003\r\u0001\u000b\u0005\u0006\u007f\u001d\u0003\r\u0001\u0011\u0005\u0006!\u0002!\t!U\u0001\b_:\u001cF/\u0019:u)\u0005\u0011\u0006C\u0001\u001dT\u0013\t!&G\u0001\u0003V]&$\b\"\u0002,\u0001\t\u0003\t\u0016AB8o'R|\u0007\u000fC\u0003Y\u0001\u0011%\u0011,\u0001\ttKR$v/\u001b;uKJ\u001cFO]3b[R\u0011!K\u0017\u0005\u00067^\u0003\r\u0001X\u0001\u0011]\u0016<Hk^5ui\u0016\u00148\u000b\u001e:fC6\u0004\"\u0001F/\n\u0005y+\"!\u0004+xSR$XM]*ue\u0016\fW\u000eC\u0005a\u0001\u0001\u0007\t\u0019!C\u0005C\u0006iAo^5ui\u0016\u00148\u000b\u001e:fC6,\u0012\u0001\u0018\u0005\nG\u0002\u0001\r\u00111A\u0005\n\u0011\f\u0011\u0003^<jiR,'o\u0015;sK\u0006lw\fJ3r)\t\u0011V\rC\u0004gE\u0006\u0005\t\u0019\u0001/\u0002\u0007a$\u0013\u0007\u0003\u0004i\u0001\u0001\u0006K\u0001X\u0001\u000fi^LG\u000f^3s'R\u0014X-Y7!Q\t9'\u000e\u0005\u00029W&\u0011AN\r\u0002\tm>d\u0017\r^5mK\"9a\u000e\u0001a\u0001\n\u0013y\u0017aB:u_B\u0004X\rZ\u000b\u0002aB\u0011\u0001(]\u0005\u0003eJ\u0012qAQ8pY\u0016\fg\u000eC\u0004u\u0001\u0001\u0007I\u0011B;\u0002\u0017M$x\u000e\u001d9fI~#S-\u001d\u000b\u0003%ZDqAZ:\u0002\u0002\u0003\u0007\u0001\u000f\u0003\u0004y\u0001\u0001\u0006K\u0001]\u0001\tgR|\u0007\u000f]3eA!\u0012qO\u001b")
public class TwitterReceiver
extends Receiver<Status>
implements Logging {
    private final Authorization twitterAuth;
    private final Seq<String> filters;
    private volatile TwitterStream twitterStream;
    private volatile boolean org$apache$spark$streaming$twitter$TwitterReceiver$$stopped;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private TwitterStream twitterStream() {
        return this.twitterStream;
    }

    private void twitterStream_$eq(TwitterStream x$1) {
        this.twitterStream = x$1;
    }

    public boolean org$apache$spark$streaming$twitter$TwitterReceiver$$stopped() {
        return this.org$apache$spark$streaming$twitter$TwitterReceiver$$stopped;
    }

    private void org$apache$spark$streaming$twitter$TwitterReceiver$$stopped_$eq(boolean x$1) {
        this.org$apache$spark$streaming$twitter$TwitterReceiver$$stopped = x$1;
    }

    public void onStart() {
        try {
            TwitterStream newTwitterStream = new TwitterStreamFactory().getInstance(this.twitterAuth);
            newTwitterStream.addListener(new StatusListener(this){
                private final /* synthetic */ TwitterReceiver $outer;

                public void onStatus(Status status) {
                    this.$outer.store(status);
                }

                public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
                }

                public void onTrackLimitationNotice(int i) {
                }

                public void onScrubGeo(long l, long l1) {
                }

                public void onStallWarning(StallWarning stallWarning) {
                }

                public void onException(Exception e) {
                    if (!this.$outer.org$apache$spark$streaming$twitter$TwitterReceiver$$stopped()) {
                        this.$outer.restart("Error receiving tweets", e);
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            FilterQuery query = new FilterQuery();
            if (this.filters.size() > 0) {
                query.track((String[])this.filters.toArray(ClassTag$.MODULE$.apply(String.class)));
                newTwitterStream.filter(query);
            } else {
                newTwitterStream.sample();
            }
            this.setTwitterStream(newTwitterStream);
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Twitter receiver started";
                }
            });
            this.org$apache$spark$streaming$twitter$TwitterReceiver$$stopped_$eq(false);
        }
        catch (Exception exception) {
            this.restart("Error starting Twitter stream", exception);
        }
    }

    public void onStop() {
        this.org$apache$spark$streaming$twitter$TwitterReceiver$$stopped_$eq(true);
        this.setTwitterStream(null);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Twitter receiver stopped";
            }
        });
    }

    private synchronized void setTwitterStream(TwitterStream newTwitterStream) {
        if (this.twitterStream() != null) {
            this.twitterStream().shutdown();
        }
        this.twitterStream_$eq(newTwitterStream);
    }

    public TwitterReceiver(Authorization twitterAuth, Seq<String> filters, StorageLevel storageLevel) {
        this.twitterAuth = twitterAuth;
        this.filters = filters;
        super(storageLevel);
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$twitter$TwitterReceiver$$stopped = false;
    }
}

