/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.clientlibrary.types.UserRecord;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.ProvisionedThroughputExceededException;
import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.kinesis.KinesisReadConfigurations;
import org.apache.spark.streaming.kinesis.SequenceNumberRange;
import org.apache.spark.util.NextIterator;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf!\u0002\u0010 \u0001}I\u0003\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011-\u0003!\u0011!Q\u0001\n1C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t5\u0002\u0011\t\u0011)A\u00057\"Aq\f\u0001B\u0001B\u0003%\u0001\rC\u0003d\u0001\u0011\u0005A\rC\u0004l\u0001\t\u0007I\u0011\u00027\t\rE\u0004\u0001\u0015!\u0003n\u0011\u001d\u0011\bA1A\u0005\nMDa\u0001\u001e\u0001!\u0002\u0013a\u0005bB;\u0001\u0005\u0004%Ia\u001d\u0005\u0007m\u0002\u0001\u000b\u0011\u0002'\t\u000f]\u0004!\u0019!C\u0005q\"1Q\u0010\u0001Q\u0001\neDqA \u0001A\u0002\u0013%q\u0010C\u0005\u0002\b\u0001\u0001\r\u0011\"\u0003\u0002\n!A\u0011Q\u0003\u0001!B\u0013\t\t\u0001\u0003\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0003t\u0011%\tI\u0002\u0001a\u0001\n\u0013\tY\u0002C\u0004\u0002 \u0001\u0001\u000b\u0015\u0002'\t\u0013\u0005\u0005\u0002\u00011A\u0005\n\u0005\r\u0002\"CA\u001c\u0001\u0001\u0007I\u0011BA\u001d\u0011!\ti\u0004\u0001Q!\n\u0005\u0015\u0002bBA \u0001\u0011E\u0013\u0011\t\u0005\b\u0003\u0007\u0002A\u0011KA#\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002n\u0001!I!a\u001c\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z\ta2*\u001b8fg&\u001c8+Z9vK:\u001cWMU1oO\u0016LE/\u001a:bi>\u0014(B\u0001\u0011\"\u0003\u001dY\u0017N\\3tSNT!AI\u0012\u0002\u0013M$(/Z1nS:<'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0014\u0007\u0001QS\bE\u0002,]Aj\u0011\u0001\f\u0006\u0003[\r\nA!\u001e;jY&\u0011q\u0006\f\u0002\r\u001d\u0016DH/\u0013;fe\u0006$xN\u001d\t\u0003cmj\u0011A\r\u0006\u0003gQ\nQ!\\8eK2T!\u0001I\u001b\u000b\u0005Y:\u0014\u0001C:feZL7-Z:\u000b\u0005aJ\u0014!C1nCj|g.Y<t\u0015\u0005Q\u0014aA2p[&\u0011AH\r\u0002\u0007%\u0016\u001cwN\u001d3\u0011\u0005y\nU\"A \u000b\u0005\u0001\u001b\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\t{$a\u0002'pO\u001eLgnZ\u0001\fGJ,G-\u001a8uS\u0006d7o\u0001\u0001\u0011\u0005\u0019KU\"A$\u000b\u0005!;\u0014\u0001B1vi\"L!AS$\u0003\u001d\u0005;6k\u0011:fI\u0016tG/[1mg\u0006YQM\u001c3q_&tG/\u0016:m!\tieK\u0004\u0002O)B\u0011qJU\u0007\u0002!*\u0011\u0011\u000bR\u0001\u0007yI|w\u000e\u001e \u000b\u0003M\u000bQa]2bY\u0006L!!\u0016*\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+J\u000b\u0001B]3hS>t\u0017\nZ\u0001\u0006e\u0006tw-\u001a\t\u00039vk\u0011aH\u0005\u0003=~\u00111cU3rk\u0016t7-\u001a(v[\n,'OU1oO\u0016\f!c[5oKNL7OU3bI\u000e{gNZ5hgB\u0011A,Y\u0005\u0003E~\u0011\u0011dS5oKNL7OU3bI\u000e{gNZ5hkJ\fG/[8og\u00061A(\u001b8jiz\"b!\u001a4hQ&T\u0007C\u0001/\u0001\u0011\u0015\u0019e\u00011\u0001F\u0011\u0015Ye\u00011\u0001M\u0011\u0015If\u00011\u0001M\u0011\u0015Qf\u00011\u0001\\\u0011\u0015yf\u00011\u0001a\u0003\u0019\u0019G.[3oiV\tQ\u000e\u0005\u0002o_6\tA'\u0003\u0002qi\t\u0019\u0012)\\1{_:\\\u0015N\\3tSN\u001cE.[3oi\u000691\r\\5f]R\u0004\u0013AC:ue\u0016\fWNT1nKV\tA*A\u0006tiJ,\u0017-\u001c(b[\u0016\u0004\u0013aB:iCJ$\u0017\nZ\u0001\tg\"\f'\u000fZ%eA\u0005\u0011R.\u0019=HKR\u0014VmY8sINd\u0015.\\5u+\u0005I\bC\u0001>|\u001b\u0005\u0011\u0016B\u0001?S\u0005\rIe\u000e^\u0001\u0014[\u0006Dx)\u001a;SK\u000e|'\u000fZ:MS6LG\u000fI\u0001\u0014i>\u001cV-\u001d(v[\n,'OU3dK&4X\rZ\u000b\u0003\u0003\u0003\u00012A_A\u0002\u0013\r\t)A\u0015\u0002\b\u0005>|G.Z1o\u0003]!xnU3r\u001dVl'-\u001a:SK\u000e,\u0017N^3e?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005E\u0001c\u0001>\u0002\u000e%\u0019\u0011q\u0002*\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003'\u0001\u0012\u0011!a\u0001\u0003\u0003\t1\u0001\u001f\u00132\u0003Q!xnU3r\u001dVl'-\u001a:SK\u000e,\u0017N^3eA\u0005iA.Y:u'\u0016\fh*^7cKJ\f\u0011\u0003\\1tiN+\u0017OT;nE\u0016\u0014x\fJ3r)\u0011\tY!!\b\t\u0011\u0005M1#!AA\u00021\u000ba\u0002\\1tiN+\u0017OT;nE\u0016\u0014\b%\u0001\tj]R,'O\\1m\u0013R,'/\u0019;peV\u0011\u0011Q\u0005\t\u0006\u0003O\t\t\u0004\r\b\u0005\u0003S\tiCD\u0002P\u0003WI\u0011aU\u0005\u0004\u0003_\u0011\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003g\t)D\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\tyCU\u0001\u0015S:$XM\u001d8bY&#XM]1u_J|F%Z9\u0015\t\u0005-\u00111\b\u0005\n\u0003'1\u0012\u0011!a\u0001\u0003K\t\u0011#\u001b8uKJt\u0017\r\\%uKJ\fGo\u001c:!\u0003\u001d9W\r\u001e(fqR$\u0012\u0001M\u0001\u0006G2|7/\u001a\u000b\u0003\u0003\u0017\t!bZ3u%\u0016\u001cwN\u001d3t)!\t)#a\u0013\u0002V\u0005e\u0003bBA'5\u0001\u0007\u0011qJ\u0001\rSR,'/\u0019;peRK\b/\u001a\t\u0004c\u0005E\u0013bAA*e\t\t2\u000b[1sI&#XM]1u_J$\u0016\u0010]3\t\r\u0005]#\u00041\u0001M\u0003\u0019\u0019X-\u001d(v[\"1\u00111\f\u000eA\u0002e\f1B]3d_J$7i\\;oi\u0006\u0001s-\u001a;SK\u000e|'\u000fZ:B]\u0012tU\r\u001f;LS:,7/[:Ji\u0016\u0014\u0018\r^8s)\u0019\t\t'a\u001a\u0002lA1!0a\u0019\u0002&1K1!!\u001aS\u0005\u0019!V\u000f\u001d7fe!1\u0011\u0011N\u000eA\u00021\u000bQb\u001d5be\u0012LE/\u001a:bi>\u0014\bBBA.7\u0001\u0007\u00110\u0001\nhKR\\\u0015N\\3tSNLE/\u001a:bi>\u0014H#\u0002'\u0002r\u0005M\u0004bBA'9\u0001\u0007\u0011q\n\u0005\u0007\u0003kb\u0002\u0019\u0001'\u0002\u001dM,\u0017/^3oG\u0016tU/\u001c2fe\u0006q!/\u001a;ss>\u0013H+[7f_V$X\u0003BA>\u0003\u0007#B!! \u0002 R!\u0011qPAK!\u0011\t\t)a!\r\u0001\u00119\u0011QQ\u000fC\u0002\u0005\u001d%!\u0001+\u0012\t\u0005%\u0015q\u0012\t\u0004u\u0006-\u0015bAAG%\n9aj\u001c;iS:<\u0007c\u0001>\u0002\u0012&\u0019\u00111\u0013*\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u0018v!\t\u0019AAM\u0003\u0011\u0011w\u000eZ=\u0011\u000bi\fY*a \n\u0007\u0005u%K\u0001\u0005=Eft\u0017-\\3?\u0011\u0019\t\t+\ba\u0001\u0019\u00069Q.Z:tC\u001e,\u0007")
public class KinesisSequenceRangeIterator
extends NextIterator<Record>
implements Logging {
    private final AWSCredentials credentials;
    private final SequenceNumberRange range;
    private final KinesisReadConfigurations kinesisReadConfigs;
    private final AmazonKinesisClient client;
    private final String streamName;
    private final String shardId;
    private final int maxGetRecordsLimit;
    private boolean toSeqNumberReceived;
    private String lastSeqNumber;
    private Iterator<Record> internalIterator;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AmazonKinesisClient client() {
        return this.client;
    }

    private String streamName() {
        return this.streamName;
    }

    private String shardId() {
        return this.shardId;
    }

    private int maxGetRecordsLimit() {
        return this.maxGetRecordsLimit;
    }

    private boolean toSeqNumberReceived() {
        return this.toSeqNumberReceived;
    }

    private void toSeqNumberReceived_$eq(boolean x$1) {
        this.toSeqNumberReceived = x$1;
    }

    private String lastSeqNumber() {
        return this.lastSeqNumber;
    }

    private void lastSeqNumber_$eq(String x$1) {
        this.lastSeqNumber = x$1;
    }

    private Iterator<Record> internalIterator() {
        return this.internalIterator;
    }

    private void internalIterator_$eq(Iterator<Record> x$1) {
        this.internalIterator = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public Record getNext() {
        void var1_1;
        block5: {
            Record nextRecord;
            block4: {
                nextRecord = null;
                if (!this.toSeqNumberReceived()) break block4;
                this.finished_$eq(true);
                break block5;
            }
            if (this.internalIterator() == null) {
                this.internalIterator_$eq(this.getRecords(ShardIteratorType.AT_SEQUENCE_NUMBER, this.range.fromSeqNumber(), this.range.recordCount()));
            } else if (!this.internalIterator().hasNext()) {
                this.internalIterator_$eq(this.getRecords(ShardIteratorType.AFTER_SEQUENCE_NUMBER, this.lastSeqNumber(), this.range.recordCount()));
            }
            if (!this.internalIterator().hasNext()) {
                this.finished_$eq(true);
                throw new SparkException(new StringBuilder(59).append("Could not read until the end sequence number of the range: ").append(this.range).toString());
            }
            nextRecord = (Record)this.internalIterator().next();
            this.lastSeqNumber_$eq(nextRecord.getSequenceNumber());
            String string = nextRecord.getSequenceNumber();
            String string2 = this.range.toSeqNumber();
            if (string != null ? !string.equals(string2) : string2 != null) break block5;
            this.toSeqNumberReceived_$eq(true);
        }
        return var1_1;
    }

    public void close() {
        this.client().shutdown();
    }

    private Iterator<Record> getRecords(ShardIteratorType iteratorType, String seqNum, int recordCount) {
        String shardIterator = this.getKinesisIterator(iteratorType, seqNum);
        Tuple2<Iterator<Record>, String> result = this.getRecordsAndNextKinesisIterator(shardIterator, recordCount);
        return (Iterator)result._1();
    }

    private Tuple2<Iterator<Record>, String> getRecordsAndNextKinesisIterator(String shardIterator, int recordCount) {
        GetRecordsRequest getRecordsRequest = new GetRecordsRequest();
        getRecordsRequest.setRequestCredentials(this.credentials);
        getRecordsRequest.setShardIterator(shardIterator);
        getRecordsRequest.setLimit(Predef$.MODULE$.int2Integer(Math.min(recordCount, this.maxGetRecordsLimit())));
        GetRecordsResult getRecordsResult = (GetRecordsResult)this.retryOrTimeout("getting records using shard iterator", (Function0 & Serializable & scala.Serializable)() -> this.client().getRecords(getRecordsRequest));
        List recordIterator = UserRecord.deaggregate((List)getRecordsResult.getRecords());
        return new Tuple2(JavaConverters$.MODULE$.asScalaIteratorConverter(recordIterator.iterator()).asScala(), (Object)getRecordsResult.getNextShardIterator());
    }

    private String getKinesisIterator(ShardIteratorType iteratorType, String sequenceNumber) {
        GetShardIteratorRequest getShardIteratorRequest = new GetShardIteratorRequest();
        getShardIteratorRequest.setRequestCredentials(this.credentials);
        getShardIteratorRequest.setStreamName(this.streamName());
        getShardIteratorRequest.setShardId(this.shardId());
        getShardIteratorRequest.setShardIteratorType(iteratorType.toString());
        getShardIteratorRequest.setStartingSequenceNumber(sequenceNumber);
        GetShardIteratorResult getShardIteratorResult = (GetShardIteratorResult)this.retryOrTimeout(new StringBuilder(44).append("getting shard iterator from sequence number ").append(sequenceNumber).toString(), (Function0 & Serializable & scala.Serializable)() -> this.client().getShardIterator(getShardIteratorRequest));
        return getShardIteratorResult.getShardIterator();
    }

    private <T> T retryOrTimeout(String message, Function0<T> body) {
        long startTimeNs = System.nanoTime();
        IntRef retryCount = IntRef.create((int)0);
        None$ result = None$.MODULE$;
        ObjectRef lastError = ObjectRef.create(null);
        long waitTimeInterval = this.kinesisReadConfigs.retryWaitTimeMs();
        while (result.isEmpty() && !this.isTimedOut$1(startTimeNs) && !this.isMaxRetryDone$1(retryCount)) {
            if (retryCount.elem > 0) {
                Thread.sleep(waitTimeInterval);
                waitTimeInterval *= 2L;
            }
            try {
                result = new Some(body.apply());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    lastError.elem = t;
                    Throwable throwable3 = t;
                    if (!(throwable3 instanceof ProvisionedThroughputExceededException)) {
                        if (throwable3 != null) {
                            Throwable throwable4 = throwable3;
                            throw new SparkException(new StringBuilder(12).append("Error while ").append(message).toString(), throwable4);
                        }
                        throw new MatchError((Object)throwable3);
                    }
                    ProvisionedThroughputExceededException provisionedThroughputExceededException = (ProvisionedThroughputExceededException)throwable3;
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Error while ").append(message).append(" [attempt = ").append(retryCount$1.elem + 1).append("]").toString(), (Throwable)provisionedThroughputExceededException);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            ++retryCount.elem;
        }
        return (T)result.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (this.isTimedOut$1(startTimeNs)) {
                throw new SparkException(new StringBuilder(44).append("Timed out after ").append($this.kinesisReadConfigs.retryTimeoutMs()).append(" ms while ").append(message).append(", last exception: ").toString(), (Throwable)lastError$1.elem);
            }
            throw new SparkException(new StringBuilder(47).append("Gave up after ").append(retryCount$1.elem).append(" retries while ").append(message).append(", last exception: ").toString(), (Throwable)lastError$1.elem);
        });
    }

    private final boolean isTimedOut$1(long startTimeNs$1) {
        long retryTimeoutNs = TimeUnit.MILLISECONDS.toNanos(this.kinesisReadConfigs.retryTimeoutMs());
        return System.nanoTime() - startTimeNs$1 >= retryTimeoutNs;
    }

    private final boolean isMaxRetryDone$1(IntRef retryCount$1) {
        return retryCount$1.elem >= this.kinesisReadConfigs.maxRetries();
    }

    public KinesisSequenceRangeIterator(AWSCredentials credentials, String endpointUrl, String regionId, SequenceNumberRange range, KinesisReadConfigurations kinesisReadConfigs) {
        this.credentials = credentials;
        this.range = range;
        this.kinesisReadConfigs = kinesisReadConfigs;
        Logging.$init$((Logging)this);
        this.client = new AmazonKinesisClient(credentials);
        this.streamName = range.streamName();
        this.shardId = range.shardId();
        this.maxGetRecordsLimit = 10000;
        this.toSeqNumberReceived = false;
        this.lastSeqNumber = null;
        this.internalIterator = null;
        this.client().setEndpoint(endpointUrl);
    }
}

