/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kinesis.BasicCredentials;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisInputDStream;
import org.apache.spark.streaming.kinesis.KinesisInputDStream$;
import org.apache.spark.streaming.kinesis.STSCredentials;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001}3Aa\u0001\u0003\u0005\u001f!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00017\tA2*\u001b8fg&\u001cX\u000b^5mgBKH\u000f[8o\u0011\u0016d\u0007/\u001a:\u000b\u0005\u00151\u0011aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003\u000f!\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\r\u0011\u0005e\u0001Q\"\u0001\u0003\u0002\u0019\r\u0014X-\u0019;f'R\u0014X-Y7\u0015\u001dqQs\u0006\u0010 A\u0005\u001ekUkV-\\;B\u0019QD\t\u0013\u000e\u0003yQ!a\b\u0011\u0002\t)\fg/\u0019\u0006\u0003C\u0019\t1!\u00199j\u0013\t\u0019cD\u0001\rKCZ\f'+Z2fSZ,'/\u00138qkR$5\u000b\u001e:fC6\u00042!E\u0013(\u0013\t1#CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0012Q%\u0011\u0011F\u0005\u0002\u0005\u0005f$X\rC\u0003,\u0005\u0001\u0007A&\u0001\u0003kgN\u001c\u0007CA\u000f.\u0013\tqcD\u0001\u000bKCZ\f7\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010\u001e\u0005\u0006a\t\u0001\r!M\u0001\u000fW&tWm]5t\u0003B\u0004h*Y7f!\t\u0011\u0014H\u0004\u00024oA\u0011AGE\u0007\u0002k)\u0011aGD\u0001\u0007yI|w\u000e\u001e \n\u0005a\u0012\u0012A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001\u000f\n\t\u000bu\u0012\u0001\u0019A\u0019\u0002\u0015M$(/Z1n\u001d\u0006lW\rC\u0003@\u0005\u0001\u0007\u0011'A\u0006f]\u0012\u0004x.\u001b8u+Jd\u0007\"B!\u0003\u0001\u0004\t\u0014A\u0003:fO&|gNT1nK\")1I\u0001a\u0001\t\u00069\u0012N\\5uS\u0006d\u0007k\\:ji&|g.\u00138TiJ,\u0017-\u001c\t\u0003#\u0015K!A\u0012\n\u0003\u0007%sG\u000fC\u0003I\u0005\u0001\u0007\u0011*\u0001\ndQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006d\u0007C\u0001&L\u001b\u00051\u0011B\u0001'\u0007\u0005!!UO]1uS>t\u0007\"\u0002(\u0003\u0001\u0004y\u0015\u0001D:u_J\fw-\u001a'fm\u0016d\u0007C\u0001)T\u001b\u0005\t&B\u0001*\t\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001V)\u0003\u0019M#xN]1hK2+g/\u001a7\t\u000bY\u0013\u0001\u0019A\u0019\u0002\u001d\u0005<8/Q2dKN\u001c8*Z=JI\")\u0001L\u0001a\u0001c\u0005a\u0011m^:TK\u000e\u0014X\r^&fs\")!L\u0001a\u0001c\u0005\u00012\u000f^:BgN,X.\u001a*pY\u0016\f%O\u001c\u0005\u00069\n\u0001\r!M\u0001\u000fgR\u001c8+Z:tS>tg*Y7f\u0011\u0015q&\u00011\u00012\u00035\u0019Ho]#yi\u0016\u0014h.\u00197JI\u0002")
public class KinesisUtilsPythonHelper {
    public JavaReceiverInputDStream<byte[]> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, int initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, String awsAccessKeyId, String awsSecretKey, String stsAssumeRoleArn, String stsSessionName, String stsExternalId) {
        JavaReceiverInputDStream javaReceiverInputDStream;
        InitialPositionInStream initialPositionInStream2;
        if (!(stsAssumeRoleArn != null && stsSessionName != null && stsExternalId != null || stsAssumeRoleArn == null && stsSessionName == null && stsExternalId == null)) {
            throw new IllegalArgumentException("stsAssumeRoleArn, stsSessionName, and stsExtenalId must all be defined or all be null");
        }
        if (awsAccessKeyId == null && awsSecretKey != null) {
            throw new IllegalArgumentException("awsSecretKey is set but awsAccessKeyId is null");
        }
        if (awsAccessKeyId != null && awsSecretKey == null) {
            throw new IllegalArgumentException("awsAccessKeyId is set but awsSecretKey is null");
        }
        int n = initialPositionInStream;
        switch (n) {
            case 0: {
                initialPositionInStream2 = InitialPositionInStream.LATEST;
                break;
            }
            case 1: {
                initialPositionInStream2 = InitialPositionInStream.TRIM_HORIZON;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal InitialPositionInStream. Please use InitialPositionInStream.LATEST or InitialPositionInStream.TRIM_HORIZON");
            }
        }
        InitialPositionInStream kinesisInitialPosition = initialPositionInStream2;
        KinesisInputDStream.Builder builder = KinesisInputDStream$.MODULE$.builder().streamingContext(jssc).checkpointAppName(kinesisAppName).streamName(streamName).endpointUrl(endpointUrl).regionName(regionName).initialPosition(KinesisInitialPositions.fromKinesisInitialPosition(kinesisInitialPosition)).checkpointInterval(checkpointInterval).storageLevel(storageLevel);
        if (stsAssumeRoleArn != null && stsSessionName != null && stsExternalId != null) {
            STSCredentials kinesisCredsProvider = new STSCredentials(stsAssumeRoleArn, stsSessionName, (Option<String>)Option$.MODULE$.apply((Object)stsExternalId), new BasicCredentials(awsAccessKeyId, awsSecretKey));
            javaReceiverInputDStream = JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(builder.kinesisCredentials(kinesisCredsProvider).buildWithMessageHandler((Function1 & Serializable & scala.Serializable)record -> KinesisInputDStream$.MODULE$.defaultMessageHandler((Record)record), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        } else {
            javaReceiverInputDStream = awsAccessKeyId == null && awsSecretKey == null ? JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(builder.build(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))) : JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(builder.kinesisCredentials(new BasicCredentials(awsAccessKeyId, awsSecretKey)).build(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        }
        return javaReceiverInputDStream;
    }
}

