/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.Record;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kinesis.BasicCredentials;
import org.apache.spark.streaming.kinesis.DefaultCredentials$;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisInputDStream;
import org.apache.spark.streaming.kinesis.KinesisInputDStream$;
import org.apache.spark.streaming.kinesis.STSCredentials;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class KinesisUtils$ {
    public static final KinesisUtils$ MODULE$;

    static {
        new KinesisUtils$();
    }

    public <T> ReceiverInputDStream<T> createStream(StreamingContext ssc, String kinesisAppName, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, ClassTag<T> evidence$1) {
        Function1 cleanedHandler = (Function1)ssc.sc().clean(messageHandler, ssc.sc().clean$default$2());
        return (ReceiverInputDStream)ssc.withNamedScope("kinesis stream", (Function0)new Serializable(ssc, kinesisAppName, streamName2, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, evidence$1, cleanedHandler){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$1;
            private final String kinesisAppName$1;
            private final String streamName$1;
            private final String endpointUrl$1;
            private final String regionName$1;
            private final InitialPositionInStream initialPositionInStream$1;
            private final Duration checkpointInterval$1;
            private final StorageLevel storageLevel$1;
            private final ClassTag evidence$1$1;
            private final Function1 cleanedHandler$1;

            public final KinesisInputDStream<T> apply() {
                return new KinesisInputDStream<T>(this.ssc$1, this.streamName$1, this.endpointUrl$1, KinesisUtils$.MODULE$.org$apache$spark$streaming$kinesis$KinesisUtils$$validateRegion(this.regionName$1), KinesisInitialPositions.fromKinesisInitialPosition(this.initialPositionInStream$1), this.kinesisAppName$1, this.checkpointInterval$1, this.storageLevel$1, this.cleanedHandler$1, DefaultCredentials$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, this.evidence$1$1);
            }
            {
                this.ssc$1 = ssc$1;
                this.kinesisAppName$1 = kinesisAppName$1;
                this.streamName$1 = streamName$1;
                this.endpointUrl$1 = endpointUrl$1;
                this.regionName$1 = regionName$1;
                this.initialPositionInStream$1 = initialPositionInStream$1;
                this.checkpointInterval$1 = checkpointInterval$1;
                this.storageLevel$1 = storageLevel$1;
                this.evidence$1$1 = evidence$1$1;
                this.cleanedHandler$1 = cleanedHandler$1;
            }
        });
    }

    public <T> ReceiverInputDStream<T> createStream(StreamingContext ssc, String kinesisAppName, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, String awsAccessKeyId, String awsSecretKey, ClassTag<T> evidence$2) {
        Function1 cleanedHandler = (Function1)ssc.sc().clean(messageHandler, ssc.sc().clean$default$2());
        return (ReceiverInputDStream)ssc.withNamedScope("kinesis stream", (Function0)new Serializable(ssc, kinesisAppName, streamName2, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, awsAccessKeyId, awsSecretKey, evidence$2, cleanedHandler){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$2;
            private final String kinesisAppName$2;
            private final String streamName$2;
            private final String endpointUrl$2;
            private final String regionName$3;
            private final InitialPositionInStream initialPositionInStream$2;
            private final Duration checkpointInterval$2;
            private final StorageLevel storageLevel$2;
            private final String awsAccessKeyId$1;
            private final String awsSecretKey$1;
            private final ClassTag evidence$2$1;
            private final Function1 cleanedHandler$2;

            public final KinesisInputDStream<T> apply() {
                BasicCredentials kinesisCredsProvider = new BasicCredentials(this.awsAccessKeyId$1, this.awsSecretKey$1);
                return new KinesisInputDStream<T>(this.ssc$2, this.streamName$2, this.endpointUrl$2, KinesisUtils$.MODULE$.org$apache$spark$streaming$kinesis$KinesisUtils$$validateRegion(this.regionName$3), KinesisInitialPositions.fromKinesisInitialPosition(this.initialPositionInStream$2), this.kinesisAppName$2, this.checkpointInterval$2, this.storageLevel$2, this.cleanedHandler$2, kinesisCredsProvider, (Option<SparkAWSCredentials>)None$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, this.evidence$2$1);
            }
            {
                this.ssc$2 = ssc$2;
                this.kinesisAppName$2 = kinesisAppName$2;
                this.streamName$2 = streamName$2;
                this.endpointUrl$2 = endpointUrl$2;
                this.regionName$3 = regionName$3;
                this.initialPositionInStream$2 = initialPositionInStream$2;
                this.checkpointInterval$2 = checkpointInterval$2;
                this.storageLevel$2 = storageLevel$2;
                this.awsAccessKeyId$1 = awsAccessKeyId$1;
                this.awsSecretKey$1 = awsSecretKey$1;
                this.evidence$2$1 = evidence$2$1;
                this.cleanedHandler$2 = cleanedHandler$2;
            }
        });
    }

    public <T> ReceiverInputDStream<T> createStream(StreamingContext ssc, String kinesisAppName, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, String awsAccessKeyId, String awsSecretKey, String stsAssumeRoleArn, String stsSessionName, String stsExternalId, ClassTag<T> evidence$3) {
        Function1 cleanedHandler = (Function1)ssc.sc().clean(messageHandler, ssc.sc().clean$default$2());
        return (ReceiverInputDStream)ssc.withNamedScope("kinesis stream", (Function0)new Serializable(ssc, kinesisAppName, streamName2, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, awsAccessKeyId, awsSecretKey, stsAssumeRoleArn, stsSessionName, stsExternalId, evidence$3, cleanedHandler){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$3;
            private final String kinesisAppName$3;
            private final String streamName$3;
            private final String endpointUrl$3;
            private final String regionName$4;
            private final InitialPositionInStream initialPositionInStream$3;
            private final Duration checkpointInterval$3;
            private final StorageLevel storageLevel$3;
            private final String awsAccessKeyId$2;
            private final String awsSecretKey$2;
            private final String stsAssumeRoleArn$1;
            private final String stsSessionName$1;
            private final String stsExternalId$1;
            private final ClassTag evidence$3$1;
            private final Function1 cleanedHandler$3;

            public final KinesisInputDStream<T> apply() {
                STSCredentials kinesisCredsProvider = new STSCredentials(this.stsAssumeRoleArn$1, this.stsSessionName$1, (Option<String>)Option$.MODULE$.apply((Object)this.stsExternalId$1), new BasicCredentials(this.awsAccessKeyId$2, this.awsSecretKey$2));
                return new KinesisInputDStream<T>(this.ssc$3, this.streamName$3, this.endpointUrl$3, KinesisUtils$.MODULE$.org$apache$spark$streaming$kinesis$KinesisUtils$$validateRegion(this.regionName$4), KinesisInitialPositions.fromKinesisInitialPosition(this.initialPositionInStream$3), this.kinesisAppName$3, this.checkpointInterval$3, this.storageLevel$3, this.cleanedHandler$3, kinesisCredsProvider, (Option<SparkAWSCredentials>)None$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, this.evidence$3$1);
            }
            {
                this.ssc$3 = ssc$3;
                this.kinesisAppName$3 = kinesisAppName$3;
                this.streamName$3 = streamName$3;
                this.endpointUrl$3 = endpointUrl$3;
                this.regionName$4 = regionName$4;
                this.initialPositionInStream$3 = initialPositionInStream$3;
                this.checkpointInterval$3 = checkpointInterval$3;
                this.storageLevel$3 = storageLevel$3;
                this.awsAccessKeyId$2 = awsAccessKeyId$2;
                this.awsSecretKey$2 = awsSecretKey$2;
                this.stsAssumeRoleArn$1 = stsAssumeRoleArn$1;
                this.stsSessionName$1 = stsSessionName$1;
                this.stsExternalId$1 = stsExternalId$1;
                this.evidence$3$1 = evidence$3$1;
                this.cleanedHandler$3 = cleanedHandler$3;
            }
        });
    }

    public ReceiverInputDStream<byte[]> createStream(StreamingContext ssc, String kinesisAppName, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel) {
        return (ReceiverInputDStream)ssc.withNamedScope("kinesis stream", (Function0)new Serializable(ssc, kinesisAppName, streamName2, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$4;
            private final String kinesisAppName$4;
            private final String streamName$4;
            private final String endpointUrl$4;
            private final String regionName$5;
            private final InitialPositionInStream initialPositionInStream$4;
            private final Duration checkpointInterval$4;
            private final StorageLevel storageLevel$4;

            public final KinesisInputDStream<byte[]> apply() {
                return new KinesisInputDStream<byte[]>(this.ssc$4, this.streamName$4, this.endpointUrl$4, KinesisUtils$.MODULE$.org$apache$spark$streaming$kinesis$KinesisUtils$$validateRegion(this.regionName$5), KinesisInitialPositions.fromKinesisInitialPosition(this.initialPositionInStream$4), this.kinesisAppName$4, this.checkpointInterval$4, this.storageLevel$4, (Function1<Record, byte[]>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final byte[] apply(Record record) {
                        return KinesisInputDStream$.MODULE$.defaultMessageHandler(record);
                    }
                }, DefaultCredentials$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, (ClassTag<byte[]>)ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            }
            {
                this.ssc$4 = ssc$4;
                this.kinesisAppName$4 = kinesisAppName$4;
                this.streamName$4 = streamName$4;
                this.endpointUrl$4 = endpointUrl$4;
                this.regionName$5 = regionName$5;
                this.initialPositionInStream$4 = initialPositionInStream$4;
                this.checkpointInterval$4 = checkpointInterval$4;
                this.storageLevel$4 = storageLevel$4;
            }
        });
    }

    public ReceiverInputDStream<byte[]> createStream(StreamingContext ssc, String kinesisAppName, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, String awsAccessKeyId, String awsSecretKey) {
        return (ReceiverInputDStream)ssc.withNamedScope("kinesis stream", (Function0)new Serializable(ssc, kinesisAppName, streamName2, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, awsAccessKeyId, awsSecretKey){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$5;
            private final String kinesisAppName$5;
            private final String streamName$5;
            private final String endpointUrl$5;
            private final String regionName$6;
            private final InitialPositionInStream initialPositionInStream$5;
            private final Duration checkpointInterval$5;
            private final StorageLevel storageLevel$5;
            private final String awsAccessKeyId$3;
            private final String awsSecretKey$3;

            public final KinesisInputDStream<byte[]> apply() {
                BasicCredentials kinesisCredsProvider = new BasicCredentials(this.awsAccessKeyId$3, this.awsSecretKey$3);
                return new KinesisInputDStream<byte[]>(this.ssc$5, this.streamName$5, this.endpointUrl$5, KinesisUtils$.MODULE$.org$apache$spark$streaming$kinesis$KinesisUtils$$validateRegion(this.regionName$6), KinesisInitialPositions.fromKinesisInitialPosition(this.initialPositionInStream$5), this.kinesisAppName$5, this.checkpointInterval$5, this.storageLevel$5, (Function1<Record, byte[]>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final byte[] apply(Record record) {
                        return KinesisInputDStream$.MODULE$.defaultMessageHandler(record);
                    }
                }, kinesisCredsProvider, (Option<SparkAWSCredentials>)None$.MODULE$, (Option<SparkAWSCredentials>)None$.MODULE$, (ClassTag<byte[]>)ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            }
            {
                this.ssc$5 = ssc$5;
                this.kinesisAppName$5 = kinesisAppName$5;
                this.streamName$5 = streamName$5;
                this.endpointUrl$5 = endpointUrl$5;
                this.regionName$6 = regionName$6;
                this.initialPositionInStream$5 = initialPositionInStream$5;
                this.checkpointInterval$5 = checkpointInterval$5;
                this.storageLevel$5 = storageLevel$5;
                this.awsAccessKeyId$3 = awsAccessKeyId$3;
                this.awsSecretKey$3 = awsSecretKey$3;
            }
        });
    }

    public <T> JavaReceiverInputDStream<T> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, Function<Record, T> messageHandler, Class<T> recordClass) {
        ClassTag recordCmt = ClassTag$.MODULE$.apply(recordClass);
        SparkContext qual$1 = JavaSparkContext$.MODULE$.toSparkContext(jssc.sparkContext());
        Serializable x$8 = new Serializable(messageHandler){
            public static final long serialVersionUID = 0L;
            private final Function messageHandler$1;

            public final T apply(Record x$1) {
                return (T)this.messageHandler$1.call((Object)x$1);
            }
            {
                this.messageHandler$1 = messageHandler$1;
            }
        };
        boolean x$9 = qual$1.clean$default$2();
        Function1 cleanedHandler = (Function1)qual$1.clean((Object)x$8, x$9);
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), kinesisAppName, streamName2, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, cleanedHandler, recordCmt), recordCmt);
    }

    public <T> JavaReceiverInputDStream<T> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, Function<Record, T> messageHandler, Class<T> recordClass, String awsAccessKeyId, String awsSecretKey) {
        ClassTag recordCmt = ClassTag$.MODULE$.apply(recordClass);
        SparkContext qual$2 = JavaSparkContext$.MODULE$.toSparkContext(jssc.sparkContext());
        Serializable x$10 = new Serializable(messageHandler){
            public static final long serialVersionUID = 0L;
            private final Function messageHandler$3;

            public final T apply(Record x$2) {
                return (T)this.messageHandler$3.call((Object)x$2);
            }
            {
                this.messageHandler$3 = messageHandler$3;
            }
        };
        boolean x$11 = qual$2.clean$default$2();
        Function1 cleanedHandler = (Function1)qual$2.clean((Object)x$10, x$11);
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), kinesisAppName, streamName2, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, cleanedHandler, awsAccessKeyId, awsSecretKey, recordCmt), recordCmt);
    }

    public <T> JavaReceiverInputDStream<T> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, Function<Record, T> messageHandler, Class<T> recordClass, String awsAccessKeyId, String awsSecretKey, String stsAssumeRoleArn, String stsSessionName, String stsExternalId) {
        ClassTag recordCmt = ClassTag$.MODULE$.apply(recordClass);
        SparkContext qual$3 = JavaSparkContext$.MODULE$.toSparkContext(jssc.sparkContext());
        Serializable x$12 = new Serializable(messageHandler){
            public static final long serialVersionUID = 0L;
            private final Function messageHandler$2;

            public final T apply(Record x$3) {
                return (T)this.messageHandler$2.call((Object)x$3);
            }
            {
                this.messageHandler$2 = messageHandler$2;
            }
        };
        boolean x$13 = qual$3.clean$default$2();
        Function1 cleanedHandler = (Function1)qual$3.clean((Object)x$12, x$13);
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), kinesisAppName, streamName2, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, cleanedHandler, awsAccessKeyId, awsSecretKey, stsAssumeRoleArn, stsSessionName, stsExternalId, recordCmt), recordCmt);
    }

    public JavaReceiverInputDStream<byte[]> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), kinesisAppName, streamName2, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Record x$4) {
                return KinesisInputDStream$.MODULE$.defaultMessageHandler(x$4);
            }
        }, (ClassTag)ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public JavaReceiverInputDStream<byte[]> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, String awsAccessKeyId, String awsSecretKey) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), kinesisAppName, streamName2, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Record x$5) {
                return KinesisInputDStream$.MODULE$.defaultMessageHandler(x$5);
            }
        }, awsAccessKeyId, awsSecretKey, (ClassTag)ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public String org$apache$spark$streaming$kinesis$KinesisUtils$$validateRegion(String regionName) {
        return (String)Option$.MODULE$.apply((Object)RegionUtils.getRegion((String)regionName)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Region x$6) {
                return x$6.getName();
            }
        }).getOrElse((Function0)new Serializable(regionName){
            public static final long serialVersionUID = 0L;
            private final String regionName$2;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Region name '", "' is not valid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.regionName$2})));
            }
            {
                this.regionName$2 = regionName$2;
            }
        });
    }

    private KinesisUtils$() {
        MODULE$ = this;
    }
}

