/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.StreamDescription;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.spark.Logging;
import org.apache.spark.streaming.kinesis.KinesisTestUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u00055g!B\u0001\u0003\u0001\ta!\u0001E&j]\u0016\u001c\u0018n\u001d+fgR,F/\u001b7t\u0015\t\u0019A!A\u0004lS:,7/[:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\u000b\u000e\u0003\u0019I!A\u0006\u0004\u0003\u000f1{wmZ5oO\")\u0001\u0004\u0001C\u00015\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\u0002}\t1\"\u001a8ea>Lg\u000e^+sYV\t\u0001\u0005\u0005\u0002\"I9\u0011aBI\u0005\u0003G=\ta\u0001\u0015:fI\u00164\u0017BA\u0013'\u0005\u0019\u0019FO]5oO*\u00111e\u0004\u0005\u0007Q\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u0019\u0015tG\r]8j]R,&\u000f\u001c\u0011\t\u000f)\u0002!\u0019!C\u0001W\u0005Q!/Z4j_:t\u0015-\\3\u0016\u00031\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\t1\fgn\u001a\u0006\u0002c\u0005!!.\u0019<b\u0013\t)c\u0006\u0003\u00045\u0001\u0001\u0006I\u0001L\u0001\fe\u0016<\u0017n\u001c8OC6,\u0007\u0005C\u00047\u0001\t\u0007I\u0011A\u001c\u0002!M$(/Z1n'\"\f'\u000fZ\"pk:$X#\u0001\u001d\u0011\u00059I\u0014B\u0001\u001e\u0010\u0005\rIe\u000e\u001e\u0005\u0007y\u0001\u0001\u000b\u0011\u0002\u001d\u0002#M$(/Z1n'\"\f'\u000fZ\"pk:$\b\u0005C\u0004?\u0001\t\u0007I\u0011B\u001c\u00025\r\u0014X-\u0019;f'R\u0014X-Y7US6,w.\u001e;TK\u000e|g\u000eZ:\t\r\u0001\u0003\u0001\u0015!\u00039\u0003m\u0019'/Z1uKN#(/Z1n)&lWm\\;u'\u0016\u001cwN\u001c3tA!9!\t\u0001b\u0001\n\u00139\u0014!\b3fg\u000e\u0014\u0018NY3TiJ,\u0017-\u001c)pY2$\u0016.\\3TK\u000e|g\u000eZ:\t\r\u0011\u0003\u0001\u0015!\u00039\u0003y!Wm]2sS\n,7\u000b\u001e:fC6\u0004v\u000e\u001c7US6,7+Z2p]\u0012\u001c\b\u0005C\u0004G\u0001\u0001\u0007I\u0011B$\u0002\u001bM$(/Z1n\u0007J,\u0017\r^3e+\u0005A\u0005C\u0001\bJ\u0013\tQuBA\u0004C_>dW-\u00198\t\u000f1\u0003\u0001\u0019!C\u0005\u001b\u0006\t2\u000f\u001e:fC6\u001c%/Z1uK\u0012|F%Z9\u0015\u00059\u000b\u0006C\u0001\bP\u0013\t\u0001vB\u0001\u0003V]&$\bb\u0002*L\u0003\u0003\u0005\r\u0001S\u0001\u0004q\u0012\n\u0004B\u0002+\u0001A\u0003&\u0001*\u0001\btiJ,\u0017-\\\"sK\u0006$X\r\u001a\u0011)\u0005M3\u0006C\u0001\bX\u0013\tAvB\u0001\u0005w_2\fG/\u001b7f\u0011%Q\u0006\u00011AA\u0002\u0013%q$A\u0006`gR\u0014X-Y7OC6,\u0007\"\u0003/\u0001\u0001\u0004\u0005\r\u0011\"\u0003^\u0003=y6\u000f\u001e:fC6t\u0015-\\3`I\u0015\fHC\u0001(_\u0011\u001d\u00116,!AA\u0002\u0001Ba\u0001\u0019\u0001!B\u0013\u0001\u0013\u0001D0tiJ,\u0017-\u001c(b[\u0016\u0004\u0003FA0W\u0011!\u0019\u0007\u0001#b\u0001\n\u0013!\u0017!D6j]\u0016\u001c\u0018n]\"mS\u0016tG/F\u0001f!\t1g.D\u0001h\u0015\t\u0019\u0001N\u0003\u0002jU\u0006A1/\u001a:wS\u000e,7O\u0003\u0002lY\u0006I\u0011-\\1{_:\fwo\u001d\u0006\u0002[\u0006\u00191m\\7\n\u0005=<'aE!nCj|gnS5oKNL7o\u00117jK:$\b\u0002C9\u0001\u0011\u0003\u0005\u000b\u0015B3\u0002\u001d-Lg.Z:jg\u000ec\u0017.\u001a8uA!A1\u000f\u0001EC\u0002\u0013%A/\u0001\u0005es:\fWn\u001c#C+\u0005)\bC\u0001<|\u001b\u00059(B\u0001=z\u0003!!wnY;nK:$(B\u0001>i\u0003)!\u0017P\\1n_\u0012\u0014gOM\u0005\u0003y^\u0014\u0001\u0002R=oC6|GI\u0011\u0005\t}\u0002A\t\u0011)Q\u0005k\u0006IA-\u001f8b[>$%\t\t\u0005\u0007\u0003\u0003\u0001A\u0011A\u0010\u0002\u0015M$(/Z1n\u001d\u0006lW\rC\u0004\u0002\u0006\u0001!\t!a\u0002\u0002\u0019\r\u0014X-\u0019;f'R\u0014X-Y7\u0015\u00039Cq!a\u0003\u0001\t\u0003\ti!\u0001\u0005qkNDG)\u0019;b)\u0011\ty!a\r\u0011\r\u0005\n\t\u0002IA\u000b\u0013\r\t\u0019B\n\u0002\u0004\u001b\u0006\u0004\bCBA\f\u0003O\tiC\u0004\u0003\u0002\u001a\u0005\rb\u0002BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}\u0011$\u0001\u0004=e>|GOP\u0005\u0002!%\u0019\u0011QE\b\u0002\u000fA\f7m[1hK&!\u0011\u0011FA\u0016\u0005\r\u0019V-\u001d\u0006\u0004\u0003Ky\u0001#\u0002\b\u00020a\u0002\u0013bAA\u0019\u001f\t1A+\u001e9mKJB\u0001\"!\u000e\u0002\n\u0001\u0007\u0011qG\u0001\ti\u0016\u001cH\u000fR1uCB)\u0011qCA\u0014q!9\u00111\u0002\u0001\u0005\u0002\u0005mBc\u0001(\u0002>!A\u0011QGA\u001d\u0001\u0004\ty\u0004E\u0003\u0002B\u0005\u001d\u0003(\u0004\u0002\u0002D)\u0019\u0011Q\t\u0019\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0013\n\u0019E\u0001\u0003MSN$\bbBA'\u0001\u0011\u0005\u0011qA\u0001\rI\u0016dW\r^3TiJ,\u0017-\u001c\u0005\b\u0003#\u0002A\u0011AA*\u0003M!W\r\\3uK\u0012Kh.Y7p\t\n#\u0016M\u00197f)\rq\u0015Q\u000b\u0005\b\u0003/\ny\u00051\u0001!\u0003%!\u0018M\u00197f\u001d\u0006lW\rC\u0004\u0002\\\u0001!I!!\u0018\u0002\u001d\u0011,7o\u0019:jE\u0016\u001cFO]3b[R!\u0011qLA9!\u0015q\u0011\u0011MA3\u0013\r\t\u0019g\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001bh\u0003\u0015iw\u000eZ3m\u0013\u0011\ty'!\u001b\u0003#M#(/Z1n\t\u0016\u001c8M]5qi&|g\u000eC\u0004\u0002t\u0005e\u0003\u0019\u0001\u0011\u0002)M$(/Z1n\u001d\u0006lW\rV8EKN\u001c'/\u001b2f\u0011\u001d\t9\b\u0001C\u0005\u0003s\n\u0011DZ5oI:{g.\u0012=jgR,g\u000e^*ue\u0016\fWNT1nKR\t\u0001\u0005C\u0004\u0002~\u0001!I!a \u0002/]\f\u0017\u000e\u001e$peN#(/Z1n)>\u0014U-Q2uSZ,Gc\u0001(\u0002\u0002\"9\u00111QA>\u0001\u0004\u0001\u0013aE:ue\u0016\fWNT1nKR{w+Y5u\r>\u0014x\u0001CAD\u0005!\u0005!!!#\u0002!-Kg.Z:jgR+7\u000f^+uS2\u001c\bc\u0001\u000f\u0002\f\u001a9\u0011A\u0001E\u0001\u0005\u000555cAAF\u001b!9\u0001$a#\u0005\u0002\u0005EECAAE\u0011%\t)*a#C\u0002\u0013\u00051&\u0001\u000ef]Z4\u0016M\u001d(b[\u00164uN]#oC\nd\u0017N\\4UKN$8\u000f\u0003\u0005\u0002\u001a\u0006-\u0005\u0015!\u0003-\u0003m)gN\u001e,be:\u000bW.\u001a$pe\u0016s\u0017M\u00197j]\u001e$Vm\u001d;tA!I\u0011QTAF\u0005\u0004%\taK\u0001\u0016K:$g+\u0019:OC6,gi\u001c:F]\u0012\u0004x.\u001b8u\u0011!\t\t+a#!\u0002\u0013a\u0013AF3oIZ\u000b'OT1nK\u001a{'/\u00128ea>Lg\u000e\u001e\u0011\t\u0013\u0005\u0015\u00161\u0012b\u0001\n\u0003Y\u0013A\u00053fM\u0006,H\u000e^#oIB|\u0017N\u001c;Ve2D\u0001\"!+\u0002\f\u0002\u0006I\u0001L\u0001\u0014I\u00164\u0017-\u001e7u\u000b:$\u0007o\\5oiV\u0013H\u000e\t\u0005\u000b\u0003[\u000bY\t#b\u0001\n\u00039\u0015AD:i_VdGMU;o)\u0016\u001cHo\u001d\u0005\u000b\u0003c\u000bY\t#A!B\u0013A\u0015aD:i_VdGMU;o)\u0016\u001cHo\u001d\u0011\t\u0013y\tY\t#b\u0001\n\u0003y\u0002\"\u0003\u0015\u0002\f\"\u0005\t\u0015)\u0003!\u0011\u001d\tI,a#\u0005\u0002\u001d\u000bq#[:B/N\u001b%/\u001a3f]RL\u0017\r\\:Qe\u0016\u001cXM\u001c;\t\u0011\u0005u\u00161\u0012C\u0001\u0003\u007f\u000b\u0011cZ3u\u0003^\u001b6I]3eK:$\u0018.\u00197t)\t\t\t\r\u0005\u0003\u0002D\u0006%WBAAc\u0015\r\t9M[\u0001\u0005CV$\b.\u0003\u0003\u0002L\u0006\u0015'AD!X'\u000e\u0013X\rZ3oi&\fGn\u001d")
public class KinesisTestUtils
implements Logging {
    private final String endpointUrl;
    private final String regionName;
    private final int streamShardCount;
    private final int createStreamTimeoutSeconds;
    private final int describeStreamPollTimeSeconds;
    private volatile boolean streamCreated;
    private volatile String org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName;
    private AmazonKinesisClient org$apache$spark$streaming$kinesis$KinesisTestUtils$$kinesisClient;
    private DynamoDB dynamoDB;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile byte bitmap$0;

    public static AWSCredentials getAWSCredentials() {
        return KinesisTestUtils$.MODULE$.getAWSCredentials();
    }

    public static boolean isAWSCredentialsPresent() {
        return KinesisTestUtils$.MODULE$.isAWSCredentialsPresent();
    }

    public static boolean shouldRunTests() {
        return KinesisTestUtils$.MODULE$.shouldRunTests();
    }

    public static String defaultEndpointUrl() {
        return KinesisTestUtils$.MODULE$.defaultEndpointUrl();
    }

    public static String endVarNameForEndpoint() {
        return KinesisTestUtils$.MODULE$.endVarNameForEndpoint();
    }

    public static String envVarNameForEnablingTests() {
        return KinesisTestUtils$.MODULE$.envVarNameForEnablingTests();
    }

    /*
     * WARNING - void declaration
     */
    private AmazonKinesisClient org$apache$spark$streaming$kinesis$KinesisTestUtils$$kinesisClient$lzycompute() {
        KinesisTestUtils kinesisTestUtils = this;
        synchronized (kinesisTestUtils) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                AmazonKinesisClient client = new AmazonKinesisClient(KinesisTestUtils$.MODULE$.getAWSCredentials());
                client.setEndpoint(this.endpointUrl());
                this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$kinesisClient = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$kinesisClient;
        }
    }

    private DynamoDB dynamoDB$lzycompute() {
        KinesisTestUtils kinesisTestUtils = this;
        synchronized (kinesisTestUtils) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                AmazonDynamoDBClient dynamoDBClient = new AmazonDynamoDBClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
                dynamoDBClient.setRegion(RegionUtils.getRegion((String)this.regionName()));
                this.dynamoDB = new DynamoDB((AmazonDynamoDB)dynamoDBClient);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.dynamoDB;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public String regionName() {
        return this.regionName;
    }

    public int streamShardCount() {
        return this.streamShardCount;
    }

    private int createStreamTimeoutSeconds() {
        return this.createStreamTimeoutSeconds;
    }

    private int describeStreamPollTimeSeconds() {
        return this.describeStreamPollTimeSeconds;
    }

    private boolean streamCreated() {
        return this.streamCreated;
    }

    private void streamCreated_$eq(boolean x$1) {
        this.streamCreated = x$1;
    }

    public String org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName() {
        return this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName;
    }

    private void org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName_$eq(String x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName = x$1;
    }

    public AmazonKinesisClient org$apache$spark$streaming$kinesis$KinesisTestUtils$$kinesisClient() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$kinesisClient$lzycompute() : this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$kinesisClient;
    }

    private DynamoDB dynamoDB() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dynamoDB$lzycompute() : this.dynamoDB;
    }

    public String streamName() {
        Predef$.MODULE$.require(this.streamCreated(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stream not yet created, call createStream() to create one";
            }
        });
        return this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName();
    }

    public void createStream() {
        Predef$.MODULE$.require(!this.streamCreated(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stream already created";
            }
        });
        this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName_$eq(this.findNonExistentStreamName());
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisTestUtils $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating stream ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        CreateStreamRequest createStreamRequest = new CreateStreamRequest();
        createStreamRequest.setStreamName(this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName());
        createStreamRequest.setShardCount(Predef$.MODULE$.int2Integer(2));
        this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$kinesisClient().createStream(createStreamRequest);
        this.waitForStreamToBeActive(this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName());
        this.streamCreated_$eq(true);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisTestUtils $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created stream ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisTestUtils$$_streamName()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public Map<String, Seq<Tuple2<Object, String>>> pushData(Seq<Object> testData) {
        Predef$.MODULE$.require(this.streamCreated(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stream not yet created, call createStream() to create one";
            }
        });
        HashMap shardIdToSeqNumbers = new HashMap();
        testData.foreach((Function1)new Serializable(this, shardIdToSeqNumbers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisTestUtils $outer;
            private final HashMap shardIdToSeqNumbers$1;

            public final ArrayBuffer<Tuple2<Object, String>> apply(int num) {
                String str = ((Object)BoxesRunTime.boxToInteger((int)num)).toString();
                PutRecordRequest putRecordRequest = new PutRecordRequest().withStreamName(this.$outer.streamName()).withData(ByteBuffer.wrap(str.getBytes())).withPartitionKey(str);
                PutRecordResult putRecordResult = this.$outer.org$apache$spark$streaming$kinesis$KinesisTestUtils$$kinesisClient().putRecord(putRecordRequest);
                String shardId = putRecordResult.getShardId();
                String seqNumber = putRecordResult.getSequenceNumber();
                ArrayBuffer sentSeqNumbers = (ArrayBuffer)this.shardIdToSeqNumbers$1.getOrElseUpdate((Object)shardId, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayBuffer<Tuple2<Object, String>> apply() {
                        return new ArrayBuffer();
                    }
                });
                return sentSeqNumbers.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)num), (Object)seqNumber));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.shardIdToSeqNumbers$1 = shardIdToSeqNumbers$1;
            }
        });
        this.logInfo((Function0<String>)new Serializable(this, testData, shardIdToSeqNumbers){
            public static final long serialVersionUID = 0L;
            private final Seq testData$1;
            private final HashMap shardIdToSeqNumbers$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pushed ", ":\\n\\t ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.testData$1, this.shardIdToSeqNumbers$1.mkString("\n\t")}));
            }
            {
                this.testData$1 = testData$1;
                this.shardIdToSeqNumbers$1 = shardIdToSeqNumbers$1;
            }
        });
        return shardIdToSeqNumbers.toMap(Predef$.MODULE$.conforms());
    }

    public void pushData(List<Object> testData) {
        this.pushData((Seq<Object>)JavaConversions$.MODULE$.asScalaBuffer(testData));
    }

    public void deleteStream() {
        try {
            if (this.streamCreated()) {
                this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$kinesisClient().deleteStream(this.streamName());
            }
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KinesisTestUtils $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not delete stream ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.streamName()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public void deleteDynamoDBTable(String tableName) {
        try {
            Table table = this.dynamoDB().getTable(tableName);
            table.delete();
            table.waitForDelete();
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this, tableName){
                public static final long serialVersionUID = 0L;
                private final String tableName$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not delete DynamoDB table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$1}));
                }
                {
                    this.tableName$1 = tableName$1;
                }
            });
        }
    }

    private Option<StreamDescription> describeStream(String streamNameToDescribe) {
        None$ none$;
        try {
            DescribeStreamRequest describeStreamRequest = new DescribeStreamRequest().withStreamName(streamNameToDescribe);
            StreamDescription desc = this.org$apache$spark$streaming$kinesis$KinesisTestUtils$$kinesisClient().describeStream(describeStreamRequest).getStreamDescription();
            none$ = new Some((Object)desc);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    private String findNonExistentStreamName() {
        void var1_1;
        String testStreamName = null;
        do {
            Thread.sleep(TimeUnit.SECONDS.toMillis(this.describeStreamPollTimeSeconds()));
        } while (this.describeStream(testStreamName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KinesisTestUtils-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)package$.MODULE$.abs(Random$.MODULE$.nextLong()))}))).nonEmpty());
        return var1_1;
    }

    private void waitForStreamToBeActive(String streamNameToWaitFor) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Object object = new Object();
            try {
                long startTime = System.currentTimeMillis();
                long endTime = startTime + TimeUnit.SECONDS.toMillis(this.createStreamTimeoutSeconds());
                while (System.currentTimeMillis() < endTime) {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(this.describeStreamPollTimeSeconds()));
                    this.describeStream(streamNameToWaitFor).foreach((Function1)new Serializable(this, object){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KinesisTestUtils $outer;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(StreamDescription description) {
                            String streamStatus = description.getStreamStatus();
                            this.$outer.logDebug((Function0<String>)new Serializable(this, streamStatus){
                                public static final long serialVersionUID = 0L;
                                private final String streamStatus$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t- current state: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.streamStatus$1}));
                                }
                                {
                                    this.streamStatus$1 = streamStatus$1;
                                }
                            });
                            if ("ACTIVE".equals(streamStatus)) {
                                throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                }
                Predef$.MODULE$.require(false, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KinesisTestUtils $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stream ", " never became active"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.streamName()}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public KinesisTestUtils() {
        Logging.class.$init$((Logging)this);
        this.endpointUrl = KinesisTestUtils$.MODULE$.endpointUrl();
        this.regionName = RegionUtils.getRegionByEndpoint((String)this.endpointUrl()).getName();
        this.streamShardCount = 2;
        this.createStreamTimeoutSeconds = 300;
        this.describeStreamPollTimeSeconds = 1;
        this.streamCreated = false;
    }
}

