/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.types.ShutdownReason;
import com.amazonaws.services.kinesis.model.Record;
import java.util.List;
import org.apache.spark.Logging;
import org.apache.spark.streaming.kinesis.KinesisCheckpointState;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.streaming.kinesis.KinesisRecordProcessor$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc!B\u0001\u0003\u0001\ta!AF&j]\u0016\u001c\u0018n\u001d*fG>\u0014H\r\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005\r!\u0011aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cB\u0001A\u0007\u0016IA\u0011abE\u0007\u0002\u001f)\u0011\u0001#E\u0001\u0005Y\u0006twMC\u0001\u0013\u0003\u0011Q\u0017M^1\n\u0005Qy!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0017E5\tqC\u0003\u0002\u00193\u0005Q\u0011N\u001c;fe\u001a\f7-Z:\u000b\u0005iY\u0012!D2mS\u0016tG\u000f\\5ce\u0006\u0014\u0018P\u0003\u0002\u00049)\u0011QDH\u0001\tg\u0016\u0014h/[2fg*\u0011q\u0004I\u0001\nC6\f'p\u001c8boNT\u0011!I\u0001\u0004G>l\u0017BA\u0012\u0018\u0005AI%+Z2pe\u0012\u0004&o\\2fgN|'\u000f\u0005\u0002&M5\ta!\u0003\u0002(\r\t9Aj\\4hS:<\u0007\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u0011I,7-Z5wKJ\u001c\u0001\u0001\u0005\u0002-[5\t!!\u0003\u0002/\u0005\ty1*\u001b8fg&\u001c(+Z2fSZ,'\u000f\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0003!9xN]6fe&#\u0007C\u0001\u001a9\u001d\t\u0019d'D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]\"\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\u0002\u001f\rDWmY6q_&tGo\u0015;bi\u0016\u0004\"\u0001\f \n\u0005}\u0012!AF&j]\u0016\u001c\u0018n]\"iK\u000e\\\u0007o\\5oiN#\u0018\r^3\t\u000b\u0005\u0003A\u0011\u0001\"\u0002\rqJg.\u001b;?)\u0011\u0019E)\u0012$\u0011\u00051\u0002\u0001\"B\u0015A\u0001\u0004Y\u0003\"\u0002\u0019A\u0001\u0004\t\u0004\"\u0002\u001fA\u0001\u0004i\u0004\"\u0003%\u0001\u0001\u0004\u0005\r\u0011\"\u0003J\u0003\u001d\u0019\b.\u0019:e\u0013\u0012,\u0012!\r\u0005\n\u0017\u0002\u0001\r\u00111A\u0005\n1\u000b1b\u001d5be\u0012LEm\u0018\u0013fcR\u0011Q\n\u0015\t\u0003g9K!a\u0014\u001b\u0003\tUs\u0017\u000e\u001e\u0005\b#*\u000b\t\u00111\u00012\u0003\rAH%\r\u0005\u0007'\u0002\u0001\u000b\u0015B\u0019\u0002\u0011MD\u0017M\u001d3JI\u0002B#AU+\u0011\u0005M2\u0016BA,5\u0005!1x\u000e\\1uS2,\u0007\"B-\u0001\t\u0003R\u0016AC5oSRL\u0017\r\\5{KR\u0011Qj\u0017\u0005\u0006\u0011b\u0003\r!\r\u0005\u0006;\u0002!\tEX\u0001\u000faJ|7-Z:t%\u0016\u001cwN\u001d3t)\riu,\u001c\u0005\u0006Ar\u0003\r!Y\u0001\u0006E\u0006$8\r\u001b\t\u0004E\u0016<W\"A2\u000b\u0005\u0011\f\u0012\u0001B;uS2L!AZ2\u0003\t1K7\u000f\u001e\t\u0003Q.l\u0011!\u001b\u0006\u0003Un\tQ!\\8eK2L!\u0001\\5\u0003\rI+7m\u001c:e\u0011\u0015qG\f1\u0001p\u00031\u0019\u0007.Z2la>Lg\u000e^3s!\t1\u0002/\u0003\u0002r/\ta\u0012JU3d_J$\u0007K]8dKN\u001cxN]\"iK\u000e\\\u0007o\\5oi\u0016\u0014\b\"B:\u0001\t\u0003\"\u0018\u0001C:ikR$wn\u001e8\u0015\u00075+h\u000fC\u0003oe\u0002\u0007q\u000eC\u0003xe\u0002\u0007\u00010\u0001\u0004sK\u0006\u001cxN\u001c\t\u0003srl\u0011A\u001f\u0006\u0003wf\tQ\u0001^=qKNL!! >\u0003\u001dMCW\u000f\u001e3po:\u0014V-Y:p]\u001e9qP\u0001E\u0001\u0005\u0005\u0005\u0011AF&j]\u0016\u001c\u0018n\u001d*fG>\u0014H\r\u0015:pG\u0016\u001c8o\u001c:\u0011\u00071\n\u0019AB\u0004\u0002\u0005!\u0005!!!\u0002\u0014\u000b\u0005\r\u0011q\u0001\u0013\u0011\u0007M\nI!C\u0002\u0002\fQ\u0012a!\u00118z%\u00164\u0007bB!\u0002\u0004\u0011\u0005\u0011q\u0002\u000b\u0003\u0003\u0003A\u0001\"a\u0005\u0002\u0004\u0011\u0005\u0011QC\u0001\fe\u0016$(/\u001f*b]\u0012|W.\u0006\u0003\u0002\u0018\u0005uA\u0003CA\r\u0003_\tI$a\u0011\u0011\t\u0005m\u0011Q\u0004\u0007\u0001\t!\ty\"!\u0005C\u0002\u0005\u0005\"!\u0001+\u0012\t\u0005\r\u0012\u0011\u0006\t\u0004g\u0005\u0015\u0012bAA\u0014i\t9aj\u001c;iS:<\u0007cA\u001a\u0002,%\u0019\u0011Q\u0006\u001b\u0003\u0007\u0005s\u0017\u0010C\u0005\u00022\u0005EA\u00111\u0001\u00024\u0005QQ\r\u001f9sKN\u001c\u0018n\u001c8\u0011\u000bM\n)$!\u0007\n\u0007\u0005]BG\u0001\u0005=Eft\u0017-\\3?\u0011!\tY$!\u0005A\u0002\u0005u\u0012A\u00048v[J+GO]5fg2+g\r\u001e\t\u0004g\u0005}\u0012bAA!i\t\u0019\u0011J\u001c;\t\u0011\u0005\u0015\u0013\u0011\u0003a\u0001\u0003{\t\u0001#\\1y\u0005\u0006\u001c7n\u00144g\u001b&dG.[:)\t\u0005E\u0011\u0011\n\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011q\n\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002T\u00055#a\u0002;bS2\u0014Xm\u0019")
public class KinesisRecordProcessor
implements IRecordProcessor,
Logging {
    private final KinesisReceiver receiver;
    public final String org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId;
    public final KinesisCheckpointState org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$checkpointState;
    private volatile String org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$shardId;
    private transient Logger org$apache$spark$Logging$$log_;

    public static <T> T retryRandom(Function0<T> function0, int n, int n2) {
        return KinesisRecordProcessor$.MODULE$.retryRandom(function0, n, n2);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$shardId() {
        return this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$shardId;
    }

    private void org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$shardId_$eq(String x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$shardId = x$1;
    }

    public void initialize(String shardId) {
        this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$shardId_$eq(shardId);
        this.logInfo((Function0<String>)new Serializable(this, shardId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisRecordProcessor $outer;
            private final String shardId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialized workerId ", " with shardId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId, this.shardId$1}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.shardId$1 = shardId$1;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processRecords(List<Record> batch, IRecordProcessorCheckpointer checkpointer) {
        if (this.receiver.isStopped()) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KinesisRecordProcessor $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopped:  KinesisReceiver has stopped for workerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" and shardId ", ".  No more records will be processed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$shardId()}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        try {
            this.receiver.addRecords(this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$shardId(), batch);
            this.logDebug((Function0<String>)new Serializable(this, batch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KinesisRecordProcessor $outer;
                private final List batch$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stored: Worker ", " stored ", " records for shardId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId, BoxesRunTime.boxToInteger((int)this.batch$1.size()), this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$shardId()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.batch$1 = batch$1;
                }
            });
            if (!this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$checkpointState.shouldCheckpoint()) return;
            this.receiver.getLatestSeqNumToCheckpoint(this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$shardId()).foreach((Function1)new Serializable(this, batch, checkpointer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KinesisRecordProcessor $outer;
                public final List batch$1;
                public final IRecordProcessorCheckpointer checkpointer$1;

                public final void apply(String latestSeqNum) {
                    KinesisRecordProcessor$.MODULE$.retryRandom(new Serializable(this, latestSeqNum){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$processRecords$2 $outer;
                        private final String latestSeqNum$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.checkpointer$1.checkpoint(this.latestSeqNum$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.latestSeqNum$1 = latestSeqNum$1;
                        }
                    }, 4, 100);
                    this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$checkpointState.advanceCheckpoint();
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$processRecords$2 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint:  WorkerId ", " completed checkpoint of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$anonfun$$$outer().org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId, BoxesRunTime.boxToInteger((int)this.$outer.batch$1.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" records for shardId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$anonfun$$$outer().org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$shardId()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$processRecords$2 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint:  Next checkpoint is at "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " for shardId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$anonfun$$$outer().org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$checkpointState.checkpointClock().getTimeMillis()), this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$anonfun$$$outer().org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$shardId()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ KinesisRecordProcessor org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.batch$1 = batch$1;
                    this.checkpointer$1 = checkpointer$1;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KinesisRecordProcessor $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception:  WorkerId ", " encountered and exception while storing "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId}))).append((Object)" or checkpointing a batch for workerId $workerId and shardId $shardId.").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, e);
            throw e;
        }
    }

    public void shutdown(IRecordProcessorCheckpointer checkpointer, ShutdownReason reason) {
        this.logInfo((Function0<String>)new Serializable(this, reason){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisRecordProcessor $outer;
            private final ShutdownReason reason$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shutdown:  Shutting down workerId ", " with reason ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId, this.reason$1}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.reason$1 = reason$1;
            }
        });
        ShutdownReason shutdownReason = reason;
        ShutdownReason shutdownReason2 = ShutdownReason.TERMINATE;
        ShutdownReason shutdownReason3 = shutdownReason;
        if (!(shutdownReason2 != null ? !shutdownReason2.equals(shutdownReason3) : shutdownReason3 != null)) {
            Option<String> latestSeqNumToCheckpointOption = this.receiver.getLatestSeqNumToCheckpoint(this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$shardId());
            BoxedUnit boxedUnit = latestSeqNumToCheckpointOption.nonEmpty() ? (BoxedUnit)KinesisRecordProcessor$.MODULE$.retryRandom(new Serializable(this, checkpointer, latestSeqNumToCheckpointOption){
                public static final long serialVersionUID = 0L;
                private final IRecordProcessorCheckpointer checkpointer$2;
                private final Option latestSeqNumToCheckpointOption$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.checkpointer$2.checkpoint((String)this.latestSeqNumToCheckpointOption$1.get());
                }
                {
                    this.checkpointer$2 = checkpointer$2;
                    this.latestSeqNumToCheckpointOption$1 = latestSeqNumToCheckpointOption$1;
                }
            }, 4, 100) : BoxedUnit.UNIT;
        } else {
            ShutdownReason shutdownReason4 = ShutdownReason.ZOMBIE;
            ShutdownReason shutdownReason5 = shutdownReason;
            if (!(shutdownReason4 != null ? !shutdownReason4.equals(shutdownReason5) : shutdownReason5 != null)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public KinesisRecordProcessor(KinesisReceiver receiver, String workerId, KinesisCheckpointState checkpointState) {
        this.receiver = receiver;
        this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId = workerId;
        this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$checkpointState = checkpointState;
        Logging.class.$init$((Logging)this);
    }
}

