/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.examples.streaming.StreamingExamples;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kinesis.KinesisUtils;
import org.spark-project.guava.collect.Lists;
import scala.Tuple2;

public final class JavaKinesisWordCountASL {
    private static final Pattern WORD_SEPARATOR = Pattern.compile(" ");
    private static final Logger logger = Logger.getLogger(JavaKinesisWordCountASL.class);

    private JavaKinesisWordCountASL() {
    }

    public static void main(String[] args) {
        int numShards;
        if (args.length < 2) {
            System.err.println("Usage: JavaKinesisWordCountASL <stream-name> <endpoint-url>\n    <stream-name> is the name of the Kinesis stream\n    <endpoint-url> is the endpoint of the Kinesis service\n                   (e.g. https://kinesis.us-east-1.amazonaws.com)\n");
            System.exit(1);
        }
        StreamingExamples.setStreamingLogLevels();
        String streamName = args[0];
        String endpointUrl = args[1];
        Duration batchInterval = new Duration(2000L);
        AmazonKinesisClient kinesisClient = new AmazonKinesisClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
        kinesisClient.setEndpoint(endpointUrl);
        int numStreams = numShards = kinesisClient.describeStream(streamName).getStreamDescription().getShards().size();
        SparkConf sparkConfig = new SparkConf().setAppName("KinesisWordCount");
        Duration checkpointInterval = batchInterval;
        JavaStreamingContext jssc = new JavaStreamingContext(sparkConfig, batchInterval);
        ArrayList<JavaReceiverInputDStream<byte[]>> streamsList = new ArrayList<JavaReceiverInputDStream<byte[]>>(numStreams);
        for (int i = 0; i < numStreams; ++i) {
            streamsList.add(KinesisUtils.createStream(jssc, streamName, endpointUrl, checkpointInterval, InitialPositionInStream.LATEST, StorageLevel.MEMORY_AND_DISK_2()));
        }
        JavaDStream unionStreams = streamsList.size() > 1 ? jssc.union((JavaDStream)streamsList.get(0), streamsList.subList(1, streamsList.size())) : (JavaDStream)streamsList.get(0);
        JavaDStream words = unionStreams.flatMap((FlatMapFunction)new FlatMapFunction<byte[], String>(){

            public Iterable<String> call(byte[] line) {
                return Lists.newArrayList((Object[])WORD_SEPARATOR.split(new String(line)));
            }
        });
        JavaPairDStream wordCounts = words.mapToPair((PairFunction)new PairFunction<String, String, Integer>(){

            public Tuple2<String, Integer> call(String s) {
                return new Tuple2((Object)s, (Object)1);
            }
        }).reduceByKey((Function2)new Function2<Integer, Integer, Integer>(){

            public Integer call(Integer i1, Integer i2) {
                return i1 + i2;
            }
        });
        wordCounts.print();
        jssc.start();
        jssc.awaitTermination();
    }
}

