/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka.v09;

import java.util.Map;
import java.util.Set;
import kafka.common.TopicAndPartition;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SSLOptions;
import org.apache.spark.SSLOptions$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaInputDStream$;
import org.apache.spark.streaming.api.java.JavaPairInputDStream;
import org.apache.spark.streaming.api.java.JavaPairInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka.v09.DirectKafkaInputDStream;
import org.apache.spark.streaming.kafka.v09.KafkaCluster;
import org.apache.spark.streaming.kafka.v09.KafkaRDD;
import org.apache.spark.streaming.kafka.v09.KafkaUtils$;
import org.apache.spark.streaming.kafka.v09.OffsetRange;
import org.apache.spark.streaming.kafka.v09.OffsetRange$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class KafkaUtils$ {
    public static final KafkaUtils$ MODULE$;

    static {
        new KafkaUtils$();
    }

    public scala.collection.immutable.Map<String, String> addSSLOptions(scala.collection.immutable.Map<String, String> kafkaParams, SparkContext sc) {
        scala.collection.immutable.Map map;
        SSLOptions defaultSSLOptions;
        SparkConf sparkConf = sc.getConf();
        SSLOptions kafkaSSLOptions = SSLOptions$.MODULE$.parse(sparkConf, "spark.ssl.kafka", (Option)new Some((Object)(defaultSSLOptions = SSLOptions$.MODULE$.parse(sparkConf, "spark.ssl", (Option)None$.MODULE$))));
        if (kafkaSSLOptions.enabled()) {
            scala.collection.immutable.Map sslParams = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"security.protocol"), (Object)new Some((Object)"SSL")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ssl.truststore.location"), (Object)kafkaSSLOptions.trustStore()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ssl.truststore.password"), (Object)kafkaSSLOptions.trustStorePassword()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ssl.keystore.location"), (Object)kafkaSSLOptions.keyStore()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ssl.keystore.password"), (Object)kafkaSSLOptions.keyStorePassword()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ssl.key.password"), (Object)kafkaSSLOptions.keyPassword())}));
            map = kafkaParams.$plus$plus((GenTraversableOnce)((scala.collection.immutable.MapLike)sslParams.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Option<?>> x$1) {
                    return ((Option)x$1._2()).isDefined();
                }
            })).mapValues((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Option<?> x$2) {
                    return x$2.get().toString();
                }
            }));
        } else {
            map = kafkaParams;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public OffsetRange[] org$apache$spark$streaming$kafka$v09$KafkaUtils$$checkOffsets(scala.collection.immutable.Map<String, String> kafkaParams, OffsetRange[] offsetRanges) {
        KafkaCluster kc = new KafkaCluster(kafkaParams, ClassTag$.MODULE$.Nothing(), ClassTag$.MODULE$.Nothing());
        try {
            void var7_7;
            scala.collection.immutable.Set topics = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])offsetRanges).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final TopicPartition apply(OffsetRange x$3) {
                    return x$3.topicPartition();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TopicPartition.class)))).toSet();
            scala.collection.immutable.Map<TopicPartition, Object> low = kc.getEarliestOffsets((scala.collection.immutable.Set<TopicPartition>)topics);
            scala.collection.immutable.Map<TopicPartition, KafkaCluster.LeaderOffset> high = kc.getLatestOffsetsWithLeaders((scala.collection.immutable.Set<TopicPartition>)topics);
            OffsetRange[] result = (OffsetRange[])Predef$.MODULE$.refArrayOps((Object[])offsetRanges).filterNot((Function1)new Serializable(low, high){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map low$1;
                private final scala.collection.immutable.Map high$1;

                public final boolean apply(OffsetRange o) {
                    return BoxesRunTime.unboxToLong((Object)this.low$1.apply((Object)o.topicPartition())) <= o.fromOffset() && o.untilOffset() <= ((KafkaCluster.LeaderOffset)this.high$1.apply((Object)o.topicPartition())).offset();
                }
                {
                    this.low$1 = low$1;
                    this.high$1 = high$1;
                }
            });
            if (Predef$.MODULE$.refArrayOps((Object[])result).isEmpty()) {
                return (OffsetRange[])Predef$.MODULE$.refArrayOps((Object[])offsetRanges).map((Function1)new Serializable(high){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Map high$1;

                    public final OffsetRange apply(OffsetRange o) {
                        return OffsetRange$.MODULE$.apply(o.topic(), o.partition(), o.fromOffset(), o.untilOffset(), ((KafkaCluster.LeaderOffset)this.high$1.apply((Object)o.topicPartition())).host());
                    }
                    {
                        this.high$1 = high$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OffsetRange.class)));
            }
            throw new SparkException(new StringBuilder().append((Object)"Offsets not available in Kafka: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])var7_7).mkString(",")).toString());
        }
        finally {
            kc.close();
        }
    }

    public <K, V> RDD<Tuple2<K, V>> createRDD(SparkContext sc, scala.collection.immutable.Map<String, String> kafkaParams, OffsetRange[] offsetRanges, ClassTag<K> evidence$1, ClassTag<V> evidence$2) {
        return (RDD)sc.withScope((Function0)new Serializable(sc, kafkaParams, offsetRanges, evidence$1, evidence$2){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$1;
            private final scala.collection.immutable.Map kafkaParams$1;
            private final OffsetRange[] offsetRanges$1;
            private final ClassTag evidence$1$1;
            private final ClassTag evidence$2$1;

            public final KafkaRDD<K, V, Tuple2<K, V>> apply() {
                Serializable messageHandler = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<K, V> apply(ConsumerRecord<K, V> cr) {
                        return new Tuple2(cr.key(), cr.value());
                    }
                };
                return new KafkaRDD<K, V, R>(this.sc$1, KafkaUtils$.MODULE$.addSSLOptions((scala.collection.immutable.Map<String, String>)this.kafkaParams$1, this.sc$1), KafkaUtils$.MODULE$.org$apache$spark$streaming$kafka$v09$KafkaUtils$$checkOffsets((scala.collection.immutable.Map<String, String>)this.kafkaParams$1, this.offsetRanges$1), messageHandler, this.evidence$1$1, this.evidence$2$1, ClassTag$.MODULE$.apply(Tuple2.class));
            }
            {
                this.sc$1 = sc$1;
                this.kafkaParams$1 = kafkaParams$1;
                this.offsetRanges$1 = offsetRanges$1;
                this.evidence$1$1 = evidence$1$1;
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    public <K, V, R> RDD<R> createRDD(SparkContext sc, scala.collection.immutable.Map<String, String> kafkaParams, OffsetRange[] offsetRanges, Function1<ConsumerRecord<K, V>, R> messageHandler, ClassTag<K> evidence$3, ClassTag<V> evidence$4, ClassTag<R> evidence$5) {
        return (RDD)sc.withScope((Function0)new Serializable(sc, kafkaParams, offsetRanges, messageHandler, evidence$3, evidence$4, evidence$5){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$2;
            private final scala.collection.immutable.Map kafkaParams$2;
            private final OffsetRange[] offsetRanges$2;
            private final Function1 messageHandler$1;
            private final ClassTag evidence$3$1;
            private final ClassTag evidence$4$1;
            private final ClassTag evidence$5$1;

            public final KafkaRDD<K, V, R> apply() {
                KafkaCluster<K, V> kc = new KafkaCluster<K, V>(KafkaUtils$.MODULE$.addSSLOptions((scala.collection.immutable.Map<String, String>)this.kafkaParams$2, this.sc$2), this.evidence$3$1, this.evidence$4$1);
                Function1 cleanedHandler = (Function1)this.sc$2.clean((Object)this.messageHandler$1, this.sc$2.clean$default$2());
                return new KafkaRDD<K, V, R>(this.sc$2, KafkaUtils$.MODULE$.addSSLOptions((scala.collection.immutable.Map<String, String>)this.kafkaParams$2, this.sc$2), KafkaUtils$.MODULE$.org$apache$spark$streaming$kafka$v09$KafkaUtils$$checkOffsets((scala.collection.immutable.Map<String, String>)this.kafkaParams$2, this.offsetRanges$2), cleanedHandler, this.evidence$3$1, this.evidence$4$1, this.evidence$5$1);
            }
            {
                this.sc$2 = sc$2;
                this.kafkaParams$2 = kafkaParams$2;
                this.offsetRanges$2 = offsetRanges$2;
                this.messageHandler$1 = messageHandler$1;
                this.evidence$3$1 = evidence$3$1;
                this.evidence$4$1 = evidence$4$1;
                this.evidence$5$1 = evidence$5$1;
            }
        });
    }

    public <K, V> JavaPairRDD<K, V> createRDD(JavaSparkContext jsc, Class<K> keyClass, Class<V> valueClass, Map<String, String> kafkaParams, OffsetRange[] offsetRanges) {
        return (JavaPairRDD)jsc.sc().withScope((Function0)new Serializable(jsc, keyClass, valueClass, kafkaParams, offsetRanges){
            public static final long serialVersionUID = 0L;
            private final JavaSparkContext jsc$1;
            private final Class keyClass$1;
            private final Class valueClass$1;
            private final Map kafkaParams$3;
            private final OffsetRange[] offsetRanges$3;

            public final JavaPairRDD<K, V> apply() {
                ClassTag keyCmt = ClassTag$.MODULE$.apply(this.keyClass$1);
                ClassTag valueCmt = ClassTag$.MODULE$.apply(this.valueClass$1);
                return new JavaPairRDD(KafkaUtils$.MODULE$.createRDD(this.jsc$1.sc(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.kafkaParams$3).asScala()).toSeq())), this.offsetRanges$3, keyCmt, valueCmt), keyCmt, valueCmt);
            }
            {
                this.jsc$1 = jsc$1;
                this.keyClass$1 = keyClass$1;
                this.valueClass$1 = valueClass$1;
                this.kafkaParams$3 = kafkaParams$3;
                this.offsetRanges$3 = offsetRanges$3;
            }
        });
    }

    public <K, V, R> JavaRDD<R> createRDD(JavaSparkContext jsc, Class<K> keyClass, Class<V> valueClass, Class<R> recordClass, Map<String, String> kafkaParams, OffsetRange[] offsetRanges, Function<ConsumerRecord<K, V>, R> messageHandler) {
        return (JavaRDD)jsc.sc().withScope((Function0)new Serializable(jsc, keyClass, valueClass, recordClass, kafkaParams, offsetRanges, messageHandler){
            public static final long serialVersionUID = 0L;
            private final JavaSparkContext jsc$2;
            private final Class keyClass$2;
            private final Class valueClass$2;
            private final Class recordClass$1;
            private final Map kafkaParams$4;
            private final OffsetRange[] offsetRanges$4;
            public final Function messageHandler$2;

            public final JavaRDD<R> apply() {
                ClassTag keyCmt = ClassTag$.MODULE$.apply(this.keyClass$2);
                ClassTag valueCmt = ClassTag$.MODULE$.apply(this.valueClass$2);
                ClassTag recordCmt = ClassTag$.MODULE$.apply(this.recordClass$1);
                return JavaRDD$.MODULE$.fromRDD(KafkaUtils$.MODULE$.createRDD(this.jsc$2.sc(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.kafkaParams$4).asScala()).toSeq())), this.offsetRanges$4, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createRDD.4 $outer;

                    public final R apply(ConsumerRecord<K, V> x$1) {
                        return (R)this.$outer.messageHandler$2.call(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, keyCmt, valueCmt, recordCmt), recordCmt);
            }
            {
                this.jsc$2 = jsc$2;
                this.keyClass$2 = keyClass$2;
                this.valueClass$2 = valueClass$2;
                this.recordClass$1 = recordClass$1;
                this.kafkaParams$4 = kafkaParams$4;
                this.offsetRanges$4 = offsetRanges$4;
                this.messageHandler$2 = messageHandler$2;
            }
        });
    }

    public <K, V, R> InputDStream<R> createDirectStream(StreamingContext ssc, scala.collection.immutable.Map<String, String> kafkaParams, scala.collection.immutable.Map<TopicPartition, Object> fromOffsets, Function1<ConsumerRecord<K, V>, R> messageHandler, ClassTag<K> evidence$6, ClassTag<V> evidence$7, ClassTag<R> evidence$8) {
        Function1 cleanedHandler = (Function1)ssc.sc().clean(messageHandler, ssc.sc().clean$default$2());
        return new DirectKafkaInputDStream<K, V, R>(ssc, this.addSSLOptions(kafkaParams, ssc.sparkContext()), fromOffsets, messageHandler, evidence$6, evidence$7, evidence$8);
    }

    public <K, V> InputDStream<Tuple2<K, V>> createDirectStream(StreamingContext ssc, scala.collection.immutable.Map<String, String> kafkaParams, scala.collection.immutable.Set<String> topics, ClassTag<K> evidence$9, ClassTag<V> evidence$10) {
        Serializable messageHandler = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<K, V> apply(ConsumerRecord<K, V> cr) {
                return new Tuple2(cr.key(), cr.value());
            }
        };
        scala.collection.immutable.Map<TopicPartition, Object> fromOffsets = this.getFromOffsets(kafkaParams, topics);
        return new DirectKafkaInputDStream(ssc, this.addSSLOptions(kafkaParams, ssc.sparkContext()), fromOffsets, messageHandler, evidence$9, evidence$10, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <K, V, R> JavaInputDStream<R> createDirectStream(JavaStreamingContext jssc, Class<K> keyClass, Class<V> valueClass, Class<R> recordClass, Map<String, String> kafkaParams, Map<TopicPartition, Long> fromOffsets, Function<ConsumerRecord<K, V>, R> messageHandler) {
        ClassTag keyCmt = ClassTag$.MODULE$.apply(keyClass);
        ClassTag valueCmt = ClassTag$.MODULE$.apply(valueClass);
        ClassTag recordCmt = ClassTag$.MODULE$.apply(recordClass);
        SparkContext qual$1 = JavaSparkContext$.MODULE$.toSparkContext(jssc.sparkContext());
        Serializable x$8 = new Serializable(messageHandler){
            public static final long serialVersionUID = 0L;
            private final Function messageHandler$3;

            public final R apply(ConsumerRecord<K, V> x$1) {
                return (R)this.messageHandler$3.call(x$1);
            }
            {
                this.messageHandler$3 = messageHandler$3;
            }
        };
        boolean x$9 = qual$1.clean$default$2();
        Function1 cleanedHandler = (Function1)qual$1.clean((Object)x$8, x$9);
        return JavaInputDStream$.MODULE$.fromInputDStream(this.createDirectStream(jssc.ssc(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(kafkaParams).asScala()).toSeq())), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fromOffsets).asScala()).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Long x$4) {
                return x$4;
            }
        }).toSeq())), cleanedHandler, keyCmt, valueCmt, recordCmt), recordCmt);
    }

    public <K, V> JavaPairInputDStream<K, V> createDirectStream(JavaStreamingContext jssc, Class<K> keyClass, Class<V> valueClass, Map<String, String> kafkaParams, Set<String> topics) {
        ClassTag keyCmt = ClassTag$.MODULE$.apply(keyClass);
        ClassTag valueCmt = ClassTag$.MODULE$.apply(valueClass);
        return JavaPairInputDStream$.MODULE$.fromInputDStream(this.createDirectStream(jssc.ssc(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(kafkaParams).asScala()).toSeq())), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply(((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(topics).asScala()).toSeq())), keyCmt, valueCmt), keyCmt, valueCmt);
    }

    public OffsetRange createOffsetRange(String topic, Integer partition, Long fromOffset, Long untilOffset) {
        return OffsetRange$.MODULE$.create(topic, Predef$.MODULE$.Integer2int(partition), Predef$.MODULE$.Long2long(fromOffset), Predef$.MODULE$.Long2long(untilOffset));
    }

    public TopicAndPartition createTopicAndPartition(String topic, Integer partition) {
        return new TopicAndPartition(topic, Predef$.MODULE$.Integer2int(partition));
    }

    public scala.collection.immutable.Map<TopicPartition, Object> getFromOffsets(scala.collection.immutable.Map<String, String> kafkaParams, scala.collection.immutable.Set<String> topics) {
        KafkaCluster kc = new KafkaCluster(kafkaParams, ClassTag$.MODULE$.Nothing(), ClassTag$.MODULE$.Nothing());
        try {
            Option reset;
            Option option = reset = kafkaParams.get((Object)"auto.offset.reset").map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$5) {
                    return x$5.toLowerCase();
                }
            });
            Some some = new Some((Object)"earliest");
            scala.collection.immutable.Map<TopicPartition, Object> map = !(option != null ? !option.equals(some) : some != null) ? kc.getEarliestOffsets(kc.getPartitions(topics)) : kc.getLatestOffsets(kc.getPartitions(topics));
            return map;
        }
        finally {
            kc.close();
        }
    }

    private KafkaUtils$() {
        MODULE$ = this;
    }
}

