/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractTransformer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;

public class StringDecoder
extends AbstractTransformer<Buffer, String> {
    private static final Logger logger = Grizzly.logger(StringDecoder.class);
    protected Charset charset;
    protected final Attribute<Integer> lengthAttribute;
    protected byte[] stringTerminateBytes = null;

    public StringDecoder() {
        this(null, null);
    }

    public StringDecoder(String stringTerminator) {
        this(Charset.forName("UTF-8"), stringTerminator);
    }

    public StringDecoder(Charset charset) {
        this(charset, null);
    }

    public StringDecoder(Charset charset, String stringTerminator) {
        this.charset = charset != null ? charset : Charset.defaultCharset();
        if (stringTerminator != null) {
            try {
                this.stringTerminateBytes = stringTerminator.getBytes(this.charset.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.lengthAttribute = this.attributeBuilder.createAttribute("StringDecoder.StringSize");
    }

    @Override
    public String getName() {
        return "StringDecoder";
    }

    @Override
    protected TransformationResult<Buffer, String> transformImpl(AttributeStorage storage, Buffer input2) throws TransformationException {
        if (input2 == null) {
            throw new TransformationException("Input could not be null");
        }
        TransformationResult<Buffer, String> result2 = this.stringTerminateBytes == null ? this.parseWithLengthPrefix(storage, input2) : this.parseWithTerminatingSeq(storage, input2);
        return result2;
    }

    protected TransformationResult<Buffer, String> parseWithLengthPrefix(AttributeStorage storage, Buffer input2) {
        Integer stringSize = this.lengthAttribute.get(storage);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "StringDecoder decode stringSize={0} buffer={1} content={2}", new Object[]{stringSize, input2, input2.toStringContent()});
        }
        if (stringSize == null) {
            if (input2.remaining() < 4) {
                return TransformationResult.createIncompletedResult(input2);
            }
            stringSize = input2.getInt();
            this.lengthAttribute.set(storage, stringSize);
        }
        if (input2.remaining() < stringSize) {
            return TransformationResult.createIncompletedResult(input2);
        }
        int tmpLimit = input2.limit();
        input2.limit(input2.position() + stringSize);
        String stringMessage = input2.toStringContent(this.charset);
        input2.position(input2.limit());
        input2.limit(tmpLimit);
        return TransformationResult.createCompletedResult(stringMessage, input2);
    }

    protected TransformationResult<Buffer, String> parseWithTerminatingSeq(AttributeStorage storage, Buffer input2) {
        int terminationBytesLength = this.stringTerminateBytes.length;
        int checkIndex = 0;
        int termIndex = -1;
        Integer offsetInt = this.lengthAttribute.get(storage);
        int offset = 0;
        if (offsetInt != null) {
            offset = offsetInt;
        }
        for (int i = input2.position() + offset; i < input2.limit(); ++i) {
            if (input2.get(i) != this.stringTerminateBytes[checkIndex] || ++checkIndex < terminationBytesLength) continue;
            termIndex = i - terminationBytesLength + 1;
            break;
        }
        if (termIndex >= 0) {
            int tmpLimit = input2.limit();
            input2.limit(termIndex);
            String stringMessage = input2.toStringContent(this.charset);
            input2.limit(tmpLimit);
            input2.position(termIndex + terminationBytesLength);
            return TransformationResult.createCompletedResult(stringMessage, input2);
        }
        offset = input2.remaining() - terminationBytesLength;
        if (offset < 0) {
            offset = 0;
        }
        this.lengthAttribute.set(storage, (Integer)offset);
        return TransformationResult.createIncompletedResult(input2);
    }

    @Override
    public void release(AttributeStorage storage) {
        this.lengthAttribute.remove(storage);
        super.release(storage);
    }

    @Override
    public boolean hasInputRemaining(AttributeStorage storage, Buffer input2) {
        return input2 != null && input2.hasRemaining();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

