/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.BufferArray;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.ByteBufferArray;

public class ByteBufferWrapper
implements Buffer {
    public static volatile boolean DEBUG_MODE = false;
    protected ByteBuffer visible;
    protected boolean allowBufferDispose = false;
    protected Exception disposeStackTrace;

    protected ByteBufferWrapper() {
        this(null);
    }

    public ByteBufferWrapper(ByteBuffer underlyingByteBuffer) {
        this.visible = underlyingByteBuffer;
    }

    @Override
    public final boolean isComposite() {
        return false;
    }

    @Override
    public ByteBufferWrapper prepend(Buffer header) {
        this.checkDispose();
        return this;
    }

    @Override
    public void trim() {
        this.checkDispose();
        this.flip();
    }

    @Override
    public void shrink() {
        this.checkDispose();
    }

    @Override
    public boolean isDirect() {
        this.checkDispose();
        return this.visible.isDirect();
    }

    @Override
    public final boolean allowBufferDispose() {
        return this.allowBufferDispose;
    }

    @Override
    public final void allowBufferDispose(boolean allowBufferDispose) {
        this.allowBufferDispose = allowBufferDispose;
    }

    @Override
    public final boolean tryDispose() {
        if (this.allowBufferDispose) {
            this.dispose();
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        this.prepareDispose();
        this.visible = null;
    }

    protected final void prepareDispose() {
        this.checkDispose();
        if (DEBUG_MODE) {
            DebugLogic.doDebug(this);
        }
    }

    @Override
    public ByteBuffer underlying() {
        this.checkDispose();
        return this.visible;
    }

    @Override
    public final int capacity() {
        return this.visible.capacity();
    }

    @Override
    public final int position() {
        this.checkDispose();
        return this.visible.position();
    }

    @Override
    public final ByteBufferWrapper position(int newPosition) {
        this.checkDispose();
        this.visible.position(newPosition);
        return this;
    }

    @Override
    public final int limit() {
        this.checkDispose();
        return this.visible.limit();
    }

    @Override
    public final ByteBufferWrapper limit(int newLimit) {
        this.checkDispose();
        this.visible.limit(newLimit);
        return this;
    }

    @Override
    public final ByteBufferWrapper mark() {
        this.visible.mark();
        return this;
    }

    @Override
    public final ByteBufferWrapper reset() {
        this.visible.reset();
        return this;
    }

    @Override
    public final ByteBufferWrapper clear() {
        this.visible.clear();
        return this;
    }

    @Override
    public final ByteBufferWrapper flip() {
        this.visible.flip();
        return this;
    }

    @Override
    public final ByteBufferWrapper rewind() {
        this.visible.rewind();
        return this;
    }

    @Override
    public final int remaining() {
        return this.visible.remaining();
    }

    @Override
    public final boolean hasRemaining() {
        return this.visible.hasRemaining();
    }

    @Override
    public boolean isReadOnly() {
        return this.visible.isReadOnly();
    }

    @Override
    public Buffer split(int splitPosition) {
        int oldPosition = this.position();
        int oldLimit = this.limit();
        Buffers.setPositionLimit(this.visible, 0, splitPosition);
        ByteBuffer slice1 = this.visible.slice();
        Buffers.setPositionLimit(this.visible, splitPosition, this.visible.capacity());
        ByteBuffer slice2 = this.visible.slice();
        if (oldPosition < splitPosition) {
            slice1.position(oldPosition);
        } else {
            slice1.position(slice1.capacity());
            slice2.position(oldPosition - splitPosition);
        }
        if (oldLimit < splitPosition) {
            slice1.limit(oldLimit);
            slice2.limit(0);
        } else {
            slice2.limit(oldLimit - splitPosition);
        }
        this.visible = slice1;
        return this.wrapByteBuffer(slice2);
    }

    @Override
    public ByteBufferWrapper slice() {
        return this.slice(this.position(), this.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBufferWrapper slice(int position, int limit) {
        int oldPosition = this.position();
        int oldLimit = this.limit();
        try {
            Buffers.setPositionLimit(this.visible, position, limit);
            ByteBuffer slice2 = this.visible.slice();
            ByteBufferWrapper byteBufferWrapper = this.wrapByteBuffer(slice2);
            return byteBufferWrapper;
        }
        finally {
            Buffers.setPositionLimit(this.visible, oldPosition, oldLimit);
        }
    }

    @Override
    public ByteBufferWrapper duplicate() {
        ByteBuffer duplicate = this.visible.duplicate();
        return this.wrapByteBuffer(duplicate);
    }

    @Override
    public ByteBufferWrapper asReadOnlyBuffer() {
        this.visible.asReadOnlyBuffer();
        return this;
    }

    @Override
    public byte get() {
        return this.visible.get();
    }

    @Override
    public byte get(int index2) {
        return this.visible.get(index2);
    }

    @Override
    public ByteBufferWrapper put(byte b) {
        this.visible.put(b);
        return this;
    }

    @Override
    public ByteBufferWrapper put(int index2, byte b) {
        this.visible.put(index2, b);
        return this;
    }

    @Override
    public ByteBufferWrapper get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    @Override
    public ByteBufferWrapper get(byte[] dst, int offset, int length) {
        Buffers.get(this.visible, dst, offset, length);
        return this;
    }

    @Override
    public ByteBufferWrapper put(Buffer src) {
        this.put(src, src.position(), src.remaining());
        src.position(src.limit());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBufferWrapper put(Buffer src, int position, int length) {
        int oldPos = src.position();
        int oldLim = this.limit();
        src.position(position);
        this.limit(this.position() + length);
        try {
            src.get(this.visible);
        }
        finally {
            src.position(oldPos);
            this.limit(oldLim);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer get(ByteBuffer dst) {
        int length = dst.remaining();
        if (this.visible.remaining() < length) {
            throw new BufferUnderflowException();
        }
        int srcPos = this.visible.position();
        int oldSrcLim = this.visible.limit();
        try {
            this.visible.limit(srcPos + length);
            dst.put(this.visible);
        }
        finally {
            this.visible.limit(oldSrcLim);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer get(ByteBuffer dst, int position, int length) {
        if (this.visible.remaining() < length) {
            throw new BufferUnderflowException();
        }
        int srcPos = this.visible.position();
        int oldSrcLim = this.visible.limit();
        int oldDstPos = dst.position();
        int oldDstLim = dst.limit();
        Buffers.setPositionLimit(dst, position, position + length);
        try {
            this.visible.limit(srcPos + length);
            dst.put(this.visible);
        }
        finally {
            this.visible.limit(oldSrcLim);
            Buffers.setPositionLimit(dst, oldDstPos, oldDstLim);
        }
        return this;
    }

    @Override
    public Buffer put(ByteBuffer src) {
        this.visible.put(src);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer put(ByteBuffer src, int position, int length) {
        int oldPos = src.position();
        int oldLim = src.limit();
        try {
            Buffers.setPositionLimit(src, position, position + length);
            this.visible.put(src);
        }
        finally {
            Buffers.setPositionLimit(src, oldPos, oldLim);
        }
        return this;
    }

    @Override
    public ByteBufferWrapper put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public ByteBufferWrapper put(byte[] src, int offset, int length) {
        Buffers.put(src, offset, length, this.visible);
        return this;
    }

    @Override
    public Buffer put8BitString(String s2) {
        int len = s2.length();
        if (this.remaining() < len) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < len; ++i) {
            this.visible.put((byte)s2.charAt(i));
        }
        return this;
    }

    @Override
    public ByteBufferWrapper compact() {
        this.visible.compact();
        return this;
    }

    @Override
    public ByteOrder order() {
        return this.visible.order();
    }

    @Override
    public ByteBufferWrapper order(ByteOrder bo) {
        this.visible.order(bo);
        return this;
    }

    @Override
    public char getChar() {
        return this.visible.getChar();
    }

    @Override
    public char getChar(int index2) {
        return this.visible.getChar(index2);
    }

    @Override
    public ByteBufferWrapper putChar(char value2) {
        this.visible.putChar(value2);
        return this;
    }

    @Override
    public ByteBufferWrapper putChar(int index2, char value2) {
        this.visible.putChar(index2, value2);
        return this;
    }

    @Override
    public short getShort() {
        return this.visible.getShort();
    }

    @Override
    public short getShort(int index2) {
        return this.visible.getShort(index2);
    }

    @Override
    public ByteBufferWrapper putShort(short value2) {
        this.visible.putShort(value2);
        return this;
    }

    @Override
    public ByteBufferWrapper putShort(int index2, short value2) {
        this.visible.putShort(index2, value2);
        return this;
    }

    @Override
    public int getInt() {
        return this.visible.getInt();
    }

    @Override
    public int getInt(int index2) {
        return this.visible.getInt(index2);
    }

    @Override
    public ByteBufferWrapper putInt(int value2) {
        this.visible.putInt(value2);
        return this;
    }

    @Override
    public ByteBufferWrapper putInt(int index2, int value2) {
        this.visible.putInt(index2, value2);
        return this;
    }

    @Override
    public long getLong() {
        return this.visible.getLong();
    }

    @Override
    public long getLong(int index2) {
        return this.visible.getLong(index2);
    }

    @Override
    public ByteBufferWrapper putLong(long value2) {
        this.visible.putLong(value2);
        return this;
    }

    @Override
    public ByteBufferWrapper putLong(int index2, long value2) {
        this.visible.putLong(index2, value2);
        return this;
    }

    @Override
    public float getFloat() {
        return this.visible.getFloat();
    }

    @Override
    public float getFloat(int index2) {
        return this.visible.getFloat(index2);
    }

    @Override
    public ByteBufferWrapper putFloat(float value2) {
        this.visible.putFloat(value2);
        return this;
    }

    @Override
    public ByteBufferWrapper putFloat(int index2, float value2) {
        this.visible.putFloat(index2, value2);
        return this;
    }

    @Override
    public double getDouble() {
        return this.visible.getDouble();
    }

    @Override
    public double getDouble(int index2) {
        return this.visible.getDouble(index2);
    }

    @Override
    public ByteBufferWrapper putDouble(double value2) {
        this.visible.putDouble(value2);
        return this;
    }

    @Override
    public ByteBufferWrapper putDouble(int index2, double value2) {
        this.visible.putDouble(index2, value2);
        return this;
    }

    public int hashCode() {
        return this.visible.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Buffer) {
            Buffer that = (Buffer)obj;
            if (this.remaining() != that.remaining()) {
                return false;
            }
            int p = this.position();
            int i = this.limit() - 1;
            int j = that.limit() - 1;
            while (i >= p) {
                byte v2;
                byte v1 = this.get(i);
                if (v1 != (v2 = that.get(j))) {
                    return false;
                }
                --i;
                --j;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Buffer o) {
        int n = this.position() + Math.min(this.remaining(), o.remaining());
        int i = this.position();
        int j = o.position();
        while (i < n) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = o.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - o.remaining();
    }

    private void checkDispose() {
        if (this.visible == null) {
            throw new IllegalStateException("BufferWrapper has already been disposed", this.disposeStackTrace);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ByteBufferWrapper (" + System.identityHashCode(this) + ") [");
        sb.append("visible=[").append(this.visible).append(']');
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String toStringContent() {
        return this.toStringContent(Charset.defaultCharset(), this.position(), this.limit());
    }

    @Override
    public String toStringContent(Charset charset) {
        return this.toStringContent(charset, this.position(), this.limit());
    }

    @Override
    public String toStringContent(Charset charset, int position, int limit) {
        this.checkDispose();
        return Buffers.toStringContent(this.visible, charset, position, limit);
    }

    @Override
    public final ByteBuffer toByteBuffer() {
        return this.visible;
    }

    @Override
    public final ByteBuffer toByteBuffer(int position, int limit) {
        int currentPosition = this.visible.position();
        int currentLimit = this.visible.limit();
        if (position == currentPosition && limit == currentLimit) {
            return this.toByteBuffer();
        }
        Buffers.setPositionLimit(this.visible, position, limit);
        ByteBuffer resultBuffer = this.visible.slice();
        Buffers.setPositionLimit(this.visible, currentPosition, currentLimit);
        return resultBuffer;
    }

    @Override
    public final ByteBufferArray toByteBufferArray() {
        ByteBufferArray array = ByteBufferArray.create();
        array.add(this.visible);
        return array;
    }

    @Override
    public final ByteBufferArray toByteBufferArray(int position, int limit) {
        return this.toByteBufferArray(ByteBufferArray.create(), position, limit);
    }

    @Override
    public final ByteBufferArray toByteBufferArray(ByteBufferArray array) {
        array.add(this.visible);
        return array;
    }

    @Override
    public final ByteBufferArray toByteBufferArray(ByteBufferArray array, int position, int limit) {
        int oldPos = this.visible.position();
        int oldLim = this.visible.limit();
        Buffers.setPositionLimit(this.visible, position, limit);
        array.add(this.visible, oldPos, oldLim);
        return array;
    }

    @Override
    public final BufferArray toBufferArray() {
        BufferArray array = BufferArray.create();
        array.add(this);
        return array;
    }

    @Override
    public final BufferArray toBufferArray(int position, int limit) {
        return this.toBufferArray(BufferArray.create(), position, limit);
    }

    @Override
    public final BufferArray toBufferArray(BufferArray array) {
        array.add(this);
        return array;
    }

    @Override
    public final BufferArray toBufferArray(BufferArray array, int position, int limit) {
        int oldPos = this.visible.position();
        int oldLim = this.visible.limit();
        Buffers.setPositionLimit(this.visible, position, limit);
        array.add(this, oldPos, oldLim);
        return array;
    }

    protected ByteBufferWrapper wrapByteBuffer(ByteBuffer byteBuffer) {
        return new ByteBufferWrapper(byteBuffer);
    }

    private static class DebugLogic {
        private DebugLogic() {
        }

        static void doDebug(ByteBufferWrapper wrapper) {
            wrapper.visible.clear();
            while (wrapper.visible.hasRemaining()) {
                wrapper.visible.put((byte)-1);
            }
            wrapper.visible.flip();
            wrapper.disposeStackTrace = new Exception("ByteBufferWrapper was disposed from: ");
        }
    }
}

