/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.filecache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.filecache.FileCacheEntry;
import org.glassfish.grizzly.http.server.filecache.FileCacheKey;
import org.glassfish.grizzly.http.server.filecache.FileCacheProbe;
import org.glassfish.grizzly.http.server.filecache.LazyFileCacheKey;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.monitoring.jmx.AbstractJmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringAware;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.utils.DelayedExecutor;

public class FileCache
implements JmxMonitoringAware<FileCacheProbe> {
    private static final Logger logger = Grizzly.logger(FileCache.class);
    private final AtomicInteger cacheSize = new AtomicInteger();
    private final ConcurrentHashMap<FileCacheKey, FileCacheEntry> fileCacheMap = new ConcurrentHashMap();
    private final FileCacheEntry NULL_CACHE_ENTRY = new FileCacheEntry(this);
    private int secondsMaxAge = -1;
    private volatile int maxCacheEntries = 1024;
    private long minEntrySize = Long.MIN_VALUE;
    private long maxEntrySize = Long.MAX_VALUE;
    private volatile long maxLargeFileCacheSize = Long.MAX_VALUE;
    private volatile long maxSmallFileCacheSize = 0x100000L;
    private AtomicLong mappedMemorySize = new AtomicLong();
    private AtomicLong heapSize = new AtomicLong();
    private boolean enabled = true;
    private MemoryManager memoryManager;
    private DelayedExecutor.DelayQueue<FileCacheEntry> delayQueue;
    protected final AbstractJmxMonitoringConfig<FileCacheProbe> monitoringConfig = new AbstractJmxMonitoringConfig<FileCacheProbe>(FileCacheProbe.class){

        @Override
        public JmxObject createManagementObject() {
            return FileCache.this.createJmxManagementObject();
        }
    };

    public void initialize(MemoryManager memoryManager, DelayedExecutor delayedExecutor) {
        this.memoryManager = memoryManager;
        this.delayQueue = delayedExecutor.createDelayQueue(new EntryWorker(), new EntryResolver());
    }

    public void add(HttpRequestPacket request, File cacheFile) {
        String requestURI = request.getRequestURI();
        String host = request.getHeader(Header.Host);
        HttpResponsePacket response = request.getResponse();
        MimeHeaders headers = response.getHeaders();
        FileCacheKey key = new FileCacheKey(host, requestURI);
        if (requestURI == null || this.fileCacheMap.putIfAbsent(key, this.NULL_CACHE_ENTRY) != null) {
            return;
        }
        int size2 = this.cacheSize.incrementAndGet();
        if (size2 > this.getMaxCacheEntries()) {
            this.cacheSize.decrementAndGet();
            this.fileCacheMap.remove(key);
            return;
        }
        FileCacheEntry entry2 = this.mapFile(cacheFile);
        if (entry2 == null) {
            return;
        }
        entry2.key = key;
        entry2.requestURI = requestURI;
        String lastModified = headers.getHeader(Header.LastModified);
        entry2.lastModified = lastModified == null ? String.valueOf(cacheFile.lastModified()) : lastModified;
        entry2.contentType = response.getContentType();
        entry2.xPoweredBy = headers.getHeader(Header.XPoweredBy);
        entry2.date = headers.getHeader(Header.Date);
        entry2.Etag = headers.getHeader(Header.ETag);
        entry2.contentLength = response.getContentLength();
        entry2.host = host;
        this.fileCacheMap.put(key, entry2);
        FileCache.notifyProbesEntryAdded(this, entry2);
        int secondsMaxAgeLocal = this.getSecondsMaxAge();
        if (secondsMaxAgeLocal > 0) {
            this.delayQueue.add(entry2, secondsMaxAgeLocal, TimeUnit.SECONDS);
        }
    }

    public HttpPacket get(HttpRequestPacket request) {
        if (this.cacheSize.get() == 0) {
            return null;
        }
        LazyFileCacheKey key = new LazyFileCacheKey(request);
        FileCacheEntry entry2 = this.fileCacheMap.get(key);
        try {
            if (entry2 != null && entry2 != this.NULL_CACHE_ENTRY) {
                FileCache.notifyProbesEntryHit(this, entry2);
                return this.makeResponse(entry2, request);
            }
            FileCache.notifyProbesEntryMissed(this, request);
        }
        catch (Exception e) {
            FileCache.notifyProbesError(this, e);
            logger.log(Level.WARNING, "File Cache exception", e);
        }
        return null;
    }

    final ConcurrentHashMap<FileCacheKey, FileCacheEntry> getFileCacheMap() {
        return this.fileCacheMap;
    }

    protected void remove(FileCacheEntry entry2) {
        if (this.fileCacheMap.remove(entry2.key) != null) {
            this.cacheSize.decrementAndGet();
        }
        if (entry2.type == CacheType.MAPPED) {
            this.subMappedMemorySize(entry2.bb.remaining());
        } else {
            this.subHeapSize(entry2.bb.remaining());
        }
        FileCache.notifyProbesEntryRemoved(this, entry2);
    }

    protected JmxObject createJmxManagementObject() {
        return new org.glassfish.grizzly.http.server.filecache.jmx.FileCache(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileCacheEntry mapFile(File file) {
        MappedByteBuffer bb;
        CacheType type;
        long size2;
        FileChannel fileChannel = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            fileChannel = stream.getChannel();
            size2 = fileChannel.size();
            if (size2 > this.getMaxEntrySize()) {
                FileCacheEntry fileCacheEntry = null;
                return fileCacheEntry;
            }
            if (size2 > this.getMinEntrySize()) {
                if (this.addMappedMemorySize(size2) > this.getMaxLargeFileCacheSize()) {
                    this.subMappedMemorySize(size2);
                    FileCacheEntry fileCacheEntry = null;
                    return fileCacheEntry;
                }
                type = CacheType.MAPPED;
            } else {
                if (this.addHeapSize(size2) > this.getMaxSmallFileCacheSize()) {
                    this.subHeapSize(size2);
                    FileCacheEntry fileCacheEntry = null;
                    return fileCacheEntry;
                }
                type = CacheType.HEAP;
            }
            bb = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size2);
            if (type == CacheType.HEAP) {
                bb.load();
            }
        }
        catch (Exception e) {
            FileCache.notifyProbesError(this, e);
            FileCacheEntry fileCacheEntry = null;
            return fileCacheEntry;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ignored) {
                    FileCache.notifyProbesError(this, ignored);
                }
            }
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException ignored) {
                    FileCache.notifyProbesError(this, ignored);
                }
            }
        }
        FileCacheEntry entry2 = new FileCacheEntry(this);
        entry2.type = type;
        entry2.fileSize = size2;
        entry2.bb = bb;
        return entry2;
    }

    protected HttpPacket makeResponse(FileCacheEntry entry2, HttpRequestPacket request) throws IOException {
        HttpResponsePacket response = request.getResponse();
        HttpStatus.OK_200.setValues(request.getResponse());
        boolean flushBody = this.checkIfHeaders(entry2, request);
        response.setContentType(entry2.contentType);
        if (flushBody) {
            response.setContentLengthLong(entry2.contentLength);
            ByteBuffer sliced = entry2.bb.slice();
            Buffer buffer = Buffers.wrap(this.memoryManager, sliced);
            return ((HttpContent.Builder)((HttpContent.Builder)HttpContent.builder(response).content(buffer)).last(true)).build();
        }
        response.setChunked(false);
        return response;
    }

    public int getSecondsMaxAge() {
        return this.secondsMaxAge;
    }

    public void setSecondsMaxAge(int secondsMaxAge) {
        this.secondsMaxAge = secondsMaxAge;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMaxCacheEntries(int maxCacheEntries) {
        this.maxCacheEntries = maxCacheEntries;
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMinEntrySize(long minEntrySize) {
        this.minEntrySize = minEntrySize;
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxEntrySize(long maxEntrySize) {
        this.maxEntrySize = maxEntrySize;
    }

    public long getMaxLargeFileCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxLargeFileCacheSize(long maxLargeFileCacheSize) {
        this.maxLargeFileCacheSize = maxLargeFileCacheSize;
    }

    public long getMaxSmallFileCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public void setMaxSmallFileCacheSize(long maxSmallFileCacheSize) {
        this.maxSmallFileCacheSize = maxSmallFileCacheSize;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected final long addHeapSize(long size2) {
        return this.heapSize.addAndGet(size2);
    }

    protected final long subHeapSize(long size2) {
        return this.heapSize.addAndGet(-size2);
    }

    public long getHeapCacheSize() {
        return this.heapSize.get();
    }

    protected final long addMappedMemorySize(long size2) {
        return this.mappedMemorySize.addAndGet(size2);
    }

    protected final long subMappedMemorySize(long size2) {
        return this.mappedMemorySize.addAndGet(-size2);
    }

    public long getMappedCacheSize() {
        return this.mappedMemorySize.get();
    }

    protected boolean checkIfHeaders(FileCacheEntry entry2, HttpRequestPacket request) throws IOException {
        return this.checkIfMatch(entry2, request) && this.checkIfModifiedSince(entry2, request) && this.checkIfNoneMatch(entry2, request) && this.checkIfUnmodifiedSince(entry2, request);
    }

    private boolean checkIfModifiedSince(FileCacheEntry entry2, HttpRequestPacket request) throws IOException {
        try {
            long headerValue;
            HttpResponsePacket response = request.getResponse();
            String h = request.getHeader(Header.IfModifiedSince);
            long l = headerValue = h == null ? -1L : Long.parseLong(h);
            if (headerValue != -1L) {
                long lastModified = Long.parseLong(entry2.lastModified);
                if (request.getHeader(Header.IfNoneMatch) == null && lastModified < headerValue + 1000L) {
                    HttpStatus.NOT_MODIFIED_304.setValues(response);
                    response.setHeader(Header.ETag, this.getETag(entry2));
                    return false;
                }
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            FileCache.notifyProbesError(this, illegalArgument);
            return true;
        }
        return true;
    }

    private boolean checkIfNoneMatch(FileCacheEntry entry2, HttpRequestPacket request) throws IOException {
        HttpResponsePacket response = request.getResponse();
        String headerValue = request.getHeader(Header.IfNoneMatch);
        if (headerValue != null) {
            String eTag = this.getETag(entry2);
            boolean conditionSatisfied = false;
            if (!headerValue.equals("*")) {
                StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(eTag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                Method method = request.getMethod();
                if (Method.GET.equals(method) || Method.HEAD.equals(method)) {
                    HttpStatus.NOT_MODIFIED_304.setValues(response);
                    response.setHeader(Header.ETag, eTag);
                    return false;
                }
                HttpStatus.PRECONDITION_FAILED_412.setValues(response);
                return false;
            }
        }
        return true;
    }

    protected boolean checkIfUnmodifiedSince(FileCacheEntry entry2, HttpRequestPacket request) throws IOException {
        try {
            long headerValue;
            HttpResponsePacket response = request.getResponse();
            long lastModified = Long.parseLong(entry2.lastModified);
            String h = request.getHeader(Header.IfUnmodifiedSince);
            long l = headerValue = h == null ? -1L : Long.parseLong(h);
            if (headerValue != -1L && lastModified >= headerValue + 1000L) {
                HttpStatus.PRECONDITION_FAILED_412.setValues(response);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            FileCache.notifyProbesError(this, illegalArgument);
            return true;
        }
        return true;
    }

    private String getETag(FileCacheEntry entry2) {
        String result2 = entry2.Etag;
        if (result2 == null) {
            StringBuilder sb = new StringBuilder();
            long contentLength = entry2.fileSize;
            long lastModified = Long.parseLong(entry2.lastModified);
            if (contentLength >= 0L || lastModified >= 0L) {
                sb.append("W/\"").append(contentLength).append('-').append(lastModified).append('\"');
                entry2.Etag = result2 = sb.toString();
            }
        }
        return result2;
    }

    protected boolean checkIfMatch(FileCacheEntry entry2, HttpRequestPacket request) throws IOException {
        HttpResponsePacket response = request.getResponse();
        String headerValue = request.getHeader(Header.IfMatch);
        if (headerValue != null && headerValue.indexOf(42) == -1) {
            String eTag = this.getETag(entry2);
            StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
            boolean conditionSatisfied = false;
            while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                String currentToken = commaTokenizer.nextToken();
                if (!currentToken.trim().equals(eTag)) continue;
                conditionSatisfied = true;
            }
            if (!conditionSatisfied) {
                HttpStatus.PRECONDITION_FAILED_412.setValues(response);
                return false;
            }
        }
        return true;
    }

    @Override
    public JmxMonitoringConfig<FileCacheProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    protected static void notifyProbesEntryAdded(FileCache fileCache, FileCacheEntry entry2) {
        FileCacheProbe[] probes = (FileCacheProbe[])fileCache.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (FileCacheProbe probe : probes) {
                probe.onEntryAddedEvent(fileCache, entry2);
            }
        }
    }

    protected static void notifyProbesEntryRemoved(FileCache fileCache, FileCacheEntry entry2) {
        FileCacheProbe[] probes = (FileCacheProbe[])fileCache.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (FileCacheProbe probe : probes) {
                probe.onEntryRemovedEvent(fileCache, entry2);
            }
        }
    }

    protected static void notifyProbesEntryHit(FileCache fileCache, FileCacheEntry entry2) {
        FileCacheProbe[] probes = (FileCacheProbe[])fileCache.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (FileCacheProbe probe : probes) {
                probe.onEntryHitEvent(fileCache, entry2);
            }
        }
    }

    protected static void notifyProbesEntryMissed(FileCache fileCache, HttpRequestPacket request) {
        FileCacheProbe[] probes = (FileCacheProbe[])fileCache.monitoringConfig.getProbesUnsafe();
        if (probes != null && probes.length > 0) {
            for (FileCacheProbe probe : probes) {
                probe.onEntryMissedEvent(fileCache, request.getHeader(Header.Host), request.getRequestURI());
            }
        }
    }

    protected static void notifyProbesError(FileCache fileCache, Throwable error) {
        FileCacheProbe[] probes = (FileCacheProbe[])fileCache.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (FileCacheProbe probe : probes) {
                probe.onErrorEvent(fileCache, error);
            }
        }
    }

    private static class EntryResolver
    implements DelayedExecutor.Resolver<FileCacheEntry> {
        private EntryResolver() {
        }

        @Override
        public boolean removeTimeout(FileCacheEntry element) {
            if (element.timeoutMillis != -1L) {
                element.timeoutMillis = -1L;
                return true;
            }
            return false;
        }

        @Override
        public Long getTimeoutMillis(FileCacheEntry element) {
            return element.timeoutMillis;
        }

        @Override
        public void setTimeoutMillis(FileCacheEntry element, long timeoutMillis) {
            element.timeoutMillis = timeoutMillis;
        }
    }

    private static class EntryWorker
    implements DelayedExecutor.Worker<FileCacheEntry> {
        private EntryWorker() {
        }

        @Override
        public boolean doWork(FileCacheEntry element) {
            element.run();
            return true;
        }
    }

    public static enum CacheType {
        HEAP,
        MAPPED;

    }
}

