/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler.generated;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.record.compiler.JBoolean;
import org.apache.hadoop.record.compiler.JBuffer;
import org.apache.hadoop.record.compiler.JByte;
import org.apache.hadoop.record.compiler.JDouble;
import org.apache.hadoop.record.compiler.JField;
import org.apache.hadoop.record.compiler.JFile;
import org.apache.hadoop.record.compiler.JFloat;
import org.apache.hadoop.record.compiler.JInt;
import org.apache.hadoop.record.compiler.JLong;
import org.apache.hadoop.record.compiler.JMap;
import org.apache.hadoop.record.compiler.JRecord;
import org.apache.hadoop.record.compiler.JString;
import org.apache.hadoop.record.compiler.JType;
import org.apache.hadoop.record.compiler.JVector;
import org.apache.hadoop.record.compiler.generated.ParseException;
import org.apache.hadoop.record.compiler.generated.RccConstants;
import org.apache.hadoop.record.compiler.generated.RccTokenManager;
import org.apache.hadoop.record.compiler.generated.SimpleCharStream;
import org.apache.hadoop.record.compiler.generated.Token;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class Rcc
implements RccConstants {
    private static String language = "java";
    private static String destDir = ".";
    private static ArrayList<String> recFiles = new ArrayList();
    private static ArrayList<String> cmdargs = new ArrayList();
    private static JFile curFile;
    private static Hashtable<String, JRecord> recTab;
    private static String curDir;
    private static String curFileName;
    private static String curModuleName;
    public RccTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[6];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private Vector<int[]> jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static void main(String[] args) {
        System.exit(Rcc.driver(args));
    }

    public static void usage() {
        System.err.println("Usage: rcc --language [java|c++] ddl-files");
    }

    public static int driver(String[] args) {
        int i;
        for (i = 0; i < args.length; ++i) {
            if ("-l".equalsIgnoreCase(args[i]) || "--language".equalsIgnoreCase(args[i])) {
                language = args[i + 1].toLowerCase();
                ++i;
                continue;
            }
            if ("-d".equalsIgnoreCase(args[i]) || "--destdir".equalsIgnoreCase(args[i])) {
                destDir = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].startsWith("-")) {
                String arg = args[i].substring(1);
                if (arg.startsWith("-")) {
                    arg = arg.substring(1);
                }
                cmdargs.add(arg.toLowerCase());
                continue;
            }
            recFiles.add(args[i]);
        }
        if (recFiles.size() == 0) {
            Rcc.usage();
            return 1;
        }
        for (i = 0; i < recFiles.size(); ++i) {
            curFileName = recFiles.get(i);
            File file = new File(curFileName);
            try {
                FileReader reader = new FileReader(file);
                Rcc parser = new Rcc(reader);
                try {
                    recTab = new Hashtable();
                    curFile = parser.Input();
                }
                catch (ParseException e) {
                    System.err.println(e.toString());
                    return 1;
                }
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            catch (FileNotFoundException e) {
                System.err.println("File " + recFiles.get(i) + " Not found.");
                return 1;
            }
            try {
                int retCode = curFile.genCode(language, destDir, cmdargs);
                if (retCode == 0) continue;
                return retCode;
            }
            catch (IOException e) {
                System.err.println(e.toString());
                return 1;
            }
        }
        return 0;
    }

    public final JFile Input() throws ParseException {
        ArrayList<JFile> ilist = new ArrayList<JFile>();
        ArrayList<JRecord> rlist = new ArrayList<JRecord>();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    JFile i = this.Include();
                    ilist.add(i);
                    break;
                }
                case 11: {
                    ArrayList<JRecord> l = this.Module();
                    rlist.addAll(l);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: 
                case 13: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(0);
        return new JFile(curFileName, ilist, rlist);
    }

    public final JFile Include() throws ParseException {
        this.jj_consume_token(13);
        Token t = this.jj_consume_token(31);
        JFile ret = null;
        String fname = t.image.replaceAll("^\"", "").replaceAll("\"$", "");
        File file = new File(curDir, fname);
        String tmpDir = curDir;
        String tmpFile = curFileName;
        curDir = file.getParent();
        curFileName = file.getName();
        try {
            FileReader reader = new FileReader(file);
            Rcc parser = new Rcc(reader);
            try {
                ret = parser.Input();
                System.out.println(fname + " Parsed Successfully");
            }
            catch (ParseException e) {
                System.out.println(e.toString());
                System.exit(1);
            }
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
        catch (FileNotFoundException e) {
            System.out.println("File " + fname + " Not found.");
            System.exit(1);
        }
        curDir = tmpDir;
        curFileName = tmpFile;
        return ret;
    }

    public final ArrayList<JRecord> Module() throws ParseException {
        String mName;
        this.jj_consume_token(11);
        curModuleName = mName = this.ModuleName();
        this.jj_consume_token(24);
        ArrayList<JRecord> rlist = this.RecordList();
        this.jj_consume_token(25);
        return rlist;
    }

    public final String ModuleName() throws ParseException {
        String name = "";
        Token t = this.jj_consume_token(32);
        name = name + t.image;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(30);
            t = this.jj_consume_token(32);
            name = name + "." + t.image;
        }
        return name;
    }

    public final ArrayList<JRecord> RecordList() throws ParseException {
        ArrayList<JRecord> rlist = new ArrayList<JRecord>();
        block3: while (true) {
            JRecord r = this.Record();
            rlist.add(r);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[3] = this.jj_gen;
        return rlist;
    }

    public final JRecord Record() throws ParseException {
        ArrayList<JField<JType>> flist = new ArrayList<JField<JType>>();
        this.jj_consume_token(12);
        Token t = this.jj_consume_token(32);
        String rname = t.image;
        this.jj_consume_token(24);
        block3: while (true) {
            JField<JType> f = this.Field();
            flist.add(f);
            this.jj_consume_token(28);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 32: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(25);
        String fqn = curModuleName + "." + rname;
        JRecord r = new JRecord(fqn, flist);
        recTab.put(fqn, r);
        return r;
    }

    public final JField<JType> Field() throws ParseException {
        JType jt = this.Type();
        Token t = this.jj_consume_token(32);
        return new JField<JType>(t.image, jt);
    }

    public final JType Type() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                JMap jt = this.Map();
                return jt;
            }
            case 22: {
                JVector jt = this.Vector();
                return jt;
            }
            case 14: {
                this.jj_consume_token(14);
                return new JByte();
            }
            case 15: {
                this.jj_consume_token(15);
                return new JBoolean();
            }
            case 16: {
                this.jj_consume_token(16);
                return new JInt();
            }
            case 17: {
                this.jj_consume_token(17);
                return new JLong();
            }
            case 18: {
                this.jj_consume_token(18);
                return new JFloat();
            }
            case 19: {
                this.jj_consume_token(19);
                return new JDouble();
            }
            case 20: {
                this.jj_consume_token(20);
                return new JString();
            }
            case 21: {
                this.jj_consume_token(21);
                return new JBuffer();
            }
            case 32: {
                JRecord r;
                String rname = this.ModuleName();
                if (rname.indexOf(46, 0) < 0) {
                    rname = curModuleName + "." + rname;
                }
                if ((r = recTab.get(rname)) == null) {
                    System.out.println("Type " + rname + " not known. Exiting.");
                    System.exit(1);
                }
                return r;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final JMap Map() throws ParseException {
        this.jj_consume_token(23);
        this.jj_consume_token(26);
        JType jt1 = this.Type();
        this.jj_consume_token(29);
        JType jt2 = this.Type();
        this.jj_consume_token(27);
        return new JMap(jt1, jt2);
    }

    public final JVector Vector() throws ParseException {
        this.jj_consume_token(22);
        this.jj_consume_token(26);
        JType jt = this.Type();
        this.jj_consume_token(27);
        return new JVector(jt);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{10240, 10240, 0x40000000, 4096, 0xFFC000, 0xFFC000};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 1, 1};
    }

    public Rcc(InputStream stream) {
        this(stream, null);
    }

    public Rcc(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new RccTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public Rcc(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new RccTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public Rcc(RccTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(RccTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index2) {
        Token t = this.token;
        for (int i = 0; i < index2; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[33];
        for (i = 0; i < 33; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 6; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 33; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        curDir = ".";
        Rcc.jj_la1_0();
        Rcc.jj_la1_1();
    }
}

