/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class TasksBlock
extends HtmlBlock {
    final App app;

    @Inject
    TasksBlock(App app) {
        this.app = app;
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        if (this.app.getJob() == null) {
            html.h2(this.$("title"));
            return;
        }
        TaskType type = null;
        String symbol = this.$("task.type");
        if (!symbol.isEmpty()) {
            type = MRApps.taskType(symbol);
        }
        HamletSpec.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.THEAD)((Hamlet.TABLE)html.table("#tasks")).thead()).tr()).th("Task")).th("Progress")).th("State")).th("Start Time")).th("Finish Time")).th("Elapsed Time")))._())._()).tbody();
        StringBuilder tasksTableData = new StringBuilder("[\n");
        for (Task task : this.app.getJob().getTasks().values()) {
            if (type != null && task.getType() != type) continue;
            TaskInfo info = new TaskInfo(task);
            String tid = info.getId();
            String pct = StringHelper.percent(info.getProgress() / 100.0f);
            tasksTableData.append("[\"<a href='").append(this.url("task", tid)).append("'>").append(tid).append("</a>\",\"").append("<br title='").append(pct).append("'> <div class='").append(JQueryUI.C_PROGRESSBAR).append("' title='").append(StringHelper.join(pct, Character.valueOf('%'))).append("'> ").append("<div class='").append(JQueryUI.C_PROGRESSBAR_VALUE).append("' style='").append(StringHelper.join("width:", pct, Character.valueOf('%'))).append("'> </div> </div>\",\"").append(info.getState()).append("\",\"").append(info.getStartTime()).append("\",\"").append(info.getFinishTime()).append("\",\"").append(info.getElapsedTime()).append("\"],\n");
        }
        if (tasksTableData.charAt(tasksTableData.length() - 2) == ',') {
            tasksTableData.delete(tasksTableData.length() - 2, tasksTableData.length() - 1);
        }
        tasksTableData.append("]");
        ((HamletImpl.EImp)((Object)((Hamlet.SCRIPT)((Hamlet.SCRIPT)html.script()).$type("text/javascript"))._(new Object[]{"var tasksTableData=" + tasksTableData})))._();
        ((Hamlet.TABLE)((HamletImpl.EImp)((Object)tbody))._())._();
    }
}

