/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.api.records;

import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;

public abstract class TaskAttemptId
implements Comparable<TaskAttemptId> {
    protected static final String TASKATTEMPT = "attempt";

    public abstract TaskId getTaskId();

    public abstract int getId();

    public abstract void setTaskId(TaskId var1);

    public abstract void setId(int var1);

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.getId();
        result2 = 31 * result2 + (this.getTaskId() == null ? 0 : this.getTaskId().hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskAttemptId other = (TaskAttemptId)obj;
        if (this.getId() != other.getId()) {
            return false;
        }
        return this.getTaskId().equals(other.getTaskId());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(TASKATTEMPT);
        TaskId taskId = this.getTaskId();
        builder.append("_").append(taskId.getJobId().getAppId().getClusterTimestamp());
        builder.append("_").append(JobId.jobIdFormat.get().format(this.getTaskId().getJobId().getAppId().getId()));
        builder.append("_");
        builder.append(taskId.getTaskType() == TaskType.MAP ? "m" : "r");
        builder.append("_").append(TaskId.taskIdFormat.get().format(taskId.getId()));
        builder.append("_");
        builder.append(this.getId());
        return builder.toString();
    }

    @Override
    public int compareTo(TaskAttemptId other) {
        int taskIdComp = this.getTaskId().compareTo(other.getTaskId());
        if (taskIdComp == 0) {
            return this.getId() - other.getId();
        }
        return taskIdComp;
    }
}

