/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.Comparator;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapred.BasicTypeSorterBase;
import org.apache.hadoop.mapred.MRSortResultIterator;
import org.apache.hadoop.util.MergeSort;

class MergeSorter
extends BasicTypeSorterBase
implements Comparator<IntWritable> {
    private static int progressUpdateFrequency = 10000;
    private int progressCalls = 0;

    MergeSorter() {
    }

    @Override
    public SequenceFile.Sorter.RawKeyValueIterator sort() {
        MergeSort m = new MergeSort(this);
        int count2 = this.count;
        if (count2 == 0) {
            return null;
        }
        int[] pointers = this.pointers;
        int[] pointersCopy = new int[count2];
        System.arraycopy(pointers, 0, pointersCopy, 0, count2);
        m.mergeSort(pointers, pointersCopy, 0, count2);
        return new MRSortResultIterator(this.keyValBuffer, pointersCopy, this.startOffsets, this.keyLengths, this.valueLengths);
    }

    @Override
    public int compare(IntWritable i, IntWritable j) {
        if (this.progressCalls < progressUpdateFrequency) {
            ++this.progressCalls;
        } else {
            this.progressCalls = 0;
            this.reporter.progress();
        }
        return this.comparator.compare(this.keyValBuffer.getData(), this.startOffsets[i.get()], this.keyLengths[i.get()], this.keyValBuffer.getData(), this.startOffsets[j.get()], this.keyLengths[j.get()]);
    }

    @Override
    public long getMemoryUtilized() {
        return super.getMemoryUtilized() + (long)(this.count * 4);
    }
}

