/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ArrayFile
extends MapFile {
    protected ArrayFile() {
    }

    public static class Reader
    extends MapFile.Reader {
        private LongWritable key = new LongWritable();

        public Reader(FileSystem fs, String file, Configuration conf) throws IOException {
            super(new Path(file), conf, new SequenceFile.Reader.Option[0]);
        }

        public synchronized void seek(long n) throws IOException {
            this.key.set(n);
            this.seek(this.key);
        }

        public synchronized Writable next(Writable value2) throws IOException {
            return this.next(this.key, value2) ? value2 : null;
        }

        public synchronized long key() throws IOException {
            return this.key.get();
        }

        public synchronized Writable get(long n, Writable value2) throws IOException {
            this.key.set(n);
            return this.get(this.key, value2);
        }
    }

    public static class Writer
    extends MapFile.Writer {
        private LongWritable count = new LongWritable(0L);

        public Writer(Configuration conf, FileSystem fs, String file, Class<? extends Writable> valClass) throws IOException {
            super(conf, new Path(file), Writer.keyClass(LongWritable.class), Writer.valueClass(valClass));
        }

        public Writer(Configuration conf, FileSystem fs, String file, Class<? extends Writable> valClass, SequenceFile.CompressionType compress, Progressable progress) throws IOException {
            super(conf, new Path(file), Writer.keyClass(LongWritable.class), Writer.valueClass(valClass), Writer.compression(compress), Writer.progressable(progress));
        }

        public synchronized void append(Writable value2) throws IOException {
            super.append(this.count, value2);
            this.count.set(this.count.get() + 1L);
        }
    }
}

