/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class GetConf
extends Configured
implements Tool {
    private static final String DESCRIPTION = "hdfs getconf is utility for getting configuration information from the config file.\n";
    static final String USAGE;
    private final PrintStream out;
    private final PrintStream err;

    GetConf(Configuration conf) {
        this(conf, System.out, System.err);
    }

    GetConf(Configuration conf, PrintStream out, PrintStream err2) {
        super(conf);
        this.out = out;
        this.err = err2;
    }

    void printError(String message) {
        this.err.println(message);
    }

    void printOut(String message) {
        this.out.println(message);
    }

    void printMap(Map<String, Map<String, InetSocketAddress>> map2) {
        StringBuilder buffer = new StringBuilder();
        List<DFSUtil.ConfiguredNNAddress> cnns = DFSUtil.flattenAddressMap(map2);
        for (DFSUtil.ConfiguredNNAddress cnn : cnns) {
            InetSocketAddress address = cnn.getAddress();
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(address.getHostName());
        }
        this.printOut(buffer.toString());
    }

    private void printUsage() {
        this.printError(USAGE);
    }

    private int doWork(String[] args) {
        CommandHandler handler;
        if (args.length >= 1 && (handler = Command.getHandler(args[0])) != null) {
            return handler.doWork(this, Arrays.copyOfRange(args, 1, args.length));
        }
        this.printUsage();
        return -1;
    }

    @Override
    public int run(final String[] args) throws Exception {
        try {
            return UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws Exception {
                    return GetConf.this.doWork(args);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        if (DFSUtil.parseHelpArgument(args, USAGE, System.out, true)) {
            System.exit(0);
        }
        int res = ToolRunner.run(new GetConf(new HdfsConfiguration()), args);
        System.exit(res);
    }

    static {
        HdfsConfiguration.init();
        StringBuilder usage = new StringBuilder(DESCRIPTION);
        usage.append("\nhadoop getconf \n");
        for (Command cmd : Command.values()) {
            usage.append("\t[" + cmd.getUsage() + "]\t\t\t" + cmd.getDescription() + "\n");
        }
        USAGE = usage.toString();
    }

    static class PrintConfKeyCommandHandler
    extends CommandHandler {
        PrintConfKeyCommandHandler() {
        }

        @Override
        protected void checkArgs(String[] args) {
            if (args.length != 1) {
                throw new HadoopIllegalArgumentException("usage: " + Command.CONFKEY.getUsage());
            }
        }

        @Override
        int doWorkInternal(GetConf tool, String[] args) throws Exception {
            this.key = args[0];
            return super.doWorkInternal(tool, args);
        }
    }

    static class NNRpcAddressesCommandHandler
    extends CommandHandler {
        NNRpcAddressesCommandHandler() {
        }

        @Override
        public int doWorkInternal(GetConf tool, String[] args) throws IOException {
            Configuration config = tool.getConf();
            List<DFSUtil.ConfiguredNNAddress> cnnlist = DFSUtil.flattenAddressMap(DFSUtil.getNNServiceRpcAddresses(config));
            if (!cnnlist.isEmpty()) {
                for (DFSUtil.ConfiguredNNAddress cnn : cnnlist) {
                    InetSocketAddress rpc = cnn.getAddress();
                    tool.printOut(rpc.getHostName() + ":" + rpc.getPort());
                }
                return 0;
            }
            tool.printError("Did not get namenode service rpc addresses.");
            return -1;
        }
    }

    static class SecondaryNameNodesCommandHandler
    extends CommandHandler {
        SecondaryNameNodesCommandHandler() {
        }

        @Override
        public int doWorkInternal(GetConf tool, String[] args) throws IOException {
            tool.printMap(DFSUtil.getSecondaryNameNodeAddresses(tool.getConf()));
            return 0;
        }
    }

    static class BackupNodesCommandHandler
    extends CommandHandler {
        BackupNodesCommandHandler() {
        }

        @Override
        public int doWorkInternal(GetConf tool, String[] args) throws IOException {
            tool.printMap(DFSUtil.getBackupNodeAddresses(tool.getConf()));
            return 0;
        }
    }

    static class NameNodesCommandHandler
    extends CommandHandler {
        NameNodesCommandHandler() {
        }

        @Override
        int doWorkInternal(GetConf tool, String[] args) throws IOException {
            tool.printMap(DFSUtil.getNNServiceRpcAddresses(tool.getConf()));
            return 0;
        }
    }

    static class CommandHandler {
        String key;

        CommandHandler() {
            this(null);
        }

        CommandHandler(String key) {
            this.key = key;
        }

        final int doWork(GetConf tool, String[] args) {
            try {
                this.checkArgs(args);
                return this.doWorkInternal(tool, args);
            }
            catch (Exception e) {
                tool.printError(e.getMessage());
                return -1;
            }
        }

        protected void checkArgs(String[] args) {
            if (args.length > 0) {
                throw new HadoopIllegalArgumentException("Did not expect argument: " + args[0]);
            }
        }

        int doWorkInternal(GetConf tool, String[] args) throws Exception {
            String value2 = tool.getConf().getTrimmed(this.key);
            if (value2 != null) {
                tool.printOut(value2);
                return 0;
            }
            tool.printError("Configuration " + this.key + " is missing.");
            return -1;
        }
    }

    static enum Command {
        NAMENODE("-namenodes", "gets list of namenodes in the cluster."),
        SECONDARY("-secondaryNameNodes", "gets list of secondary namenodes in the cluster."),
        BACKUP("-backupNodes", "gets list of backup nodes in the cluster."),
        INCLUDE_FILE("-includeFile", "gets the include file path that defines the datanodes that can join the cluster."),
        EXCLUDE_FILE("-excludeFile", "gets the exclude file path that defines the datanodes that need to decommissioned."),
        NNRPCADDRESSES("-nnRpcAddresses", "gets the namenode rpc addresses"),
        CONFKEY("-confKey [key]", "gets a specific key from the configuration");

        private static Map<String, CommandHandler> map;
        private final String cmd;
        private final String description;

        private Command(String cmd, String description) {
            this.cmd = cmd;
            this.description = description;
        }

        public String getName() {
            return this.cmd.split(" ")[0];
        }

        public String getUsage() {
            return this.cmd;
        }

        public String getDescription() {
            return this.description;
        }

        public static CommandHandler getHandler(String cmd) {
            return map.get(cmd.toLowerCase());
        }

        static {
            map = new HashMap<String, CommandHandler>();
            map.put(NAMENODE.getName().toLowerCase(), new NameNodesCommandHandler());
            map.put(SECONDARY.getName().toLowerCase(), new SecondaryNameNodesCommandHandler());
            map.put(BACKUP.getName().toLowerCase(), new BackupNodesCommandHandler());
            map.put(INCLUDE_FILE.getName().toLowerCase(), new CommandHandler("DFSConfigKeys.DFS_HOSTS"));
            map.put(EXCLUDE_FILE.getName().toLowerCase(), new CommandHandler("DFSConfigKeys.DFS_HOSTS_EXCLUDE"));
            map.put(NNRPCADDRESSES.getName().toLowerCase(), new NNRpcAddressesCommandHandler());
            map.put(CONFKEY.getName().toLowerCase(), new PrintConfKeyCommandHandler());
        }
    }
}

