/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectoryWithSnapshot;
import org.apache.hadoop.hdfs.util.ReadOnlyList;

@InterfaceAudience.Private
public class Snapshot
implements Comparable<byte[]> {
    public static final int INVALID_ID = -1;
    private static final String DEFAULT_SNAPSHOT_NAME_PATTERN = "'s'yyyyMMdd-HHmmss.SSS";
    public static final Comparator<Snapshot> ID_COMPARATOR = new Comparator<Snapshot>(){

        @Override
        public int compare(Snapshot left, Snapshot right) {
            return ID_INTEGER_COMPARATOR.compare(left == null ? null : Integer.valueOf(left.getId()), right == null ? null : Integer.valueOf(right.getId()));
        }
    };
    public static final Comparator<Integer> ID_INTEGER_COMPARATOR = new Comparator<Integer>(){

        @Override
        public int compare(Integer left, Integer right) {
            if (left == null) {
                return right == null ? 0 : 1;
            }
            return right == null ? -1 : left - right;
        }
    };
    private final int id;
    private final Root root;

    public static String generateDefaultSnapshotName() {
        return new SimpleDateFormat(DEFAULT_SNAPSHOT_NAME_PATTERN).format(new Date());
    }

    public static String getSnapshotPath(String snapshottableDir, String snapshotRelativePath) {
        StringBuilder b = new StringBuilder(snapshottableDir);
        if (b.charAt(b.length() - 1) != '/') {
            b.append("/");
        }
        return b.append(".snapshot").append("/").append(snapshotRelativePath).toString();
    }

    static String getSnapshotName(Snapshot s2) {
        return s2 != null ? s2.getRoot().getLocalName() : "";
    }

    public static Snapshot findLatestSnapshot(INode inode, Snapshot anchor) {
        Snapshot latest = null;
        while (inode != null) {
            INodeDirectory dir;
            if (inode.isDirectory() && (dir = inode.asDirectory()) instanceof INodeDirectoryWithSnapshot) {
                latest = ((INodeDirectoryWithSnapshot)dir).getDiffs().updatePrior(anchor, latest);
            }
            inode = inode.getParent();
        }
        return latest;
    }

    static Snapshot read(DataInput in, FSImageFormat.Loader loader) throws IOException {
        int snapshotId = in.readInt();
        INode root2 = loader.loadINodeWithLocalName(false, in, false);
        return new Snapshot(snapshotId, root2.asDirectory(), null);
    }

    Snapshot(int id, String name, INodeDirectorySnapshottable dir) {
        this(id, dir, dir);
        this.root.setLocalName(DFSUtil.string2Bytes(name));
    }

    Snapshot(int id, INodeDirectory dir, INodeDirectorySnapshottable parent) {
        this.id = id;
        this.root = new Root(dir);
        this.root.setParent(parent);
    }

    public int getId() {
        return this.id;
    }

    public Root getRoot() {
        return this.root;
    }

    @Override
    public int compareTo(byte[] bytes) {
        return this.root.compareTo(bytes);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof Snapshot)) {
            return false;
        }
        return this.id == ((Snapshot)that).id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "." + this.root.getLocalName() + "(id=" + this.id + ")";
    }

    void write(DataOutput out) throws IOException {
        out.writeInt(this.id);
        FSImageSerialization.writeINodeDirectory(this.root, out);
    }

    public static class Root
    extends INodeDirectory {
        Root(INodeDirectory other) {
            super(other, false);
        }

        @Override
        public ReadOnlyList<INode> getChildrenList(Snapshot snapshot) {
            return this.getParent().getChildrenList(snapshot);
        }

        @Override
        public INode getChild(byte[] name, Snapshot snapshot) {
            return this.getParent().getChild(name, snapshot);
        }

        @Override
        public String getFullPathName() {
            return Snapshot.getSnapshotPath(this.getParent().getFullPathName(), this.getLocalName());
        }
    }
}

