/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.NamenodeJspHelper;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ServletUtil;

@InterfaceAudience.Private
public class FileDataServlet
extends DfsServlet {
    private static final long serialVersionUID = 1L;

    private URL createRedirectURL(String path, String encodedPath, HdfsFileStatus status, UserGroupInformation ugi, ClientProtocol nnproxy, HttpServletRequest request, String dt) throws IOException {
        Integer portObject;
        Configuration conf;
        String scheme = request.getScheme();
        LocatedBlocks blks = nnproxy.getBlockLocations(status.getFullPath(new Path(path)).toUri().getPath(), 0L, 1L);
        DatanodeID host = this.pickSrcDatanode(blks, status, conf = NameNodeHttpServer.getConfFromContext(this.getServletContext()));
        String hostname = host instanceof DatanodeInfo ? ((DatanodeInfo)host).getHostName() : host.getIpAddr();
        int port = host.getInfoPort();
        if ("https".equals(scheme) && (portObject = (Integer)this.getServletContext().getAttribute("datanode.https.port")) != null) {
            port = portObject;
        }
        String dtParam = "";
        if (dt != null) {
            dtParam = JspHelper.getDelegationTokenUrlParam(dt);
        }
        NameNode nn = NameNodeHttpServer.getNameNodeFromContext(this.getServletContext());
        String addr = nn.getNameNodeAddressHostPortString();
        String addrParam = JspHelper.getUrlParam("nnaddr", addr);
        return new URL(scheme, hostname, port, "/streamFile" + encodedPath + '?' + "ugi=" + ServletUtil.encodeQueryValue(ugi.getShortUserName()) + dtParam + addrParam);
    }

    private DatanodeID pickSrcDatanode(LocatedBlocks blks, HdfsFileStatus i, Configuration conf) throws IOException {
        if (i.getLen() == 0L || blks.getLocatedBlocks().size() <= 0) {
            NameNode nn = NameNodeHttpServer.getNameNodeFromContext(this.getServletContext());
            return NamenodeJspHelper.getRandomDatanode(nn);
        }
        return JspHelper.bestNode(blks, conf);
    }

    @Override
    public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws IOException {
        Configuration conf = NameNodeHttpServer.getConfFromContext(this.getServletContext());
        final UserGroupInformation ugi = this.getUGI(request, conf);
        try {
            ugi.doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    ClientProtocol nn = FileDataServlet.this.createNameNodeProxy();
                    String path = ServletUtil.getDecodedPath(request, "/data");
                    String encodedPath = ServletUtil.getRawPath(request, "/data");
                    String delegationToken = request.getParameter("delegation");
                    HdfsFileStatus info = nn.getFileInfo(path);
                    if (info != null && !info.isDir()) {
                        response.sendRedirect(FileDataServlet.this.createRedirectURL(path, encodedPath, info, ugi, nn, request, delegationToken).toString());
                    } else if (info == null) {
                        response.sendError(400, "File not found " + path);
                    } else {
                        response.sendError(400, path + ": is a directory");
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            response.sendError(400, e.getMessage());
        }
        catch (InterruptedException e) {
            response.sendError(400, e.getMessage());
        }
    }
}

