/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;

public class FinalizedReplica
extends ReplicaInfo {
    private boolean unlinked;

    public FinalizedReplica(long blockId, long len, long genStamp, FsVolumeSpi vol, File dir) {
        super(blockId, len, genStamp, vol, dir);
    }

    public FinalizedReplica(Block block, FsVolumeSpi vol, File dir) {
        super(block, vol, dir);
    }

    public FinalizedReplica(FinalizedReplica from2) {
        super(from2);
        this.unlinked = from2.isUnlinked();
    }

    @Override
    public HdfsServerConstants.ReplicaState getState() {
        return HdfsServerConstants.ReplicaState.FINALIZED;
    }

    @Override
    public boolean isUnlinked() {
        return this.unlinked;
    }

    @Override
    public void setUnlinked() {
        this.unlinked = true;
    }

    @Override
    public long getVisibleLength() {
        return this.getNumBytes();
    }

    @Override
    public long getBytesOnDisk() {
        return this.getNumBytes();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + "\n  unlinked          =" + this.unlinked;
    }
}

