/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.spark-project.guava.collect.Lists;
import org.spark-project.guava.collect.Maps;

class PendingDataNodeMessages {
    Map<Block, Queue<ReportedBlockInfo>> queueByBlockId = Maps.newHashMap();
    private int count = 0;

    PendingDataNodeMessages() {
    }

    void enqueueReportedBlock(DatanodeDescriptor dn, Block block, HdfsServerConstants.ReplicaState reportedState) {
        block = new Block(block);
        this.getBlockQueue(block).add(new ReportedBlockInfo(dn, block, reportedState));
        ++this.count;
    }

    Queue<ReportedBlockInfo> takeBlockQueue(Block block) {
        Queue<ReportedBlockInfo> queue = this.queueByBlockId.remove(block);
        if (queue != null) {
            this.count -= queue.size();
        }
        return queue;
    }

    private Queue<ReportedBlockInfo> getBlockQueue(Block block) {
        LinkedList queue = this.queueByBlockId.get(block);
        if (queue == null) {
            queue = Lists.newLinkedList();
            this.queueByBlockId.put(block, queue);
        }
        return queue;
    }

    public int count() {
        return this.count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Block, Queue<ReportedBlockInfo>> entry2 : this.queueByBlockId.entrySet()) {
            sb.append("Block " + entry2.getKey() + ":\n");
            for (ReportedBlockInfo rbi : entry2.getValue()) {
                sb.append("  ").append(rbi).append("\n");
            }
        }
        return sb.toString();
    }

    public Iterable<ReportedBlockInfo> takeAll() {
        ArrayList rbis = Lists.newArrayListWithCapacity((int)this.count);
        for (Queue<ReportedBlockInfo> q : this.queueByBlockId.values()) {
            rbis.addAll(q);
        }
        this.queueByBlockId.clear();
        this.count = 0;
        return rbis;
    }

    static class ReportedBlockInfo {
        private final Block block;
        private final DatanodeDescriptor dn;
        private final HdfsServerConstants.ReplicaState reportedState;

        ReportedBlockInfo(DatanodeDescriptor dn, Block block, HdfsServerConstants.ReplicaState reportedState) {
            this.dn = dn;
            this.block = block;
            this.reportedState = reportedState;
        }

        Block getBlock() {
            return this.block;
        }

        DatanodeDescriptor getNode() {
            return this.dn;
        }

        HdfsServerConstants.ReplicaState getReportedState() {
            return this.reportedState;
        }

        public String toString() {
            return "ReportedBlockInfo [block=" + this.block + ", dn=" + this.dn + ", reportedState=" + (Object)((Object)this.reportedState) + "]";
        }
    }
}

