/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.datatransfer.Op;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class Receiver
implements DataTransferProtocol {
    protected DataInputStream in;

    protected void initialize(DataInputStream in) {
        this.in = in;
    }

    protected final Op readOp() throws IOException {
        short version = this.in.readShort();
        if (version != 28) {
            throw new IOException("Version Mismatch (Expected: 28, Received: " + version + " )");
        }
        return Op.read(this.in);
    }

    protected final void processOp(Op op) throws IOException {
        switch (op) {
            case READ_BLOCK: {
                this.opReadBlock();
                break;
            }
            case WRITE_BLOCK: {
                this.opWriteBlock(this.in);
                break;
            }
            case REPLACE_BLOCK: {
                this.opReplaceBlock(this.in);
                break;
            }
            case COPY_BLOCK: {
                this.opCopyBlock(this.in);
                break;
            }
            case BLOCK_CHECKSUM: {
                this.opBlockChecksum(this.in);
                break;
            }
            case TRANSFER_BLOCK: {
                this.opTransferBlock(this.in);
                break;
            }
            case REQUEST_SHORT_CIRCUIT_FDS: {
                this.opRequestShortCircuitFds(this.in);
                break;
            }
            default: {
                throw new IOException("Unknown op " + (Object)((Object)op) + " in data stream");
            }
        }
    }

    private static CachingStrategy getCachingStrategy(DataTransferProtos.CachingStrategyProto strategy) {
        Boolean dropBehind = strategy.hasDropBehind() ? Boolean.valueOf(strategy.getDropBehind()) : null;
        Long readahead = strategy.hasReadahead() ? Long.valueOf(strategy.getReadahead()) : null;
        return new CachingStrategy(dropBehind, readahead);
    }

    private void opReadBlock() throws IOException {
        DataTransferProtos.OpReadBlockProto proto = DataTransferProtos.OpReadBlockProto.parseFrom(PBHelper.vintPrefixed(this.in));
        this.readBlock(PBHelper.convert(proto.getHeader().getBaseHeader().getBlock()), PBHelper.convert(proto.getHeader().getBaseHeader().getToken()), proto.getHeader().getClientName(), proto.getOffset(), proto.getLen(), proto.getSendChecksums(), proto.hasCachingStrategy() ? Receiver.getCachingStrategy(proto.getCachingStrategy()) : CachingStrategy.newDefaultStrategy());
    }

    private void opWriteBlock(DataInputStream in) throws IOException {
        DataTransferProtos.OpWriteBlockProto proto = DataTransferProtos.OpWriteBlockProto.parseFrom(PBHelper.vintPrefixed(in));
        this.writeBlock(PBHelper.convert(proto.getHeader().getBaseHeader().getBlock()), PBHelper.convert(proto.getHeader().getBaseHeader().getToken()), proto.getHeader().getClientName(), PBHelper.convert(proto.getTargetsList()), PBHelper.convert(proto.getSource()), DataTransferProtoUtil.fromProto(proto.getStage()), proto.getPipelineSize(), proto.getMinBytesRcvd(), proto.getMaxBytesRcvd(), proto.getLatestGenerationStamp(), DataTransferProtoUtil.fromProto(proto.getRequestedChecksum()), proto.hasCachingStrategy() ? Receiver.getCachingStrategy(proto.getCachingStrategy()) : CachingStrategy.newDefaultStrategy());
    }

    private void opTransferBlock(DataInputStream in) throws IOException {
        DataTransferProtos.OpTransferBlockProto proto = DataTransferProtos.OpTransferBlockProto.parseFrom(PBHelper.vintPrefixed(in));
        this.transferBlock(PBHelper.convert(proto.getHeader().getBaseHeader().getBlock()), PBHelper.convert(proto.getHeader().getBaseHeader().getToken()), proto.getHeader().getClientName(), PBHelper.convert(proto.getTargetsList()));
    }

    private void opRequestShortCircuitFds(DataInputStream in) throws IOException {
        DataTransferProtos.OpRequestShortCircuitAccessProto proto = DataTransferProtos.OpRequestShortCircuitAccessProto.parseFrom(PBHelper.vintPrefixed(in));
        this.requestShortCircuitFds(PBHelper.convert(proto.getHeader().getBlock()), PBHelper.convert(proto.getHeader().getToken()), proto.getMaxVersion());
    }

    private void opReplaceBlock(DataInputStream in) throws IOException {
        DataTransferProtos.OpReplaceBlockProto proto = DataTransferProtos.OpReplaceBlockProto.parseFrom(PBHelper.vintPrefixed(in));
        this.replaceBlock(PBHelper.convert(proto.getHeader().getBlock()), PBHelper.convert(proto.getHeader().getToken()), proto.getDelHint(), PBHelper.convert(proto.getSource()));
    }

    private void opCopyBlock(DataInputStream in) throws IOException {
        DataTransferProtos.OpCopyBlockProto proto = DataTransferProtos.OpCopyBlockProto.parseFrom(PBHelper.vintPrefixed(in));
        this.copyBlock(PBHelper.convert(proto.getHeader().getBlock()), PBHelper.convert(proto.getHeader().getToken()));
    }

    private void opBlockChecksum(DataInputStream in) throws IOException {
        DataTransferProtos.OpBlockChecksumProto proto = DataTransferProtos.OpBlockChecksumProto.parseFrom(PBHelper.vintPrefixed(in));
        this.blockChecksum(PBHelper.convert(proto.getHeader().getBlock()), PBHelper.convert(proto.getHeader().getToken()));
    }
}

