/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.FailoverFailedException;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceProtocolHelper;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ipc.RPC;
import org.spark-project.guava.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FailoverController {
    private static final Log LOG = LogFactory.getLog(FailoverController.class);
    private final int gracefulFenceTimeout;
    private final int rpcTimeoutToNewActive;
    private final Configuration conf;
    private final Configuration gracefulFenceConf;
    private final HAServiceProtocol.RequestSource requestSource;

    public FailoverController(Configuration conf, HAServiceProtocol.RequestSource source) {
        this.conf = conf;
        this.gracefulFenceConf = new Configuration(conf);
        this.requestSource = source;
        this.gracefulFenceTimeout = FailoverController.getGracefulFenceTimeout(conf);
        this.rpcTimeoutToNewActive = FailoverController.getRpcTimeoutToNewActive(conf);
        int gracefulFenceConnectRetries = conf.getInt("ha.failover-controller.graceful-fence.connection.retries", 1);
        this.gracefulFenceConf.setInt("ipc.client.connect.max.retries", gracefulFenceConnectRetries);
        this.gracefulFenceConf.setInt("ipc.client.connect.max.retries.on.timeouts", gracefulFenceConnectRetries);
    }

    static int getGracefulFenceTimeout(Configuration conf) {
        return conf.getInt("ha.failover-controller.graceful-fence.rpc-timeout.ms", 5000);
    }

    static int getRpcTimeoutToNewActive(Configuration conf) {
        return conf.getInt("ha.failover-controller.new-active.rpc-timeout.ms", 60000);
    }

    private void preFailoverChecks(HAServiceTarget from2, HAServiceTarget target, boolean forceActive) throws FailoverFailedException {
        HAServiceStatus toSvcStatus;
        HAServiceProtocol toSvc;
        if (from2.getAddress().equals(target.getAddress())) {
            throw new FailoverFailedException("Can't failover a service to itself");
        }
        try {
            toSvc = target.getProxy(this.conf, this.rpcTimeoutToNewActive);
            toSvcStatus = toSvc.getServiceStatus();
        }
        catch (IOException e) {
            String msg = "Unable to get service state for " + target;
            LOG.error((Object)(msg + ": " + e.getLocalizedMessage()));
            throw new FailoverFailedException(msg, e);
        }
        if (!toSvcStatus.getState().equals((Object)HAServiceProtocol.HAServiceState.STANDBY)) {
            throw new FailoverFailedException("Can't failover to an active service");
        }
        if (!toSvcStatus.isReadyToBecomeActive()) {
            String notReadyReason = toSvcStatus.getNotReadyReason();
            if (!forceActive) {
                throw new FailoverFailedException(target + " is not ready to become active: " + notReadyReason);
            }
            LOG.warn((Object)("Service is not ready to become active, but forcing: " + notReadyReason));
        }
        try {
            HAServiceProtocolHelper.monitorHealth(toSvc, this.createReqInfo());
        }
        catch (HealthCheckFailedException hce) {
            throw new FailoverFailedException("Can't failover to an unhealthy service", hce);
        }
        catch (IOException e) {
            throw new FailoverFailedException("Got an IO exception", e);
        }
    }

    private HAServiceProtocol.StateChangeRequestInfo createReqInfo() {
        return new HAServiceProtocol.StateChangeRequestInfo(this.requestSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean tryGracefulFence(HAServiceTarget svc) {
        boolean bl;
        HAServiceProtocol proxy = null;
        try {
            proxy = svc.getProxy(this.gracefulFenceConf, this.gracefulFenceTimeout);
            proxy.transitionToStandby(this.createReqInfo());
            bl = true;
            if (proxy == null) return bl;
        }
        catch (ServiceFailedException sfe) {
            LOG.warn((Object)("Unable to gracefully make " + svc + " standby (" + sfe.getMessage() + ")"));
            if (proxy == null) return false;
            RPC.stopProxy(proxy);
            return false;
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Unable to gracefully make " + svc + " standby (unable to connect)"), (Throwable)ioe);
            if (proxy == null) return false;
            {
                catch (Throwable throwable) {
                    if (proxy == null) throw throwable;
                    RPC.stopProxy(proxy);
                    throw throwable;
                }
            }
            RPC.stopProxy(proxy);
            return false;
        }
        RPC.stopProxy(proxy);
        return bl;
    }

    public void failover(HAServiceTarget fromSvc, HAServiceTarget toSvc, boolean forceFence, boolean forceActive) throws FailoverFailedException {
        Preconditions.checkArgument((fromSvc.getFencer() != null ? 1 : 0) != 0, (Object)"failover requires a fencer");
        this.preFailoverChecks(fromSvc, toSvc, forceActive);
        boolean tryFence = true;
        if (this.tryGracefulFence(fromSvc)) {
            tryFence = forceFence;
        }
        if (tryFence && !fromSvc.getFencer().fence(fromSvc)) {
            throw new FailoverFailedException("Unable to fence " + fromSvc + ". Fencing failed.");
        }
        boolean failed2 = false;
        IOException cause = null;
        try {
            HAServiceProtocolHelper.transitionToActive(toSvc.getProxy(this.conf, this.rpcTimeoutToNewActive), this.createReqInfo());
        }
        catch (ServiceFailedException sfe) {
            LOG.error((Object)("Unable to make " + toSvc + " active (" + sfe.getMessage() + "). Failing back."));
            failed2 = true;
            cause = sfe;
        }
        catch (IOException ioe) {
            LOG.error((Object)("Unable to make " + toSvc + " active (unable to connect). Failing back."), (Throwable)ioe);
            failed2 = true;
            cause = ioe;
        }
        if (failed2) {
            String msg = "Unable to failover to " + toSvc;
            if (!tryFence) {
                try {
                    this.failover(toSvc, fromSvc, true, true);
                }
                catch (FailoverFailedException ffe) {
                    msg = msg + ". Failback to " + fromSvc + " failed (" + ffe.getMessage() + ")";
                    LOG.fatal((Object)msg);
                }
            }
            throw new FailoverFailedException(msg, cause);
        }
    }
}

