/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.linear.AbstractRealVector;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.OpenMapRealMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SparseRealVector;
import org.apache.commons.math.util.OpenIntToDoubleHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMapRealVector
extends AbstractRealVector
implements SparseRealVector,
Serializable {
    public static final double DEFAULT_ZERO_TOLERANCE = 1.0E-12;
    private static final long serialVersionUID = 8772222695580707260L;
    private final OpenIntToDoubleHashMap entries;
    private final int virtualSize;
    private double epsilon;

    public OpenMapRealVector() {
        this(0, 1.0E-12);
    }

    public OpenMapRealVector(int dimension) {
        this(dimension, 1.0E-12);
    }

    public OpenMapRealVector(int dimension, double epsilon) {
        this.virtualSize = dimension;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = epsilon;
    }

    protected OpenMapRealVector(OpenMapRealVector v, int resize2) {
        this.virtualSize = v.getDimension() + resize2;
        this.entries = new OpenIntToDoubleHashMap(v.entries);
        this.epsilon = v.epsilon;
    }

    public OpenMapRealVector(int dimension, int expectedSize) {
        this(dimension, expectedSize, 1.0E-12);
    }

    public OpenMapRealVector(int dimension, int expectedSize, double epsilon) {
        this.virtualSize = dimension;
        this.entries = new OpenIntToDoubleHashMap(expectedSize, 0.0);
        this.epsilon = epsilon;
    }

    public OpenMapRealVector(double[] values) {
        this(values, 1.0E-12);
    }

    public OpenMapRealVector(double[] values, double epsilon) {
        this.virtualSize = values.length;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = epsilon;
        for (int key = 0; key < values.length; ++key) {
            double value2 = values[key];
            if (this.isDefaultValue(value2)) continue;
            this.entries.put(key, value2);
        }
    }

    public OpenMapRealVector(Double[] values) {
        this(values, 1.0E-12);
    }

    public OpenMapRealVector(Double[] values, double epsilon) {
        this.virtualSize = values.length;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = epsilon;
        for (int key = 0; key < values.length; ++key) {
            double value2 = values[key];
            if (this.isDefaultValue(value2)) continue;
            this.entries.put(key, value2);
        }
    }

    public OpenMapRealVector(OpenMapRealVector v) {
        this.virtualSize = v.getDimension();
        this.entries = new OpenIntToDoubleHashMap(v.getEntries());
        this.epsilon = v.epsilon;
    }

    public OpenMapRealVector(RealVector v) {
        this.virtualSize = v.getDimension();
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = 1.0E-12;
        for (int key = 0; key < this.virtualSize; ++key) {
            double value2 = v.getEntry(key);
            if (this.isDefaultValue(value2)) continue;
            this.entries.put(key, value2);
        }
    }

    private OpenIntToDoubleHashMap getEntries() {
        return this.entries;
    }

    protected boolean isDefaultValue(double value2) {
        return Math.abs(value2) < this.epsilon;
    }

    @Override
    public RealVector add(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        if (v instanceof OpenMapRealVector) {
            return this.add((OpenMapRealVector)v);
        }
        return super.add(v);
    }

    public OpenMapRealVector add(OpenMapRealVector v) throws IllegalArgumentException {
        OpenIntToDoubleHashMap randomAccess;
        this.checkVectorDimensions(v.getDimension());
        boolean copyThis = this.entries.size() > v.entries.size();
        OpenMapRealVector res = copyThis ? this.copy() : v.copy();
        OpenIntToDoubleHashMap.Iterator iter2 = copyThis ? v.entries.iterator() : this.entries.iterator();
        OpenIntToDoubleHashMap openIntToDoubleHashMap = randomAccess = copyThis ? this.entries : v.entries;
        while (iter2.hasNext()) {
            iter2.advance();
            int key = iter2.key();
            if (randomAccess.containsKey(key)) {
                res.setEntry(key, randomAccess.get(key) + iter2.value());
                continue;
            }
            res.setEntry(key, iter2.value());
        }
        return res;
    }

    public OpenMapRealVector append(OpenMapRealVector v) {
        OpenMapRealVector res = new OpenMapRealVector(this, v.getDimension());
        OpenIntToDoubleHashMap.Iterator iter2 = v.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            res.setEntry(iter2.key() + this.virtualSize, iter2.value());
        }
        return res;
    }

    @Override
    public OpenMapRealVector append(RealVector v) {
        if (v instanceof OpenMapRealVector) {
            return this.append((OpenMapRealVector)v);
        }
        return this.append(v.getData());
    }

    @Override
    public OpenMapRealVector append(double d) {
        OpenMapRealVector res = new OpenMapRealVector(this, 1);
        res.setEntry(this.virtualSize, d);
        return res;
    }

    @Override
    public OpenMapRealVector append(double[] a) {
        OpenMapRealVector res = new OpenMapRealVector(this, a.length);
        for (int i = 0; i < a.length; ++i) {
            res.setEntry(i + this.virtualSize, a[i]);
        }
        return res;
    }

    @Override
    public OpenMapRealVector copy() {
        return new OpenMapRealVector(this);
    }

    public double dotProduct(OpenMapRealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        boolean thisIsSmaller = this.entries.size() < v.entries.size();
        OpenIntToDoubleHashMap.Iterator iter2 = thisIsSmaller ? this.entries.iterator() : v.entries.iterator();
        OpenIntToDoubleHashMap larger = thisIsSmaller ? v.entries : this.entries;
        double d = 0.0;
        while (iter2.hasNext()) {
            iter2.advance();
            d += iter2.value() * larger.get(iter2.key());
        }
        return d;
    }

    @Override
    public double dotProduct(RealVector v) throws IllegalArgumentException {
        if (v instanceof OpenMapRealVector) {
            return this.dotProduct((OpenMapRealVector)v);
        }
        return super.dotProduct(v);
    }

    @Override
    public OpenMapRealVector ebeDivide(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        OpenMapRealVector res = new OpenMapRealVector(this);
        OpenIntToDoubleHashMap.Iterator iter2 = res.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            res.setEntry(iter2.key(), iter2.value() / v.getEntry(iter2.key()));
        }
        return res;
    }

    @Override
    public OpenMapRealVector ebeDivide(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        OpenMapRealVector res = new OpenMapRealVector(this);
        OpenIntToDoubleHashMap.Iterator iter2 = res.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            res.setEntry(iter2.key(), iter2.value() / v[iter2.key()]);
        }
        return res;
    }

    @Override
    public OpenMapRealVector ebeMultiply(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        OpenMapRealVector res = new OpenMapRealVector(this);
        OpenIntToDoubleHashMap.Iterator iter2 = res.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            res.setEntry(iter2.key(), iter2.value() * v.getEntry(iter2.key()));
        }
        return res;
    }

    @Override
    public OpenMapRealVector ebeMultiply(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        OpenMapRealVector res = new OpenMapRealVector(this);
        OpenIntToDoubleHashMap.Iterator iter2 = res.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            res.setEntry(iter2.key(), iter2.value() * v[iter2.key()]);
        }
        return res;
    }

    @Override
    public OpenMapRealVector getSubVector(int index2, int n) throws MatrixIndexException {
        this.checkIndex(index2);
        this.checkIndex(index2 + n - 1);
        OpenMapRealVector res = new OpenMapRealVector(n);
        int end = index2 + n;
        OpenIntToDoubleHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            int key = iter2.key();
            if (key < index2 || key >= end) continue;
            res.setEntry(key - index2, iter2.value());
        }
        return res;
    }

    @Override
    public double[] getData() {
        double[] res = new double[this.virtualSize];
        OpenIntToDoubleHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            res[iter2.key()] = iter2.value();
        }
        return res;
    }

    @Override
    public int getDimension() {
        return this.virtualSize;
    }

    public double getDistance(OpenMapRealVector v) throws IllegalArgumentException {
        int key;
        OpenIntToDoubleHashMap.Iterator iter2 = this.entries.iterator();
        double res = 0.0;
        while (iter2.hasNext()) {
            iter2.advance();
            key = iter2.key();
            double delta = iter2.value() - v.getEntry(key);
            res += delta * delta;
        }
        iter2 = v.getEntries().iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            key = iter2.key();
            if (this.entries.containsKey(key)) continue;
            double value2 = iter2.value();
            res += value2 * value2;
        }
        return Math.sqrt(res);
    }

    @Override
    public double getDistance(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        if (v instanceof OpenMapRealVector) {
            return this.getDistance((OpenMapRealVector)v);
        }
        return this.getDistance(v.getData());
    }

    @Override
    public double getDistance(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double res = 0.0;
        for (int i = 0; i < v.length; ++i) {
            double delta = this.entries.get(i) - v[i];
            res += delta * delta;
        }
        return Math.sqrt(res);
    }

    @Override
    public double getEntry(int index2) throws MatrixIndexException {
        this.checkIndex(index2);
        return this.entries.get(index2);
    }

    public double getL1Distance(OpenMapRealVector v) {
        double max2 = 0.0;
        OpenIntToDoubleHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            double delta = Math.abs(iter2.value() - v.getEntry(iter2.key()));
            max2 += delta;
        }
        iter2 = v.getEntries().iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            int key = iter2.key();
            if (this.entries.containsKey(key)) continue;
            double delta = Math.abs(iter2.value());
            max2 += Math.abs(delta);
        }
        return max2;
    }

    @Override
    public double getL1Distance(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        if (v instanceof OpenMapRealVector) {
            return this.getL1Distance((OpenMapRealVector)v);
        }
        return this.getL1Distance(v.getData());
    }

    @Override
    public double getL1Distance(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double max2 = 0.0;
        for (int i = 0; i < v.length; ++i) {
            double delta = Math.abs(this.getEntry(i) - v[i]);
            max2 += delta;
        }
        return max2;
    }

    private double getLInfDistance(OpenMapRealVector v) {
        double max2 = 0.0;
        OpenIntToDoubleHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            double delta = Math.abs(iter2.value() - v.getEntry(iter2.key()));
            if (!(delta > max2)) continue;
            max2 = delta;
        }
        iter2 = v.getEntries().iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            int key = iter2.key();
            if (this.entries.containsKey(key) || !(iter2.value() > max2)) continue;
            max2 = iter2.value();
        }
        return max2;
    }

    @Override
    public double getLInfDistance(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        if (v instanceof OpenMapRealVector) {
            return this.getLInfDistance((OpenMapRealVector)v);
        }
        return this.getLInfDistance(v.getData());
    }

    @Override
    public double getLInfDistance(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        double max2 = 0.0;
        for (int i = 0; i < v.length; ++i) {
            double delta = Math.abs(this.getEntry(i) - v[i]);
            if (!(delta > max2)) continue;
            max2 = delta;
        }
        return max2;
    }

    @Override
    public boolean isInfinite() {
        boolean infiniteFound = false;
        OpenIntToDoubleHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            double value2 = iter2.value();
            if (Double.isNaN(value2)) {
                return false;
            }
            if (!Double.isInfinite(value2)) continue;
            infiniteFound = true;
        }
        return infiniteFound;
    }

    @Override
    public boolean isNaN() {
        OpenIntToDoubleHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            if (!Double.isNaN(iter2.value())) continue;
            return true;
        }
        return false;
    }

    @Override
    public OpenMapRealVector mapAdd(double d) {
        return this.copy().mapAddToSelf(d);
    }

    @Override
    public OpenMapRealVector mapAddToSelf(double d) {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, this.getEntry(i) + d);
        }
        return this;
    }

    @Override
    public RealMatrix outerProduct(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        OpenMapRealMatrix res = new OpenMapRealMatrix(this.virtualSize, this.virtualSize);
        OpenIntToDoubleHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            int row = iter2.key();
            double value2 = iter2.value();
            for (int col = 0; col < this.virtualSize; ++col) {
                res.setEntry(row, col, value2 * v[col]);
            }
        }
        return res;
    }

    @Override
    public RealVector projection(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        return v.mapMultiply(this.dotProduct(v) / v.dotProduct(v));
    }

    @Override
    public OpenMapRealVector projection(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        return (OpenMapRealVector)this.projection(new OpenMapRealVector(v));
    }

    @Override
    public void setEntry(int index2, double value2) throws MatrixIndexException {
        this.checkIndex(index2);
        if (!this.isDefaultValue(value2)) {
            this.entries.put(index2, value2);
        } else if (this.entries.containsKey(index2)) {
            this.entries.remove(index2);
        }
    }

    @Override
    public void setSubVector(int index2, RealVector v) throws MatrixIndexException {
        this.checkIndex(index2);
        this.checkIndex(index2 + v.getDimension() - 1);
        this.setSubVector(index2, v.getData());
    }

    @Override
    public void setSubVector(int index2, double[] v) throws MatrixIndexException {
        this.checkIndex(index2);
        this.checkIndex(index2 + v.length - 1);
        for (int i = 0; i < v.length; ++i) {
            this.setEntry(i + index2, v[i]);
        }
    }

    @Override
    public void set(double value2) {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, value2);
        }
    }

    public OpenMapRealVector subtract(OpenMapRealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        OpenMapRealVector res = this.copy();
        OpenIntToDoubleHashMap.Iterator iter2 = v.getEntries().iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            int key = iter2.key();
            if (this.entries.containsKey(key)) {
                res.setEntry(key, this.entries.get(key) - iter2.value());
                continue;
            }
            res.setEntry(key, -iter2.value());
        }
        return res;
    }

    @Override
    public OpenMapRealVector subtract(RealVector v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        if (v instanceof OpenMapRealVector) {
            return this.subtract((OpenMapRealVector)v);
        }
        return this.subtract(v.getData());
    }

    @Override
    public OpenMapRealVector subtract(double[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        OpenMapRealVector res = new OpenMapRealVector(this);
        for (int i = 0; i < v.length; ++i) {
            if (this.entries.containsKey(i)) {
                res.setEntry(i, this.entries.get(i) - v[i]);
                continue;
            }
            res.setEntry(i, -v[i]);
        }
        return res;
    }

    @Override
    public OpenMapRealVector unitVector() {
        OpenMapRealVector res = this.copy();
        res.unitize();
        return res;
    }

    @Override
    public void unitize() {
        double norm = this.getNorm();
        if (this.isDefaultValue(norm)) {
            throw MathRuntimeException.createArithmeticException("cannot normalize a zero norm vector", new Object[0]);
        }
        OpenIntToDoubleHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            this.entries.put(iter2.key(), iter2.value() / norm);
        }
    }

    @Override
    public double[] toArray() {
        return this.getData();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        long temp = Double.doubleToLongBits(this.epsilon);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        result2 = 31 * result2 + this.virtualSize;
        OpenIntToDoubleHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            temp = Double.doubleToLongBits(iter2.value());
            result2 = 31 * result2 + (int)(temp ^ temp >> 32);
        }
        return result2;
    }

    public boolean equals(Object obj) {
        double test;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OpenMapRealVector)) {
            return false;
        }
        OpenMapRealVector other = (OpenMapRealVector)obj;
        if (this.virtualSize != other.virtualSize) {
            return false;
        }
        if (Double.doubleToLongBits(this.epsilon) != Double.doubleToLongBits(other.epsilon)) {
            return false;
        }
        OpenIntToDoubleHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            test = other.getEntry(iter2.key());
            if (Double.doubleToLongBits(test) == Double.doubleToLongBits(iter2.value())) continue;
            return false;
        }
        iter2 = other.getEntries().iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            test = iter2.value();
            if (Double.doubleToLongBits(test) == Double.doubleToLongBits(this.getEntry(iter2.key()))) continue;
            return false;
        }
        return true;
    }

    public double getSparcity() {
        return (double)this.entries.size() / (double)this.getDimension();
    }

    @Override
    public Iterator<RealVector.Entry> sparseIterator() {
        return new OpenMapSparseIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OpenMapSparseIterator
    implements Iterator<RealVector.Entry> {
        private final OpenIntToDoubleHashMap.Iterator iter;
        private final RealVector.Entry current;

        protected OpenMapSparseIterator() {
            this.iter = OpenMapRealVector.this.entries.iterator();
            this.current = new OpenMapEntry(this.iter);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public RealVector.Entry next() {
            this.iter.advance();
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    protected class OpenMapEntry
    extends RealVector.Entry {
        private final OpenIntToDoubleHashMap.Iterator iter;

        protected OpenMapEntry(OpenIntToDoubleHashMap.Iterator iter2) {
            this.iter = iter2;
        }

        public double getValue() {
            return this.iter.value();
        }

        public void setValue(double value2) {
            OpenMapRealVector.this.entries.put(this.iter.key(), value2);
        }

        public int getIndex() {
            return this.iter.key();
        }
    }
}

