/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree.xpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.xpath.ConfigurationNodeIteratorBase;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.lang.StringUtils;

class ConfigurationNodeIteratorChildren
extends ConfigurationNodeIteratorBase {
    public ConfigurationNodeIteratorChildren(NodePointer parent, NodeTest nodeTest, boolean reverse2, NodePointer startsWith2) {
        super(parent, reverse2);
        ConfigurationNode root2 = (ConfigurationNode)parent.getNode();
        List childNodes = this.createSubNodeList(root2, nodeTest);
        this.initSubNodeList(childNodes);
        if (startsWith2 != null) {
            this.setStartOffset(this.findStartIndex(root2, (ConfigurationNode)startsWith2.getNode()));
        }
    }

    protected List createSubNodeList(ConfigurationNode node, NodeTest test) {
        NodeTypeTest typeTest;
        List children = node.getChildren();
        if (test == null) {
            return children;
        }
        if (test instanceof NodeNameTest) {
            NodeNameTest nameTest = (NodeNameTest)test;
            QName name = nameTest.getNodeName();
            if (name.getPrefix() == null) {
                if (nameTest.isWildcard()) {
                    return children;
                }
                ArrayList<ConfigurationNode> result2 = new ArrayList<ConfigurationNode>();
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    ConfigurationNode child = (ConfigurationNode)it.next();
                    if (!StringUtils.equals(name.getName(), child.getName())) continue;
                    result2.add(child);
                }
                return result2;
            }
        } else if (test instanceof NodeTypeTest && ((typeTest = (NodeTypeTest)test).getNodeType() == 1 || typeTest.getNodeType() == 2)) {
            return children;
        }
        return Collections.EMPTY_LIST;
    }

    protected int findStartIndex(ConfigurationNode node, ConfigurationNode startNode) {
        for (int index2 = 0; index2 < node.getChildrenCount(); ++index2) {
            if (node.getChild(index2) != startNode) continue;
            return index2;
        }
        return -1;
    }
}

