/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class ShortArrayConverter
extends AbstractArrayConverter {
    private static short[] model = new short[0];

    public ShortArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public ShortArrayConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value2) {
        if (value2 == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == value2.getClass()) {
            return value2;
        }
        if (AbstractArrayConverter.strings.getClass() == value2.getClass()) {
            try {
                String[] values = (String[])value2;
                short[] results = new short[values.length];
                int i = 0;
                while (i < values.length) {
                    results[i] = Short.parseShort(values[i]);
                    ++i;
                }
                return results;
            }
            catch (Exception e) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(value2.toString(), e);
            }
        }
        try {
            List list2 = this.parseElements(value2.toString());
            short[] results = new short[list2.size()];
            int i = 0;
            while (i < results.length) {
                results[i] = Short.parseShort((String)list2.get(i));
                ++i;
            }
            return results;
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(value2.toString(), e);
        }
    }
}

