/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class ByteArrayConverter
extends AbstractArrayConverter {
    private static byte[] model = new byte[0];

    public ByteArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public ByteArrayConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value2) {
        if (value2 == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == value2.getClass()) {
            return value2;
        }
        if (AbstractArrayConverter.strings.getClass() == value2.getClass()) {
            try {
                String[] values = (String[])value2;
                byte[] results = new byte[values.length];
                int i = 0;
                while (i < values.length) {
                    results[i] = Byte.parseByte(values[i]);
                    ++i;
                }
                return results;
            }
            catch (Exception e) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(value2.toString(), e);
            }
        }
        try {
            List list2 = this.parseElements(value2.toString());
            byte[] results = new byte[list2.size()];
            int i = 0;
            while (i < results.length) {
                results[i] = Byte.parseByte((String)list2.get(i));
                ++i;
            }
            return results;
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(value2.toString(), e);
        }
    }
}

