/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.Serializable;
import kafka.admin.AdminOperationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.Cluster;
import kafka.common.KafkaException;
import kafka.common.NoEpochForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.consumer.TopicCount;
import kafka.consumer.TopicCount$;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReassignedPartitionsContext;
import kafka.controller.ReassignedPartitionsContext$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import kafka.utils.ZkUtils$$anonfun$getConsumersPerTopic$1$;
import kafka.utils.ZkUtils$$anonfun$getReplicaAssignmentForTopics$1$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcZI$sp;
import scala.collection.GenTraversable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ZkUtils$
implements Logging {
    public static final ZkUtils$ MODULE$;
    private final String ConsumersPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String TopicConfigPath;
    private final String TopicConfigChangesPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String ReassignPartitionsPath;
    private final String DeleteTopicsPath;
    private final String PreferredReplicaLeaderElectionPath;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ZkUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZkUtils$ zkUtils$ = this;
        synchronized (zkUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public String TopicConfigPath() {
        return this.TopicConfigPath;
    }

    public String TopicConfigChangesPath() {
        return this.TopicConfigChangesPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String ReassignPartitionsPath() {
        return this.ReassignPartitionsPath;
    }

    public String DeleteTopicsPath() {
        return this.DeleteTopicsPath;
    }

    public String PreferredReplicaLeaderElectionPath() {
        return this.PreferredReplicaLeaderElectionPath;
    }

    public String getTopicPath(String topic) {
        return new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public String getTopicPartitionsPath(String topic) {
        return new StringBuilder().append((Object)this.getTopicPath(topic)).append((Object)"/partitions").toString();
    }

    public String getTopicConfigPath(String topic) {
        return new StringBuilder().append((Object)this.TopicConfigPath()).append((Object)"/").append((Object)topic).toString();
    }

    public String getDeleteTopicPath(String topic) {
        return new StringBuilder().append((Object)this.DeleteTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public int getController(ZkClient zkClient) {
        Option<String> option = this.readDataMaybeNull(zkClient, this.ControllerPath())._1();
        if (option instanceof Some) {
            Some some = (Some)option;
            String controller = (String)some.x();
            int n = KafkaController$.MODULE$.parseControllerId(controller);
            return n;
        }
        None$ none$ = None$.MODULE$;
        Option<String> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new KafkaException("Controller doesn't exist");
        }
        throw new MatchError(option);
    }

    public String getTopicPartitionPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionsPath(topic)).append((Object)"/").append(BoxesRunTime.boxToInteger(partitionId)).toString();
    }

    public String getTopicPartitionLeaderAndIsrPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionPath(topic, partitionId)).append((Object)"/").append((Object)"state").toString();
    }

    public Seq<Object> getSortedBrokerList(ZkClient zkClient) {
        return (Seq)((SeqLike)this.getChildren(zkClient, this.BrokerIdsPath()).map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
            }
        }, Seq$.MODULE$.canBuildFrom())).sorted(Ordering$Int$.MODULE$);
    }

    public Seq<Broker> getAllBrokersInCluster(ZkClient zkClient) {
        Seq brokerIds = (Seq)this.getChildrenParentMayNotExist(zkClient, this.BrokerIdsPath()).sorted(Ordering$String$.MODULE$);
        return ((TraversableLike)((TraversableLike)((TraversableLike)brokerIds.map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
            }
        }, Seq$.MODULE$.canBuildFrom())).map(new scala.Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$4;

            public final Option<Broker> apply(int x$3) {
                return ZkUtils$.MODULE$.getBrokerInfo(this.zkClient$4, x$3);
            }
            {
                this.zkClient$4 = zkClient$4;
            }
        }, Seq$.MODULE$.canBuildFrom())).filter(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Broker> x$4) {
                return x$4.isDefined();
            }
        })).map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(Option<Broker> x$5) {
                return x$5.get();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Option<LeaderIsrAndControllerEpoch> getLeaderIsrAndEpochForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> option;
        block4: {
            Option option2;
            block3: {
                block2: {
                    String leaderAndIsrPath = this.getTopicPartitionLeaderAndIsrPath(topic, partition2);
                    Tuple2<Option<String>, Stat> leaderAndIsrInfo = this.readDataMaybeNull(zkClient, leaderAndIsrPath);
                    Option<String> leaderAndIsrOpt = leaderAndIsrInfo._1();
                    Stat stat = leaderAndIsrInfo._2();
                    option = leaderAndIsrOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String leaderAndIsrStr = (String)some.x();
                    option2 = this.parseLeaderAndIsr(leaderAndIsrStr, topic, partition2, stat);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public Option<LeaderAndIsr> getLeaderAndIsrForPartition(ZkClient zkClient, String topic, int partition2) {
        return this.getLeaderIsrAndEpochForPartition(zkClient, topic, partition2).map(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final LeaderAndIsr apply(LeaderIsrAndControllerEpoch x$6) {
                return x$6.leaderAndIsr();
            }
        });
    }

    public void setupCommonPaths(ZkClient zkClient) {
        ((IterableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ConsumersPath(), this.BrokerIdsPath(), this.BrokerTopicsPath(), this.TopicConfigChangesPath(), this.TopicConfigPath(), this.DeleteTopicsPath()}))).foreach(new scala.Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$8;

            public final void apply(String path) {
                ZkUtils$.MODULE$.makeSurePersistentPathExists(this.zkClient$8, path);
            }
            {
                this.zkClient$8 = zkClient$8;
            }
        });
    }

    public Option<LeaderIsrAndControllerEpoch> parseLeaderAndIsr(String leaderAndIsrStr, String topic, int partition2, Stat stat) {
        Option<Object> option;
        block4: {
            Option option2;
            block3: {
                block2: {
                    option = Json$.MODULE$.parseFull(leaderAndIsrStr);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Object m = some.x();
                    Map leaderIsrAndEpochInfo = (Map)m;
                    int leader = BoxesRunTime.unboxToInt(leaderIsrAndEpochInfo.get("leader").get());
                    int epoch = BoxesRunTime.unboxToInt(leaderIsrAndEpochInfo.get("leader_epoch").get());
                    List isr = (List)leaderIsrAndEpochInfo.get("isr").get();
                    int controllerEpoch = BoxesRunTime.unboxToInt(leaderIsrAndEpochInfo.get("controller_epoch").get());
                    int zkPathVersion = stat.getVersion();
                    this.debug((Function0<String>)((Object)new scala.Serializable(topic, partition2, leader, epoch, isr, zkPathVersion){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final int partition$1;
                        private final int leader$1;
                        private final int epoch$1;
                        private final List isr$1;
                        private final int zkPathVersion$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Leader %d, Epoch %d, Isr %s, Zk path version %d for partition [%s,%d]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.leader$1), BoxesRunTime.boxToInteger(this.epoch$1), this.isr$1.toString(), BoxesRunTime.boxToInteger(this.zkPathVersion$1), this.topic$1, BoxesRunTime.boxToInteger(this.partition$1)}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.partition$1 = partition$1;
                            this.leader$1 = leader$1;
                            this.epoch$1 = epoch$1;
                            this.isr$1 = isr$1;
                            this.zkPathVersion$1 = zkPathVersion$1;
                        }
                    }));
                    option2 = new Some<LeaderIsrAndControllerEpoch>(new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, epoch, isr, zkPathVersion), controllerEpoch));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public Option<Object> getLeaderForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> option;
        block7: {
            None$ none$;
            block6: {
                block2: {
                    Option<Object> option2;
                    block5: {
                        Option option3;
                        block4: {
                            block3: {
                                Option<String> leaderAndIsrOpt = this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition2))._1();
                                option = leaderAndIsrOpt;
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String leaderAndIsr = (String)some.x();
                                option2 = Json$.MODULE$.parseFull(leaderAndIsr);
                                if (!(option2 instanceof Some)) break block3;
                                Some some2 = (Some)option2;
                                Object m = some2.x();
                                option3 = new Some<Integer>(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(((Map)m).get("leader").get())));
                                break block4;
                            }
                            None$ none$2 = None$.MODULE$;
                            Option<Object> option4 = option2;
                            if (none$2 != null ? !none$2.equals(option4) : option4 != null) break block5;
                            option3 = None$.MODULE$;
                        }
                        none$ = option3;
                        break block6;
                    }
                    throw new MatchError(option2);
                }
                None$ none$3 = None$.MODULE$;
                Option<String> option5 = option;
                if (none$3 != null ? !none$3.equals(option5) : option5 != null) break block7;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public int getEpochForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> leaderAndIsrOpt = this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition2))._1();
        Option<String> option = leaderAndIsrOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String leaderAndIsr = (String)some.x();
            Option<Object> option2 = Json$.MODULE$.parseFull(leaderAndIsr);
            None$ none$ = None$.MODULE$;
            Option<Object> option3 = option2;
            if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                throw new NoEpochForPartitionException(new StringOps(Predef$.MODULE$.augmentString("No epoch, leaderAndISR data for partition [%s,%d] is invalid")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partition2)})));
            }
            if (option2 instanceof Some) {
                int n;
                Some some2 = (Some)option2;
                Object m = some2.x();
                int n2 = n = BoxesRunTime.unboxToInt(((Map)m).get("leader_epoch").get());
                return n2;
            }
            throw new MatchError(option2);
        }
        None$ none$ = None$.MODULE$;
        Option<String> option4 = option;
        if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
            throw new NoEpochForPartitionException(new StringOps(Predef$.MODULE$.augmentString("No epoch, ISR path for partition [%s,%d] is empty")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partition2)})));
        }
        throw new MatchError(option);
    }

    public Seq<Object> getInSyncReplicasForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> option;
        block7: {
            Seq seq;
            block6: {
                block2: {
                    Option<Object> option2;
                    block5: {
                        Seq seq2;
                        block4: {
                            block3: {
                                Option<String> leaderAndIsrOpt = this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition2))._1();
                                option = leaderAndIsrOpt;
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String leaderAndIsr = (String)some.x();
                                option2 = Json$.MODULE$.parseFull(leaderAndIsr);
                                if (!(option2 instanceof Some)) break block3;
                                Some some2 = (Some)option2;
                                Object m = some2.x();
                                seq2 = (Seq)((Map)m).get("isr").get();
                                break block4;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<Object> option3 = option2;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                            seq2 = (Seq)Seq$.MODULE$.empty();
                        }
                        seq = seq2;
                        break block6;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option<String> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public Seq<Object> getReplicasForPartition(ZkClient zkClient, String topic, int partition2) {
        Option<String> option;
        block13: {
            Seq seq;
            block12: {
                block2: {
                    Option<Object> option2;
                    block11: {
                        Seq seq2;
                        block10: {
                            block3: {
                                Option option3;
                                block9: {
                                    Seq seq3;
                                    block8: {
                                        block4: {
                                            Option option4;
                                            block7: {
                                                Seq seq4;
                                                block6: {
                                                    block5: {
                                                        Seq seq5;
                                                        Option<String> jsonPartitionMapOpt = this.readDataMaybeNull(zkClient, this.getTopicPath(topic))._1();
                                                        option = jsonPartitionMapOpt;
                                                        if (!(option instanceof Some)) break block2;
                                                        Some some = (Some)option;
                                                        String jsonPartitionMap = (String)some.x();
                                                        option2 = Json$.MODULE$.parseFull(jsonPartitionMap);
                                                        if (!(option2 instanceof Some)) break block3;
                                                        Some some2 = (Some)option2;
                                                        Object m = some2.x();
                                                        option3 = ((Map)m).get("partitions");
                                                        if (!(option3 instanceof Some)) break block4;
                                                        Some some3 = (Some)option3;
                                                        Object replicaMap = some3.x();
                                                        option4 = ((Map)replicaMap).get(((Object)BoxesRunTime.boxToInteger(partition2)).toString());
                                                        if (!(option4 instanceof Some)) break block5;
                                                        Some some4 = (Some)option4;
                                                        seq4 = seq5 = (Seq)some4.x();
                                                        break block6;
                                                    }
                                                    None$ none$ = None$.MODULE$;
                                                    Option option5 = option4;
                                                    if (none$ != null ? !none$.equals(option5) : option5 != null) break block7;
                                                    seq4 = (Seq)Seq$.MODULE$.empty();
                                                }
                                                seq3 = seq4;
                                                break block8;
                                            }
                                            throw new MatchError(option4);
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option6 = option3;
                                        if (none$ != null ? !none$.equals(option6) : option6 != null) break block9;
                                        seq3 = (Seq)Seq$.MODULE$.empty();
                                    }
                                    seq2 = seq3;
                                    break block10;
                                }
                                throw new MatchError(option3);
                            }
                            None$ none$ = None$.MODULE$;
                            Option<Object> option7 = option2;
                            if (none$ != null ? !none$.equals(option7) : option7 != null) break block11;
                            seq2 = (Seq)Seq$.MODULE$.empty();
                        }
                        seq = seq2;
                        break block12;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option<String> option8 = option;
                if (none$ != null ? !none$.equals(option8) : option8 != null) break block13;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    public void registerBrokerInZk(ZkClient zkClient, int id, String host, int port, int timeout, int jmxPort) {
        String brokerIdPath = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(id)).toString();
        String timestamp = ((Object)BoxesRunTime.boxToLong(SystemTime$.MODULE$.milliseconds())).toString();
        String brokerInfo = Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("version"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("host"), host), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("port"), BoxesRunTime.boxToInteger(port)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("jmx_port"), BoxesRunTime.boxToInteger(jmxPort)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("timestamp"), timestamp)})));
        Broker expectedBroker = new Broker(id, host, port);
        try {
            this.createEphemeralPathExpectConflictHandleZKBug(zkClient, brokerIdPath, brokerInfo, expectedBroker, (Function2<String, Object, Object>)((Object)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String brokerString, Object broker) {
                    return Broker$.MODULE$.createBroker(((Broker)broker).id(), brokerString).equals((Broker)broker);
                }
            }), timeout);
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            void var7_7;
            throw new RuntimeException(new StringBuilder().append((Object)"A broker is already registered on the path ").append(var7_7).append((Object)". This probably ").append((Object)"indicates that you either have configured a brokerid that is already in use, or ").append((Object)"else you have shutdown this broker and restarted it faster than the zookeeper ").append((Object)"timeout so it appears to be re-registering.").toString());
        }
        this.info((Function0<String>)((Object)new scala.Serializable(id, host, port, brokerIdPath){
            public static final long serialVersionUID = 0L;
            private final int id$1;
            private final String host$1;
            private final int port$1;
            private final String brokerIdPath$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Registered broker %d at path %s with address %s:%d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.id$1), this.brokerIdPath$1, this.host$1, BoxesRunTime.boxToInteger(this.port$1)}));
            }
            {
                this.id$1 = id$1;
                this.host$1 = host$1;
                this.port$1 = port$1;
                this.brokerIdPath$1 = brokerIdPath$1;
            }
        }));
    }

    public String getConsumerPartitionOwnerPath(String group, String topic, int partition2) {
        ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(group, topic);
        return new StringBuilder().append((Object)topicDirs.consumerOwnerDir()).append((Object)"/").append(BoxesRunTime.boxToInteger(partition2)).toString();
    }

    public String leaderAndIsrZkData(LeaderAndIsr leaderAndIsr, int controllerEpoch) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("version"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("leader"), BoxesRunTime.boxToInteger(leaderAndIsr.leader())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("leader_epoch"), BoxesRunTime.boxToInteger(leaderAndIsr.leaderEpoch())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("controller_epoch"), BoxesRunTime.boxToInteger(controllerEpoch)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("isr"), leaderAndIsr.isr())})));
    }

    public String replicaAssignmentZkData(Map<String, Seq<Object>> map2) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("version"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("partitions"), map2)})));
    }

    public void makeSurePersistentPathExists(ZkClient client, String path) {
        if (!client.exists(path)) {
            client.createPersistent(path, true);
        }
    }

    private void createParentPath(ZkClient client, String path) {
        String parentDir = path.substring(0, path.lastIndexOf(47));
        if (parentDir.length() != 0) {
            client.createPersistent(parentDir, true);
        }
    }

    private void createEphemeralPath(ZkClient client, String path, String data2) {
        try {
            client.createEphemeral(path, data2);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, data2);
        }
    }

    public void createEphemeralPathExpectConflict(ZkClient client, String path, String data2) {
        ObjectRef<Object> storedData;
        ZkNodeExistsException zkNodeExistsException2;
        block6: {
            try {
                this.createEphemeralPath(client, path, data2);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException2) {
                storedData = new ObjectRef<Object>(null);
                try {
                    storedData.elem = this.readData(client, path)._1();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    // empty catch block
                }
                if ((String)storedData.elem == null) break block6;
                String string2 = (String)storedData.elem;
                String string3 = data2;
                if (string2 != null ? !string2.equals(string3) : string3 != null) break block6;
                this.info((Function0<String>)((Object)new scala.Serializable(path, data2){
                    public static final long serialVersionUID = 0L;
                    private final String path$4;
                    private final String data$3;

                    public final String apply() {
                        return new StringBuilder().append((Object)this.path$4).append((Object)" exists with value ").append((Object)this.data$3).append((Object)" during connection loss; this is ok").toString();
                    }
                    {
                        this.path$4 = path$4;
                        this.data$3 = data$3;
                    }
                }));
            }
            return;
        }
        this.info((Function0<String>)((Object)new scala.Serializable(path, data2, storedData){
            public static final long serialVersionUID = 0L;
            private final String path$4;
            private final String data$3;
            private final ObjectRef storedData$1;

            public final String apply() {
                return new StringBuilder().append((Object)"conflict in ").append((Object)this.path$4).append((Object)" data: ").append((Object)this.data$3).append((Object)" stored data: ").append((Object)((String)this.storedData$1.elem)).toString();
            }
            {
                this.path$4 = path$4;
                this.data$3 = data$3;
                this.storedData$1 = storedData$1;
            }
        }));
        throw zkNodeExistsException2;
    }

    public void createEphemeralPathExpectConflictHandleZKBug(ZkClient zkClient, String path, String data2, Object expectedCallerData, Function2<String, Object, Object> checker, int backoffTime) {
        Option<String> option;
        while (true) {
            try {
                this.createEphemeralPathExpectConflict(zkClient, path, data2);
                return;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                BoxedUnit boxedUnit;
                option = this.readDataMaybeNull(zkClient, path)._1();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String writtenData = (String)some.x();
                    if (BoxesRunTime.unboxToBoolean(checker.apply(writtenData, expectedCallerData))) {
                        this.info((Function0<String>)((Object)new scala.Serializable(path, data2){
                            public static final long serialVersionUID = 0L;
                            private final String path$2;
                            private final String data$2;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("I wrote this conflicted ephemeral node [%s] at %s a while back in a different session, ")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.data$2, this.path$2}))).append((Object)"hence I will backoff for this node to be deleted by Zookeeper and retry").toString();
                            }
                            {
                                this.path$2 = path$2;
                                this.data$2 = data$2;
                            }
                        }));
                        Thread.sleep(backoffTime);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    throw zkNodeExistsException;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            break;
        }
        throw new MatchError(option);
    }

    public void createPersistentPath(ZkClient client, String path, String data2) {
        try {
            client.createPersistent(path, data2);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createPersistent(path, data2);
        }
    }

    public String createPersistentPath$default$3() {
        return "";
    }

    public String createSequentialPersistentPath(ZkClient client, String path, String data2) {
        return client.createPersistentSequential(path, data2);
    }

    public String createSequentialPersistentPath$default$3() {
        return "";
    }

    public void updatePersistentPath(ZkClient client, String path, String data2) {
        try {
            client.writeData(path, data2);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            try {
                client.createPersistent(path, data2);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                client.writeData(path, data2);
            }
        }
    }

    public Tuple2<Object, Object> conditionalUpdatePersistentPath(ZkClient client, String path, String data2, int expectVersion) {
        Tuple2$mcZI$sp tuple2$mcZI$sp;
        try {
            Stat stat = client.writeDataReturnStat(path, data2, expectVersion);
            this.debug((Function0<String>)((Object)new scala.Serializable(path, data2, expectVersion, stat){
                public static final long serialVersionUID = 0L;
                private final String path$1;
                private final String data$1;
                private final int expectVersion$1;
                private final Stat stat$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Conditional update of path %s with value %s and expected version %d succeeded, returning the new version: %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.path$1, this.data$1, BoxesRunTime.boxToInteger(this.expectVersion$1), BoxesRunTime.boxToInteger(this.stat$1.getVersion())}));
                }
                {
                    this.path$1 = path$1;
                    this.data$1 = data$1;
                    this.expectVersion$1 = expectVersion$1;
                    this.stat$1 = stat$1;
                }
            }));
            tuple2$mcZI$sp = new Tuple2$mcZI$sp(true, stat.getVersion());
        }
        catch (Exception exception) {
            this.error((Function0<String>)((Object)new scala.Serializable(path, data2, expectVersion, exception){
                public static final long serialVersionUID = 0L;
                private final String path$1;
                private final String data$1;
                private final int expectVersion$1;
                private final Exception e$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Conditional update of path %s with data %s and expected version %d failed due to %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.path$1, this.data$1, BoxesRunTime.boxToInteger(this.expectVersion$1), this.e$1.getMessage()}));
                }
                {
                    this.path$1 = path$1;
                    this.data$1 = data$1;
                    this.expectVersion$1 = expectVersion$1;
                    this.e$1 = e$1;
                }
            }));
            tuple2$mcZI$sp = new Tuple2$mcZI$sp(false, -1);
        }
        return tuple2$mcZI$sp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple2<Object, Object> conditionalUpdatePersistentPathIfExists(ZkClient client, String path, String data2, int expectVersion) {
        Tuple2$mcZI$sp tuple2$mcZI$sp;
        try {
            Stat stat = client.writeDataReturnStat(path, data2, expectVersion);
            this.debug((Function0<String>)((Object)new scala.Serializable(path, data2, expectVersion, stat){
                public static final long serialVersionUID = 0L;
                private final String path$5;
                private final String data$4;
                private final int expectVersion$2;
                private final Stat stat$2;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Conditional update of path %s with value %s and expected version %d succeeded, returning the new version: %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.path$5, this.data$4, BoxesRunTime.boxToInteger(this.expectVersion$2), BoxesRunTime.boxToInteger(this.stat$2.getVersion())}));
                }
                {
                    this.path$5 = path$5;
                    this.data$4 = data$4;
                    this.expectVersion$2 = expectVersion$2;
                    this.stat$2 = stat$2;
                }
            }));
            tuple2$mcZI$sp = new Tuple2$mcZI$sp(true, stat.getVersion());
            return tuple2$mcZI$sp;
        }
        catch (Exception exception) {
            this.error((Function0<String>)((Object)new scala.Serializable(path, data2, expectVersion, exception){
                public static final long serialVersionUID = 0L;
                private final String path$5;
                private final String data$4;
                private final int expectVersion$2;
                private final Exception e$2;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Conditional update of path %s with data %s and expected version %d failed due to %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.path$5, this.data$4, BoxesRunTime.boxToInteger(this.expectVersion$2), this.e$2.getMessage()}));
                }
                {
                    this.path$5 = path$5;
                    this.data$4 = data$4;
                    this.expectVersion$2 = expectVersion$2;
                    this.e$2 = e$2;
                }
            }));
            tuple2$mcZI$sp = new Tuple2$mcZI$sp(false, -1);
            return tuple2$mcZI$sp;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            throw zkNoNodeException;
        }
    }

    public void updateEphemeralPath(ZkClient client, String path, String data2) {
        try {
            client.writeData(path, data2);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, data2);
        }
    }

    public boolean deletePath(ZkClient client, String path) {
        boolean bl;
        try {
            bl = client.delete(path);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)((Object)new scala.Serializable(path){
                public static final long serialVersionUID = 0L;
                private final String path$3;

                public final String apply() {
                    return new StringBuilder().append((Object)this.path$3).append((Object)" deleted during connection loss; this is ok").toString();
                }
                {
                    this.path$3 = path$3;
                }
            }));
            bl = false;
        }
        return bl;
    }

    public void deletePathRecursive(ZkClient client, String path) {
        try {
            client.deleteRecursive(path);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)((Object)new scala.Serializable(path){
                public static final long serialVersionUID = 0L;
                private final String path$6;

                public final String apply() {
                    return new StringBuilder().append((Object)this.path$6).append((Object)" deleted during connection loss; this is ok").toString();
                }
                {
                    this.path$6 = path$6;
                }
            }));
        }
    }

    public void maybeDeletePath(String zkUrl, String dir) {
        try {
            ZkClient zk = new ZkClient(zkUrl, 30000, 30000, ZKStringSerializer$.MODULE$);
            zk.deleteRecursive(dir);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    public Tuple2<String, Stat> readData(ZkClient client, String path) {
        Stat stat = new Stat();
        String dataStr = (String)client.readData(path, stat);
        return new Tuple2<String, Stat>(dataStr, stat);
    }

    public Tuple2<Option<String>, Stat> readDataMaybeNull(ZkClient client, String path) {
        Tuple2 tuple2;
        Stat stat = new Stat();
        try {
            tuple2 = new Tuple2(new Some(client.readData(path, stat)), stat);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            tuple2 = new Tuple2<None$, Stat>(None$.MODULE$, stat);
        }
        Tuple2 dataAndStat = tuple2;
        return dataAndStat;
    }

    public Seq<String> getChildren(ZkClient client, String path) {
        return JavaConversions$.MODULE$.asScalaBuffer(client.getChildren(path));
    }

    public Seq<String> getChildrenParentMayNotExist(ZkClient client, String path) {
        try {
            return JavaConversions$.MODULE$.asScalaBuffer(client.getChildren(path));
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            return Nil$.MODULE$;
        }
    }

    public boolean pathExists(ZkClient client, String path) {
        return client.exists(path);
    }

    /*
     * WARNING - void declaration
     */
    public Cluster getCluster(ZkClient zkClient) {
        void var2_2;
        Cluster cluster = new Cluster();
        Seq<String> nodes = this.getChildrenParentMayNotExist(zkClient, this.BrokerIdsPath());
        nodes.foreach(new scala.Serializable(zkClient, cluster){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$5;
            private final Cluster cluster$1;

            public final Option<Broker> apply(String node) {
                String brokerZKString = ZkUtils$.MODULE$.readData(this.zkClient$5, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)node).toString())._1();
                return this.cluster$1.add(Broker$.MODULE$.createBroker(new StringOps(Predef$.MODULE$.augmentString(node)).toInt(), brokerZKString));
            }
            {
                this.zkClient$5 = zkClient$5;
                this.cluster$1 = cluster$1;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<TopicAndPartition, LeaderIsrAndControllerEpoch> getPartitionLeaderAndIsrForTopics(ZkClient zkClient, Set<TopicAndPartition> topicAndPartitions) {
        void var3_3;
        HashMap ret = new HashMap();
        topicAndPartitions.foreach(new scala.Serializable(zkClient, ret){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$7;
            private final HashMap ret$1;

            public final Object apply(TopicAndPartition topicAndPartition) {
                Option<LeaderIsrAndControllerEpoch> option;
                block4: {
                    Serializable serializable2;
                    block3: {
                        block2: {
                            option = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkClient$7, topicAndPartition.topic(), topicAndPartition.partition());
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                            serializable2 = this.ret$1.put(topicAndPartition, leaderIsrAndControllerEpoch);
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<LeaderIsrAndControllerEpoch> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        serializable2 = BoxedUnit.UNIT;
                    }
                    return serializable2;
                }
                throw new MatchError(option);
            }
            {
                this.zkClient$7 = zkClient$7;
                this.ret$1 = ret$1;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> getReplicaAssignmentForTopics(ZkClient zkClient, Seq<String> topics) {
        void var3_3;
        HashMap ret = new HashMap();
        topics.foreach(new scala.Serializable(zkClient, ret){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$1;
            public final HashMap ret$2;

            public final void apply(String topic) {
                Option<String> option;
                block10: {
                    block9: {
                        block2: {
                            Option<Object> option2;
                            block8: {
                                block7: {
                                    block3: {
                                        Option<B> option3;
                                        block6: {
                                            block5: {
                                                block4: {
                                                    Option<String> jsonPartitionMapOpt = ZkUtils$.MODULE$.readDataMaybeNull(this.zkClient$1, ZkUtils$.MODULE$.getTopicPath(topic))._1();
                                                    option = jsonPartitionMapOpt;
                                                    if (!(option instanceof Some)) break block2;
                                                    Some some = (Some)option;
                                                    String jsonPartitionMap = (String)some.x();
                                                    option2 = Json$.MODULE$.parseFull(jsonPartitionMap);
                                                    if (!(option2 instanceof Some)) break block3;
                                                    Some some2 = (Some)option2;
                                                    A m = some2.x();
                                                    option3 = ((Map)m).get("partitions");
                                                    if (!(option3 instanceof Some)) break block4;
                                                    Some some3 = (Some)option3;
                                                    A repl = some3.x();
                                                    Map replicaMap = (Map)repl;
                                                    replicaMap.withFilter(new scala.Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final boolean apply(Tuple2<String, Seq<Object>> check$ifrefutable$1) {
                                                            Tuple2<String, Seq<Object>> tuple2 = check$ifrefutable$1;
                                                            boolean bl = tuple2 != null;
                                                            return bl;
                                                        }
                                                    }).foreach(new scala.Serializable(this, topic){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ anonfun.getReplicaAssignmentForTopics.1 $outer;
                                                        public final String topic$2;

                                                        public final void apply(Tuple2<String, Seq<Object>> x$7) {
                                                            Tuple2<String, Seq<Object>> tuple2 = x$7;
                                                            if (tuple2 != null) {
                                                                String partition2 = tuple2._1();
                                                                Seq<Object> replicas = tuple2._2();
                                                                this.$outer.ret$2.put(new TopicAndPartition(this.topic$2, new StringOps(Predef$.MODULE$.augmentString(partition2)).toInt()), replicas);
                                                                ZkUtils$.MODULE$.debug((Function0<String>)((Object)new scala.Serializable(this, partition2, replicas){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final /* synthetic */ anonfun$getReplicaAssignmentForTopics$1$$anonfun$apply$3 $outer;
                                                                    private final String partition$2;
                                                                    private final Seq replicas$1;

                                                                    public final String apply() {
                                                                        return new StringOps(Predef$.MODULE$.augmentString("Replicas assigned to topic [%s], partition [%s] are [%s]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic$2, this.partition$2, this.replicas$1}));
                                                                    }
                                                                    {
                                                                        if ($outer == null) {
                                                                            throw new NullPointerException();
                                                                        }
                                                                        this.$outer = $outer;
                                                                        this.partition$2 = partition$2;
                                                                        this.replicas$1 = replicas$1;
                                                                    }
                                                                }));
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                return;
                                                            }
                                                            throw new MatchError(tuple2);
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw new NullPointerException();
                                                            }
                                                            this.$outer = $outer;
                                                            this.topic$2 = topic$2;
                                                        }
                                                    });
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block5;
                                                }
                                                None$ none$ = None$.MODULE$;
                                                Option<B> option4 = option3;
                                                if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            }
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block7;
                                        }
                                        throw new MatchError(option3);
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<Object> option5 = option2;
                                    if (none$ != null ? !none$.equals(option5) : option5 != null) break block8;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block9;
                            }
                            throw new MatchError(option2);
                        }
                        None$ none$ = None$.MODULE$;
                        Option<String> option6 = option;
                        if (none$ != null ? !none$.equals(option6) : option6 != null) break block10;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(option);
            }
            {
                this.zkClient$1 = zkClient$1;
                this.ret$2 = ret$2;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<String, Map<Object, Seq<Object>>> getPartitionAssignmentForTopics(ZkClient zkClient, Seq<String> topics) {
        void var3_3;
        HashMap ret = new HashMap();
        topics.foreach(new scala.Serializable(zkClient, ret){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$2;
            private final HashMap ret$3;

            public final HashMap<String, Map<Object, Seq<Object>>> apply(String topic) {
                Option<String> option;
                block10: {
                    Map map2;
                    block9: {
                        block2: {
                            Option<Object> option2;
                            block8: {
                                Map map3;
                                block7: {
                                    block3: {
                                        Option<B> option3;
                                        block6: {
                                            Map<A, B> map4;
                                            block5: {
                                                block4: {
                                                    Option<String> jsonPartitionMapOpt = ZkUtils$.MODULE$.readDataMaybeNull(this.zkClient$2, ZkUtils$.MODULE$.getTopicPath(topic))._1();
                                                    option = jsonPartitionMapOpt;
                                                    if (!(option instanceof Some)) break block2;
                                                    Some some = (Some)option;
                                                    String jsonPartitionMap = (String)some.x();
                                                    option2 = Json$.MODULE$.parseFull(jsonPartitionMap);
                                                    if (!(option2 instanceof Some)) break block3;
                                                    Some some2 = (Some)option2;
                                                    A m = some2.x();
                                                    option3 = ((Map)m).get("partitions");
                                                    if (!(option3 instanceof Some)) break block4;
                                                    Some some3 = (Some)option3;
                                                    A replicaMap = some3.x();
                                                    Map m1 = (Map)replicaMap;
                                                    map4 = m1.map(new scala.Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final Tuple2<Object, Seq<Object>> apply(Tuple2<String, Seq<Object>> p) {
                                                            return new Tuple2<Object, Seq<Object>>(BoxesRunTime.boxToInteger(new StringOps(Predef$.MODULE$.augmentString(p._1())).toInt()), p._2());
                                                        }
                                                    }, scala.collection.Map$.MODULE$.canBuildFrom());
                                                    break block5;
                                                }
                                                None$ none$ = None$.MODULE$;
                                                Option<B> option4 = option3;
                                                if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                                                map4 = (Map<A, B>)scala.collection.Map$.MODULE$.apply(Nil$.MODULE$);
                                            }
                                            map3 = map4;
                                            break block7;
                                        }
                                        throw new MatchError(option3);
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<Object> option5 = option2;
                                    if (none$ != null ? !none$.equals(option5) : option5 != null) break block8;
                                    map3 = (Map)scala.collection.Map$.MODULE$.apply(Nil$.MODULE$);
                                }
                                map2 = map3;
                                break block9;
                            }
                            throw new MatchError(option2);
                        }
                        None$ none$ = None$.MODULE$;
                        Option<String> option6 = option;
                        if (none$ != null ? !none$.equals(option6) : option6 != null) break block10;
                        map2 = (Map)scala.collection.Map$.MODULE$.apply(Nil$.MODULE$);
                    }
                    Map partitionMap = map2;
                    ZkUtils$.MODULE$.debug((Function0<String>)((Object)new scala.Serializable(this, topic, partitionMap){
                        public static final long serialVersionUID = 0L;
                        private final String topic$3;
                        private final Map partitionMap$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Partition map for /brokers/topics/%s is %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$3, this.partitionMap$1}));
                        }
                        {
                            this.topic$3 = topic$3;
                            this.partitionMap$1 = partitionMap$1;
                        }
                    }));
                    return this.ret$3.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(topic), partitionMap));
                }
                throw new MatchError(option);
            }
            {
                this.zkClient$2 = zkClient$2;
                this.ret$3 = ret$3;
            }
        });
        return var3_3;
    }

    public scala.collection.mutable.Map<String, Seq<Object>> getPartitionsForTopics(ZkClient zkClient, Seq<String> topics) {
        return this.getPartitionAssignmentForTopics(zkClient, topics).map((Function1<Object, Seq<Object>>)((Object)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<Object>> apply(Tuple2<String, Map<Object, Seq<Object>>> topicAndPartitionMap) {
                String topic = topicAndPartitionMap._1();
                Map<Object, Seq<Object>> partitionMap = topicAndPartitionMap._2();
                ZkUtils$.MODULE$.debug((Function0<String>)((Object)new scala.Serializable(this, topic, partitionMap){
                    public static final long serialVersionUID = 0L;
                    private final String topic$4;
                    private final Map partitionMap$2;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("partition assignment of /brokers/topics/%s is %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$4, this.partitionMap$2}));
                    }
                    {
                        this.topic$4 = topic$4;
                        this.partitionMap$2 = partitionMap$2;
                    }
                }));
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(topic), partitionMap.keys().toSeq().sortWith((Function2<Object, Object, Object>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int s2, int t) {
                        return this.apply$mcZII$sp(s2, t);
                    }

                    public boolean apply$mcZII$sp(int s2, int t) {
                        return s2 < t;
                    }
                })));
            }
        }), Map$.MODULE$.canBuildFrom());
    }

    public Map<TopicAndPartition, ReassignedPartitionsContext> getPartitionsBeingReassigned(ZkClient zkClient) {
        Option<String> option;
        block4: {
            Map map2;
            block3: {
                block2: {
                    Option<String> jsonPartitionMapOpt = this.readDataMaybeNull(zkClient, this.ReassignPartitionsPath())._1();
                    option = jsonPartitionMapOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String jsonPartitionMap = (String)some.x();
                    Map<TopicAndPartition, Seq<Object>> reassignedPartitions = this.parsePartitionReassignmentData(jsonPartitionMap);
                    map2 = reassignedPartitions.map((Function1<TopicAndPartition, Seq<Object>>)((Object)new scala.Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<TopicAndPartition, ReassignedPartitionsContext> apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(p._1()), new ReassignedPartitionsContext(p._2(), ReassignedPartitionsContext$.MODULE$.$lessinit$greater$default$2()));
                        }
                    }), scala.collection.Map$.MODULE$.canBuildFrom());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                map2 = scala.collection.Map$.MODULE$.empty();
            }
            return map2;
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    public Map<TopicAndPartition, Seq<Object>> parsePartitionReassignmentData(String jsonData) {
        Option<Object> option;
        block7: {
            void var2_2;
            block6: {
                block2: {
                    Option option2;
                    block5: {
                        block4: {
                            block3: {
                                scala.collection.mutable.Map reassignedPartitions = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
                                option = Json$.MODULE$.parseFull(jsonData);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Object m = some.x();
                                option2 = ((Map)m).get("partitions");
                                if (!(option2 instanceof Some)) break block3;
                                Some some2 = (Some)option2;
                                Object partitionsSeq = some2.x();
                                ((Seq)partitionsSeq).foreach(new scala.Serializable(reassignedPartitions){
                                    public static final long serialVersionUID = 0L;
                                    private final scala.collection.mutable.Map reassignedPartitions$1;

                                    public final scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> apply(Map<String, Object> p) {
                                        String topic = (String)p.get("topic").get();
                                        int partition2 = BoxesRunTime.unboxToInt(p.get("partition").get());
                                        Seq newReplicas = (Seq)p.get("replicas").get();
                                        return (scala.collection.mutable.Map)this.reassignedPartitions$1.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(new TopicAndPartition(topic, partition2)), newReplicas));
                                    }
                                    {
                                        this.reassignedPartitions$1 = reassignedPartitions$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option3 = option2;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return var2_2;
        }
        throw new MatchError(option);
    }

    public Seq<String> parseTopicsData(String jsonData) {
        Option<Object> option;
        block7: {
            ObjectRef<GenTraversable> topics;
            block6: {
                block2: {
                    Option option2;
                    block5: {
                        block4: {
                            block3: {
                                topics = new ObjectRef<GenTraversable>(List$.MODULE$.empty());
                                option = Json$.MODULE$.parseFull(jsonData);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Object m = some.x();
                                option2 = ((Map)m).get("topics");
                                if (!(option2 instanceof Some)) break block3;
                                Some some2 = (Some)option2;
                                Object partitionsSeq = some2.x();
                                Seq mapPartitionSeq = (Seq)partitionsSeq;
                                mapPartitionSeq.foreach(new scala.Serializable(topics){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef topics$1;

                                    public final void apply(Map<String, Object> p) {
                                        String topic = (String)p.get("topic").get();
                                        this.topics$1.elem = ((List)this.topics$1.elem).$plus$plus(List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), List$.MODULE$.canBuildFrom());
                                    }
                                    {
                                        this.topics$1 = topics$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option3 = option2;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return (List)topics.elem;
        }
        throw new MatchError(option);
    }

    public String getPartitionReassignmentZkData(Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("version"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("partitions"), partitionsToBeReassigned.map((Function1<TopicAndPartition, Seq<Object>>)((Object)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(Tuple2<TopicAndPartition, Seq<Object>> e) {
                return (Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("topic"), e._1().topic()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("partition"), BoxesRunTime.boxToInteger(e._1().partition())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("replicas"), e._2())}));
            }
        }), Iterable$.MODULE$.canBuildFrom()))})));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updatePartitionReassignmentData(ZkClient zkClient, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        String zkPath = this.ReassignPartitionsPath();
        int n = partitionsToBeReassigned.size();
        switch (n) {
            default: {
                String jsonData = this.getPartitionReassignmentZkData(partitionsToBeReassigned);
                try {
                    this.updatePersistentPath(zkClient, zkPath, jsonData);
                    this.info((Function0<String>)((Object)new scala.Serializable(jsonData){
                        public static final long serialVersionUID = 0L;
                        private final String jsonData$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Updated partition reassignment path with %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.jsonData$1}));
                        }
                        {
                            this.jsonData$1 = jsonData$1;
                        }
                    }));
                    return;
                }
                catch (Throwable throwable) {
                    throw new AdminOperationException(throwable.toString());
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    this.createPersistentPath(zkClient, zkPath, jsonData);
                    this.debug((Function0<String>)((Object)new scala.Serializable(zkPath, jsonData){
                        public static final long serialVersionUID = 0L;
                        private final String zkPath$1;
                        private final String jsonData$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Created path %s with %s for partition reassignment")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.zkPath$1, this.jsonData$1}));
                        }
                        {
                            this.zkPath$1 = zkPath$1;
                            this.jsonData$1 = jsonData$1;
                        }
                    }));
                    return;
                }
            }
            case 0: {
                this.deletePath(zkClient, zkPath);
                this.info((Function0<String>)((Object)new scala.Serializable(zkPath){
                    public static final long serialVersionUID = 0L;
                    private final String zkPath$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("No more partitions need to be reassigned. Deleting zk path %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.zkPath$1}));
                    }
                    {
                        this.zkPath$1 = zkPath$1;
                    }
                }));
                return;
            }
        }
    }

    public Set<TopicAndPartition> getPartitionsUndergoingPreferredReplicaElection(ZkClient zkClient) {
        Option<String> option;
        block4: {
            GenTraversable<TopicAndPartition> genTraversable;
            block3: {
                block2: {
                    Option<String> jsonPartitionListOpt = this.readDataMaybeNull(zkClient, this.PreferredReplicaLeaderElectionPath())._1();
                    option = jsonPartitionListOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String jsonPartitionList = (String)some.x();
                    genTraversable = PreferredReplicaLeaderElectionCommand$.MODULE$.parsePreferredReplicaElectionData(jsonPartitionList);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                genTraversable = Set$.MODULE$.empty();
            }
            return genTraversable;
        }
        throw new MatchError(option);
    }

    public void deletePartition(ZkClient zkClient, int brokerId, String topic) {
        String brokerIdPath = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(brokerId)).toString();
        zkClient.delete(brokerIdPath);
        String brokerPartTopicPath = new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).append((Object)"/").append(BoxesRunTime.boxToInteger(brokerId)).toString();
        zkClient.delete(brokerPartTopicPath);
    }

    public Seq<String> getConsumersInGroup(ZkClient zkClient, String group) {
        ZKGroupDirs dirs = new ZKGroupDirs(group);
        return this.getChildren(zkClient, dirs.consumerRegistryDir());
    }

    public scala.collection.mutable.Map<String, List<String>> getConsumersPerTopic(ZkClient zkClient, String group) {
        ZKGroupDirs dirs = new ZKGroupDirs(group);
        Seq<String> consumers = this.getChildrenParentMayNotExist(zkClient, dirs.consumerRegistryDir());
        HashMap<String, List<String>> consumersPerTopicMap = new HashMap<String, List<String>>();
        consumers.foreach(new scala.Serializable(zkClient, group, consumersPerTopicMap){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$6;
            private final String group$1;
            public final HashMap consumersPerTopicMap$1;

            public final void apply(String consumer) {
                TopicCount topicCount = TopicCount$.MODULE$.constructTopicCount(this.group$1, consumer, this.zkClient$6);
                topicCount.getConsumerThreadIdsPerTopic().withFilter((Function1<String, Object>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, Set<String>> check$ifrefutable$2) {
                        Tuple2<String, Set<String>> tuple2 = check$ifrefutable$2;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                })).foreach(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getConsumersPerTopic.1 $outer;

                    public final void apply(Tuple2<String, Set<String>> x$9) {
                        Tuple2<String, Set<String>> tuple2 = x$9;
                        if (tuple2 != null) {
                            String topic = tuple2._1();
                            Set<String> consumerThreadIdSet = tuple2._2();
                            consumerThreadIdSet.foreach(new scala.Serializable(this, topic){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$getConsumersPerTopic$1$$anonfun$apply$8 $outer;
                                private final String topic$5;

                                public final Option<List<String>> apply(String consumerThreadId) {
                                    Option<GenTraversable> option;
                                    Option<B> option2 = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.get(this.topic$5);
                                    if (option2 instanceof Some) {
                                        Some some = (Some)option2;
                                        List curConsumers = (List)some.x();
                                        String string2 = consumerThreadId;
                                        option = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.put(this.topic$5, curConsumers.$colon$colon(string2));
                                    } else {
                                        option = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.put(this.topic$5, List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{consumerThreadId})));
                                    }
                                    return option;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.topic$5 = topic$5;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ anonfun.getConsumersPerTopic.1 kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.zkClient$6 = zkClient$6;
                this.group$1 = group$1;
                this.consumersPerTopicMap$1 = consumersPerTopicMap$1;
            }
        });
        consumersPerTopicMap.withFilter((Function1<String, Object>)((Object)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, List<String>> check$ifrefutable$3) {
                Tuple2<String, List<String>> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        })).foreach(new scala.Serializable(consumersPerTopicMap){
            public static final long serialVersionUID = 0L;
            private final HashMap consumersPerTopicMap$1;

            public final Option<List<String>> apply(Tuple2<String, List<String>> x$10) {
                Tuple2<String, List<String>> tuple2 = x$10;
                if (tuple2 != null) {
                    String topic = tuple2._1();
                    List<String> consumerList = tuple2._2();
                    Option<List<String>> option = this.consumersPerTopicMap$1.put(topic, consumerList.sortWith((Function2<String, String, Object>)((Object)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String s2, String t) {
                            return new StringOps(Predef$.MODULE$.augmentString(s2)).$less(t);
                        }
                    })));
                    return option;
                }
                throw new MatchError(tuple2);
            }
            {
                this.consumersPerTopicMap$1 = consumersPerTopicMap$1;
            }
        });
        return consumersPerTopicMap;
    }

    public Option<Broker> getBrokerInfo(ZkClient zkClient, int brokerId) {
        Option<String> option;
        block4: {
            Option option2;
            block3: {
                block2: {
                    option = this.readDataMaybeNull(zkClient, new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(brokerId)).toString())._1();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String brokerInfo = (String)some.x();
                    option2 = new Some<Broker>(Broker$.MODULE$.createBroker(brokerId, brokerInfo));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public Seq<String> getAllTopics(ZkClient zkClient) {
        Seq topics = this.getChildrenParentMayNotExist(zkClient, this.BrokerTopicsPath());
        return topics == null ? (Seq)Seq$.MODULE$.empty() : topics;
    }

    public Set<TopicAndPartition> getAllPartitions(ZkClient zkClient) {
        Seq<String> topics = this.getChildrenParentMayNotExist(zkClient, this.BrokerTopicsPath());
        return topics == null ? Set$.MODULE$.empty() : ((TraversableOnce)((GenericTraversableTemplate)topics.map(new scala.Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$3;

            public final Seq<TopicAndPartition> apply(String topic) {
                return ((TraversableLike)ZkUtils$.MODULE$.getChildren(this.zkClient$3, ZkUtils$.MODULE$.getTopicPartitionsPath(topic)).map(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String x$11) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toInt();
                    }
                }, Seq$.MODULE$.canBuildFrom())).map(new scala.Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$6;

                    public final TopicAndPartition apply(int x$12) {
                        return new TopicAndPartition(this.topic$6, x$12);
                    }
                    {
                        this.topic$6 = topic$6;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.zkClient$3 = zkClient$3;
            }
        }, Seq$.MODULE$.canBuildFrom())).flatten(Predef$.MODULE$.conforms())).toSet();
    }

    private ZkUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ConsumersPath = "/consumers";
        this.BrokerIdsPath = "/brokers/ids";
        this.BrokerTopicsPath = "/brokers/topics";
        this.TopicConfigPath = "/config/topics";
        this.TopicConfigChangesPath = "/config/changes";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.ReassignPartitionsPath = "/admin/reassign_partitions";
        this.DeleteTopicsPath = "/admin/delete_topics";
        this.PreferredReplicaLeaderElectionPath = "/admin/preferred_replica_election";
    }
}

